from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class AuditEventSchema:
    """
    A record of an event made for purposes of maintaining a security log. Typical
    uses include detection of intrusion attempts and monitoring for inappropriate
    usage.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        A record of an event made for purposes of maintaining a security log. Typical
        uses include detection of intrusion attempts and monitoring for inappropriate
        usage.


        resourceType: This is a AuditEvent resource

        type: Identifier for a family of the event.  For example, a menu item, program,
            rule, policy, function code, application name or URL. It identifies the
            performed function.

        subtype: Identifier for the category of event.

        action: Indicator for type of action performed during the event that generated the
            audit.

        recorded: The time when the event occurred on the source.

        outcome: Indicates whether the event succeeded or failed.

        outcomeDesc: A free text description of the outcome of the event.

        purposeOfEvent: The purposeOfUse (reason) that was used during the event being recorded.

        agent: An actor taking an active role in the event or activity that is logged.

        source: The system that is reporting the event.

        entity: Specific instances of data or objects that have been accessed.

        """
        from spark_fhir_schemas.stu3.complex_types.coding import CodingSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import CodeableConceptSchema
        from spark_fhir_schemas.stu3.complex_types.auditevent_agent import AuditEvent_AgentSchema
        from spark_fhir_schemas.stu3.complex_types.auditevent_source import AuditEvent_SourceSchema
        from spark_fhir_schemas.stu3.complex_types.auditevent_entity import AuditEvent_EntitySchema
        if (
            max_recursion_limit
            and nesting_list.count("AuditEvent") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["AuditEvent"]
        schema = StructType(
            [
                # This is a AuditEvent resource
                StructField("resourceType", StringType(), True),
                # Identifier for a family of the event.  For example, a menu item, program,
                # rule, policy, function code, application name or URL. It identifies the
                # performed function.
                StructField(
                    "type",
                    CodingSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Identifier for the category of event.
                StructField(
                    "subtype",
                    ArrayType(
                        CodingSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Indicator for type of action performed during the event that generated the
                # audit.
                StructField("action", StringType(), True),
                # The time when the event occurred on the source.
                StructField("recorded", StringType(), True),
                # Indicates whether the event succeeded or failed.
                StructField("outcome", StringType(), True),
                # A free text description of the outcome of the event.
                StructField("outcomeDesc", StringType(), True),
                # The purposeOfUse (reason) that was used during the event being recorded.
                StructField(
                    "purposeOfEvent",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # An actor taking an active role in the event or activity that is logged.
                StructField(
                    "agent",
                    ArrayType(
                        AuditEvent_AgentSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # The system that is reporting the event.
                StructField(
                    "source",
                    AuditEvent_SourceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Specific instances of data or objects that have been accessed.
                StructField(
                    "entity",
                    ArrayType(
                        AuditEvent_EntitySchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
