from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ActivityDefinition_DynamicValueSchema:
    """
    This resource allows for the definition of some activity to be performed,
    independent of a particular patient, practitioner, or other performance
    context.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        This resource allows for the definition of some activity to be performed,
        independent of a particular patient, practitioner, or other performance
        context.


        description: A brief, natural language description of the intended semantics of the dynamic
            value.

        path: The path to the element to be customized. This is the path on the resource
            that will hold the result of the calculation defined by the expression.

        language: The media type of the language for the expression.

        expression: An expression specifying the value of the customized element.

        """
        if (
            max_recursion_limit
            and nesting_list.count("ActivityDefinition_DynamicValue") >=
            max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + [
            "ActivityDefinition_DynamicValue"
        ]
        schema = StructType(
            [
                # A brief, natural language description of the intended semantics of the dynamic
                # value.
                StructField("description", StringType(), True),
                # The path to the element to be customized. This is the path on the resource
                # that will hold the result of the calculation defined by the expression.
                StructField("path", StringType(), True),
                # The media type of the language for the expression.
                StructField("language", StringType(), True),
                # An expression specifying the value of the customized element.
                StructField("expression", StringType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
