from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class AccountSchema:
    """
    A financial tool for tracking value accrued for a particular purpose.  In the
    healthcare field, used to track charges for a patient, cost centers, etc.
    """
    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False
    ) -> Union[StructType, DataType]:
        """
        A financial tool for tracking value accrued for a particular purpose.  In the
        healthcare field, used to track charges for a patient, cost centers, etc.


        resourceType: This is a Account resource

        identifier: Unique identifier used to reference the account.  May or may not be intended
            for human use (e.g. credit card number).

        status: Indicates whether the account is presently used/usable or not.

        type: Categorizes the account for reporting and searching purposes.

        name: Name used for the account when displaying it to humans in reports, etc.

        subject: Identifies the patient, device, practitioner, location or other object the
            account is associated with.

        period: Identifies the period of time the account applies to; e.g. accounts created
            per fiscal year, quarter, etc.

        active: Indicates the period of time over which the account is allowed to have
            transactions posted to it.
            This period may be different to the coveragePeriod which is the duration of
            time that services may occur.

        balance: Represents the sum of all credits less all debits associated with the account.
            Might be positive, zero or negative.

        coverage: The party(s) that are responsible for covering the payment of this account,
            and what order should they be applied to the account.

        owner: Indicates the organization, department, etc. with responsibility for the
            account.

        description: Provides additional information about what the account tracks and how it is
            used.

        guarantor: Parties financially responsible for the account.

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import CodeableConceptSchema
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.period import PeriodSchema
        from spark_fhir_schemas.stu3.complex_types.money import MoneySchema
        from spark_fhir_schemas.stu3.complex_types.account_coverage import Account_CoverageSchema
        from spark_fhir_schemas.stu3.complex_types.account_guarantor import Account_GuarantorSchema
        if (
            max_recursion_limit
            and nesting_list.count("Account") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Account"]
        schema = StructType(
            [
                # This is a Account resource
                StructField("resourceType", StringType(), True),
                # Unique identifier used to reference the account.  May or may not be intended
                # for human use (e.g. credit card number).
                StructField(
                    "identifier",
                    ArrayType(
                        IdentifierSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Indicates whether the account is presently used/usable or not.
                StructField("status", StringType(), True),
                # Categorizes the account for reporting and searching purposes.
                StructField(
                    "type",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Name used for the account when displaying it to humans in reports, etc.
                StructField("name", StringType(), True),
                # Identifies the patient, device, practitioner, location or other object the
                # account is associated with.
                StructField(
                    "subject",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Identifies the period of time the account applies to; e.g. accounts created
                # per fiscal year, quarter, etc.
                StructField(
                    "period",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Indicates the period of time over which the account is allowed to have
                # transactions posted to it.
                # This period may be different to the coveragePeriod which is the duration of
                # time that services may occur.
                StructField(
                    "active",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Represents the sum of all credits less all debits associated with the account.
                # Might be positive, zero or negative.
                StructField(
                    "balance",
                    MoneySchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # The party(s) that are responsible for covering the payment of this account,
                # and what order should they be applied to the account.
                StructField(
                    "coverage",
                    ArrayType(
                        Account_CoverageSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
                # Indicates the organization, department, etc. with responsibility for the
                # account.
                StructField(
                    "owner",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension
                    ), True
                ),
                # Provides additional information about what the account tracks and how it is
                # used.
                StructField("description", StringType(), True),
                # Parties financially responsible for the account.
                StructField(
                    "guarantor",
                    ArrayType(
                        Account_GuarantorSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension
                        )
                    ), True
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c if c.name != "extension" else
                StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
