"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubjectAlternativeNames = exports.MutualTlsValidationTrust = exports.TlsValidationTrust = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Defines the TLS Validation Context Trust.
 *
 * @stability stable
 */
class TlsValidationTrust {
    /**
     * Tells envoy where to fetch the validation context from.
     *
     * @stability stable
     */
    static file(certificateChain) {
        return new TlsValidationFileTrust(certificateChain);
    }
    /**
     * TLS Validation Context Trust for ACM Private Certificate Authority (CA).
     *
     * @stability stable
     */
    static acm(certificateAuthorities) {
        return new TlsValidationAcmTrust(certificateAuthorities);
    }
    /**
     * TLS Validation Context Trust for Envoy' service discovery service.
     *
     * @stability stable
     */
    static sds(secretName) {
        return new TlsValidationSdsTrust(secretName);
    }
}
exports.TlsValidationTrust = TlsValidationTrust;
_a = JSII_RTTI_SYMBOL_1;
TlsValidationTrust[_a] = { fqn: "@aws-cdk/aws-appmesh.TlsValidationTrust", version: "1.138.0" };
/**
 * Represents a TLS Validation Context Trust that is supported for mutual TLS authentication.
 *
 * @stability stable
 */
class MutualTlsValidationTrust extends TlsValidationTrust {
    constructor() {
        super(...arguments);
        // TypeScript uses structural typing, so we need a property different from TlsValidationTrust
        /**
         * @stability stable
         */
        this.differentiator = false;
    }
}
exports.MutualTlsValidationTrust = MutualTlsValidationTrust;
_b = JSII_RTTI_SYMBOL_1;
MutualTlsValidationTrust[_b] = { fqn: "@aws-cdk/aws-appmesh.MutualTlsValidationTrust", version: "1.138.0" };
class TlsValidationAcmTrust extends TlsValidationTrust {
    constructor(certificateAuthorities) {
        super();
        this.certificateAuthorities = certificateAuthorities;
    }
    bind(_scope) {
        if (this.certificateAuthorities.length === 0) {
            throw new Error('you must provide at least one Certificate Authority when creating an ACM Trust ClientPolicy');
        }
        else {
            return {
                tlsValidationTrust: {
                    acm: {
                        certificateAuthorityArns: this.certificateAuthorities.map(certificateArn => certificateArn.certificateAuthorityArn),
                    },
                },
            };
        }
    }
}
class TlsValidationFileTrust extends MutualTlsValidationTrust {
    constructor(certificateChain) {
        super();
        this.certificateChain = certificateChain;
    }
    bind(_scope) {
        return {
            tlsValidationTrust: {
                file: {
                    certificateChain: this.certificateChain,
                },
            },
        };
    }
}
class TlsValidationSdsTrust extends MutualTlsValidationTrust {
    constructor(secretName) {
        super();
        this.secretName = secretName;
    }
    bind(_scope) {
        return {
            tlsValidationTrust: {
                sds: {
                    secretName: this.secretName,
                },
            },
        };
    }
}
/**
 * Used to generate Subject Alternative Names Matchers.
 *
 * @stability stable
 */
class SubjectAlternativeNames {
    /**
     * The values of the SAN must match the specified values exactly.
     *
     * @param names The exact values to test against.
     * @stability stable
     */
    static matchingExactly(...names) {
        return new SubjectAlternativeNamesImpl({ exact: names });
    }
}
exports.SubjectAlternativeNames = SubjectAlternativeNames;
_c = JSII_RTTI_SYMBOL_1;
SubjectAlternativeNames[_c] = { fqn: "@aws-cdk/aws-appmesh.SubjectAlternativeNames", version: "1.138.0" };
class SubjectAlternativeNamesImpl extends SubjectAlternativeNames {
    constructor(matchProperty) {
        super();
        this.matchProperty = matchProperty;
    }
    bind(_scope) {
        return {
            subjectAlternativeNamesMatch: this.matchProperty,
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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