"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetaflowService = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const kplus = require("cdk8s-plus-22");
const cdk8s_plus_22_1 = require("cdk8s-plus-22");
const constructs_1 = require("constructs");
class MetaflowService extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const serviceAccountName = props?.serviceAccountName || 'release-name-metaflow-service';
        const serviceName = props?.serviceName || 'metaflow-service';
        const image = props?.image || 'public.ecr.aws/outerbounds/metaflow_metadata_service:2.2.4';
        const metadataServicePort = props?.metadataServicePort || 8080;
        const upgradesServicePort = props?.upgradesServicePort || 8082;
        const ingressHostName = props?.ingressOptions?.hostName || 'metaflow-service.local';
        const dbEnvVals = {
            MF_METADATA_DB_NAME: kplus.EnvValue.fromValue(props?.postgresOptions?.databaseName || 'metaflow'),
            MF_METADATA_DB_USER: kplus.EnvValue.fromValue(props?.postgresOptions?.databaseUser || 'metaflow'),
            MF_METADATA_DB_PSWD: kplus.EnvValue.fromValue(props?.postgresOptions?.databasePassword || 'metaflow'),
            MF_METADATA_DB_PORT: kplus.EnvValue.fromValue('5432'),
            MF_METADATA_DB_HOST: kplus.EnvValue.fromValue('release-name-postgresql'),
        };
        const serviceAccount = new kplus.ServiceAccount(this, 'service-account', {
            metadata: {
                name: serviceAccountName,
                labels: {
                    'helm.sh/chart': 'metaflow-service-0.2.0',
                    'app.kubernetes.io/name': serviceName,
                    'app.kubernetes.io/instance': 'release-name',
                    'app.kubernetes.io/version': '2.2.4',
                    'app.kubernetes.io/managed-by': 'Helm',
                },
            },
        });
        this.deployment = new kplus.Deployment(this, 'metaflow-deployment', {
            replicas: 1,
            initContainers: [
                {
                    name: 'db-migrations',
                    image: image,
                    command: ['/opt/latest/bin/python3', '/root/run_goose.py', '--only-if-empty-db'],
                    envVariables: dbEnvVals,
                },
            ],
            containers: [
                {
                    name: 'metaflow-service',
                    image: image,
                    command: ['/opt/latest/bin/python3', '-m', 'services.metadata_service.server'],
                    imagePullPolicy: kplus.ImagePullPolicy.IF_NOT_PRESENT,
                    liveness: kplus.Probe.fromHttpGet('/ping', { port: metadataServicePort }),
                    readiness: kplus.Probe.fromHttpGet('/ping', { port: metadataServicePort }),
                    port: metadataServicePort,
                    envVariables: dbEnvVals,
                },
            ],
            metadata: {
                name: serviceAccountName,
                labels: {
                    'helm.sh/chart': 'metaflow-service-0.2.0',
                    'app.kubernetes.io/name': serviceName,
                    'app.kubernetes.io/instance': 'release-name',
                    'app.kubernetes.io/version': '2.2.4',
                    'app.kubernetes.io/managed-by': 'Helm',
                },
            },
            serviceAccount,
        });
        this.service = new kplus.Service(this, 'metaflow-service', {
            metadata: {
                name: serviceAccountName,
                labels: {
                    'helm.sh/chart': 'metaflow-service-0.2.0',
                    'app.kubernetes.io/name': serviceName,
                    'app.kubernetes.io/instance': 'release-name',
                    'app.kubernetes.io/version': '2.2.4',
                    'app.kubernetes.io/managed-by': 'Helm',
                },
            },
            type: kplus.ServiceType.CLUSTER_IP,
            ports: [
                {
                    name: 'metadata',
                    port: metadataServicePort,
                    protocol: cdk8s_plus_22_1.Protocol.TCP,
                    targetPort: metadataServicePort,
                },
                {
                    name: 'upgrades',
                    port: upgradesServicePort,
                    protocol: cdk8s_plus_22_1.Protocol.TCP,
                    targetPort: upgradesServicePort,
                },
            ],
        });
        new kplus.Pod(this, 'metaflow-service-pod', {
            metadata: {
                name: 'release-name-metaflow-service-test-connection',
                labels: {
                    'helm.sh/chart': 'metaflow-service-0.2.0',
                    'app.kubernetes.io/name': serviceName,
                    'app.kubernetes.io/instance': 'release-name',
                    'app.kubernetes.io/version': '2.2.4',
                    'app.kubernetes.io/managed-by': 'Helm',
                },
                annotations: { 'helm.sh/hook': 'test' },
            },
            containers: [
                {
                    name: 'wget',
                    image: 'busybox',
                    command: ['wget'],
                    args: ['release-name-metaflow-service:8080'],
                },
            ],
            restartPolicy: kplus.RestartPolicy.ON_FAILURE,
        });
        if (props?.postgresEnabled) {
            new cdk8s_1.Helm(this, 'postgres', {
                chart: 'bitnami/postgresql',
                releaseName: 'release-name-postgresql',
                values: {
                    enabled: true,
                    serviceAccount: {
                        name: serviceAccountName,
                    },
                    auth: {
                        database: props?.postgresOptions?.databaseName ?? 'metaflow',
                        username: props?.postgresOptions?.databaseUser ?? 'metaflow',
                        password: props?.postgresOptions?.databasePassword ?? 'metaflow',
                    },
                },
            });
        }
        if (props?.ingressEnabled) {
            const ingress = new kplus.Ingress(this, 'ingress', {
                metadata: {
                    name: serviceAccountName,
                    labels: {
                        'helm.sh/chart': 'metaflow-service-0.2.0',
                        'app.kubernetes.io/name': serviceName,
                        'app.kubernetes.io/instance': 'release-name',
                        'app.kubernetes.io/version': '2.2.4',
                        'app.kubernetes.io/managed-by': 'Helm',
                    },
                },
            });
            ingress.addHostRule(ingressHostName, '/', kplus.IngressBackend.fromService(this.service, { port: metadataServicePort }), cdk8s_plus_22_1.HttpIngressPathType.IMPLEMENTATION_SPECIFIC);
        }
    }
}
exports.MetaflowService = MetaflowService;
_a = JSII_RTTI_SYMBOL_1;
MetaflowService[_a] = { fqn: "cdk8s-metaflow.MetaflowService", version: "0.0.2" };
//# sourceMappingURL=data:application/json;base64,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