import { ApiObject, ApiObjectMetadata, GroupVersionKind } from 'cdk8s';
import { Construct } from 'constructs';
/**
 *
 *
 * @schema Tenant
 */
export declare class Tenant extends ApiObject {
    /**
     * Returns the apiVersion and kind for "Tenant"
     */
    static readonly GVK: GroupVersionKind;
    /**
     * Renders a Kubernetes manifest for "Tenant".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props
     */
    static manifest(props: TenantProps): any;
    /**
     * Defines a "Tenant" API object
     * @param scope the scope in which to define this object
     * @param id a scope-local name for the object
     * @param props initialization props
     */
    constructor(scope: Construct, id: string, props: TenantProps);
    /**
     * Renders the object to Kubernetes JSON.
     */
    toJson(): any;
}
/**
 * @schema Tenant
 */
export interface TenantProps {
    /**
     * @schema Tenant#metadata
     */
    readonly metadata?: ApiObjectMetadata;
    /**
     * @schema Tenant#scheduler
     */
    readonly scheduler?: TenantScheduler;
    /**
     * @schema Tenant#spec
     */
    readonly spec: TenantSpec;
}
/**
 * Converts an object of type 'TenantProps' to JSON representation.
 */
export declare function toJson_TenantProps(obj: TenantProps | undefined): Record<string, any> | undefined;
/**
 * @schema TenantScheduler
 */
export interface TenantScheduler {
    /**
     * @schema TenantScheduler#name
     */
    readonly name: string;
}
/**
 * Converts an object of type 'TenantScheduler' to JSON representation.
 */
export declare function toJson_TenantScheduler(obj: TenantScheduler | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpec
 */
export interface TenantSpec {
    /**
     * @schema TenantSpec#certConfig
     */
    readonly certConfig?: TenantSpecCertConfig;
    /**
     * @schema TenantSpec#configuration
     */
    readonly configuration?: TenantSpecConfiguration;
    /**
     * @schema TenantSpec#credsSecret
     */
    readonly credsSecret?: TenantSpecCredsSecret;
    /**
     * @schema TenantSpec#env
     */
    readonly env?: TenantSpecEnv[];
    /**
     * @schema TenantSpec#exposeServices
     */
    readonly exposeServices?: TenantSpecExposeServices;
    /**
     * @schema TenantSpec#externalCaCertSecret
     */
    readonly externalCaCertSecret?: TenantSpecExternalCaCertSecret[];
    /**
     * @schema TenantSpec#externalCertSecret
     */
    readonly externalCertSecret?: TenantSpecExternalCertSecret[];
    /**
     * @schema TenantSpec#externalClientCertSecret
     */
    readonly externalClientCertSecret?: TenantSpecExternalClientCertSecret;
    /**
     * @schema TenantSpec#image
     */
    readonly image?: string;
    /**
     * @schema TenantSpec#imagePullPolicy
     */
    readonly imagePullPolicy?: string;
    /**
     * @schema TenantSpec#imagePullSecret
     */
    readonly imagePullSecret?: TenantSpecImagePullSecret;
    /**
     * @schema TenantSpec#kes
     */
    readonly kes?: TenantSpecKes;
    /**
     * @schema TenantSpec#log
     */
    readonly log?: TenantSpecLog;
    /**
     * @schema TenantSpec#mountPath
     */
    readonly mountPath?: string;
    /**
     * @schema TenantSpec#podManagementPolicy
     */
    readonly podManagementPolicy?: string;
    /**
     * @schema TenantSpec#priorityClassName
     */
    readonly priorityClassName?: string;
    /**
     * @schema TenantSpec#prometheus
     */
    readonly prometheus?: TenantSpecPrometheus;
    /**
     * @schema TenantSpec#requestAutoCert
     */
    readonly requestAutoCert?: boolean;
    /**
     * @schema TenantSpec#s3
     */
    readonly s3?: TenantSpecS3;
    /**
     * @schema TenantSpec#securityContext
     */
    readonly securityContext?: TenantSpecSecurityContext;
    /**
     * @schema TenantSpec#serviceAccountName
     */
    readonly serviceAccountName?: string;
    /**
     * @schema TenantSpec#sideCars
     */
    readonly sideCars?: TenantSpecSideCars;
    /**
     * @schema TenantSpec#subPath
     */
    readonly subPath?: string;
    /**
     * @schema TenantSpec#users
     */
    readonly users?: TenantSpecUsers[];
    /**
     * @schema TenantSpec#zones
     */
    readonly zones: TenantSpecZones[];
}
/**
 * Converts an object of type 'TenantSpec' to JSON representation.
 */
export declare function toJson_TenantSpec(obj: TenantSpec | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecCertConfig
 */
export interface TenantSpecCertConfig {
    /**
     * @schema TenantSpecCertConfig#commonName
     */
    readonly commonName?: string;
    /**
     * @schema TenantSpecCertConfig#dnsNames
     */
    readonly dnsNames?: string[];
    /**
     * @schema TenantSpecCertConfig#organizationName
     */
    readonly organizationName?: string[];
}
/**
 * Converts an object of type 'TenantSpecCertConfig' to JSON representation.
 */
export declare function toJson_TenantSpecCertConfig(obj: TenantSpecCertConfig | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecConfiguration
 */
export interface TenantSpecConfiguration {
    /**
     * @schema TenantSpecConfiguration#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'TenantSpecConfiguration' to JSON representation.
 */
export declare function toJson_TenantSpecConfiguration(obj: TenantSpecConfiguration | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecCredsSecret
 */
export interface TenantSpecCredsSecret {
    /**
     * @schema TenantSpecCredsSecret#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'TenantSpecCredsSecret' to JSON representation.
 */
export declare function toJson_TenantSpecCredsSecret(obj: TenantSpecCredsSecret | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecEnv
 */
export interface TenantSpecEnv {
    /**
     * @schema TenantSpecEnv#name
     */
    readonly name: string;
    /**
     * @schema TenantSpecEnv#value
     */
    readonly value?: string;
    /**
     * @schema TenantSpecEnv#valueFrom
     */
    readonly valueFrom?: TenantSpecEnvValueFrom;
}
/**
 * Converts an object of type 'TenantSpecEnv' to JSON representation.
 */
export declare function toJson_TenantSpecEnv(obj: TenantSpecEnv | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecExposeServices
 */
export interface TenantSpecExposeServices {
    /**
     * @schema TenantSpecExposeServices#console
     */
    readonly console?: boolean;
    /**
     * @schema TenantSpecExposeServices#minio
     */
    readonly minio?: boolean;
}
/**
 * Converts an object of type 'TenantSpecExposeServices' to JSON representation.
 */
export declare function toJson_TenantSpecExposeServices(obj: TenantSpecExposeServices | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecExternalCaCertSecret
 */
export interface TenantSpecExternalCaCertSecret {
    /**
     * @schema TenantSpecExternalCaCertSecret#name
     */
    readonly name: string;
    /**
     * @schema TenantSpecExternalCaCertSecret#type
     */
    readonly type?: string;
}
/**
 * Converts an object of type 'TenantSpecExternalCaCertSecret' to JSON representation.
 */
export declare function toJson_TenantSpecExternalCaCertSecret(obj: TenantSpecExternalCaCertSecret | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecExternalCertSecret
 */
export interface TenantSpecExternalCertSecret {
    /**
     * @schema TenantSpecExternalCertSecret#name
     */
    readonly name: string;
    /**
     * @schema TenantSpecExternalCertSecret#type
     */
    readonly type?: string;
}
/**
 * Converts an object of type 'TenantSpecExternalCertSecret' to JSON representation.
 */
export declare function toJson_TenantSpecExternalCertSecret(obj: TenantSpecExternalCertSecret | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecExternalClientCertSecret
 */
export interface TenantSpecExternalClientCertSecret {
    /**
     * @schema TenantSpecExternalClientCertSecret#name
     */
    readonly name: string;
    /**
     * @schema TenantSpecExternalClientCertSecret#type
     */
    readonly type?: string;
}
/**
 * Converts an object of type 'TenantSpecExternalClientCertSecret' to JSON representation.
 */
export declare function toJson_TenantSpecExternalClientCertSecret(obj: TenantSpecExternalClientCertSecret | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecImagePullSecret
 */
export interface TenantSpecImagePullSecret {
    /**
     * @schema TenantSpecImagePullSecret#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'TenantSpecImagePullSecret' to JSON representation.
 */
export declare function toJson_TenantSpecImagePullSecret(obj: TenantSpecImagePullSecret | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKes
 */
export interface TenantSpecKes {
    /**
     * @schema TenantSpecKes#affinity
     */
    readonly affinity?: TenantSpecKesAffinity;
    /**
     * @schema TenantSpecKes#annotations
     */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
     * @schema TenantSpecKes#clientCertSecret
     */
    readonly clientCertSecret?: TenantSpecKesClientCertSecret;
    /**
     * @schema TenantSpecKes#externalCertSecret
     */
    readonly externalCertSecret?: TenantSpecKesExternalCertSecret;
    /**
     * @schema TenantSpecKes#image
     */
    readonly image?: string;
    /**
     * @schema TenantSpecKes#imagePullPolicy
     */
    readonly imagePullPolicy?: string;
    /**
     * @schema TenantSpecKes#kesSecret
     */
    readonly kesSecret: TenantSpecKesKesSecret;
    /**
     * @schema TenantSpecKes#keyName
     */
    readonly keyName?: string;
    /**
     * @schema TenantSpecKes#labels
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * @schema TenantSpecKes#nodeSelector
     */
    readonly nodeSelector?: {
        [key: string]: string;
    };
    /**
     * @schema TenantSpecKes#replicas
     */
    readonly replicas?: number;
    /**
     * @schema TenantSpecKes#resources
     */
    readonly resources?: TenantSpecKesResources;
    /**
     * @schema TenantSpecKes#securityContext
     */
    readonly securityContext?: TenantSpecKesSecurityContext;
    /**
     * @schema TenantSpecKes#serviceAccountName
     */
    readonly serviceAccountName?: string;
    /**
     * @schema TenantSpecKes#tolerations
     */
    readonly tolerations?: TenantSpecKesTolerations[];
    /**
     * @schema TenantSpecKes#topologySpreadConstraints
     */
    readonly topologySpreadConstraints?: TenantSpecKesTopologySpreadConstraints[];
}
/**
 * Converts an object of type 'TenantSpecKes' to JSON representation.
 */
export declare function toJson_TenantSpecKes(obj: TenantSpecKes | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLog
 */
export interface TenantSpecLog {
    /**
     * @schema TenantSpecLog#affinity
     */
    readonly affinity?: TenantSpecLogAffinity;
    /**
     * @schema TenantSpecLog#annotations
     */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
     * @schema TenantSpecLog#audit
     */
    readonly audit?: TenantSpecLogAudit;
    /**
     * @schema TenantSpecLog#db
     */
    readonly db?: TenantSpecLogDb;
    /**
     * @schema TenantSpecLog#image
     */
    readonly image?: string;
    /**
     * @schema TenantSpecLog#labels
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * @schema TenantSpecLog#nodeSelector
     */
    readonly nodeSelector?: {
        [key: string]: string;
    };
    /**
     * @schema TenantSpecLog#resources
     */
    readonly resources?: TenantSpecLogResources;
    /**
     * @schema TenantSpecLog#securityContext
     */
    readonly securityContext?: TenantSpecLogSecurityContext;
    /**
     * @schema TenantSpecLog#serviceAccountName
     */
    readonly serviceAccountName?: string;
    /**
     * @schema TenantSpecLog#tolerations
     */
    readonly tolerations?: TenantSpecLogTolerations[];
    /**
     * @schema TenantSpecLog#topologySpreadConstraints
     */
    readonly topologySpreadConstraints?: TenantSpecLogTopologySpreadConstraints[];
}
/**
 * Converts an object of type 'TenantSpecLog' to JSON representation.
 */
export declare function toJson_TenantSpecLog(obj: TenantSpecLog | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheus
 */
export interface TenantSpecPrometheus {
    /**
     * @schema TenantSpecPrometheus#affinity
     */
    readonly affinity?: TenantSpecPrometheusAffinity;
    /**
     * @schema TenantSpecPrometheus#annotations
     */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
     * @schema TenantSpecPrometheus#diskCapacityGB
     */
    readonly diskCapacityGb?: number;
    /**
     * @schema TenantSpecPrometheus#image
     */
    readonly image?: string;
    /**
     * @schema TenantSpecPrometheus#initimage
     */
    readonly initimage?: string;
    /**
     * @schema TenantSpecPrometheus#labels
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * @schema TenantSpecPrometheus#nodeSelector
     */
    readonly nodeSelector?: {
        [key: string]: string;
    };
    /**
     * @schema TenantSpecPrometheus#resources
     */
    readonly resources?: TenantSpecPrometheusResources;
    /**
     * @schema TenantSpecPrometheus#securityContext
     */
    readonly securityContext?: TenantSpecPrometheusSecurityContext;
    /**
     * @schema TenantSpecPrometheus#serviceAccountName
     */
    readonly serviceAccountName?: string;
    /**
     * @schema TenantSpecPrometheus#sidecarimage
     */
    readonly sidecarimage?: string;
    /**
     * @schema TenantSpecPrometheus#storageClassName
     */
    readonly storageClassName?: string;
    /**
     * @schema TenantSpecPrometheus#topologySpreadConstraints
     */
    readonly topologySpreadConstraints?: TenantSpecPrometheusTopologySpreadConstraints[];
}
/**
 * Converts an object of type 'TenantSpecPrometheus' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheus(obj: TenantSpecPrometheus | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecS3
 */
export interface TenantSpecS3 {
    /**
     * @schema TenantSpecS3#bucketDNS
     */
    readonly bucketDns?: boolean;
}
/**
 * Converts an object of type 'TenantSpecS3' to JSON representation.
 */
export declare function toJson_TenantSpecS3(obj: TenantSpecS3 | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSecurityContext
 */
export interface TenantSpecSecurityContext {
    /**
     * @schema TenantSpecSecurityContext#fsGroup
     */
    readonly fsGroup?: number;
    /**
     * @schema TenantSpecSecurityContext#fsGroupChangePolicy
     */
    readonly fsGroupChangePolicy?: string;
    /**
     * @schema TenantSpecSecurityContext#runAsGroup
     */
    readonly runAsGroup?: number;
    /**
     * @schema TenantSpecSecurityContext#runAsNonRoot
     */
    readonly runAsNonRoot?: boolean;
    /**
     * @schema TenantSpecSecurityContext#runAsUser
     */
    readonly runAsUser?: number;
    /**
     * @schema TenantSpecSecurityContext#seLinuxOptions
     */
    readonly seLinuxOptions?: TenantSpecSecurityContextSeLinuxOptions;
    /**
     * @schema TenantSpecSecurityContext#seccompProfile
     */
    readonly seccompProfile?: TenantSpecSecurityContextSeccompProfile;
    /**
     * @schema TenantSpecSecurityContext#supplementalGroups
     */
    readonly supplementalGroups?: number[];
    /**
     * @schema TenantSpecSecurityContext#sysctls
     */
    readonly sysctls?: TenantSpecSecurityContextSysctls[];
    /**
     * @schema TenantSpecSecurityContext#windowsOptions
     */
    readonly windowsOptions?: TenantSpecSecurityContextWindowsOptions;
}
/**
 * Converts an object of type 'TenantSpecSecurityContext' to JSON representation.
 */
export declare function toJson_TenantSpecSecurityContext(obj: TenantSpecSecurityContext | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCars
 */
export interface TenantSpecSideCars {
    /**
     * @schema TenantSpecSideCars#containers
     */
    readonly containers: TenantSpecSideCarsContainers[];
    /**
     * @schema TenantSpecSideCars#volumeClaimTemplates
     */
    readonly volumeClaimTemplates?: TenantSpecSideCarsVolumeClaimTemplates[];
    /**
     * @schema TenantSpecSideCars#volumes
     */
    readonly volumes?: TenantSpecSideCarsVolumes[];
}
/**
 * Converts an object of type 'TenantSpecSideCars' to JSON representation.
 */
export declare function toJson_TenantSpecSideCars(obj: TenantSpecSideCars | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecUsers
 */
export interface TenantSpecUsers {
    /**
     * @schema TenantSpecUsers#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'TenantSpecUsers' to JSON representation.
 */
export declare function toJson_TenantSpecUsers(obj: TenantSpecUsers | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZones
 */
export interface TenantSpecZones {
    /**
     * @schema TenantSpecZones#affinity
     */
    readonly affinity?: TenantSpecZonesAffinity;
    /**
     * @schema TenantSpecZones#annotations
     */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
     * @schema TenantSpecZones#labels
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * @schema TenantSpecZones#name
     */
    readonly name?: string;
    /**
     * @schema TenantSpecZones#nodeSelector
     */
    readonly nodeSelector?: {
        [key: string]: string;
    };
    /**
     * @schema TenantSpecZones#resources
     */
    readonly resources?: TenantSpecZonesResources;
    /**
     * @schema TenantSpecZones#securityContext
     */
    readonly securityContext?: TenantSpecZonesSecurityContext;
    /**
     * @schema TenantSpecZones#servers
     */
    readonly servers: number;
    /**
     * @schema TenantSpecZones#tolerations
     */
    readonly tolerations?: TenantSpecZonesTolerations[];
    /**
     * @schema TenantSpecZones#topologySpreadConstraints
     */
    readonly topologySpreadConstraints?: TenantSpecZonesTopologySpreadConstraints[];
    /**
     * @schema TenantSpecZones#volumeClaimTemplate
     */
    readonly volumeClaimTemplate: TenantSpecZonesVolumeClaimTemplate;
    /**
     * @schema TenantSpecZones#volumesPerServer
     */
    readonly volumesPerServer: number;
}
/**
 * Converts an object of type 'TenantSpecZones' to JSON representation.
 */
export declare function toJson_TenantSpecZones(obj: TenantSpecZones | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecEnvValueFrom
 */
export interface TenantSpecEnvValueFrom {
    /**
     * @schema TenantSpecEnvValueFrom#configMapKeyRef
     */
    readonly configMapKeyRef?: TenantSpecEnvValueFromConfigMapKeyRef;
    /**
     * @schema TenantSpecEnvValueFrom#fieldRef
     */
    readonly fieldRef?: TenantSpecEnvValueFromFieldRef;
    /**
     * @schema TenantSpecEnvValueFrom#resourceFieldRef
     */
    readonly resourceFieldRef?: TenantSpecEnvValueFromResourceFieldRef;
    /**
     * @schema TenantSpecEnvValueFrom#secretKeyRef
     */
    readonly secretKeyRef?: TenantSpecEnvValueFromSecretKeyRef;
}
/**
 * Converts an object of type 'TenantSpecEnvValueFrom' to JSON representation.
 */
export declare function toJson_TenantSpecEnvValueFrom(obj: TenantSpecEnvValueFrom | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesAffinity
 */
export interface TenantSpecKesAffinity {
    /**
     * @schema TenantSpecKesAffinity#nodeAffinity
     */
    readonly nodeAffinity?: TenantSpecKesAffinityNodeAffinity;
    /**
     * @schema TenantSpecKesAffinity#podAffinity
     */
    readonly podAffinity?: TenantSpecKesAffinityPodAffinity;
    /**
     * @schema TenantSpecKesAffinity#podAntiAffinity
     */
    readonly podAntiAffinity?: TenantSpecKesAffinityPodAntiAffinity;
}
/**
 * Converts an object of type 'TenantSpecKesAffinity' to JSON representation.
 */
export declare function toJson_TenantSpecKesAffinity(obj: TenantSpecKesAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesClientCertSecret
 */
export interface TenantSpecKesClientCertSecret {
    /**
     * @schema TenantSpecKesClientCertSecret#name
     */
    readonly name: string;
    /**
     * @schema TenantSpecKesClientCertSecret#type
     */
    readonly type?: string;
}
/**
 * Converts an object of type 'TenantSpecKesClientCertSecret' to JSON representation.
 */
export declare function toJson_TenantSpecKesClientCertSecret(obj: TenantSpecKesClientCertSecret | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesExternalCertSecret
 */
export interface TenantSpecKesExternalCertSecret {
    /**
     * @schema TenantSpecKesExternalCertSecret#name
     */
    readonly name: string;
    /**
     * @schema TenantSpecKesExternalCertSecret#type
     */
    readonly type?: string;
}
/**
 * Converts an object of type 'TenantSpecKesExternalCertSecret' to JSON representation.
 */
export declare function toJson_TenantSpecKesExternalCertSecret(obj: TenantSpecKesExternalCertSecret | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesKesSecret
 */
export interface TenantSpecKesKesSecret {
    /**
     * @schema TenantSpecKesKesSecret#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'TenantSpecKesKesSecret' to JSON representation.
 */
export declare function toJson_TenantSpecKesKesSecret(obj: TenantSpecKesKesSecret | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesResources
 */
export interface TenantSpecKesResources {
    /**
     * @schema TenantSpecKesResources#limits
     */
    readonly limits?: {
        [key: string]: TenantSpecKesResourcesLimits;
    };
    /**
     * @schema TenantSpecKesResources#requests
     */
    readonly requests?: {
        [key: string]: TenantSpecKesResourcesRequests;
    };
}
/**
 * Converts an object of type 'TenantSpecKesResources' to JSON representation.
 */
export declare function toJson_TenantSpecKesResources(obj: TenantSpecKesResources | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesSecurityContext
 */
export interface TenantSpecKesSecurityContext {
    /**
     * @schema TenantSpecKesSecurityContext#fsGroup
     */
    readonly fsGroup?: number;
    /**
     * @schema TenantSpecKesSecurityContext#fsGroupChangePolicy
     */
    readonly fsGroupChangePolicy?: string;
    /**
     * @schema TenantSpecKesSecurityContext#runAsGroup
     */
    readonly runAsGroup?: number;
    /**
     * @schema TenantSpecKesSecurityContext#runAsNonRoot
     */
    readonly runAsNonRoot?: boolean;
    /**
     * @schema TenantSpecKesSecurityContext#runAsUser
     */
    readonly runAsUser?: number;
    /**
     * @schema TenantSpecKesSecurityContext#seLinuxOptions
     */
    readonly seLinuxOptions?: TenantSpecKesSecurityContextSeLinuxOptions;
    /**
     * @schema TenantSpecKesSecurityContext#seccompProfile
     */
    readonly seccompProfile?: TenantSpecKesSecurityContextSeccompProfile;
    /**
     * @schema TenantSpecKesSecurityContext#supplementalGroups
     */
    readonly supplementalGroups?: number[];
    /**
     * @schema TenantSpecKesSecurityContext#sysctls
     */
    readonly sysctls?: TenantSpecKesSecurityContextSysctls[];
    /**
     * @schema TenantSpecKesSecurityContext#windowsOptions
     */
    readonly windowsOptions?: TenantSpecKesSecurityContextWindowsOptions;
}
/**
 * Converts an object of type 'TenantSpecKesSecurityContext' to JSON representation.
 */
export declare function toJson_TenantSpecKesSecurityContext(obj: TenantSpecKesSecurityContext | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesTolerations
 */
export interface TenantSpecKesTolerations {
    /**
     * @schema TenantSpecKesTolerations#effect
     */
    readonly effect?: string;
    /**
     * @schema TenantSpecKesTolerations#key
     */
    readonly key?: string;
    /**
     * @schema TenantSpecKesTolerations#operator
     */
    readonly operator?: string;
    /**
     * @schema TenantSpecKesTolerations#tolerationSeconds
     */
    readonly tolerationSeconds?: number;
    /**
     * @schema TenantSpecKesTolerations#value
     */
    readonly value?: string;
}
/**
 * Converts an object of type 'TenantSpecKesTolerations' to JSON representation.
 */
export declare function toJson_TenantSpecKesTolerations(obj: TenantSpecKesTolerations | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesTopologySpreadConstraints
 */
export interface TenantSpecKesTopologySpreadConstraints {
    /**
     * @schema TenantSpecKesTopologySpreadConstraints#labelSelector
     */
    readonly labelSelector?: TenantSpecKesTopologySpreadConstraintsLabelSelector;
    /**
     * @schema TenantSpecKesTopologySpreadConstraints#maxSkew
     */
    readonly maxSkew: number;
    /**
     * @schema TenantSpecKesTopologySpreadConstraints#topologyKey
     */
    readonly topologyKey: string;
    /**
     * @schema TenantSpecKesTopologySpreadConstraints#whenUnsatisfiable
     */
    readonly whenUnsatisfiable: string;
}
/**
 * Converts an object of type 'TenantSpecKesTopologySpreadConstraints' to JSON representation.
 */
export declare function toJson_TenantSpecKesTopologySpreadConstraints(obj: TenantSpecKesTopologySpreadConstraints | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogAffinity
 */
export interface TenantSpecLogAffinity {
    /**
     * @schema TenantSpecLogAffinity#nodeAffinity
     */
    readonly nodeAffinity?: TenantSpecLogAffinityNodeAffinity;
    /**
     * @schema TenantSpecLogAffinity#podAffinity
     */
    readonly podAffinity?: TenantSpecLogAffinityPodAffinity;
    /**
     * @schema TenantSpecLogAffinity#podAntiAffinity
     */
    readonly podAntiAffinity?: TenantSpecLogAffinityPodAntiAffinity;
}
/**
 * Converts an object of type 'TenantSpecLogAffinity' to JSON representation.
 */
export declare function toJson_TenantSpecLogAffinity(obj: TenantSpecLogAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogAudit
 */
export interface TenantSpecLogAudit {
    /**
     * @schema TenantSpecLogAudit#diskCapacityGB
     */
    readonly diskCapacityGb?: number;
}
/**
 * Converts an object of type 'TenantSpecLogAudit' to JSON representation.
 */
export declare function toJson_TenantSpecLogAudit(obj: TenantSpecLogAudit | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDb
 */
export interface TenantSpecLogDb {
    /**
     * @schema TenantSpecLogDb#affinity
     */
    readonly affinity?: TenantSpecLogDbAffinity;
    /**
     * @schema TenantSpecLogDb#annotations
     */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
     * @schema TenantSpecLogDb#image
     */
    readonly image?: string;
    /**
     * @schema TenantSpecLogDb#initimage
     */
    readonly initimage?: string;
    /**
     * @schema TenantSpecLogDb#labels
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * @schema TenantSpecLogDb#nodeSelector
     */
    readonly nodeSelector?: {
        [key: string]: string;
    };
    /**
     * @schema TenantSpecLogDb#resources
     */
    readonly resources?: TenantSpecLogDbResources;
    /**
     * @schema TenantSpecLogDb#securityContext
     */
    readonly securityContext?: TenantSpecLogDbSecurityContext;
    /**
     * @schema TenantSpecLogDb#serviceAccountName
     */
    readonly serviceAccountName?: string;
    /**
     * @schema TenantSpecLogDb#tolerations
     */
    readonly tolerations?: TenantSpecLogDbTolerations[];
    /**
     * @schema TenantSpecLogDb#topologySpreadConstraints
     */
    readonly topologySpreadConstraints?: TenantSpecLogDbTopologySpreadConstraints[];
    /**
     * @schema TenantSpecLogDb#volumeClaimTemplate
     */
    readonly volumeClaimTemplate: TenantSpecLogDbVolumeClaimTemplate;
}
/**
 * Converts an object of type 'TenantSpecLogDb' to JSON representation.
 */
export declare function toJson_TenantSpecLogDb(obj: TenantSpecLogDb | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogResources
 */
export interface TenantSpecLogResources {
    /**
     * @schema TenantSpecLogResources#limits
     */
    readonly limits?: {
        [key: string]: TenantSpecLogResourcesLimits;
    };
    /**
     * @schema TenantSpecLogResources#requests
     */
    readonly requests?: {
        [key: string]: TenantSpecLogResourcesRequests;
    };
}
/**
 * Converts an object of type 'TenantSpecLogResources' to JSON representation.
 */
export declare function toJson_TenantSpecLogResources(obj: TenantSpecLogResources | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogSecurityContext
 */
export interface TenantSpecLogSecurityContext {
    /**
     * @schema TenantSpecLogSecurityContext#fsGroup
     */
    readonly fsGroup?: number;
    /**
     * @schema TenantSpecLogSecurityContext#fsGroupChangePolicy
     */
    readonly fsGroupChangePolicy?: string;
    /**
     * @schema TenantSpecLogSecurityContext#runAsGroup
     */
    readonly runAsGroup?: number;
    /**
     * @schema TenantSpecLogSecurityContext#runAsNonRoot
     */
    readonly runAsNonRoot?: boolean;
    /**
     * @schema TenantSpecLogSecurityContext#runAsUser
     */
    readonly runAsUser?: number;
    /**
     * @schema TenantSpecLogSecurityContext#seLinuxOptions
     */
    readonly seLinuxOptions?: TenantSpecLogSecurityContextSeLinuxOptions;
    /**
     * @schema TenantSpecLogSecurityContext#seccompProfile
     */
    readonly seccompProfile?: TenantSpecLogSecurityContextSeccompProfile;
    /**
     * @schema TenantSpecLogSecurityContext#supplementalGroups
     */
    readonly supplementalGroups?: number[];
    /**
     * @schema TenantSpecLogSecurityContext#sysctls
     */
    readonly sysctls?: TenantSpecLogSecurityContextSysctls[];
    /**
     * @schema TenantSpecLogSecurityContext#windowsOptions
     */
    readonly windowsOptions?: TenantSpecLogSecurityContextWindowsOptions;
}
/**
 * Converts an object of type 'TenantSpecLogSecurityContext' to JSON representation.
 */
export declare function toJson_TenantSpecLogSecurityContext(obj: TenantSpecLogSecurityContext | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogTolerations
 */
export interface TenantSpecLogTolerations {
    /**
     * @schema TenantSpecLogTolerations#effect
     */
    readonly effect?: string;
    /**
     * @schema TenantSpecLogTolerations#key
     */
    readonly key?: string;
    /**
     * @schema TenantSpecLogTolerations#operator
     */
    readonly operator?: string;
    /**
     * @schema TenantSpecLogTolerations#tolerationSeconds
     */
    readonly tolerationSeconds?: number;
    /**
     * @schema TenantSpecLogTolerations#value
     */
    readonly value?: string;
}
/**
 * Converts an object of type 'TenantSpecLogTolerations' to JSON representation.
 */
export declare function toJson_TenantSpecLogTolerations(obj: TenantSpecLogTolerations | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogTopologySpreadConstraints
 */
export interface TenantSpecLogTopologySpreadConstraints {
    /**
     * @schema TenantSpecLogTopologySpreadConstraints#labelSelector
     */
    readonly labelSelector?: TenantSpecLogTopologySpreadConstraintsLabelSelector;
    /**
     * @schema TenantSpecLogTopologySpreadConstraints#maxSkew
     */
    readonly maxSkew: number;
    /**
     * @schema TenantSpecLogTopologySpreadConstraints#topologyKey
     */
    readonly topologyKey: string;
    /**
     * @schema TenantSpecLogTopologySpreadConstraints#whenUnsatisfiable
     */
    readonly whenUnsatisfiable: string;
}
/**
 * Converts an object of type 'TenantSpecLogTopologySpreadConstraints' to JSON representation.
 */
export declare function toJson_TenantSpecLogTopologySpreadConstraints(obj: TenantSpecLogTopologySpreadConstraints | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusAffinity
 */
export interface TenantSpecPrometheusAffinity {
    /**
     * @schema TenantSpecPrometheusAffinity#nodeAffinity
     */
    readonly nodeAffinity?: TenantSpecPrometheusAffinityNodeAffinity;
    /**
     * @schema TenantSpecPrometheusAffinity#podAffinity
     */
    readonly podAffinity?: TenantSpecPrometheusAffinityPodAffinity;
    /**
     * @schema TenantSpecPrometheusAffinity#podAntiAffinity
     */
    readonly podAntiAffinity?: TenantSpecPrometheusAffinityPodAntiAffinity;
}
/**
 * Converts an object of type 'TenantSpecPrometheusAffinity' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusAffinity(obj: TenantSpecPrometheusAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusResources
 */
export interface TenantSpecPrometheusResources {
    /**
     * @schema TenantSpecPrometheusResources#limits
     */
    readonly limits?: {
        [key: string]: TenantSpecPrometheusResourcesLimits;
    };
    /**
     * @schema TenantSpecPrometheusResources#requests
     */
    readonly requests?: {
        [key: string]: TenantSpecPrometheusResourcesRequests;
    };
}
/**
 * Converts an object of type 'TenantSpecPrometheusResources' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusResources(obj: TenantSpecPrometheusResources | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusSecurityContext
 */
export interface TenantSpecPrometheusSecurityContext {
    /**
     * @schema TenantSpecPrometheusSecurityContext#fsGroup
     */
    readonly fsGroup?: number;
    /**
     * @schema TenantSpecPrometheusSecurityContext#fsGroupChangePolicy
     */
    readonly fsGroupChangePolicy?: string;
    /**
     * @schema TenantSpecPrometheusSecurityContext#runAsGroup
     */
    readonly runAsGroup?: number;
    /**
     * @schema TenantSpecPrometheusSecurityContext#runAsNonRoot
     */
    readonly runAsNonRoot?: boolean;
    /**
     * @schema TenantSpecPrometheusSecurityContext#runAsUser
     */
    readonly runAsUser?: number;
    /**
     * @schema TenantSpecPrometheusSecurityContext#seLinuxOptions
     */
    readonly seLinuxOptions?: TenantSpecPrometheusSecurityContextSeLinuxOptions;
    /**
     * @schema TenantSpecPrometheusSecurityContext#seccompProfile
     */
    readonly seccompProfile?: TenantSpecPrometheusSecurityContextSeccompProfile;
    /**
     * @schema TenantSpecPrometheusSecurityContext#supplementalGroups
     */
    readonly supplementalGroups?: number[];
    /**
     * @schema TenantSpecPrometheusSecurityContext#sysctls
     */
    readonly sysctls?: TenantSpecPrometheusSecurityContextSysctls[];
    /**
     * @schema TenantSpecPrometheusSecurityContext#windowsOptions
     */
    readonly windowsOptions?: TenantSpecPrometheusSecurityContextWindowsOptions;
}
/**
 * Converts an object of type 'TenantSpecPrometheusSecurityContext' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusSecurityContext(obj: TenantSpecPrometheusSecurityContext | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusTopologySpreadConstraints
 */
export interface TenantSpecPrometheusTopologySpreadConstraints {
    /**
     * @schema TenantSpecPrometheusTopologySpreadConstraints#labelSelector
     */
    readonly labelSelector?: TenantSpecPrometheusTopologySpreadConstraintsLabelSelector;
    /**
     * @schema TenantSpecPrometheusTopologySpreadConstraints#maxSkew
     */
    readonly maxSkew: number;
    /**
     * @schema TenantSpecPrometheusTopologySpreadConstraints#topologyKey
     */
    readonly topologyKey: string;
    /**
     * @schema TenantSpecPrometheusTopologySpreadConstraints#whenUnsatisfiable
     */
    readonly whenUnsatisfiable: string;
}
/**
 * Converts an object of type 'TenantSpecPrometheusTopologySpreadConstraints' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusTopologySpreadConstraints(obj: TenantSpecPrometheusTopologySpreadConstraints | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSecurityContextSeLinuxOptions
 */
export interface TenantSpecSecurityContextSeLinuxOptions {
    /**
     * @schema TenantSpecSecurityContextSeLinuxOptions#level
     */
    readonly level?: string;
    /**
     * @schema TenantSpecSecurityContextSeLinuxOptions#role
     */
    readonly role?: string;
    /**
     * @schema TenantSpecSecurityContextSeLinuxOptions#type
     */
    readonly type?: string;
    /**
     * @schema TenantSpecSecurityContextSeLinuxOptions#user
     */
    readonly user?: string;
}
/**
 * Converts an object of type 'TenantSpecSecurityContextSeLinuxOptions' to JSON representation.
 */
export declare function toJson_TenantSpecSecurityContextSeLinuxOptions(obj: TenantSpecSecurityContextSeLinuxOptions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSecurityContextSeccompProfile
 */
export interface TenantSpecSecurityContextSeccompProfile {
    /**
     * @schema TenantSpecSecurityContextSeccompProfile#localhostProfile
     */
    readonly localhostProfile?: string;
    /**
     * @schema TenantSpecSecurityContextSeccompProfile#type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'TenantSpecSecurityContextSeccompProfile' to JSON representation.
 */
export declare function toJson_TenantSpecSecurityContextSeccompProfile(obj: TenantSpecSecurityContextSeccompProfile | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSecurityContextSysctls
 */
export interface TenantSpecSecurityContextSysctls {
    /**
     * @schema TenantSpecSecurityContextSysctls#name
     */
    readonly name: string;
    /**
     * @schema TenantSpecSecurityContextSysctls#value
     */
    readonly value: string;
}
/**
 * Converts an object of type 'TenantSpecSecurityContextSysctls' to JSON representation.
 */
export declare function toJson_TenantSpecSecurityContextSysctls(obj: TenantSpecSecurityContextSysctls | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSecurityContextWindowsOptions
 */
export interface TenantSpecSecurityContextWindowsOptions {
    /**
     * @schema TenantSpecSecurityContextWindowsOptions#gmsaCredentialSpec
     */
    readonly gmsaCredentialSpec?: string;
    /**
     * @schema TenantSpecSecurityContextWindowsOptions#gmsaCredentialSpecName
     */
    readonly gmsaCredentialSpecName?: string;
    /**
     * @schema TenantSpecSecurityContextWindowsOptions#runAsUserName
     */
    readonly runAsUserName?: string;
}
/**
 * Converts an object of type 'TenantSpecSecurityContextWindowsOptions' to JSON representation.
 */
export declare function toJson_TenantSpecSecurityContextWindowsOptions(obj: TenantSpecSecurityContextWindowsOptions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainers
 */
export interface TenantSpecSideCarsContainers {
    /**
     * @schema TenantSpecSideCarsContainers#args
     */
    readonly args?: string[];
    /**
     * @schema TenantSpecSideCarsContainers#command
     */
    readonly command?: string[];
    /**
     * @schema TenantSpecSideCarsContainers#env
     */
    readonly env?: TenantSpecSideCarsContainersEnv[];
    /**
     * @schema TenantSpecSideCarsContainers#envFrom
     */
    readonly envFrom?: TenantSpecSideCarsContainersEnvFrom[];
    /**
     * @schema TenantSpecSideCarsContainers#image
     */
    readonly image?: string;
    /**
     * @schema TenantSpecSideCarsContainers#imagePullPolicy
     */
    readonly imagePullPolicy?: string;
    /**
     * @schema TenantSpecSideCarsContainers#lifecycle
     */
    readonly lifecycle?: TenantSpecSideCarsContainersLifecycle;
    /**
     * @schema TenantSpecSideCarsContainers#livenessProbe
     */
    readonly livenessProbe?: TenantSpecSideCarsContainersLivenessProbe;
    /**
     * @schema TenantSpecSideCarsContainers#name
     */
    readonly name: string;
    /**
     * @schema TenantSpecSideCarsContainers#ports
     */
    readonly ports?: TenantSpecSideCarsContainersPorts[];
    /**
     * @schema TenantSpecSideCarsContainers#readinessProbe
     */
    readonly readinessProbe?: TenantSpecSideCarsContainersReadinessProbe;
    /**
     * @schema TenantSpecSideCarsContainers#resources
     */
    readonly resources?: TenantSpecSideCarsContainersResources;
    /**
     * @schema TenantSpecSideCarsContainers#securityContext
     */
    readonly securityContext?: TenantSpecSideCarsContainersSecurityContext;
    /**
     * @schema TenantSpecSideCarsContainers#startupProbe
     */
    readonly startupProbe?: TenantSpecSideCarsContainersStartupProbe;
    /**
     * @schema TenantSpecSideCarsContainers#stdin
     */
    readonly stdin?: boolean;
    /**
     * @schema TenantSpecSideCarsContainers#stdinOnce
     */
    readonly stdinOnce?: boolean;
    /**
     * @schema TenantSpecSideCarsContainers#terminationMessagePath
     */
    readonly terminationMessagePath?: string;
    /**
     * @schema TenantSpecSideCarsContainers#terminationMessagePolicy
     */
    readonly terminationMessagePolicy?: string;
    /**
     * @schema TenantSpecSideCarsContainers#tty
     */
    readonly tty?: boolean;
    /**
     * @schema TenantSpecSideCarsContainers#volumeDevices
     */
    readonly volumeDevices?: TenantSpecSideCarsContainersVolumeDevices[];
    /**
     * @schema TenantSpecSideCarsContainers#volumeMounts
     */
    readonly volumeMounts?: TenantSpecSideCarsContainersVolumeMounts[];
    /**
     * @schema TenantSpecSideCarsContainers#workingDir
     */
    readonly workingDir?: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainers' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainers(obj: TenantSpecSideCarsContainers | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumeClaimTemplates
 */
export interface TenantSpecSideCarsVolumeClaimTemplates {
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplates#apiVersion
     */
    readonly apiVersion?: string;
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplates#kind
     */
    readonly kind?: string;
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplates#metadata
     */
    readonly metadata?: TenantSpecSideCarsVolumeClaimTemplatesMetadata;
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplates#spec
     */
    readonly spec?: TenantSpecSideCarsVolumeClaimTemplatesSpec;
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplates#status
     */
    readonly status?: TenantSpecSideCarsVolumeClaimTemplatesStatus;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumeClaimTemplates' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumeClaimTemplates(obj: TenantSpecSideCarsVolumeClaimTemplates | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumes
 */
export interface TenantSpecSideCarsVolumes {
    /**
     * @schema TenantSpecSideCarsVolumes#awsElasticBlockStore
     */
    readonly awsElasticBlockStore?: TenantSpecSideCarsVolumesAwsElasticBlockStore;
    /**
     * @schema TenantSpecSideCarsVolumes#azureDisk
     */
    readonly azureDisk?: TenantSpecSideCarsVolumesAzureDisk;
    /**
     * @schema TenantSpecSideCarsVolumes#azureFile
     */
    readonly azureFile?: TenantSpecSideCarsVolumesAzureFile;
    /**
     * @schema TenantSpecSideCarsVolumes#cephfs
     */
    readonly cephfs?: TenantSpecSideCarsVolumesCephfs;
    /**
     * @schema TenantSpecSideCarsVolumes#cinder
     */
    readonly cinder?: TenantSpecSideCarsVolumesCinder;
    /**
     * @schema TenantSpecSideCarsVolumes#configMap
     */
    readonly configMap?: TenantSpecSideCarsVolumesConfigMap;
    /**
     * @schema TenantSpecSideCarsVolumes#csi
     */
    readonly csi?: TenantSpecSideCarsVolumesCsi;
    /**
     * @schema TenantSpecSideCarsVolumes#downwardAPI
     */
    readonly downwardApi?: TenantSpecSideCarsVolumesDownwardApi;
    /**
     * @schema TenantSpecSideCarsVolumes#emptyDir
     */
    readonly emptyDir?: TenantSpecSideCarsVolumesEmptyDir;
    /**
     * @schema TenantSpecSideCarsVolumes#ephemeral
     */
    readonly ephemeral?: TenantSpecSideCarsVolumesEphemeral;
    /**
     * @schema TenantSpecSideCarsVolumes#fc
     */
    readonly fc?: TenantSpecSideCarsVolumesFc;
    /**
     * @schema TenantSpecSideCarsVolumes#flexVolume
     */
    readonly flexVolume?: TenantSpecSideCarsVolumesFlexVolume;
    /**
     * @schema TenantSpecSideCarsVolumes#flocker
     */
    readonly flocker?: TenantSpecSideCarsVolumesFlocker;
    /**
     * @schema TenantSpecSideCarsVolumes#gcePersistentDisk
     */
    readonly gcePersistentDisk?: TenantSpecSideCarsVolumesGcePersistentDisk;
    /**
     * @schema TenantSpecSideCarsVolumes#gitRepo
     */
    readonly gitRepo?: TenantSpecSideCarsVolumesGitRepo;
    /**
     * @schema TenantSpecSideCarsVolumes#glusterfs
     */
    readonly glusterfs?: TenantSpecSideCarsVolumesGlusterfs;
    /**
     * @schema TenantSpecSideCarsVolumes#hostPath
     */
    readonly hostPath?: TenantSpecSideCarsVolumesHostPath;
    /**
     * @schema TenantSpecSideCarsVolumes#iscsi
     */
    readonly iscsi?: TenantSpecSideCarsVolumesIscsi;
    /**
     * @schema TenantSpecSideCarsVolumes#name
     */
    readonly name: string;
    /**
     * @schema TenantSpecSideCarsVolumes#nfs
     */
    readonly nfs?: TenantSpecSideCarsVolumesNfs;
    /**
     * @schema TenantSpecSideCarsVolumes#persistentVolumeClaim
     */
    readonly persistentVolumeClaim?: TenantSpecSideCarsVolumesPersistentVolumeClaim;
    /**
     * @schema TenantSpecSideCarsVolumes#photonPersistentDisk
     */
    readonly photonPersistentDisk?: TenantSpecSideCarsVolumesPhotonPersistentDisk;
    /**
     * @schema TenantSpecSideCarsVolumes#portworxVolume
     */
    readonly portworxVolume?: TenantSpecSideCarsVolumesPortworxVolume;
    /**
     * @schema TenantSpecSideCarsVolumes#projected
     */
    readonly projected?: TenantSpecSideCarsVolumesProjected;
    /**
     * @schema TenantSpecSideCarsVolumes#quobyte
     */
    readonly quobyte?: TenantSpecSideCarsVolumesQuobyte;
    /**
     * @schema TenantSpecSideCarsVolumes#rbd
     */
    readonly rbd?: TenantSpecSideCarsVolumesRbd;
    /**
     * @schema TenantSpecSideCarsVolumes#scaleIO
     */
    readonly scaleIo?: TenantSpecSideCarsVolumesScaleIo;
    /**
     * @schema TenantSpecSideCarsVolumes#secret
     */
    readonly secret?: TenantSpecSideCarsVolumesSecret;
    /**
     * @schema TenantSpecSideCarsVolumes#storageos
     */
    readonly storageos?: TenantSpecSideCarsVolumesStorageos;
    /**
     * @schema TenantSpecSideCarsVolumes#vsphereVolume
     */
    readonly vsphereVolume?: TenantSpecSideCarsVolumesVsphereVolume;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumes' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumes(obj: TenantSpecSideCarsVolumes | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesAffinity
 */
export interface TenantSpecZonesAffinity {
    /**
     * @schema TenantSpecZonesAffinity#nodeAffinity
     */
    readonly nodeAffinity?: TenantSpecZonesAffinityNodeAffinity;
    /**
     * @schema TenantSpecZonesAffinity#podAffinity
     */
    readonly podAffinity?: TenantSpecZonesAffinityPodAffinity;
    /**
     * @schema TenantSpecZonesAffinity#podAntiAffinity
     */
    readonly podAntiAffinity?: TenantSpecZonesAffinityPodAntiAffinity;
}
/**
 * Converts an object of type 'TenantSpecZonesAffinity' to JSON representation.
 */
export declare function toJson_TenantSpecZonesAffinity(obj: TenantSpecZonesAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesResources
 */
export interface TenantSpecZonesResources {
    /**
     * @schema TenantSpecZonesResources#limits
     */
    readonly limits?: {
        [key: string]: TenantSpecZonesResourcesLimits;
    };
    /**
     * @schema TenantSpecZonesResources#requests
     */
    readonly requests?: {
        [key: string]: TenantSpecZonesResourcesRequests;
    };
}
/**
 * Converts an object of type 'TenantSpecZonesResources' to JSON representation.
 */
export declare function toJson_TenantSpecZonesResources(obj: TenantSpecZonesResources | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesSecurityContext
 */
export interface TenantSpecZonesSecurityContext {
    /**
     * @schema TenantSpecZonesSecurityContext#fsGroup
     */
    readonly fsGroup?: number;
    /**
     * @schema TenantSpecZonesSecurityContext#fsGroupChangePolicy
     */
    readonly fsGroupChangePolicy?: string;
    /**
     * @schema TenantSpecZonesSecurityContext#runAsGroup
     */
    readonly runAsGroup?: number;
    /**
     * @schema TenantSpecZonesSecurityContext#runAsNonRoot
     */
    readonly runAsNonRoot?: boolean;
    /**
     * @schema TenantSpecZonesSecurityContext#runAsUser
     */
    readonly runAsUser?: number;
    /**
     * @schema TenantSpecZonesSecurityContext#seLinuxOptions
     */
    readonly seLinuxOptions?: TenantSpecZonesSecurityContextSeLinuxOptions;
    /**
     * @schema TenantSpecZonesSecurityContext#seccompProfile
     */
    readonly seccompProfile?: TenantSpecZonesSecurityContextSeccompProfile;
    /**
     * @schema TenantSpecZonesSecurityContext#supplementalGroups
     */
    readonly supplementalGroups?: number[];
    /**
     * @schema TenantSpecZonesSecurityContext#sysctls
     */
    readonly sysctls?: TenantSpecZonesSecurityContextSysctls[];
    /**
     * @schema TenantSpecZonesSecurityContext#windowsOptions
     */
    readonly windowsOptions?: TenantSpecZonesSecurityContextWindowsOptions;
}
/**
 * Converts an object of type 'TenantSpecZonesSecurityContext' to JSON representation.
 */
export declare function toJson_TenantSpecZonesSecurityContext(obj: TenantSpecZonesSecurityContext | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesTolerations
 */
export interface TenantSpecZonesTolerations {
    /**
     * @schema TenantSpecZonesTolerations#effect
     */
    readonly effect?: string;
    /**
     * @schema TenantSpecZonesTolerations#key
     */
    readonly key?: string;
    /**
     * @schema TenantSpecZonesTolerations#operator
     */
    readonly operator?: string;
    /**
     * @schema TenantSpecZonesTolerations#tolerationSeconds
     */
    readonly tolerationSeconds?: number;
    /**
     * @schema TenantSpecZonesTolerations#value
     */
    readonly value?: string;
}
/**
 * Converts an object of type 'TenantSpecZonesTolerations' to JSON representation.
 */
export declare function toJson_TenantSpecZonesTolerations(obj: TenantSpecZonesTolerations | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesTopologySpreadConstraints
 */
export interface TenantSpecZonesTopologySpreadConstraints {
    /**
     * @schema TenantSpecZonesTopologySpreadConstraints#labelSelector
     */
    readonly labelSelector?: TenantSpecZonesTopologySpreadConstraintsLabelSelector;
    /**
     * @schema TenantSpecZonesTopologySpreadConstraints#maxSkew
     */
    readonly maxSkew: number;
    /**
     * @schema TenantSpecZonesTopologySpreadConstraints#topologyKey
     */
    readonly topologyKey: string;
    /**
     * @schema TenantSpecZonesTopologySpreadConstraints#whenUnsatisfiable
     */
    readonly whenUnsatisfiable: string;
}
/**
 * Converts an object of type 'TenantSpecZonesTopologySpreadConstraints' to JSON representation.
 */
export declare function toJson_TenantSpecZonesTopologySpreadConstraints(obj: TenantSpecZonesTopologySpreadConstraints | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesVolumeClaimTemplate
 */
export interface TenantSpecZonesVolumeClaimTemplate {
    /**
     * @schema TenantSpecZonesVolumeClaimTemplate#apiVersion
     */
    readonly apiVersion?: string;
    /**
     * @schema TenantSpecZonesVolumeClaimTemplate#kind
     */
    readonly kind?: string;
    /**
     * @schema TenantSpecZonesVolumeClaimTemplate#metadata
     */
    readonly metadata?: TenantSpecZonesVolumeClaimTemplateMetadata;
    /**
     * @schema TenantSpecZonesVolumeClaimTemplate#spec
     */
    readonly spec?: TenantSpecZonesVolumeClaimTemplateSpec;
    /**
     * @schema TenantSpecZonesVolumeClaimTemplate#status
     */
    readonly status?: TenantSpecZonesVolumeClaimTemplateStatus;
}
/**
 * Converts an object of type 'TenantSpecZonesVolumeClaimTemplate' to JSON representation.
 */
export declare function toJson_TenantSpecZonesVolumeClaimTemplate(obj: TenantSpecZonesVolumeClaimTemplate | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecEnvValueFromConfigMapKeyRef
 */
export interface TenantSpecEnvValueFromConfigMapKeyRef {
    /**
     * @schema TenantSpecEnvValueFromConfigMapKeyRef#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecEnvValueFromConfigMapKeyRef#name
     */
    readonly name?: string;
    /**
     * @schema TenantSpecEnvValueFromConfigMapKeyRef#optional
     */
    readonly optional?: boolean;
}
/**
 * Converts an object of type 'TenantSpecEnvValueFromConfigMapKeyRef' to JSON representation.
 */
export declare function toJson_TenantSpecEnvValueFromConfigMapKeyRef(obj: TenantSpecEnvValueFromConfigMapKeyRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecEnvValueFromFieldRef
 */
export interface TenantSpecEnvValueFromFieldRef {
    /**
     * @schema TenantSpecEnvValueFromFieldRef#apiVersion
     */
    readonly apiVersion?: string;
    /**
     * @schema TenantSpecEnvValueFromFieldRef#fieldPath
     */
    readonly fieldPath: string;
}
/**
 * Converts an object of type 'TenantSpecEnvValueFromFieldRef' to JSON representation.
 */
export declare function toJson_TenantSpecEnvValueFromFieldRef(obj: TenantSpecEnvValueFromFieldRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecEnvValueFromResourceFieldRef
 */
export interface TenantSpecEnvValueFromResourceFieldRef {
    /**
     * @schema TenantSpecEnvValueFromResourceFieldRef#containerName
     */
    readonly containerName?: string;
    /**
     * @schema TenantSpecEnvValueFromResourceFieldRef#divisor
     */
    readonly divisor?: TenantSpecEnvValueFromResourceFieldRefDivisor;
    /**
     * @schema TenantSpecEnvValueFromResourceFieldRef#resource
     */
    readonly resource: string;
}
/**
 * Converts an object of type 'TenantSpecEnvValueFromResourceFieldRef' to JSON representation.
 */
export declare function toJson_TenantSpecEnvValueFromResourceFieldRef(obj: TenantSpecEnvValueFromResourceFieldRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecEnvValueFromSecretKeyRef
 */
export interface TenantSpecEnvValueFromSecretKeyRef {
    /**
     * @schema TenantSpecEnvValueFromSecretKeyRef#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecEnvValueFromSecretKeyRef#name
     */
    readonly name?: string;
    /**
     * @schema TenantSpecEnvValueFromSecretKeyRef#optional
     */
    readonly optional?: boolean;
}
/**
 * Converts an object of type 'TenantSpecEnvValueFromSecretKeyRef' to JSON representation.
 */
export declare function toJson_TenantSpecEnvValueFromSecretKeyRef(obj: TenantSpecEnvValueFromSecretKeyRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesAffinityNodeAffinity
 */
export interface TenantSpecKesAffinityNodeAffinity {
    /**
     * @schema TenantSpecKesAffinityNodeAffinity#preferredDuringSchedulingIgnoredDuringExecution
     */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution[];
    /**
     * @schema TenantSpecKesAffinityNodeAffinity#requiredDuringSchedulingIgnoredDuringExecution
     */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution;
}
/**
 * Converts an object of type 'TenantSpecKesAffinityNodeAffinity' to JSON representation.
 */
export declare function toJson_TenantSpecKesAffinityNodeAffinity(obj: TenantSpecKesAffinityNodeAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesAffinityPodAffinity
 */
export interface TenantSpecKesAffinityPodAffinity {
    /**
     * @schema TenantSpecKesAffinityPodAffinity#preferredDuringSchedulingIgnoredDuringExecution
     */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution[];
    /**
     * @schema TenantSpecKesAffinityPodAffinity#requiredDuringSchedulingIgnoredDuringExecution
     */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution[];
}
/**
 * Converts an object of type 'TenantSpecKesAffinityPodAffinity' to JSON representation.
 */
export declare function toJson_TenantSpecKesAffinityPodAffinity(obj: TenantSpecKesAffinityPodAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesAffinityPodAntiAffinity
 */
export interface TenantSpecKesAffinityPodAntiAffinity {
    /**
     * @schema TenantSpecKesAffinityPodAntiAffinity#preferredDuringSchedulingIgnoredDuringExecution
     */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution[];
    /**
     * @schema TenantSpecKesAffinityPodAntiAffinity#requiredDuringSchedulingIgnoredDuringExecution
     */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution[];
}
/**
 * Converts an object of type 'TenantSpecKesAffinityPodAntiAffinity' to JSON representation.
 */
export declare function toJson_TenantSpecKesAffinityPodAntiAffinity(obj: TenantSpecKesAffinityPodAntiAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesResourcesLimits
 */
export declare class TenantSpecKesResourcesLimits {
    readonly value: any;
    static fromNumber(value: number): TenantSpecKesResourcesLimits;
    static fromString(value: string): TenantSpecKesResourcesLimits;
    private constructor();
}
/**
 * @schema TenantSpecKesResourcesRequests
 */
export declare class TenantSpecKesResourcesRequests {
    readonly value: any;
    static fromNumber(value: number): TenantSpecKesResourcesRequests;
    static fromString(value: string): TenantSpecKesResourcesRequests;
    private constructor();
}
/**
 * @schema TenantSpecKesSecurityContextSeLinuxOptions
 */
export interface TenantSpecKesSecurityContextSeLinuxOptions {
    /**
     * @schema TenantSpecKesSecurityContextSeLinuxOptions#level
     */
    readonly level?: string;
    /**
     * @schema TenantSpecKesSecurityContextSeLinuxOptions#role
     */
    readonly role?: string;
    /**
     * @schema TenantSpecKesSecurityContextSeLinuxOptions#type
     */
    readonly type?: string;
    /**
     * @schema TenantSpecKesSecurityContextSeLinuxOptions#user
     */
    readonly user?: string;
}
/**
 * Converts an object of type 'TenantSpecKesSecurityContextSeLinuxOptions' to JSON representation.
 */
export declare function toJson_TenantSpecKesSecurityContextSeLinuxOptions(obj: TenantSpecKesSecurityContextSeLinuxOptions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesSecurityContextSeccompProfile
 */
export interface TenantSpecKesSecurityContextSeccompProfile {
    /**
     * @schema TenantSpecKesSecurityContextSeccompProfile#localhostProfile
     */
    readonly localhostProfile?: string;
    /**
     * @schema TenantSpecKesSecurityContextSeccompProfile#type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'TenantSpecKesSecurityContextSeccompProfile' to JSON representation.
 */
export declare function toJson_TenantSpecKesSecurityContextSeccompProfile(obj: TenantSpecKesSecurityContextSeccompProfile | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesSecurityContextSysctls
 */
export interface TenantSpecKesSecurityContextSysctls {
    /**
     * @schema TenantSpecKesSecurityContextSysctls#name
     */
    readonly name: string;
    /**
     * @schema TenantSpecKesSecurityContextSysctls#value
     */
    readonly value: string;
}
/**
 * Converts an object of type 'TenantSpecKesSecurityContextSysctls' to JSON representation.
 */
export declare function toJson_TenantSpecKesSecurityContextSysctls(obj: TenantSpecKesSecurityContextSysctls | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesSecurityContextWindowsOptions
 */
export interface TenantSpecKesSecurityContextWindowsOptions {
    /**
     * @schema TenantSpecKesSecurityContextWindowsOptions#gmsaCredentialSpec
     */
    readonly gmsaCredentialSpec?: string;
    /**
     * @schema TenantSpecKesSecurityContextWindowsOptions#gmsaCredentialSpecName
     */
    readonly gmsaCredentialSpecName?: string;
    /**
     * @schema TenantSpecKesSecurityContextWindowsOptions#runAsUserName
     */
    readonly runAsUserName?: string;
}
/**
 * Converts an object of type 'TenantSpecKesSecurityContextWindowsOptions' to JSON representation.
 */
export declare function toJson_TenantSpecKesSecurityContextWindowsOptions(obj: TenantSpecKesSecurityContextWindowsOptions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesTopologySpreadConstraintsLabelSelector
 */
export interface TenantSpecKesTopologySpreadConstraintsLabelSelector {
    /**
     * @schema TenantSpecKesTopologySpreadConstraintsLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantSpecKesTopologySpreadConstraintsLabelSelectorMatchExpressions[];
    /**
     * @schema TenantSpecKesTopologySpreadConstraintsLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantSpecKesTopologySpreadConstraintsLabelSelector' to JSON representation.
 */
export declare function toJson_TenantSpecKesTopologySpreadConstraintsLabelSelector(obj: TenantSpecKesTopologySpreadConstraintsLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogAffinityNodeAffinity
 */
export interface TenantSpecLogAffinityNodeAffinity {
    /**
     * @schema TenantSpecLogAffinityNodeAffinity#preferredDuringSchedulingIgnoredDuringExecution
     */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution[];
    /**
     * @schema TenantSpecLogAffinityNodeAffinity#requiredDuringSchedulingIgnoredDuringExecution
     */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution;
}
/**
 * Converts an object of type 'TenantSpecLogAffinityNodeAffinity' to JSON representation.
 */
export declare function toJson_TenantSpecLogAffinityNodeAffinity(obj: TenantSpecLogAffinityNodeAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogAffinityPodAffinity
 */
export interface TenantSpecLogAffinityPodAffinity {
    /**
     * @schema TenantSpecLogAffinityPodAffinity#preferredDuringSchedulingIgnoredDuringExecution
     */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution[];
    /**
     * @schema TenantSpecLogAffinityPodAffinity#requiredDuringSchedulingIgnoredDuringExecution
     */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution[];
}
/**
 * Converts an object of type 'TenantSpecLogAffinityPodAffinity' to JSON representation.
 */
export declare function toJson_TenantSpecLogAffinityPodAffinity(obj: TenantSpecLogAffinityPodAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogAffinityPodAntiAffinity
 */
export interface TenantSpecLogAffinityPodAntiAffinity {
    /**
     * @schema TenantSpecLogAffinityPodAntiAffinity#preferredDuringSchedulingIgnoredDuringExecution
     */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution[];
    /**
     * @schema TenantSpecLogAffinityPodAntiAffinity#requiredDuringSchedulingIgnoredDuringExecution
     */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution[];
}
/**
 * Converts an object of type 'TenantSpecLogAffinityPodAntiAffinity' to JSON representation.
 */
export declare function toJson_TenantSpecLogAffinityPodAntiAffinity(obj: TenantSpecLogAffinityPodAntiAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbAffinity
 */
export interface TenantSpecLogDbAffinity {
    /**
     * @schema TenantSpecLogDbAffinity#nodeAffinity
     */
    readonly nodeAffinity?: TenantSpecLogDbAffinityNodeAffinity;
    /**
     * @schema TenantSpecLogDbAffinity#podAffinity
     */
    readonly podAffinity?: TenantSpecLogDbAffinityPodAffinity;
    /**
     * @schema TenantSpecLogDbAffinity#podAntiAffinity
     */
    readonly podAntiAffinity?: TenantSpecLogDbAffinityPodAntiAffinity;
}
/**
 * Converts an object of type 'TenantSpecLogDbAffinity' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbAffinity(obj: TenantSpecLogDbAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbResources
 */
export interface TenantSpecLogDbResources {
    /**
     * @schema TenantSpecLogDbResources#limits
     */
    readonly limits?: {
        [key: string]: TenantSpecLogDbResourcesLimits;
    };
    /**
     * @schema TenantSpecLogDbResources#requests
     */
    readonly requests?: {
        [key: string]: TenantSpecLogDbResourcesRequests;
    };
}
/**
 * Converts an object of type 'TenantSpecLogDbResources' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbResources(obj: TenantSpecLogDbResources | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbSecurityContext
 */
export interface TenantSpecLogDbSecurityContext {
    /**
     * @schema TenantSpecLogDbSecurityContext#fsGroup
     */
    readonly fsGroup?: number;
    /**
     * @schema TenantSpecLogDbSecurityContext#fsGroupChangePolicy
     */
    readonly fsGroupChangePolicy?: string;
    /**
     * @schema TenantSpecLogDbSecurityContext#runAsGroup
     */
    readonly runAsGroup?: number;
    /**
     * @schema TenantSpecLogDbSecurityContext#runAsNonRoot
     */
    readonly runAsNonRoot?: boolean;
    /**
     * @schema TenantSpecLogDbSecurityContext#runAsUser
     */
    readonly runAsUser?: number;
    /**
     * @schema TenantSpecLogDbSecurityContext#seLinuxOptions
     */
    readonly seLinuxOptions?: TenantSpecLogDbSecurityContextSeLinuxOptions;
    /**
     * @schema TenantSpecLogDbSecurityContext#seccompProfile
     */
    readonly seccompProfile?: TenantSpecLogDbSecurityContextSeccompProfile;
    /**
     * @schema TenantSpecLogDbSecurityContext#supplementalGroups
     */
    readonly supplementalGroups?: number[];
    /**
     * @schema TenantSpecLogDbSecurityContext#sysctls
     */
    readonly sysctls?: TenantSpecLogDbSecurityContextSysctls[];
    /**
     * @schema TenantSpecLogDbSecurityContext#windowsOptions
     */
    readonly windowsOptions?: TenantSpecLogDbSecurityContextWindowsOptions;
}
/**
 * Converts an object of type 'TenantSpecLogDbSecurityContext' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbSecurityContext(obj: TenantSpecLogDbSecurityContext | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbTolerations
 */
export interface TenantSpecLogDbTolerations {
    /**
     * @schema TenantSpecLogDbTolerations#effect
     */
    readonly effect?: string;
    /**
     * @schema TenantSpecLogDbTolerations#key
     */
    readonly key?: string;
    /**
     * @schema TenantSpecLogDbTolerations#operator
     */
    readonly operator?: string;
    /**
     * @schema TenantSpecLogDbTolerations#tolerationSeconds
     */
    readonly tolerationSeconds?: number;
    /**
     * @schema TenantSpecLogDbTolerations#value
     */
    readonly value?: string;
}
/**
 * Converts an object of type 'TenantSpecLogDbTolerations' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbTolerations(obj: TenantSpecLogDbTolerations | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbTopologySpreadConstraints
 */
export interface TenantSpecLogDbTopologySpreadConstraints {
    /**
     * @schema TenantSpecLogDbTopologySpreadConstraints#labelSelector
     */
    readonly labelSelector?: TenantSpecLogDbTopologySpreadConstraintsLabelSelector;
    /**
     * @schema TenantSpecLogDbTopologySpreadConstraints#maxSkew
     */
    readonly maxSkew: number;
    /**
     * @schema TenantSpecLogDbTopologySpreadConstraints#topologyKey
     */
    readonly topologyKey: string;
    /**
     * @schema TenantSpecLogDbTopologySpreadConstraints#whenUnsatisfiable
     */
    readonly whenUnsatisfiable: string;
}
/**
 * Converts an object of type 'TenantSpecLogDbTopologySpreadConstraints' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbTopologySpreadConstraints(obj: TenantSpecLogDbTopologySpreadConstraints | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbVolumeClaimTemplate
 */
export interface TenantSpecLogDbVolumeClaimTemplate {
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplate#apiVersion
     */
    readonly apiVersion?: string;
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplate#kind
     */
    readonly kind?: string;
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplate#metadata
     */
    readonly metadata?: TenantSpecLogDbVolumeClaimTemplateMetadata;
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplate#spec
     */
    readonly spec?: TenantSpecLogDbVolumeClaimTemplateSpec;
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplate#status
     */
    readonly status?: TenantSpecLogDbVolumeClaimTemplateStatus;
}
/**
 * Converts an object of type 'TenantSpecLogDbVolumeClaimTemplate' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbVolumeClaimTemplate(obj: TenantSpecLogDbVolumeClaimTemplate | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogResourcesLimits
 */
export declare class TenantSpecLogResourcesLimits {
    readonly value: any;
    static fromNumber(value: number): TenantSpecLogResourcesLimits;
    static fromString(value: string): TenantSpecLogResourcesLimits;
    private constructor();
}
/**
 * @schema TenantSpecLogResourcesRequests
 */
export declare class TenantSpecLogResourcesRequests {
    readonly value: any;
    static fromNumber(value: number): TenantSpecLogResourcesRequests;
    static fromString(value: string): TenantSpecLogResourcesRequests;
    private constructor();
}
/**
 * @schema TenantSpecLogSecurityContextSeLinuxOptions
 */
export interface TenantSpecLogSecurityContextSeLinuxOptions {
    /**
     * @schema TenantSpecLogSecurityContextSeLinuxOptions#level
     */
    readonly level?: string;
    /**
     * @schema TenantSpecLogSecurityContextSeLinuxOptions#role
     */
    readonly role?: string;
    /**
     * @schema TenantSpecLogSecurityContextSeLinuxOptions#type
     */
    readonly type?: string;
    /**
     * @schema TenantSpecLogSecurityContextSeLinuxOptions#user
     */
    readonly user?: string;
}
/**
 * Converts an object of type 'TenantSpecLogSecurityContextSeLinuxOptions' to JSON representation.
 */
export declare function toJson_TenantSpecLogSecurityContextSeLinuxOptions(obj: TenantSpecLogSecurityContextSeLinuxOptions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogSecurityContextSeccompProfile
 */
export interface TenantSpecLogSecurityContextSeccompProfile {
    /**
     * @schema TenantSpecLogSecurityContextSeccompProfile#localhostProfile
     */
    readonly localhostProfile?: string;
    /**
     * @schema TenantSpecLogSecurityContextSeccompProfile#type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'TenantSpecLogSecurityContextSeccompProfile' to JSON representation.
 */
export declare function toJson_TenantSpecLogSecurityContextSeccompProfile(obj: TenantSpecLogSecurityContextSeccompProfile | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogSecurityContextSysctls
 */
export interface TenantSpecLogSecurityContextSysctls {
    /**
     * @schema TenantSpecLogSecurityContextSysctls#name
     */
    readonly name: string;
    /**
     * @schema TenantSpecLogSecurityContextSysctls#value
     */
    readonly value: string;
}
/**
 * Converts an object of type 'TenantSpecLogSecurityContextSysctls' to JSON representation.
 */
export declare function toJson_TenantSpecLogSecurityContextSysctls(obj: TenantSpecLogSecurityContextSysctls | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogSecurityContextWindowsOptions
 */
export interface TenantSpecLogSecurityContextWindowsOptions {
    /**
     * @schema TenantSpecLogSecurityContextWindowsOptions#gmsaCredentialSpec
     */
    readonly gmsaCredentialSpec?: string;
    /**
     * @schema TenantSpecLogSecurityContextWindowsOptions#gmsaCredentialSpecName
     */
    readonly gmsaCredentialSpecName?: string;
    /**
     * @schema TenantSpecLogSecurityContextWindowsOptions#runAsUserName
     */
    readonly runAsUserName?: string;
}
/**
 * Converts an object of type 'TenantSpecLogSecurityContextWindowsOptions' to JSON representation.
 */
export declare function toJson_TenantSpecLogSecurityContextWindowsOptions(obj: TenantSpecLogSecurityContextWindowsOptions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogTopologySpreadConstraintsLabelSelector
 */
export interface TenantSpecLogTopologySpreadConstraintsLabelSelector {
    /**
     * @schema TenantSpecLogTopologySpreadConstraintsLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantSpecLogTopologySpreadConstraintsLabelSelectorMatchExpressions[];
    /**
     * @schema TenantSpecLogTopologySpreadConstraintsLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantSpecLogTopologySpreadConstraintsLabelSelector' to JSON representation.
 */
export declare function toJson_TenantSpecLogTopologySpreadConstraintsLabelSelector(obj: TenantSpecLogTopologySpreadConstraintsLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusAffinityNodeAffinity
 */
export interface TenantSpecPrometheusAffinityNodeAffinity {
    /**
     * @schema TenantSpecPrometheusAffinityNodeAffinity#preferredDuringSchedulingIgnoredDuringExecution
     */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution[];
    /**
     * @schema TenantSpecPrometheusAffinityNodeAffinity#requiredDuringSchedulingIgnoredDuringExecution
     */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution;
}
/**
 * Converts an object of type 'TenantSpecPrometheusAffinityNodeAffinity' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusAffinityNodeAffinity(obj: TenantSpecPrometheusAffinityNodeAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusAffinityPodAffinity
 */
export interface TenantSpecPrometheusAffinityPodAffinity {
    /**
     * @schema TenantSpecPrometheusAffinityPodAffinity#preferredDuringSchedulingIgnoredDuringExecution
     */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution[];
    /**
     * @schema TenantSpecPrometheusAffinityPodAffinity#requiredDuringSchedulingIgnoredDuringExecution
     */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution[];
}
/**
 * Converts an object of type 'TenantSpecPrometheusAffinityPodAffinity' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusAffinityPodAffinity(obj: TenantSpecPrometheusAffinityPodAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusAffinityPodAntiAffinity
 */
export interface TenantSpecPrometheusAffinityPodAntiAffinity {
    /**
     * @schema TenantSpecPrometheusAffinityPodAntiAffinity#preferredDuringSchedulingIgnoredDuringExecution
     */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution[];
    /**
     * @schema TenantSpecPrometheusAffinityPodAntiAffinity#requiredDuringSchedulingIgnoredDuringExecution
     */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution[];
}
/**
 * Converts an object of type 'TenantSpecPrometheusAffinityPodAntiAffinity' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusAffinityPodAntiAffinity(obj: TenantSpecPrometheusAffinityPodAntiAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusResourcesLimits
 */
export declare class TenantSpecPrometheusResourcesLimits {
    readonly value: any;
    static fromNumber(value: number): TenantSpecPrometheusResourcesLimits;
    static fromString(value: string): TenantSpecPrometheusResourcesLimits;
    private constructor();
}
/**
 * @schema TenantSpecPrometheusResourcesRequests
 */
export declare class TenantSpecPrometheusResourcesRequests {
    readonly value: any;
    static fromNumber(value: number): TenantSpecPrometheusResourcesRequests;
    static fromString(value: string): TenantSpecPrometheusResourcesRequests;
    private constructor();
}
/**
 * @schema TenantSpecPrometheusSecurityContextSeLinuxOptions
 */
export interface TenantSpecPrometheusSecurityContextSeLinuxOptions {
    /**
     * @schema TenantSpecPrometheusSecurityContextSeLinuxOptions#level
     */
    readonly level?: string;
    /**
     * @schema TenantSpecPrometheusSecurityContextSeLinuxOptions#role
     */
    readonly role?: string;
    /**
     * @schema TenantSpecPrometheusSecurityContextSeLinuxOptions#type
     */
    readonly type?: string;
    /**
     * @schema TenantSpecPrometheusSecurityContextSeLinuxOptions#user
     */
    readonly user?: string;
}
/**
 * Converts an object of type 'TenantSpecPrometheusSecurityContextSeLinuxOptions' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusSecurityContextSeLinuxOptions(obj: TenantSpecPrometheusSecurityContextSeLinuxOptions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusSecurityContextSeccompProfile
 */
export interface TenantSpecPrometheusSecurityContextSeccompProfile {
    /**
     * @schema TenantSpecPrometheusSecurityContextSeccompProfile#localhostProfile
     */
    readonly localhostProfile?: string;
    /**
     * @schema TenantSpecPrometheusSecurityContextSeccompProfile#type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'TenantSpecPrometheusSecurityContextSeccompProfile' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusSecurityContextSeccompProfile(obj: TenantSpecPrometheusSecurityContextSeccompProfile | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusSecurityContextSysctls
 */
export interface TenantSpecPrometheusSecurityContextSysctls {
    /**
     * @schema TenantSpecPrometheusSecurityContextSysctls#name
     */
    readonly name: string;
    /**
     * @schema TenantSpecPrometheusSecurityContextSysctls#value
     */
    readonly value: string;
}
/**
 * Converts an object of type 'TenantSpecPrometheusSecurityContextSysctls' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusSecurityContextSysctls(obj: TenantSpecPrometheusSecurityContextSysctls | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusSecurityContextWindowsOptions
 */
export interface TenantSpecPrometheusSecurityContextWindowsOptions {
    /**
     * @schema TenantSpecPrometheusSecurityContextWindowsOptions#gmsaCredentialSpec
     */
    readonly gmsaCredentialSpec?: string;
    /**
     * @schema TenantSpecPrometheusSecurityContextWindowsOptions#gmsaCredentialSpecName
     */
    readonly gmsaCredentialSpecName?: string;
    /**
     * @schema TenantSpecPrometheusSecurityContextWindowsOptions#runAsUserName
     */
    readonly runAsUserName?: string;
}
/**
 * Converts an object of type 'TenantSpecPrometheusSecurityContextWindowsOptions' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusSecurityContextWindowsOptions(obj: TenantSpecPrometheusSecurityContextWindowsOptions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusTopologySpreadConstraintsLabelSelector
 */
export interface TenantSpecPrometheusTopologySpreadConstraintsLabelSelector {
    /**
     * @schema TenantSpecPrometheusTopologySpreadConstraintsLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantSpecPrometheusTopologySpreadConstraintsLabelSelectorMatchExpressions[];
    /**
     * @schema TenantSpecPrometheusTopologySpreadConstraintsLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantSpecPrometheusTopologySpreadConstraintsLabelSelector' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusTopologySpreadConstraintsLabelSelector(obj: TenantSpecPrometheusTopologySpreadConstraintsLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersEnv
 */
export interface TenantSpecSideCarsContainersEnv {
    /**
     * @schema TenantSpecSideCarsContainersEnv#name
     */
    readonly name: string;
    /**
     * @schema TenantSpecSideCarsContainersEnv#value
     */
    readonly value?: string;
    /**
     * @schema TenantSpecSideCarsContainersEnv#valueFrom
     */
    readonly valueFrom?: TenantSpecSideCarsContainersEnvValueFrom;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersEnv' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersEnv(obj: TenantSpecSideCarsContainersEnv | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersEnvFrom
 */
export interface TenantSpecSideCarsContainersEnvFrom {
    /**
     * @schema TenantSpecSideCarsContainersEnvFrom#configMapRef
     */
    readonly configMapRef?: TenantSpecSideCarsContainersEnvFromConfigMapRef;
    /**
     * @schema TenantSpecSideCarsContainersEnvFrom#prefix
     */
    readonly prefix?: string;
    /**
     * @schema TenantSpecSideCarsContainersEnvFrom#secretRef
     */
    readonly secretRef?: TenantSpecSideCarsContainersEnvFromSecretRef;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersEnvFrom' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersEnvFrom(obj: TenantSpecSideCarsContainersEnvFrom | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersLifecycle
 */
export interface TenantSpecSideCarsContainersLifecycle {
    /**
     * @schema TenantSpecSideCarsContainersLifecycle#postStart
     */
    readonly postStart?: TenantSpecSideCarsContainersLifecyclePostStart;
    /**
     * @schema TenantSpecSideCarsContainersLifecycle#preStop
     */
    readonly preStop?: TenantSpecSideCarsContainersLifecyclePreStop;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersLifecycle' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersLifecycle(obj: TenantSpecSideCarsContainersLifecycle | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersLivenessProbe
 */
export interface TenantSpecSideCarsContainersLivenessProbe {
    /**
     * @schema TenantSpecSideCarsContainersLivenessProbe#exec
     */
    readonly exec?: TenantSpecSideCarsContainersLivenessProbeExec;
    /**
     * @schema TenantSpecSideCarsContainersLivenessProbe#failureThreshold
     */
    readonly failureThreshold?: number;
    /**
     * @schema TenantSpecSideCarsContainersLivenessProbe#httpGet
     */
    readonly httpGet?: TenantSpecSideCarsContainersLivenessProbeHttpGet;
    /**
     * @schema TenantSpecSideCarsContainersLivenessProbe#initialDelaySeconds
     */
    readonly initialDelaySeconds?: number;
    /**
     * @schema TenantSpecSideCarsContainersLivenessProbe#periodSeconds
     */
    readonly periodSeconds?: number;
    /**
     * @schema TenantSpecSideCarsContainersLivenessProbe#successThreshold
     */
    readonly successThreshold?: number;
    /**
     * @schema TenantSpecSideCarsContainersLivenessProbe#tcpSocket
     */
    readonly tcpSocket?: TenantSpecSideCarsContainersLivenessProbeTcpSocket;
    /**
     * @schema TenantSpecSideCarsContainersLivenessProbe#timeoutSeconds
     */
    readonly timeoutSeconds?: number;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersLivenessProbe' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersLivenessProbe(obj: TenantSpecSideCarsContainersLivenessProbe | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersPorts
 */
export interface TenantSpecSideCarsContainersPorts {
    /**
     * @schema TenantSpecSideCarsContainersPorts#containerPort
     */
    readonly containerPort: number;
    /**
     * @schema TenantSpecSideCarsContainersPorts#hostIP
     */
    readonly hostIp?: string;
    /**
     * @schema TenantSpecSideCarsContainersPorts#hostPort
     */
    readonly hostPort?: number;
    /**
     * @schema TenantSpecSideCarsContainersPorts#name
     */
    readonly name?: string;
    /**
     * @schema TenantSpecSideCarsContainersPorts#protocol
     */
    readonly protocol?: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersPorts' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersPorts(obj: TenantSpecSideCarsContainersPorts | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersReadinessProbe
 */
export interface TenantSpecSideCarsContainersReadinessProbe {
    /**
     * @schema TenantSpecSideCarsContainersReadinessProbe#exec
     */
    readonly exec?: TenantSpecSideCarsContainersReadinessProbeExec;
    /**
     * @schema TenantSpecSideCarsContainersReadinessProbe#failureThreshold
     */
    readonly failureThreshold?: number;
    /**
     * @schema TenantSpecSideCarsContainersReadinessProbe#httpGet
     */
    readonly httpGet?: TenantSpecSideCarsContainersReadinessProbeHttpGet;
    /**
     * @schema TenantSpecSideCarsContainersReadinessProbe#initialDelaySeconds
     */
    readonly initialDelaySeconds?: number;
    /**
     * @schema TenantSpecSideCarsContainersReadinessProbe#periodSeconds
     */
    readonly periodSeconds?: number;
    /**
     * @schema TenantSpecSideCarsContainersReadinessProbe#successThreshold
     */
    readonly successThreshold?: number;
    /**
     * @schema TenantSpecSideCarsContainersReadinessProbe#tcpSocket
     */
    readonly tcpSocket?: TenantSpecSideCarsContainersReadinessProbeTcpSocket;
    /**
     * @schema TenantSpecSideCarsContainersReadinessProbe#timeoutSeconds
     */
    readonly timeoutSeconds?: number;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersReadinessProbe' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersReadinessProbe(obj: TenantSpecSideCarsContainersReadinessProbe | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersResources
 */
export interface TenantSpecSideCarsContainersResources {
    /**
     * @schema TenantSpecSideCarsContainersResources#limits
     */
    readonly limits?: {
        [key: string]: TenantSpecSideCarsContainersResourcesLimits;
    };
    /**
     * @schema TenantSpecSideCarsContainersResources#requests
     */
    readonly requests?: {
        [key: string]: TenantSpecSideCarsContainersResourcesRequests;
    };
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersResources' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersResources(obj: TenantSpecSideCarsContainersResources | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersSecurityContext
 */
export interface TenantSpecSideCarsContainersSecurityContext {
    /**
     * @schema TenantSpecSideCarsContainersSecurityContext#allowPrivilegeEscalation
     */
    readonly allowPrivilegeEscalation?: boolean;
    /**
     * @schema TenantSpecSideCarsContainersSecurityContext#capabilities
     */
    readonly capabilities?: TenantSpecSideCarsContainersSecurityContextCapabilities;
    /**
     * @schema TenantSpecSideCarsContainersSecurityContext#privileged
     */
    readonly privileged?: boolean;
    /**
     * @schema TenantSpecSideCarsContainersSecurityContext#procMount
     */
    readonly procMount?: string;
    /**
     * @schema TenantSpecSideCarsContainersSecurityContext#readOnlyRootFilesystem
     */
    readonly readOnlyRootFilesystem?: boolean;
    /**
     * @schema TenantSpecSideCarsContainersSecurityContext#runAsGroup
     */
    readonly runAsGroup?: number;
    /**
     * @schema TenantSpecSideCarsContainersSecurityContext#runAsNonRoot
     */
    readonly runAsNonRoot?: boolean;
    /**
     * @schema TenantSpecSideCarsContainersSecurityContext#runAsUser
     */
    readonly runAsUser?: number;
    /**
     * @schema TenantSpecSideCarsContainersSecurityContext#seLinuxOptions
     */
    readonly seLinuxOptions?: TenantSpecSideCarsContainersSecurityContextSeLinuxOptions;
    /**
     * @schema TenantSpecSideCarsContainersSecurityContext#seccompProfile
     */
    readonly seccompProfile?: TenantSpecSideCarsContainersSecurityContextSeccompProfile;
    /**
     * @schema TenantSpecSideCarsContainersSecurityContext#windowsOptions
     */
    readonly windowsOptions?: TenantSpecSideCarsContainersSecurityContextWindowsOptions;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersSecurityContext' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersSecurityContext(obj: TenantSpecSideCarsContainersSecurityContext | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersStartupProbe
 */
export interface TenantSpecSideCarsContainersStartupProbe {
    /**
     * @schema TenantSpecSideCarsContainersStartupProbe#exec
     */
    readonly exec?: TenantSpecSideCarsContainersStartupProbeExec;
    /**
     * @schema TenantSpecSideCarsContainersStartupProbe#failureThreshold
     */
    readonly failureThreshold?: number;
    /**
     * @schema TenantSpecSideCarsContainersStartupProbe#httpGet
     */
    readonly httpGet?: TenantSpecSideCarsContainersStartupProbeHttpGet;
    /**
     * @schema TenantSpecSideCarsContainersStartupProbe#initialDelaySeconds
     */
    readonly initialDelaySeconds?: number;
    /**
     * @schema TenantSpecSideCarsContainersStartupProbe#periodSeconds
     */
    readonly periodSeconds?: number;
    /**
     * @schema TenantSpecSideCarsContainersStartupProbe#successThreshold
     */
    readonly successThreshold?: number;
    /**
     * @schema TenantSpecSideCarsContainersStartupProbe#tcpSocket
     */
    readonly tcpSocket?: TenantSpecSideCarsContainersStartupProbeTcpSocket;
    /**
     * @schema TenantSpecSideCarsContainersStartupProbe#timeoutSeconds
     */
    readonly timeoutSeconds?: number;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersStartupProbe' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersStartupProbe(obj: TenantSpecSideCarsContainersStartupProbe | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersVolumeDevices
 */
export interface TenantSpecSideCarsContainersVolumeDevices {
    /**
     * @schema TenantSpecSideCarsContainersVolumeDevices#devicePath
     */
    readonly devicePath: string;
    /**
     * @schema TenantSpecSideCarsContainersVolumeDevices#name
     */
    readonly name: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersVolumeDevices' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersVolumeDevices(obj: TenantSpecSideCarsContainersVolumeDevices | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersVolumeMounts
 */
export interface TenantSpecSideCarsContainersVolumeMounts {
    /**
     * @schema TenantSpecSideCarsContainersVolumeMounts#mountPath
     */
    readonly mountPath: string;
    /**
     * @schema TenantSpecSideCarsContainersVolumeMounts#mountPropagation
     */
    readonly mountPropagation?: string;
    /**
     * @schema TenantSpecSideCarsContainersVolumeMounts#name
     */
    readonly name: string;
    /**
     * @schema TenantSpecSideCarsContainersVolumeMounts#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * @schema TenantSpecSideCarsContainersVolumeMounts#subPath
     */
    readonly subPath?: string;
    /**
     * @schema TenantSpecSideCarsContainersVolumeMounts#subPathExpr
     */
    readonly subPathExpr?: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersVolumeMounts' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersVolumeMounts(obj: TenantSpecSideCarsContainersVolumeMounts | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumeClaimTemplatesMetadata
 */
export interface TenantSpecSideCarsVolumeClaimTemplatesMetadata {
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplatesMetadata#annotations
     */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplatesMetadata#finalizers
     */
    readonly finalizers?: string[];
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplatesMetadata#labels
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplatesMetadata#name
     */
    readonly name?: string;
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplatesMetadata#namespace
     */
    readonly namespace?: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumeClaimTemplatesMetadata' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumeClaimTemplatesMetadata(obj: TenantSpecSideCarsVolumeClaimTemplatesMetadata | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumeClaimTemplatesSpec
 */
export interface TenantSpecSideCarsVolumeClaimTemplatesSpec {
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplatesSpec#accessModes
     */
    readonly accessModes?: string[];
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplatesSpec#dataSource
     */
    readonly dataSource?: TenantSpecSideCarsVolumeClaimTemplatesSpecDataSource;
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplatesSpec#resources
     */
    readonly resources?: TenantSpecSideCarsVolumeClaimTemplatesSpecResources;
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplatesSpec#selector
     */
    readonly selector?: TenantSpecSideCarsVolumeClaimTemplatesSpecSelector;
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplatesSpec#storageClassName
     */
    readonly storageClassName?: string;
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplatesSpec#volumeMode
     */
    readonly volumeMode?: string;
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplatesSpec#volumeName
     */
    readonly volumeName?: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumeClaimTemplatesSpec' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumeClaimTemplatesSpec(obj: TenantSpecSideCarsVolumeClaimTemplatesSpec | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumeClaimTemplatesStatus
 */
export interface TenantSpecSideCarsVolumeClaimTemplatesStatus {
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplatesStatus#accessModes
     */
    readonly accessModes?: string[];
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplatesStatus#capacity
     */
    readonly capacity?: {
        [key: string]: TenantSpecSideCarsVolumeClaimTemplatesStatusCapacity;
    };
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplatesStatus#conditions
     */
    readonly conditions?: TenantSpecSideCarsVolumeClaimTemplatesStatusConditions[];
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplatesStatus#phase
     */
    readonly phase?: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumeClaimTemplatesStatus' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumeClaimTemplatesStatus(obj: TenantSpecSideCarsVolumeClaimTemplatesStatus | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesAwsElasticBlockStore
 */
export interface TenantSpecSideCarsVolumesAwsElasticBlockStore {
    /**
     * @schema TenantSpecSideCarsVolumesAwsElasticBlockStore#fsType
     */
    readonly fsType?: string;
    /**
     * @schema TenantSpecSideCarsVolumesAwsElasticBlockStore#partition
     */
    readonly partition?: number;
    /**
     * @schema TenantSpecSideCarsVolumesAwsElasticBlockStore#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * @schema TenantSpecSideCarsVolumesAwsElasticBlockStore#volumeID
     */
    readonly volumeId: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesAwsElasticBlockStore' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesAwsElasticBlockStore(obj: TenantSpecSideCarsVolumesAwsElasticBlockStore | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesAzureDisk
 */
export interface TenantSpecSideCarsVolumesAzureDisk {
    /**
     * @schema TenantSpecSideCarsVolumesAzureDisk#cachingMode
     */
    readonly cachingMode?: string;
    /**
     * @schema TenantSpecSideCarsVolumesAzureDisk#diskName
     */
    readonly diskName: string;
    /**
     * @schema TenantSpecSideCarsVolumesAzureDisk#diskURI
     */
    readonly diskUri: string;
    /**
     * @schema TenantSpecSideCarsVolumesAzureDisk#fsType
     */
    readonly fsType?: string;
    /**
     * @schema TenantSpecSideCarsVolumesAzureDisk#kind
     */
    readonly kind?: string;
    /**
     * @schema TenantSpecSideCarsVolumesAzureDisk#readOnly
     */
    readonly readOnly?: boolean;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesAzureDisk' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesAzureDisk(obj: TenantSpecSideCarsVolumesAzureDisk | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesAzureFile
 */
export interface TenantSpecSideCarsVolumesAzureFile {
    /**
     * @schema TenantSpecSideCarsVolumesAzureFile#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * @schema TenantSpecSideCarsVolumesAzureFile#secretName
     */
    readonly secretName: string;
    /**
     * @schema TenantSpecSideCarsVolumesAzureFile#shareName
     */
    readonly shareName: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesAzureFile' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesAzureFile(obj: TenantSpecSideCarsVolumesAzureFile | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesCephfs
 */
export interface TenantSpecSideCarsVolumesCephfs {
    /**
     * @schema TenantSpecSideCarsVolumesCephfs#monitors
     */
    readonly monitors: string[];
    /**
     * @schema TenantSpecSideCarsVolumesCephfs#path
     */
    readonly path?: string;
    /**
     * @schema TenantSpecSideCarsVolumesCephfs#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * @schema TenantSpecSideCarsVolumesCephfs#secretFile
     */
    readonly secretFile?: string;
    /**
     * @schema TenantSpecSideCarsVolumesCephfs#secretRef
     */
    readonly secretRef?: TenantSpecSideCarsVolumesCephfsSecretRef;
    /**
     * @schema TenantSpecSideCarsVolumesCephfs#user
     */
    readonly user?: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesCephfs' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesCephfs(obj: TenantSpecSideCarsVolumesCephfs | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesCinder
 */
export interface TenantSpecSideCarsVolumesCinder {
    /**
     * @schema TenantSpecSideCarsVolumesCinder#fsType
     */
    readonly fsType?: string;
    /**
     * @schema TenantSpecSideCarsVolumesCinder#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * @schema TenantSpecSideCarsVolumesCinder#secretRef
     */
    readonly secretRef?: TenantSpecSideCarsVolumesCinderSecretRef;
    /**
     * @schema TenantSpecSideCarsVolumesCinder#volumeID
     */
    readonly volumeId: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesCinder' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesCinder(obj: TenantSpecSideCarsVolumesCinder | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesConfigMap
 */
export interface TenantSpecSideCarsVolumesConfigMap {
    /**
     * @schema TenantSpecSideCarsVolumesConfigMap#defaultMode
     */
    readonly defaultMode?: number;
    /**
     * @schema TenantSpecSideCarsVolumesConfigMap#items
     */
    readonly items?: TenantSpecSideCarsVolumesConfigMapItems[];
    /**
     * @schema TenantSpecSideCarsVolumesConfigMap#name
     */
    readonly name?: string;
    /**
     * @schema TenantSpecSideCarsVolumesConfigMap#optional
     */
    readonly optional?: boolean;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesConfigMap' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesConfigMap(obj: TenantSpecSideCarsVolumesConfigMap | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesCsi
 */
export interface TenantSpecSideCarsVolumesCsi {
    /**
     * @schema TenantSpecSideCarsVolumesCsi#driver
     */
    readonly driver: string;
    /**
     * @schema TenantSpecSideCarsVolumesCsi#fsType
     */
    readonly fsType?: string;
    /**
     * @schema TenantSpecSideCarsVolumesCsi#nodePublishSecretRef
     */
    readonly nodePublishSecretRef?: TenantSpecSideCarsVolumesCsiNodePublishSecretRef;
    /**
     * @schema TenantSpecSideCarsVolumesCsi#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * @schema TenantSpecSideCarsVolumesCsi#volumeAttributes
     */
    readonly volumeAttributes?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesCsi' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesCsi(obj: TenantSpecSideCarsVolumesCsi | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesDownwardApi
 */
export interface TenantSpecSideCarsVolumesDownwardApi {
    /**
     * @schema TenantSpecSideCarsVolumesDownwardApi#defaultMode
     */
    readonly defaultMode?: number;
    /**
     * @schema TenantSpecSideCarsVolumesDownwardApi#items
     */
    readonly items?: TenantSpecSideCarsVolumesDownwardApiItems[];
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesDownwardApi' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesDownwardApi(obj: TenantSpecSideCarsVolumesDownwardApi | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesEmptyDir
 */
export interface TenantSpecSideCarsVolumesEmptyDir {
    /**
     * @schema TenantSpecSideCarsVolumesEmptyDir#medium
     */
    readonly medium?: string;
    /**
     * @schema TenantSpecSideCarsVolumesEmptyDir#sizeLimit
     */
    readonly sizeLimit?: TenantSpecSideCarsVolumesEmptyDirSizeLimit;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesEmptyDir' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesEmptyDir(obj: TenantSpecSideCarsVolumesEmptyDir | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesEphemeral
 */
export interface TenantSpecSideCarsVolumesEphemeral {
    /**
     * @schema TenantSpecSideCarsVolumesEphemeral#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * @schema TenantSpecSideCarsVolumesEphemeral#volumeClaimTemplate
     */
    readonly volumeClaimTemplate?: TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplate;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesEphemeral' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesEphemeral(obj: TenantSpecSideCarsVolumesEphemeral | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesFc
 */
export interface TenantSpecSideCarsVolumesFc {
    /**
     * @schema TenantSpecSideCarsVolumesFc#fsType
     */
    readonly fsType?: string;
    /**
     * @schema TenantSpecSideCarsVolumesFc#lun
     */
    readonly lun?: number;
    /**
     * @schema TenantSpecSideCarsVolumesFc#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * @schema TenantSpecSideCarsVolumesFc#targetWWNs
     */
    readonly targetWwNs?: string[];
    /**
     * @schema TenantSpecSideCarsVolumesFc#wwids
     */
    readonly wwids?: string[];
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesFc' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesFc(obj: TenantSpecSideCarsVolumesFc | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesFlexVolume
 */
export interface TenantSpecSideCarsVolumesFlexVolume {
    /**
     * @schema TenantSpecSideCarsVolumesFlexVolume#driver
     */
    readonly driver: string;
    /**
     * @schema TenantSpecSideCarsVolumesFlexVolume#fsType
     */
    readonly fsType?: string;
    /**
     * @schema TenantSpecSideCarsVolumesFlexVolume#options
     */
    readonly options?: {
        [key: string]: string;
    };
    /**
     * @schema TenantSpecSideCarsVolumesFlexVolume#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * @schema TenantSpecSideCarsVolumesFlexVolume#secretRef
     */
    readonly secretRef?: TenantSpecSideCarsVolumesFlexVolumeSecretRef;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesFlexVolume' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesFlexVolume(obj: TenantSpecSideCarsVolumesFlexVolume | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesFlocker
 */
export interface TenantSpecSideCarsVolumesFlocker {
    /**
     * @schema TenantSpecSideCarsVolumesFlocker#datasetName
     */
    readonly datasetName?: string;
    /**
     * @schema TenantSpecSideCarsVolumesFlocker#datasetUUID
     */
    readonly datasetUuid?: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesFlocker' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesFlocker(obj: TenantSpecSideCarsVolumesFlocker | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesGcePersistentDisk
 */
export interface TenantSpecSideCarsVolumesGcePersistentDisk {
    /**
     * @schema TenantSpecSideCarsVolumesGcePersistentDisk#fsType
     */
    readonly fsType?: string;
    /**
     * @schema TenantSpecSideCarsVolumesGcePersistentDisk#partition
     */
    readonly partition?: number;
    /**
     * @schema TenantSpecSideCarsVolumesGcePersistentDisk#pdName
     */
    readonly pdName: string;
    /**
     * @schema TenantSpecSideCarsVolumesGcePersistentDisk#readOnly
     */
    readonly readOnly?: boolean;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesGcePersistentDisk' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesGcePersistentDisk(obj: TenantSpecSideCarsVolumesGcePersistentDisk | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesGitRepo
 */
export interface TenantSpecSideCarsVolumesGitRepo {
    /**
     * @schema TenantSpecSideCarsVolumesGitRepo#directory
     */
    readonly directory?: string;
    /**
     * @schema TenantSpecSideCarsVolumesGitRepo#repository
     */
    readonly repository: string;
    /**
     * @schema TenantSpecSideCarsVolumesGitRepo#revision
     */
    readonly revision?: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesGitRepo' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesGitRepo(obj: TenantSpecSideCarsVolumesGitRepo | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesGlusterfs
 */
export interface TenantSpecSideCarsVolumesGlusterfs {
    /**
     * @schema TenantSpecSideCarsVolumesGlusterfs#endpoints
     */
    readonly endpoints: string;
    /**
     * @schema TenantSpecSideCarsVolumesGlusterfs#path
     */
    readonly path: string;
    /**
     * @schema TenantSpecSideCarsVolumesGlusterfs#readOnly
     */
    readonly readOnly?: boolean;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesGlusterfs' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesGlusterfs(obj: TenantSpecSideCarsVolumesGlusterfs | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesHostPath
 */
export interface TenantSpecSideCarsVolumesHostPath {
    /**
     * @schema TenantSpecSideCarsVolumesHostPath#path
     */
    readonly path: string;
    /**
     * @schema TenantSpecSideCarsVolumesHostPath#type
     */
    readonly type?: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesHostPath' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesHostPath(obj: TenantSpecSideCarsVolumesHostPath | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesIscsi
 */
export interface TenantSpecSideCarsVolumesIscsi {
    /**
     * @schema TenantSpecSideCarsVolumesIscsi#chapAuthDiscovery
     */
    readonly chapAuthDiscovery?: boolean;
    /**
     * @schema TenantSpecSideCarsVolumesIscsi#chapAuthSession
     */
    readonly chapAuthSession?: boolean;
    /**
     * @schema TenantSpecSideCarsVolumesIscsi#fsType
     */
    readonly fsType?: string;
    /**
     * @schema TenantSpecSideCarsVolumesIscsi#initiatorName
     */
    readonly initiatorName?: string;
    /**
     * @schema TenantSpecSideCarsVolumesIscsi#iqn
     */
    readonly iqn: string;
    /**
     * @schema TenantSpecSideCarsVolumesIscsi#iscsiInterface
     */
    readonly iscsiInterface?: string;
    /**
     * @schema TenantSpecSideCarsVolumesIscsi#lun
     */
    readonly lun: number;
    /**
     * @schema TenantSpecSideCarsVolumesIscsi#portals
     */
    readonly portals?: string[];
    /**
     * @schema TenantSpecSideCarsVolumesIscsi#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * @schema TenantSpecSideCarsVolumesIscsi#secretRef
     */
    readonly secretRef?: TenantSpecSideCarsVolumesIscsiSecretRef;
    /**
     * @schema TenantSpecSideCarsVolumesIscsi#targetPortal
     */
    readonly targetPortal: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesIscsi' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesIscsi(obj: TenantSpecSideCarsVolumesIscsi | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesNfs
 */
export interface TenantSpecSideCarsVolumesNfs {
    /**
     * @schema TenantSpecSideCarsVolumesNfs#path
     */
    readonly path: string;
    /**
     * @schema TenantSpecSideCarsVolumesNfs#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * @schema TenantSpecSideCarsVolumesNfs#server
     */
    readonly server: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesNfs' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesNfs(obj: TenantSpecSideCarsVolumesNfs | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesPersistentVolumeClaim
 */
export interface TenantSpecSideCarsVolumesPersistentVolumeClaim {
    /**
     * @schema TenantSpecSideCarsVolumesPersistentVolumeClaim#claimName
     */
    readonly claimName: string;
    /**
     * @schema TenantSpecSideCarsVolumesPersistentVolumeClaim#readOnly
     */
    readonly readOnly?: boolean;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesPersistentVolumeClaim' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesPersistentVolumeClaim(obj: TenantSpecSideCarsVolumesPersistentVolumeClaim | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesPhotonPersistentDisk
 */
export interface TenantSpecSideCarsVolumesPhotonPersistentDisk {
    /**
     * @schema TenantSpecSideCarsVolumesPhotonPersistentDisk#fsType
     */
    readonly fsType?: string;
    /**
     * @schema TenantSpecSideCarsVolumesPhotonPersistentDisk#pdID
     */
    readonly pdId: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesPhotonPersistentDisk' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesPhotonPersistentDisk(obj: TenantSpecSideCarsVolumesPhotonPersistentDisk | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesPortworxVolume
 */
export interface TenantSpecSideCarsVolumesPortworxVolume {
    /**
     * @schema TenantSpecSideCarsVolumesPortworxVolume#fsType
     */
    readonly fsType?: string;
    /**
     * @schema TenantSpecSideCarsVolumesPortworxVolume#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * @schema TenantSpecSideCarsVolumesPortworxVolume#volumeID
     */
    readonly volumeId: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesPortworxVolume' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesPortworxVolume(obj: TenantSpecSideCarsVolumesPortworxVolume | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesProjected
 */
export interface TenantSpecSideCarsVolumesProjected {
    /**
     * @schema TenantSpecSideCarsVolumesProjected#defaultMode
     */
    readonly defaultMode?: number;
    /**
     * @schema TenantSpecSideCarsVolumesProjected#sources
     */
    readonly sources?: TenantSpecSideCarsVolumesProjectedSources[];
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesProjected' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesProjected(obj: TenantSpecSideCarsVolumesProjected | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesQuobyte
 */
export interface TenantSpecSideCarsVolumesQuobyte {
    /**
     * @schema TenantSpecSideCarsVolumesQuobyte#group
     */
    readonly group?: string;
    /**
     * @schema TenantSpecSideCarsVolumesQuobyte#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * @schema TenantSpecSideCarsVolumesQuobyte#registry
     */
    readonly registry: string;
    /**
     * @schema TenantSpecSideCarsVolumesQuobyte#tenant
     */
    readonly tenant?: string;
    /**
     * @schema TenantSpecSideCarsVolumesQuobyte#user
     */
    readonly user?: string;
    /**
     * @schema TenantSpecSideCarsVolumesQuobyte#volume
     */
    readonly volume: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesQuobyte' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesQuobyte(obj: TenantSpecSideCarsVolumesQuobyte | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesRbd
 */
export interface TenantSpecSideCarsVolumesRbd {
    /**
     * @schema TenantSpecSideCarsVolumesRbd#fsType
     */
    readonly fsType?: string;
    /**
     * @schema TenantSpecSideCarsVolumesRbd#image
     */
    readonly image: string;
    /**
     * @schema TenantSpecSideCarsVolumesRbd#keyring
     */
    readonly keyring?: string;
    /**
     * @schema TenantSpecSideCarsVolumesRbd#monitors
     */
    readonly monitors: string[];
    /**
     * @schema TenantSpecSideCarsVolumesRbd#pool
     */
    readonly pool?: string;
    /**
     * @schema TenantSpecSideCarsVolumesRbd#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * @schema TenantSpecSideCarsVolumesRbd#secretRef
     */
    readonly secretRef?: TenantSpecSideCarsVolumesRbdSecretRef;
    /**
     * @schema TenantSpecSideCarsVolumesRbd#user
     */
    readonly user?: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesRbd' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesRbd(obj: TenantSpecSideCarsVolumesRbd | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesScaleIo
 */
export interface TenantSpecSideCarsVolumesScaleIo {
    /**
     * @schema TenantSpecSideCarsVolumesScaleIo#fsType
     */
    readonly fsType?: string;
    /**
     * @schema TenantSpecSideCarsVolumesScaleIo#gateway
     */
    readonly gateway: string;
    /**
     * @schema TenantSpecSideCarsVolumesScaleIo#protectionDomain
     */
    readonly protectionDomain?: string;
    /**
     * @schema TenantSpecSideCarsVolumesScaleIo#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * @schema TenantSpecSideCarsVolumesScaleIo#secretRef
     */
    readonly secretRef: TenantSpecSideCarsVolumesScaleIoSecretRef;
    /**
     * @schema TenantSpecSideCarsVolumesScaleIo#sslEnabled
     */
    readonly sslEnabled?: boolean;
    /**
     * @schema TenantSpecSideCarsVolumesScaleIo#storageMode
     */
    readonly storageMode?: string;
    /**
     * @schema TenantSpecSideCarsVolumesScaleIo#storagePool
     */
    readonly storagePool?: string;
    /**
     * @schema TenantSpecSideCarsVolumesScaleIo#system
     */
    readonly system: string;
    /**
     * @schema TenantSpecSideCarsVolumesScaleIo#volumeName
     */
    readonly volumeName?: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesScaleIo' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesScaleIo(obj: TenantSpecSideCarsVolumesScaleIo | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesSecret
 */
export interface TenantSpecSideCarsVolumesSecret {
    /**
     * @schema TenantSpecSideCarsVolumesSecret#defaultMode
     */
    readonly defaultMode?: number;
    /**
     * @schema TenantSpecSideCarsVolumesSecret#items
     */
    readonly items?: TenantSpecSideCarsVolumesSecretItems[];
    /**
     * @schema TenantSpecSideCarsVolumesSecret#optional
     */
    readonly optional?: boolean;
    /**
     * @schema TenantSpecSideCarsVolumesSecret#secretName
     */
    readonly secretName?: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesSecret' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesSecret(obj: TenantSpecSideCarsVolumesSecret | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesStorageos
 */
export interface TenantSpecSideCarsVolumesStorageos {
    /**
     * @schema TenantSpecSideCarsVolumesStorageos#fsType
     */
    readonly fsType?: string;
    /**
     * @schema TenantSpecSideCarsVolumesStorageos#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * @schema TenantSpecSideCarsVolumesStorageos#secretRef
     */
    readonly secretRef?: TenantSpecSideCarsVolumesStorageosSecretRef;
    /**
     * @schema TenantSpecSideCarsVolumesStorageos#volumeName
     */
    readonly volumeName?: string;
    /**
     * @schema TenantSpecSideCarsVolumesStorageos#volumeNamespace
     */
    readonly volumeNamespace?: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesStorageos' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesStorageos(obj: TenantSpecSideCarsVolumesStorageos | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesVsphereVolume
 */
export interface TenantSpecSideCarsVolumesVsphereVolume {
    /**
     * @schema TenantSpecSideCarsVolumesVsphereVolume#fsType
     */
    readonly fsType?: string;
    /**
     * @schema TenantSpecSideCarsVolumesVsphereVolume#storagePolicyID
     */
    readonly storagePolicyId?: string;
    /**
     * @schema TenantSpecSideCarsVolumesVsphereVolume#storagePolicyName
     */
    readonly storagePolicyName?: string;
    /**
     * @schema TenantSpecSideCarsVolumesVsphereVolume#volumePath
     */
    readonly volumePath: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesVsphereVolume' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesVsphereVolume(obj: TenantSpecSideCarsVolumesVsphereVolume | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesAffinityNodeAffinity
 */
export interface TenantSpecZonesAffinityNodeAffinity {
    /**
     * @schema TenantSpecZonesAffinityNodeAffinity#preferredDuringSchedulingIgnoredDuringExecution
     */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution[];
    /**
     * @schema TenantSpecZonesAffinityNodeAffinity#requiredDuringSchedulingIgnoredDuringExecution
     */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution;
}
/**
 * Converts an object of type 'TenantSpecZonesAffinityNodeAffinity' to JSON representation.
 */
export declare function toJson_TenantSpecZonesAffinityNodeAffinity(obj: TenantSpecZonesAffinityNodeAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesAffinityPodAffinity
 */
export interface TenantSpecZonesAffinityPodAffinity {
    /**
     * @schema TenantSpecZonesAffinityPodAffinity#preferredDuringSchedulingIgnoredDuringExecution
     */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution[];
    /**
     * @schema TenantSpecZonesAffinityPodAffinity#requiredDuringSchedulingIgnoredDuringExecution
     */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: TenantSpecZonesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution[];
}
/**
 * Converts an object of type 'TenantSpecZonesAffinityPodAffinity' to JSON representation.
 */
export declare function toJson_TenantSpecZonesAffinityPodAffinity(obj: TenantSpecZonesAffinityPodAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesAffinityPodAntiAffinity
 */
export interface TenantSpecZonesAffinityPodAntiAffinity {
    /**
     * @schema TenantSpecZonesAffinityPodAntiAffinity#preferredDuringSchedulingIgnoredDuringExecution
     */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution[];
    /**
     * @schema TenantSpecZonesAffinityPodAntiAffinity#requiredDuringSchedulingIgnoredDuringExecution
     */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: TenantSpecZonesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution[];
}
/**
 * Converts an object of type 'TenantSpecZonesAffinityPodAntiAffinity' to JSON representation.
 */
export declare function toJson_TenantSpecZonesAffinityPodAntiAffinity(obj: TenantSpecZonesAffinityPodAntiAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesResourcesLimits
 */
export declare class TenantSpecZonesResourcesLimits {
    readonly value: any;
    static fromNumber(value: number): TenantSpecZonesResourcesLimits;
    static fromString(value: string): TenantSpecZonesResourcesLimits;
    private constructor();
}
/**
 * @schema TenantSpecZonesResourcesRequests
 */
export declare class TenantSpecZonesResourcesRequests {
    readonly value: any;
    static fromNumber(value: number): TenantSpecZonesResourcesRequests;
    static fromString(value: string): TenantSpecZonesResourcesRequests;
    private constructor();
}
/**
 * @schema TenantSpecZonesSecurityContextSeLinuxOptions
 */
export interface TenantSpecZonesSecurityContextSeLinuxOptions {
    /**
     * @schema TenantSpecZonesSecurityContextSeLinuxOptions#level
     */
    readonly level?: string;
    /**
     * @schema TenantSpecZonesSecurityContextSeLinuxOptions#role
     */
    readonly role?: string;
    /**
     * @schema TenantSpecZonesSecurityContextSeLinuxOptions#type
     */
    readonly type?: string;
    /**
     * @schema TenantSpecZonesSecurityContextSeLinuxOptions#user
     */
    readonly user?: string;
}
/**
 * Converts an object of type 'TenantSpecZonesSecurityContextSeLinuxOptions' to JSON representation.
 */
export declare function toJson_TenantSpecZonesSecurityContextSeLinuxOptions(obj: TenantSpecZonesSecurityContextSeLinuxOptions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesSecurityContextSeccompProfile
 */
export interface TenantSpecZonesSecurityContextSeccompProfile {
    /**
     * @schema TenantSpecZonesSecurityContextSeccompProfile#localhostProfile
     */
    readonly localhostProfile?: string;
    /**
     * @schema TenantSpecZonesSecurityContextSeccompProfile#type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'TenantSpecZonesSecurityContextSeccompProfile' to JSON representation.
 */
export declare function toJson_TenantSpecZonesSecurityContextSeccompProfile(obj: TenantSpecZonesSecurityContextSeccompProfile | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesSecurityContextSysctls
 */
export interface TenantSpecZonesSecurityContextSysctls {
    /**
     * @schema TenantSpecZonesSecurityContextSysctls#name
     */
    readonly name: string;
    /**
     * @schema TenantSpecZonesSecurityContextSysctls#value
     */
    readonly value: string;
}
/**
 * Converts an object of type 'TenantSpecZonesSecurityContextSysctls' to JSON representation.
 */
export declare function toJson_TenantSpecZonesSecurityContextSysctls(obj: TenantSpecZonesSecurityContextSysctls | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesSecurityContextWindowsOptions
 */
export interface TenantSpecZonesSecurityContextWindowsOptions {
    /**
     * @schema TenantSpecZonesSecurityContextWindowsOptions#gmsaCredentialSpec
     */
    readonly gmsaCredentialSpec?: string;
    /**
     * @schema TenantSpecZonesSecurityContextWindowsOptions#gmsaCredentialSpecName
     */
    readonly gmsaCredentialSpecName?: string;
    /**
     * @schema TenantSpecZonesSecurityContextWindowsOptions#runAsUserName
     */
    readonly runAsUserName?: string;
}
/**
 * Converts an object of type 'TenantSpecZonesSecurityContextWindowsOptions' to JSON representation.
 */
export declare function toJson_TenantSpecZonesSecurityContextWindowsOptions(obj: TenantSpecZonesSecurityContextWindowsOptions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesTopologySpreadConstraintsLabelSelector
 */
export interface TenantSpecZonesTopologySpreadConstraintsLabelSelector {
    /**
     * @schema TenantSpecZonesTopologySpreadConstraintsLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantSpecZonesTopologySpreadConstraintsLabelSelectorMatchExpressions[];
    /**
     * @schema TenantSpecZonesTopologySpreadConstraintsLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantSpecZonesTopologySpreadConstraintsLabelSelector' to JSON representation.
 */
export declare function toJson_TenantSpecZonesTopologySpreadConstraintsLabelSelector(obj: TenantSpecZonesTopologySpreadConstraintsLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesVolumeClaimTemplateMetadata
 */
export interface TenantSpecZonesVolumeClaimTemplateMetadata {
    /**
     * @schema TenantSpecZonesVolumeClaimTemplateMetadata#annotations
     */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
     * @schema TenantSpecZonesVolumeClaimTemplateMetadata#finalizers
     */
    readonly finalizers?: string[];
    /**
     * @schema TenantSpecZonesVolumeClaimTemplateMetadata#labels
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * @schema TenantSpecZonesVolumeClaimTemplateMetadata#name
     */
    readonly name?: string;
    /**
     * @schema TenantSpecZonesVolumeClaimTemplateMetadata#namespace
     */
    readonly namespace?: string;
}
/**
 * Converts an object of type 'TenantSpecZonesVolumeClaimTemplateMetadata' to JSON representation.
 */
export declare function toJson_TenantSpecZonesVolumeClaimTemplateMetadata(obj: TenantSpecZonesVolumeClaimTemplateMetadata | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesVolumeClaimTemplateSpec
 */
export interface TenantSpecZonesVolumeClaimTemplateSpec {
    /**
     * @schema TenantSpecZonesVolumeClaimTemplateSpec#accessModes
     */
    readonly accessModes?: string[];
    /**
     * @schema TenantSpecZonesVolumeClaimTemplateSpec#dataSource
     */
    readonly dataSource?: TenantSpecZonesVolumeClaimTemplateSpecDataSource;
    /**
     * @schema TenantSpecZonesVolumeClaimTemplateSpec#resources
     */
    readonly resources?: TenantSpecZonesVolumeClaimTemplateSpecResources;
    /**
     * @schema TenantSpecZonesVolumeClaimTemplateSpec#selector
     */
    readonly selector?: TenantSpecZonesVolumeClaimTemplateSpecSelector;
    /**
     * @schema TenantSpecZonesVolumeClaimTemplateSpec#storageClassName
     */
    readonly storageClassName?: string;
    /**
     * @schema TenantSpecZonesVolumeClaimTemplateSpec#volumeMode
     */
    readonly volumeMode?: string;
    /**
     * @schema TenantSpecZonesVolumeClaimTemplateSpec#volumeName
     */
    readonly volumeName?: string;
}
/**
 * Converts an object of type 'TenantSpecZonesVolumeClaimTemplateSpec' to JSON representation.
 */
export declare function toJson_TenantSpecZonesVolumeClaimTemplateSpec(obj: TenantSpecZonesVolumeClaimTemplateSpec | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesVolumeClaimTemplateStatus
 */
export interface TenantSpecZonesVolumeClaimTemplateStatus {
    /**
     * @schema TenantSpecZonesVolumeClaimTemplateStatus#accessModes
     */
    readonly accessModes?: string[];
    /**
     * @schema TenantSpecZonesVolumeClaimTemplateStatus#capacity
     */
    readonly capacity?: {
        [key: string]: TenantSpecZonesVolumeClaimTemplateStatusCapacity;
    };
    /**
     * @schema TenantSpecZonesVolumeClaimTemplateStatus#conditions
     */
    readonly conditions?: TenantSpecZonesVolumeClaimTemplateStatusConditions[];
    /**
     * @schema TenantSpecZonesVolumeClaimTemplateStatus#phase
     */
    readonly phase?: string;
}
/**
 * Converts an object of type 'TenantSpecZonesVolumeClaimTemplateStatus' to JSON representation.
 */
export declare function toJson_TenantSpecZonesVolumeClaimTemplateStatus(obj: TenantSpecZonesVolumeClaimTemplateStatus | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecEnvValueFromResourceFieldRefDivisor
 */
export declare class TenantSpecEnvValueFromResourceFieldRefDivisor {
    readonly value: any;
    static fromNumber(value: number): TenantSpecEnvValueFromResourceFieldRefDivisor;
    static fromString(value: string): TenantSpecEnvValueFromResourceFieldRefDivisor;
    private constructor();
}
/**
 * @schema TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution#preference
     */
    readonly preference: TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference;
    /**
     * @schema TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
     */
    readonly weight: number;
}
/**
 * Converts an object of type 'TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution(obj: TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution#nodeSelectorTerms
     */
    readonly nodeSelectorTerms: TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms[];
}
/**
 * Converts an object of type 'TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution(obj: TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution#podAffinityTerm
     */
    readonly podAffinityTerm: TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm;
    /**
     * @schema TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
     */
    readonly weight: number;
}
/**
 * Converts an object of type 'TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution(obj: TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#labelSelector
     */
    readonly labelSelector?: TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector;
    /**
     * @schema TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution(obj: TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution#podAffinityTerm
     */
    readonly podAffinityTerm: TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm;
    /**
     * @schema TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
     */
    readonly weight: number;
}
/**
 * Converts an object of type 'TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution(obj: TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#labelSelector
     */
    readonly labelSelector?: TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector;
    /**
     * @schema TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution(obj: TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesTopologySpreadConstraintsLabelSelectorMatchExpressions
 */
export interface TenantSpecKesTopologySpreadConstraintsLabelSelectorMatchExpressions {
    /**
     * @schema TenantSpecKesTopologySpreadConstraintsLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecKesTopologySpreadConstraintsLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecKesTopologySpreadConstraintsLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecKesTopologySpreadConstraintsLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecKesTopologySpreadConstraintsLabelSelectorMatchExpressions(obj: TenantSpecKesTopologySpreadConstraintsLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution#preference
     */
    readonly preference: TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference;
    /**
     * @schema TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
     */
    readonly weight: number;
}
/**
 * Converts an object of type 'TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution(obj: TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution#nodeSelectorTerms
     */
    readonly nodeSelectorTerms: TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms[];
}
/**
 * Converts an object of type 'TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution(obj: TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution#podAffinityTerm
     */
    readonly podAffinityTerm: TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm;
    /**
     * @schema TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
     */
    readonly weight: number;
}
/**
 * Converts an object of type 'TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution(obj: TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#labelSelector
     */
    readonly labelSelector?: TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector;
    /**
     * @schema TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution(obj: TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution#podAffinityTerm
     */
    readonly podAffinityTerm: TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm;
    /**
     * @schema TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
     */
    readonly weight: number;
}
/**
 * Converts an object of type 'TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution(obj: TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#labelSelector
     */
    readonly labelSelector?: TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector;
    /**
     * @schema TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution(obj: TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbAffinityNodeAffinity
 */
export interface TenantSpecLogDbAffinityNodeAffinity {
    /**
     * @schema TenantSpecLogDbAffinityNodeAffinity#preferredDuringSchedulingIgnoredDuringExecution
     */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution[];
    /**
     * @schema TenantSpecLogDbAffinityNodeAffinity#requiredDuringSchedulingIgnoredDuringExecution
     */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution;
}
/**
 * Converts an object of type 'TenantSpecLogDbAffinityNodeAffinity' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbAffinityNodeAffinity(obj: TenantSpecLogDbAffinityNodeAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbAffinityPodAffinity
 */
export interface TenantSpecLogDbAffinityPodAffinity {
    /**
     * @schema TenantSpecLogDbAffinityPodAffinity#preferredDuringSchedulingIgnoredDuringExecution
     */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution[];
    /**
     * @schema TenantSpecLogDbAffinityPodAffinity#requiredDuringSchedulingIgnoredDuringExecution
     */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution[];
}
/**
 * Converts an object of type 'TenantSpecLogDbAffinityPodAffinity' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbAffinityPodAffinity(obj: TenantSpecLogDbAffinityPodAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbAffinityPodAntiAffinity
 */
export interface TenantSpecLogDbAffinityPodAntiAffinity {
    /**
     * @schema TenantSpecLogDbAffinityPodAntiAffinity#preferredDuringSchedulingIgnoredDuringExecution
     */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution[];
    /**
     * @schema TenantSpecLogDbAffinityPodAntiAffinity#requiredDuringSchedulingIgnoredDuringExecution
     */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution[];
}
/**
 * Converts an object of type 'TenantSpecLogDbAffinityPodAntiAffinity' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbAffinityPodAntiAffinity(obj: TenantSpecLogDbAffinityPodAntiAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbResourcesLimits
 */
export declare class TenantSpecLogDbResourcesLimits {
    readonly value: any;
    static fromNumber(value: number): TenantSpecLogDbResourcesLimits;
    static fromString(value: string): TenantSpecLogDbResourcesLimits;
    private constructor();
}
/**
 * @schema TenantSpecLogDbResourcesRequests
 */
export declare class TenantSpecLogDbResourcesRequests {
    readonly value: any;
    static fromNumber(value: number): TenantSpecLogDbResourcesRequests;
    static fromString(value: string): TenantSpecLogDbResourcesRequests;
    private constructor();
}
/**
 * @schema TenantSpecLogDbSecurityContextSeLinuxOptions
 */
export interface TenantSpecLogDbSecurityContextSeLinuxOptions {
    /**
     * @schema TenantSpecLogDbSecurityContextSeLinuxOptions#level
     */
    readonly level?: string;
    /**
     * @schema TenantSpecLogDbSecurityContextSeLinuxOptions#role
     */
    readonly role?: string;
    /**
     * @schema TenantSpecLogDbSecurityContextSeLinuxOptions#type
     */
    readonly type?: string;
    /**
     * @schema TenantSpecLogDbSecurityContextSeLinuxOptions#user
     */
    readonly user?: string;
}
/**
 * Converts an object of type 'TenantSpecLogDbSecurityContextSeLinuxOptions' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbSecurityContextSeLinuxOptions(obj: TenantSpecLogDbSecurityContextSeLinuxOptions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbSecurityContextSeccompProfile
 */
export interface TenantSpecLogDbSecurityContextSeccompProfile {
    /**
     * @schema TenantSpecLogDbSecurityContextSeccompProfile#localhostProfile
     */
    readonly localhostProfile?: string;
    /**
     * @schema TenantSpecLogDbSecurityContextSeccompProfile#type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'TenantSpecLogDbSecurityContextSeccompProfile' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbSecurityContextSeccompProfile(obj: TenantSpecLogDbSecurityContextSeccompProfile | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbSecurityContextSysctls
 */
export interface TenantSpecLogDbSecurityContextSysctls {
    /**
     * @schema TenantSpecLogDbSecurityContextSysctls#name
     */
    readonly name: string;
    /**
     * @schema TenantSpecLogDbSecurityContextSysctls#value
     */
    readonly value: string;
}
/**
 * Converts an object of type 'TenantSpecLogDbSecurityContextSysctls' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbSecurityContextSysctls(obj: TenantSpecLogDbSecurityContextSysctls | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbSecurityContextWindowsOptions
 */
export interface TenantSpecLogDbSecurityContextWindowsOptions {
    /**
     * @schema TenantSpecLogDbSecurityContextWindowsOptions#gmsaCredentialSpec
     */
    readonly gmsaCredentialSpec?: string;
    /**
     * @schema TenantSpecLogDbSecurityContextWindowsOptions#gmsaCredentialSpecName
     */
    readonly gmsaCredentialSpecName?: string;
    /**
     * @schema TenantSpecLogDbSecurityContextWindowsOptions#runAsUserName
     */
    readonly runAsUserName?: string;
}
/**
 * Converts an object of type 'TenantSpecLogDbSecurityContextWindowsOptions' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbSecurityContextWindowsOptions(obj: TenantSpecLogDbSecurityContextWindowsOptions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbTopologySpreadConstraintsLabelSelector
 */
export interface TenantSpecLogDbTopologySpreadConstraintsLabelSelector {
    /**
     * @schema TenantSpecLogDbTopologySpreadConstraintsLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantSpecLogDbTopologySpreadConstraintsLabelSelectorMatchExpressions[];
    /**
     * @schema TenantSpecLogDbTopologySpreadConstraintsLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantSpecLogDbTopologySpreadConstraintsLabelSelector' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbTopologySpreadConstraintsLabelSelector(obj: TenantSpecLogDbTopologySpreadConstraintsLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbVolumeClaimTemplateMetadata
 */
export interface TenantSpecLogDbVolumeClaimTemplateMetadata {
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplateMetadata#annotations
     */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplateMetadata#finalizers
     */
    readonly finalizers?: string[];
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplateMetadata#labels
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplateMetadata#name
     */
    readonly name?: string;
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplateMetadata#namespace
     */
    readonly namespace?: string;
}
/**
 * Converts an object of type 'TenantSpecLogDbVolumeClaimTemplateMetadata' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbVolumeClaimTemplateMetadata(obj: TenantSpecLogDbVolumeClaimTemplateMetadata | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbVolumeClaimTemplateSpec
 */
export interface TenantSpecLogDbVolumeClaimTemplateSpec {
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplateSpec#accessModes
     */
    readonly accessModes?: string[];
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplateSpec#dataSource
     */
    readonly dataSource?: TenantSpecLogDbVolumeClaimTemplateSpecDataSource;
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplateSpec#resources
     */
    readonly resources?: TenantSpecLogDbVolumeClaimTemplateSpecResources;
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplateSpec#selector
     */
    readonly selector?: TenantSpecLogDbVolumeClaimTemplateSpecSelector;
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplateSpec#storageClassName
     */
    readonly storageClassName?: string;
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplateSpec#volumeMode
     */
    readonly volumeMode?: string;
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplateSpec#volumeName
     */
    readonly volumeName?: string;
}
/**
 * Converts an object of type 'TenantSpecLogDbVolumeClaimTemplateSpec' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbVolumeClaimTemplateSpec(obj: TenantSpecLogDbVolumeClaimTemplateSpec | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbVolumeClaimTemplateStatus
 */
export interface TenantSpecLogDbVolumeClaimTemplateStatus {
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplateStatus#accessModes
     */
    readonly accessModes?: string[];
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplateStatus#capacity
     */
    readonly capacity?: {
        [key: string]: TenantSpecLogDbVolumeClaimTemplateStatusCapacity;
    };
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplateStatus#conditions
     */
    readonly conditions?: TenantSpecLogDbVolumeClaimTemplateStatusConditions[];
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplateStatus#phase
     */
    readonly phase?: string;
}
/**
 * Converts an object of type 'TenantSpecLogDbVolumeClaimTemplateStatus' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbVolumeClaimTemplateStatus(obj: TenantSpecLogDbVolumeClaimTemplateStatus | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogTopologySpreadConstraintsLabelSelectorMatchExpressions
 */
export interface TenantSpecLogTopologySpreadConstraintsLabelSelectorMatchExpressions {
    /**
     * @schema TenantSpecLogTopologySpreadConstraintsLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecLogTopologySpreadConstraintsLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecLogTopologySpreadConstraintsLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecLogTopologySpreadConstraintsLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecLogTopologySpreadConstraintsLabelSelectorMatchExpressions(obj: TenantSpecLogTopologySpreadConstraintsLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution#preference
     */
    readonly preference: TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference;
    /**
     * @schema TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
     */
    readonly weight: number;
}
/**
 * Converts an object of type 'TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution(obj: TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution#nodeSelectorTerms
     */
    readonly nodeSelectorTerms: TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms[];
}
/**
 * Converts an object of type 'TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution(obj: TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution#podAffinityTerm
     */
    readonly podAffinityTerm: TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm;
    /**
     * @schema TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
     */
    readonly weight: number;
}
/**
 * Converts an object of type 'TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution(obj: TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#labelSelector
     */
    readonly labelSelector?: TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector;
    /**
     * @schema TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution(obj: TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution#podAffinityTerm
     */
    readonly podAffinityTerm: TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm;
    /**
     * @schema TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
     */
    readonly weight: number;
}
/**
 * Converts an object of type 'TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution(obj: TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#labelSelector
     */
    readonly labelSelector?: TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector;
    /**
     * @schema TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution(obj: TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusTopologySpreadConstraintsLabelSelectorMatchExpressions
 */
export interface TenantSpecPrometheusTopologySpreadConstraintsLabelSelectorMatchExpressions {
    /**
     * @schema TenantSpecPrometheusTopologySpreadConstraintsLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecPrometheusTopologySpreadConstraintsLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecPrometheusTopologySpreadConstraintsLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecPrometheusTopologySpreadConstraintsLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusTopologySpreadConstraintsLabelSelectorMatchExpressions(obj: TenantSpecPrometheusTopologySpreadConstraintsLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersEnvValueFrom
 */
export interface TenantSpecSideCarsContainersEnvValueFrom {
    /**
     * @schema TenantSpecSideCarsContainersEnvValueFrom#configMapKeyRef
     */
    readonly configMapKeyRef?: TenantSpecSideCarsContainersEnvValueFromConfigMapKeyRef;
    /**
     * @schema TenantSpecSideCarsContainersEnvValueFrom#fieldRef
     */
    readonly fieldRef?: TenantSpecSideCarsContainersEnvValueFromFieldRef;
    /**
     * @schema TenantSpecSideCarsContainersEnvValueFrom#resourceFieldRef
     */
    readonly resourceFieldRef?: TenantSpecSideCarsContainersEnvValueFromResourceFieldRef;
    /**
     * @schema TenantSpecSideCarsContainersEnvValueFrom#secretKeyRef
     */
    readonly secretKeyRef?: TenantSpecSideCarsContainersEnvValueFromSecretKeyRef;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersEnvValueFrom' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersEnvValueFrom(obj: TenantSpecSideCarsContainersEnvValueFrom | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersEnvFromConfigMapRef
 */
export interface TenantSpecSideCarsContainersEnvFromConfigMapRef {
    /**
     * @schema TenantSpecSideCarsContainersEnvFromConfigMapRef#name
     */
    readonly name?: string;
    /**
     * @schema TenantSpecSideCarsContainersEnvFromConfigMapRef#optional
     */
    readonly optional?: boolean;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersEnvFromConfigMapRef' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersEnvFromConfigMapRef(obj: TenantSpecSideCarsContainersEnvFromConfigMapRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersEnvFromSecretRef
 */
export interface TenantSpecSideCarsContainersEnvFromSecretRef {
    /**
     * @schema TenantSpecSideCarsContainersEnvFromSecretRef#name
     */
    readonly name?: string;
    /**
     * @schema TenantSpecSideCarsContainersEnvFromSecretRef#optional
     */
    readonly optional?: boolean;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersEnvFromSecretRef' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersEnvFromSecretRef(obj: TenantSpecSideCarsContainersEnvFromSecretRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersLifecyclePostStart
 */
export interface TenantSpecSideCarsContainersLifecyclePostStart {
    /**
     * @schema TenantSpecSideCarsContainersLifecyclePostStart#exec
     */
    readonly exec?: TenantSpecSideCarsContainersLifecyclePostStartExec;
    /**
     * @schema TenantSpecSideCarsContainersLifecyclePostStart#httpGet
     */
    readonly httpGet?: TenantSpecSideCarsContainersLifecyclePostStartHttpGet;
    /**
     * @schema TenantSpecSideCarsContainersLifecyclePostStart#tcpSocket
     */
    readonly tcpSocket?: TenantSpecSideCarsContainersLifecyclePostStartTcpSocket;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersLifecyclePostStart' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersLifecyclePostStart(obj: TenantSpecSideCarsContainersLifecyclePostStart | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersLifecyclePreStop
 */
export interface TenantSpecSideCarsContainersLifecyclePreStop {
    /**
     * @schema TenantSpecSideCarsContainersLifecyclePreStop#exec
     */
    readonly exec?: TenantSpecSideCarsContainersLifecyclePreStopExec;
    /**
     * @schema TenantSpecSideCarsContainersLifecyclePreStop#httpGet
     */
    readonly httpGet?: TenantSpecSideCarsContainersLifecyclePreStopHttpGet;
    /**
     * @schema TenantSpecSideCarsContainersLifecyclePreStop#tcpSocket
     */
    readonly tcpSocket?: TenantSpecSideCarsContainersLifecyclePreStopTcpSocket;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersLifecyclePreStop' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersLifecyclePreStop(obj: TenantSpecSideCarsContainersLifecyclePreStop | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersLivenessProbeExec
 */
export interface TenantSpecSideCarsContainersLivenessProbeExec {
    /**
     * @schema TenantSpecSideCarsContainersLivenessProbeExec#command
     */
    readonly command?: string[];
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersLivenessProbeExec' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersLivenessProbeExec(obj: TenantSpecSideCarsContainersLivenessProbeExec | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersLivenessProbeHttpGet
 */
export interface TenantSpecSideCarsContainersLivenessProbeHttpGet {
    /**
     * @schema TenantSpecSideCarsContainersLivenessProbeHttpGet#host
     */
    readonly host?: string;
    /**
     * @schema TenantSpecSideCarsContainersLivenessProbeHttpGet#httpHeaders
     */
    readonly httpHeaders?: TenantSpecSideCarsContainersLivenessProbeHttpGetHttpHeaders[];
    /**
     * @schema TenantSpecSideCarsContainersLivenessProbeHttpGet#path
     */
    readonly path?: string;
    /**
     * @schema TenantSpecSideCarsContainersLivenessProbeHttpGet#port
     */
    readonly port: TenantSpecSideCarsContainersLivenessProbeHttpGetPort;
    /**
     * @schema TenantSpecSideCarsContainersLivenessProbeHttpGet#scheme
     */
    readonly scheme?: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersLivenessProbeHttpGet' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersLivenessProbeHttpGet(obj: TenantSpecSideCarsContainersLivenessProbeHttpGet | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersLivenessProbeTcpSocket
 */
export interface TenantSpecSideCarsContainersLivenessProbeTcpSocket {
    /**
     * @schema TenantSpecSideCarsContainersLivenessProbeTcpSocket#host
     */
    readonly host?: string;
    /**
     * @schema TenantSpecSideCarsContainersLivenessProbeTcpSocket#port
     */
    readonly port: TenantSpecSideCarsContainersLivenessProbeTcpSocketPort;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersLivenessProbeTcpSocket' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersLivenessProbeTcpSocket(obj: TenantSpecSideCarsContainersLivenessProbeTcpSocket | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersReadinessProbeExec
 */
export interface TenantSpecSideCarsContainersReadinessProbeExec {
    /**
     * @schema TenantSpecSideCarsContainersReadinessProbeExec#command
     */
    readonly command?: string[];
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersReadinessProbeExec' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersReadinessProbeExec(obj: TenantSpecSideCarsContainersReadinessProbeExec | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersReadinessProbeHttpGet
 */
export interface TenantSpecSideCarsContainersReadinessProbeHttpGet {
    /**
     * @schema TenantSpecSideCarsContainersReadinessProbeHttpGet#host
     */
    readonly host?: string;
    /**
     * @schema TenantSpecSideCarsContainersReadinessProbeHttpGet#httpHeaders
     */
    readonly httpHeaders?: TenantSpecSideCarsContainersReadinessProbeHttpGetHttpHeaders[];
    /**
     * @schema TenantSpecSideCarsContainersReadinessProbeHttpGet#path
     */
    readonly path?: string;
    /**
     * @schema TenantSpecSideCarsContainersReadinessProbeHttpGet#port
     */
    readonly port: TenantSpecSideCarsContainersReadinessProbeHttpGetPort;
    /**
     * @schema TenantSpecSideCarsContainersReadinessProbeHttpGet#scheme
     */
    readonly scheme?: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersReadinessProbeHttpGet' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersReadinessProbeHttpGet(obj: TenantSpecSideCarsContainersReadinessProbeHttpGet | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersReadinessProbeTcpSocket
 */
export interface TenantSpecSideCarsContainersReadinessProbeTcpSocket {
    /**
     * @schema TenantSpecSideCarsContainersReadinessProbeTcpSocket#host
     */
    readonly host?: string;
    /**
     * @schema TenantSpecSideCarsContainersReadinessProbeTcpSocket#port
     */
    readonly port: TenantSpecSideCarsContainersReadinessProbeTcpSocketPort;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersReadinessProbeTcpSocket' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersReadinessProbeTcpSocket(obj: TenantSpecSideCarsContainersReadinessProbeTcpSocket | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersResourcesLimits
 */
export declare class TenantSpecSideCarsContainersResourcesLimits {
    readonly value: any;
    static fromNumber(value: number): TenantSpecSideCarsContainersResourcesLimits;
    static fromString(value: string): TenantSpecSideCarsContainersResourcesLimits;
    private constructor();
}
/**
 * @schema TenantSpecSideCarsContainersResourcesRequests
 */
export declare class TenantSpecSideCarsContainersResourcesRequests {
    readonly value: any;
    static fromNumber(value: number): TenantSpecSideCarsContainersResourcesRequests;
    static fromString(value: string): TenantSpecSideCarsContainersResourcesRequests;
    private constructor();
}
/**
 * @schema TenantSpecSideCarsContainersSecurityContextCapabilities
 */
export interface TenantSpecSideCarsContainersSecurityContextCapabilities {
    /**
     * @schema TenantSpecSideCarsContainersSecurityContextCapabilities#add
     */
    readonly add?: string[];
    /**
     * @schema TenantSpecSideCarsContainersSecurityContextCapabilities#drop
     */
    readonly drop?: string[];
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersSecurityContextCapabilities' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersSecurityContextCapabilities(obj: TenantSpecSideCarsContainersSecurityContextCapabilities | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersSecurityContextSeLinuxOptions
 */
export interface TenantSpecSideCarsContainersSecurityContextSeLinuxOptions {
    /**
     * @schema TenantSpecSideCarsContainersSecurityContextSeLinuxOptions#level
     */
    readonly level?: string;
    /**
     * @schema TenantSpecSideCarsContainersSecurityContextSeLinuxOptions#role
     */
    readonly role?: string;
    /**
     * @schema TenantSpecSideCarsContainersSecurityContextSeLinuxOptions#type
     */
    readonly type?: string;
    /**
     * @schema TenantSpecSideCarsContainersSecurityContextSeLinuxOptions#user
     */
    readonly user?: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersSecurityContextSeLinuxOptions' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersSecurityContextSeLinuxOptions(obj: TenantSpecSideCarsContainersSecurityContextSeLinuxOptions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersSecurityContextSeccompProfile
 */
export interface TenantSpecSideCarsContainersSecurityContextSeccompProfile {
    /**
     * @schema TenantSpecSideCarsContainersSecurityContextSeccompProfile#localhostProfile
     */
    readonly localhostProfile?: string;
    /**
     * @schema TenantSpecSideCarsContainersSecurityContextSeccompProfile#type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersSecurityContextSeccompProfile' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersSecurityContextSeccompProfile(obj: TenantSpecSideCarsContainersSecurityContextSeccompProfile | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersSecurityContextWindowsOptions
 */
export interface TenantSpecSideCarsContainersSecurityContextWindowsOptions {
    /**
     * @schema TenantSpecSideCarsContainersSecurityContextWindowsOptions#gmsaCredentialSpec
     */
    readonly gmsaCredentialSpec?: string;
    /**
     * @schema TenantSpecSideCarsContainersSecurityContextWindowsOptions#gmsaCredentialSpecName
     */
    readonly gmsaCredentialSpecName?: string;
    /**
     * @schema TenantSpecSideCarsContainersSecurityContextWindowsOptions#runAsUserName
     */
    readonly runAsUserName?: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersSecurityContextWindowsOptions' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersSecurityContextWindowsOptions(obj: TenantSpecSideCarsContainersSecurityContextWindowsOptions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersStartupProbeExec
 */
export interface TenantSpecSideCarsContainersStartupProbeExec {
    /**
     * @schema TenantSpecSideCarsContainersStartupProbeExec#command
     */
    readonly command?: string[];
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersStartupProbeExec' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersStartupProbeExec(obj: TenantSpecSideCarsContainersStartupProbeExec | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersStartupProbeHttpGet
 */
export interface TenantSpecSideCarsContainersStartupProbeHttpGet {
    /**
     * @schema TenantSpecSideCarsContainersStartupProbeHttpGet#host
     */
    readonly host?: string;
    /**
     * @schema TenantSpecSideCarsContainersStartupProbeHttpGet#httpHeaders
     */
    readonly httpHeaders?: TenantSpecSideCarsContainersStartupProbeHttpGetHttpHeaders[];
    /**
     * @schema TenantSpecSideCarsContainersStartupProbeHttpGet#path
     */
    readonly path?: string;
    /**
     * @schema TenantSpecSideCarsContainersStartupProbeHttpGet#port
     */
    readonly port: TenantSpecSideCarsContainersStartupProbeHttpGetPort;
    /**
     * @schema TenantSpecSideCarsContainersStartupProbeHttpGet#scheme
     */
    readonly scheme?: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersStartupProbeHttpGet' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersStartupProbeHttpGet(obj: TenantSpecSideCarsContainersStartupProbeHttpGet | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersStartupProbeTcpSocket
 */
export interface TenantSpecSideCarsContainersStartupProbeTcpSocket {
    /**
     * @schema TenantSpecSideCarsContainersStartupProbeTcpSocket#host
     */
    readonly host?: string;
    /**
     * @schema TenantSpecSideCarsContainersStartupProbeTcpSocket#port
     */
    readonly port: TenantSpecSideCarsContainersStartupProbeTcpSocketPort;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersStartupProbeTcpSocket' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersStartupProbeTcpSocket(obj: TenantSpecSideCarsContainersStartupProbeTcpSocket | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumeClaimTemplatesSpecDataSource
 */
export interface TenantSpecSideCarsVolumeClaimTemplatesSpecDataSource {
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplatesSpecDataSource#apiGroup
     */
    readonly apiGroup?: string;
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplatesSpecDataSource#kind
     */
    readonly kind: string;
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplatesSpecDataSource#name
     */
    readonly name: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumeClaimTemplatesSpecDataSource' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumeClaimTemplatesSpecDataSource(obj: TenantSpecSideCarsVolumeClaimTemplatesSpecDataSource | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumeClaimTemplatesSpecResources
 */
export interface TenantSpecSideCarsVolumeClaimTemplatesSpecResources {
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplatesSpecResources#limits
     */
    readonly limits?: {
        [key: string]: TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesLimits;
    };
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplatesSpecResources#requests
     */
    readonly requests?: {
        [key: string]: TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesRequests;
    };
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumeClaimTemplatesSpecResources' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumeClaimTemplatesSpecResources(obj: TenantSpecSideCarsVolumeClaimTemplatesSpecResources | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumeClaimTemplatesSpecSelector
 */
export interface TenantSpecSideCarsVolumeClaimTemplatesSpecSelector {
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplatesSpecSelector#matchExpressions
     */
    readonly matchExpressions?: TenantSpecSideCarsVolumeClaimTemplatesSpecSelectorMatchExpressions[];
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplatesSpecSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumeClaimTemplatesSpecSelector' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumeClaimTemplatesSpecSelector(obj: TenantSpecSideCarsVolumeClaimTemplatesSpecSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumeClaimTemplatesStatusCapacity
 */
export declare class TenantSpecSideCarsVolumeClaimTemplatesStatusCapacity {
    readonly value: any;
    static fromNumber(value: number): TenantSpecSideCarsVolumeClaimTemplatesStatusCapacity;
    static fromString(value: string): TenantSpecSideCarsVolumeClaimTemplatesStatusCapacity;
    private constructor();
}
/**
 * @schema TenantSpecSideCarsVolumeClaimTemplatesStatusConditions
 */
export interface TenantSpecSideCarsVolumeClaimTemplatesStatusConditions {
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplatesStatusConditions#lastProbeTime
     */
    readonly lastProbeTime?: Date;
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplatesStatusConditions#lastTransitionTime
     */
    readonly lastTransitionTime?: Date;
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplatesStatusConditions#message
     */
    readonly message?: string;
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplatesStatusConditions#reason
     */
    readonly reason?: string;
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplatesStatusConditions#status
     */
    readonly status: string;
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplatesStatusConditions#type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumeClaimTemplatesStatusConditions' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumeClaimTemplatesStatusConditions(obj: TenantSpecSideCarsVolumeClaimTemplatesStatusConditions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesCephfsSecretRef
 */
export interface TenantSpecSideCarsVolumesCephfsSecretRef {
    /**
     * @schema TenantSpecSideCarsVolumesCephfsSecretRef#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesCephfsSecretRef' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesCephfsSecretRef(obj: TenantSpecSideCarsVolumesCephfsSecretRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesCinderSecretRef
 */
export interface TenantSpecSideCarsVolumesCinderSecretRef {
    /**
     * @schema TenantSpecSideCarsVolumesCinderSecretRef#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesCinderSecretRef' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesCinderSecretRef(obj: TenantSpecSideCarsVolumesCinderSecretRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesConfigMapItems
 */
export interface TenantSpecSideCarsVolumesConfigMapItems {
    /**
     * @schema TenantSpecSideCarsVolumesConfigMapItems#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecSideCarsVolumesConfigMapItems#mode
     */
    readonly mode?: number;
    /**
     * @schema TenantSpecSideCarsVolumesConfigMapItems#path
     */
    readonly path: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesConfigMapItems' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesConfigMapItems(obj: TenantSpecSideCarsVolumesConfigMapItems | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesCsiNodePublishSecretRef
 */
export interface TenantSpecSideCarsVolumesCsiNodePublishSecretRef {
    /**
     * @schema TenantSpecSideCarsVolumesCsiNodePublishSecretRef#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesCsiNodePublishSecretRef' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesCsiNodePublishSecretRef(obj: TenantSpecSideCarsVolumesCsiNodePublishSecretRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesDownwardApiItems
 */
export interface TenantSpecSideCarsVolumesDownwardApiItems {
    /**
     * @schema TenantSpecSideCarsVolumesDownwardApiItems#fieldRef
     */
    readonly fieldRef?: TenantSpecSideCarsVolumesDownwardApiItemsFieldRef;
    /**
     * @schema TenantSpecSideCarsVolumesDownwardApiItems#mode
     */
    readonly mode?: number;
    /**
     * @schema TenantSpecSideCarsVolumesDownwardApiItems#path
     */
    readonly path: string;
    /**
     * @schema TenantSpecSideCarsVolumesDownwardApiItems#resourceFieldRef
     */
    readonly resourceFieldRef?: TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRef;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesDownwardApiItems' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesDownwardApiItems(obj: TenantSpecSideCarsVolumesDownwardApiItems | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesEmptyDirSizeLimit
 */
export declare class TenantSpecSideCarsVolumesEmptyDirSizeLimit {
    readonly value: any;
    static fromNumber(value: number): TenantSpecSideCarsVolumesEmptyDirSizeLimit;
    static fromString(value: string): TenantSpecSideCarsVolumesEmptyDirSizeLimit;
    private constructor();
}
/**
 * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplate
 */
export interface TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplate {
    /**
     * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplate#metadata
     */
    readonly metadata?: TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateMetadata;
    /**
     * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplate#spec
     */
    readonly spec: TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpec;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplate' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplate(obj: TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplate | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesFlexVolumeSecretRef
 */
export interface TenantSpecSideCarsVolumesFlexVolumeSecretRef {
    /**
     * @schema TenantSpecSideCarsVolumesFlexVolumeSecretRef#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesFlexVolumeSecretRef' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesFlexVolumeSecretRef(obj: TenantSpecSideCarsVolumesFlexVolumeSecretRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesIscsiSecretRef
 */
export interface TenantSpecSideCarsVolumesIscsiSecretRef {
    /**
     * @schema TenantSpecSideCarsVolumesIscsiSecretRef#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesIscsiSecretRef' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesIscsiSecretRef(obj: TenantSpecSideCarsVolumesIscsiSecretRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesProjectedSources
 */
export interface TenantSpecSideCarsVolumesProjectedSources {
    /**
     * @schema TenantSpecSideCarsVolumesProjectedSources#configMap
     */
    readonly configMap?: TenantSpecSideCarsVolumesProjectedSourcesConfigMap;
    /**
     * @schema TenantSpecSideCarsVolumesProjectedSources#downwardAPI
     */
    readonly downwardApi?: TenantSpecSideCarsVolumesProjectedSourcesDownwardApi;
    /**
     * @schema TenantSpecSideCarsVolumesProjectedSources#secret
     */
    readonly secret?: TenantSpecSideCarsVolumesProjectedSourcesSecret;
    /**
     * @schema TenantSpecSideCarsVolumesProjectedSources#serviceAccountToken
     */
    readonly serviceAccountToken?: TenantSpecSideCarsVolumesProjectedSourcesServiceAccountToken;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesProjectedSources' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesProjectedSources(obj: TenantSpecSideCarsVolumesProjectedSources | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesRbdSecretRef
 */
export interface TenantSpecSideCarsVolumesRbdSecretRef {
    /**
     * @schema TenantSpecSideCarsVolumesRbdSecretRef#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesRbdSecretRef' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesRbdSecretRef(obj: TenantSpecSideCarsVolumesRbdSecretRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesScaleIoSecretRef
 */
export interface TenantSpecSideCarsVolumesScaleIoSecretRef {
    /**
     * @schema TenantSpecSideCarsVolumesScaleIoSecretRef#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesScaleIoSecretRef' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesScaleIoSecretRef(obj: TenantSpecSideCarsVolumesScaleIoSecretRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesSecretItems
 */
export interface TenantSpecSideCarsVolumesSecretItems {
    /**
     * @schema TenantSpecSideCarsVolumesSecretItems#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecSideCarsVolumesSecretItems#mode
     */
    readonly mode?: number;
    /**
     * @schema TenantSpecSideCarsVolumesSecretItems#path
     */
    readonly path: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesSecretItems' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesSecretItems(obj: TenantSpecSideCarsVolumesSecretItems | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesStorageosSecretRef
 */
export interface TenantSpecSideCarsVolumesStorageosSecretRef {
    /**
     * @schema TenantSpecSideCarsVolumesStorageosSecretRef#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesStorageosSecretRef' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesStorageosSecretRef(obj: TenantSpecSideCarsVolumesStorageosSecretRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution#preference
     */
    readonly preference: TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference;
    /**
     * @schema TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
     */
    readonly weight: number;
}
/**
 * Converts an object of type 'TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution(obj: TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution#nodeSelectorTerms
     */
    readonly nodeSelectorTerms: TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms[];
}
/**
 * Converts an object of type 'TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution(obj: TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution#podAffinityTerm
     */
    readonly podAffinityTerm: TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm;
    /**
     * @schema TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
     */
    readonly weight: number;
}
/**
 * Converts an object of type 'TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution(obj: TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantSpecZonesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantSpecZonesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#labelSelector
     */
    readonly labelSelector?: TenantSpecZonesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector;
    /**
     * @schema TenantSpecZonesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantSpecZonesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantSpecZonesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantSpecZonesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution(obj: TenantSpecZonesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution#podAffinityTerm
     */
    readonly podAffinityTerm: TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm;
    /**
     * @schema TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
     */
    readonly weight: number;
}
/**
 * Converts an object of type 'TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution(obj: TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantSpecZonesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantSpecZonesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#labelSelector
     */
    readonly labelSelector?: TenantSpecZonesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector;
    /**
     * @schema TenantSpecZonesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantSpecZonesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantSpecZonesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantSpecZonesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution(obj: TenantSpecZonesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesTopologySpreadConstraintsLabelSelectorMatchExpressions
 */
export interface TenantSpecZonesTopologySpreadConstraintsLabelSelectorMatchExpressions {
    /**
     * @schema TenantSpecZonesTopologySpreadConstraintsLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecZonesTopologySpreadConstraintsLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecZonesTopologySpreadConstraintsLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecZonesTopologySpreadConstraintsLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecZonesTopologySpreadConstraintsLabelSelectorMatchExpressions(obj: TenantSpecZonesTopologySpreadConstraintsLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesVolumeClaimTemplateSpecDataSource
 */
export interface TenantSpecZonesVolumeClaimTemplateSpecDataSource {
    /**
     * @schema TenantSpecZonesVolumeClaimTemplateSpecDataSource#apiGroup
     */
    readonly apiGroup?: string;
    /**
     * @schema TenantSpecZonesVolumeClaimTemplateSpecDataSource#kind
     */
    readonly kind: string;
    /**
     * @schema TenantSpecZonesVolumeClaimTemplateSpecDataSource#name
     */
    readonly name: string;
}
/**
 * Converts an object of type 'TenantSpecZonesVolumeClaimTemplateSpecDataSource' to JSON representation.
 */
export declare function toJson_TenantSpecZonesVolumeClaimTemplateSpecDataSource(obj: TenantSpecZonesVolumeClaimTemplateSpecDataSource | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesVolumeClaimTemplateSpecResources
 */
export interface TenantSpecZonesVolumeClaimTemplateSpecResources {
    /**
     * @schema TenantSpecZonesVolumeClaimTemplateSpecResources#limits
     */
    readonly limits?: {
        [key: string]: TenantSpecZonesVolumeClaimTemplateSpecResourcesLimits;
    };
    /**
     * @schema TenantSpecZonesVolumeClaimTemplateSpecResources#requests
     */
    readonly requests?: {
        [key: string]: TenantSpecZonesVolumeClaimTemplateSpecResourcesRequests;
    };
}
/**
 * Converts an object of type 'TenantSpecZonesVolumeClaimTemplateSpecResources' to JSON representation.
 */
export declare function toJson_TenantSpecZonesVolumeClaimTemplateSpecResources(obj: TenantSpecZonesVolumeClaimTemplateSpecResources | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesVolumeClaimTemplateSpecSelector
 */
export interface TenantSpecZonesVolumeClaimTemplateSpecSelector {
    /**
     * @schema TenantSpecZonesVolumeClaimTemplateSpecSelector#matchExpressions
     */
    readonly matchExpressions?: TenantSpecZonesVolumeClaimTemplateSpecSelectorMatchExpressions[];
    /**
     * @schema TenantSpecZonesVolumeClaimTemplateSpecSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantSpecZonesVolumeClaimTemplateSpecSelector' to JSON representation.
 */
export declare function toJson_TenantSpecZonesVolumeClaimTemplateSpecSelector(obj: TenantSpecZonesVolumeClaimTemplateSpecSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesVolumeClaimTemplateStatusCapacity
 */
export declare class TenantSpecZonesVolumeClaimTemplateStatusCapacity {
    readonly value: any;
    static fromNumber(value: number): TenantSpecZonesVolumeClaimTemplateStatusCapacity;
    static fromString(value: string): TenantSpecZonesVolumeClaimTemplateStatusCapacity;
    private constructor();
}
/**
 * @schema TenantSpecZonesVolumeClaimTemplateStatusConditions
 */
export interface TenantSpecZonesVolumeClaimTemplateStatusConditions {
    /**
     * @schema TenantSpecZonesVolumeClaimTemplateStatusConditions#lastProbeTime
     */
    readonly lastProbeTime?: Date;
    /**
     * @schema TenantSpecZonesVolumeClaimTemplateStatusConditions#lastTransitionTime
     */
    readonly lastTransitionTime?: Date;
    /**
     * @schema TenantSpecZonesVolumeClaimTemplateStatusConditions#message
     */
    readonly message?: string;
    /**
     * @schema TenantSpecZonesVolumeClaimTemplateStatusConditions#reason
     */
    readonly reason?: string;
    /**
     * @schema TenantSpecZonesVolumeClaimTemplateStatusConditions#status
     */
    readonly status: string;
    /**
     * @schema TenantSpecZonesVolumeClaimTemplateStatusConditions#type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'TenantSpecZonesVolumeClaimTemplateStatusConditions' to JSON representation.
 */
export declare function toJson_TenantSpecZonesVolumeClaimTemplateStatusConditions(obj: TenantSpecZonesVolumeClaimTemplateStatusConditions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference
 */
export interface TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference {
    /**
     * @schema TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference#matchExpressions
     */
    readonly matchExpressions?: TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions[];
    /**
     * @schema TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference#matchFields
     */
    readonly matchFields?: TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields[];
}
/**
 * Converts an object of type 'TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference' to JSON representation.
 */
export declare function toJson_TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference(obj: TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms
 */
export interface TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms {
    /**
     * @schema TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms#matchExpressions
     */
    readonly matchExpressions?: TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions[];
    /**
     * @schema TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms#matchFields
     */
    readonly matchFields?: TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields[];
}
/**
 * Converts an object of type 'TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms' to JSON representation.
 */
export declare function toJson_TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms(obj: TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm
 */
export interface TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm {
    /**
     * @schema TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#labelSelector
     */
    readonly labelSelector?: TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector;
    /**
     * @schema TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm' to JSON representation.
 */
export declare function toJson_TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(obj: TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector
 */
export interface TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector {
    /**
     * @schema TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[];
    /**
     * @schema TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector' to JSON representation.
 */
export declare function toJson_TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(obj: TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm
 */
export interface TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm {
    /**
     * @schema TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#labelSelector
     */
    readonly labelSelector?: TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector;
    /**
     * @schema TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm' to JSON representation.
 */
export declare function toJson_TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(obj: TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector
 */
export interface TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector {
    /**
     * @schema TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[];
    /**
     * @schema TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector' to JSON representation.
 */
export declare function toJson_TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(obj: TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference
 */
export interface TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference {
    /**
     * @schema TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference#matchExpressions
     */
    readonly matchExpressions?: TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions[];
    /**
     * @schema TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference#matchFields
     */
    readonly matchFields?: TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields[];
}
/**
 * Converts an object of type 'TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference' to JSON representation.
 */
export declare function toJson_TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference(obj: TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms
 */
export interface TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms {
    /**
     * @schema TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms#matchExpressions
     */
    readonly matchExpressions?: TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions[];
    /**
     * @schema TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms#matchFields
     */
    readonly matchFields?: TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields[];
}
/**
 * Converts an object of type 'TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms' to JSON representation.
 */
export declare function toJson_TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms(obj: TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm
 */
export interface TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm {
    /**
     * @schema TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#labelSelector
     */
    readonly labelSelector?: TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector;
    /**
     * @schema TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm' to JSON representation.
 */
export declare function toJson_TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(obj: TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector
 */
export interface TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector {
    /**
     * @schema TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[];
    /**
     * @schema TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector' to JSON representation.
 */
export declare function toJson_TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(obj: TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm
 */
export interface TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm {
    /**
     * @schema TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#labelSelector
     */
    readonly labelSelector?: TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector;
    /**
     * @schema TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm' to JSON representation.
 */
export declare function toJson_TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(obj: TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector
 */
export interface TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector {
    /**
     * @schema TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[];
    /**
     * @schema TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector' to JSON representation.
 */
export declare function toJson_TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(obj: TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution#preference
     */
    readonly preference: TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference;
    /**
     * @schema TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
     */
    readonly weight: number;
}
/**
 * Converts an object of type 'TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution(obj: TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution#nodeSelectorTerms
     */
    readonly nodeSelectorTerms: TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms[];
}
/**
 * Converts an object of type 'TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution(obj: TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution#podAffinityTerm
     */
    readonly podAffinityTerm: TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm;
    /**
     * @schema TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
     */
    readonly weight: number;
}
/**
 * Converts an object of type 'TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution(obj: TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#labelSelector
     */
    readonly labelSelector?: TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector;
    /**
     * @schema TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution(obj: TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution#podAffinityTerm
     */
    readonly podAffinityTerm: TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm;
    /**
     * @schema TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
     */
    readonly weight: number;
}
/**
 * Converts an object of type 'TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution(obj: TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#labelSelector
     */
    readonly labelSelector?: TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector;
    /**
     * @schema TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution(obj: TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbTopologySpreadConstraintsLabelSelectorMatchExpressions
 */
export interface TenantSpecLogDbTopologySpreadConstraintsLabelSelectorMatchExpressions {
    /**
     * @schema TenantSpecLogDbTopologySpreadConstraintsLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecLogDbTopologySpreadConstraintsLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecLogDbTopologySpreadConstraintsLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecLogDbTopologySpreadConstraintsLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbTopologySpreadConstraintsLabelSelectorMatchExpressions(obj: TenantSpecLogDbTopologySpreadConstraintsLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbVolumeClaimTemplateSpecDataSource
 */
export interface TenantSpecLogDbVolumeClaimTemplateSpecDataSource {
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplateSpecDataSource#apiGroup
     */
    readonly apiGroup?: string;
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplateSpecDataSource#kind
     */
    readonly kind: string;
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplateSpecDataSource#name
     */
    readonly name: string;
}
/**
 * Converts an object of type 'TenantSpecLogDbVolumeClaimTemplateSpecDataSource' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbVolumeClaimTemplateSpecDataSource(obj: TenantSpecLogDbVolumeClaimTemplateSpecDataSource | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbVolumeClaimTemplateSpecResources
 */
export interface TenantSpecLogDbVolumeClaimTemplateSpecResources {
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplateSpecResources#limits
     */
    readonly limits?: {
        [key: string]: TenantSpecLogDbVolumeClaimTemplateSpecResourcesLimits;
    };
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplateSpecResources#requests
     */
    readonly requests?: {
        [key: string]: TenantSpecLogDbVolumeClaimTemplateSpecResourcesRequests;
    };
}
/**
 * Converts an object of type 'TenantSpecLogDbVolumeClaimTemplateSpecResources' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbVolumeClaimTemplateSpecResources(obj: TenantSpecLogDbVolumeClaimTemplateSpecResources | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbVolumeClaimTemplateSpecSelector
 */
export interface TenantSpecLogDbVolumeClaimTemplateSpecSelector {
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplateSpecSelector#matchExpressions
     */
    readonly matchExpressions?: TenantSpecLogDbVolumeClaimTemplateSpecSelectorMatchExpressions[];
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplateSpecSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantSpecLogDbVolumeClaimTemplateSpecSelector' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbVolumeClaimTemplateSpecSelector(obj: TenantSpecLogDbVolumeClaimTemplateSpecSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbVolumeClaimTemplateStatusCapacity
 */
export declare class TenantSpecLogDbVolumeClaimTemplateStatusCapacity {
    readonly value: any;
    static fromNumber(value: number): TenantSpecLogDbVolumeClaimTemplateStatusCapacity;
    static fromString(value: string): TenantSpecLogDbVolumeClaimTemplateStatusCapacity;
    private constructor();
}
/**
 * @schema TenantSpecLogDbVolumeClaimTemplateStatusConditions
 */
export interface TenantSpecLogDbVolumeClaimTemplateStatusConditions {
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplateStatusConditions#lastProbeTime
     */
    readonly lastProbeTime?: Date;
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplateStatusConditions#lastTransitionTime
     */
    readonly lastTransitionTime?: Date;
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplateStatusConditions#message
     */
    readonly message?: string;
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplateStatusConditions#reason
     */
    readonly reason?: string;
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplateStatusConditions#status
     */
    readonly status: string;
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplateStatusConditions#type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'TenantSpecLogDbVolumeClaimTemplateStatusConditions' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbVolumeClaimTemplateStatusConditions(obj: TenantSpecLogDbVolumeClaimTemplateStatusConditions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference
 */
export interface TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference {
    /**
     * @schema TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference#matchExpressions
     */
    readonly matchExpressions?: TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions[];
    /**
     * @schema TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference#matchFields
     */
    readonly matchFields?: TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields[];
}
/**
 * Converts an object of type 'TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference(obj: TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms
 */
export interface TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms {
    /**
     * @schema TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms#matchExpressions
     */
    readonly matchExpressions?: TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions[];
    /**
     * @schema TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms#matchFields
     */
    readonly matchFields?: TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields[];
}
/**
 * Converts an object of type 'TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms(obj: TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm
 */
export interface TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm {
    /**
     * @schema TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#labelSelector
     */
    readonly labelSelector?: TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector;
    /**
     * @schema TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(obj: TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector
 */
export interface TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector {
    /**
     * @schema TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[];
    /**
     * @schema TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(obj: TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm
 */
export interface TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm {
    /**
     * @schema TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#labelSelector
     */
    readonly labelSelector?: TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector;
    /**
     * @schema TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(obj: TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector
 */
export interface TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector {
    /**
     * @schema TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[];
    /**
     * @schema TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(obj: TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersEnvValueFromConfigMapKeyRef
 */
export interface TenantSpecSideCarsContainersEnvValueFromConfigMapKeyRef {
    /**
     * @schema TenantSpecSideCarsContainersEnvValueFromConfigMapKeyRef#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecSideCarsContainersEnvValueFromConfigMapKeyRef#name
     */
    readonly name?: string;
    /**
     * @schema TenantSpecSideCarsContainersEnvValueFromConfigMapKeyRef#optional
     */
    readonly optional?: boolean;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersEnvValueFromConfigMapKeyRef' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersEnvValueFromConfigMapKeyRef(obj: TenantSpecSideCarsContainersEnvValueFromConfigMapKeyRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersEnvValueFromFieldRef
 */
export interface TenantSpecSideCarsContainersEnvValueFromFieldRef {
    /**
     * @schema TenantSpecSideCarsContainersEnvValueFromFieldRef#apiVersion
     */
    readonly apiVersion?: string;
    /**
     * @schema TenantSpecSideCarsContainersEnvValueFromFieldRef#fieldPath
     */
    readonly fieldPath: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersEnvValueFromFieldRef' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersEnvValueFromFieldRef(obj: TenantSpecSideCarsContainersEnvValueFromFieldRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersEnvValueFromResourceFieldRef
 */
export interface TenantSpecSideCarsContainersEnvValueFromResourceFieldRef {
    /**
     * @schema TenantSpecSideCarsContainersEnvValueFromResourceFieldRef#containerName
     */
    readonly containerName?: string;
    /**
     * @schema TenantSpecSideCarsContainersEnvValueFromResourceFieldRef#divisor
     */
    readonly divisor?: TenantSpecSideCarsContainersEnvValueFromResourceFieldRefDivisor;
    /**
     * @schema TenantSpecSideCarsContainersEnvValueFromResourceFieldRef#resource
     */
    readonly resource: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersEnvValueFromResourceFieldRef' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersEnvValueFromResourceFieldRef(obj: TenantSpecSideCarsContainersEnvValueFromResourceFieldRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersEnvValueFromSecretKeyRef
 */
export interface TenantSpecSideCarsContainersEnvValueFromSecretKeyRef {
    /**
     * @schema TenantSpecSideCarsContainersEnvValueFromSecretKeyRef#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecSideCarsContainersEnvValueFromSecretKeyRef#name
     */
    readonly name?: string;
    /**
     * @schema TenantSpecSideCarsContainersEnvValueFromSecretKeyRef#optional
     */
    readonly optional?: boolean;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersEnvValueFromSecretKeyRef' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersEnvValueFromSecretKeyRef(obj: TenantSpecSideCarsContainersEnvValueFromSecretKeyRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersLifecyclePostStartExec
 */
export interface TenantSpecSideCarsContainersLifecyclePostStartExec {
    /**
     * @schema TenantSpecSideCarsContainersLifecyclePostStartExec#command
     */
    readonly command?: string[];
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersLifecyclePostStartExec' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersLifecyclePostStartExec(obj: TenantSpecSideCarsContainersLifecyclePostStartExec | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersLifecyclePostStartHttpGet
 */
export interface TenantSpecSideCarsContainersLifecyclePostStartHttpGet {
    /**
     * @schema TenantSpecSideCarsContainersLifecyclePostStartHttpGet#host
     */
    readonly host?: string;
    /**
     * @schema TenantSpecSideCarsContainersLifecyclePostStartHttpGet#httpHeaders
     */
    readonly httpHeaders?: TenantSpecSideCarsContainersLifecyclePostStartHttpGetHttpHeaders[];
    /**
     * @schema TenantSpecSideCarsContainersLifecyclePostStartHttpGet#path
     */
    readonly path?: string;
    /**
     * @schema TenantSpecSideCarsContainersLifecyclePostStartHttpGet#port
     */
    readonly port: TenantSpecSideCarsContainersLifecyclePostStartHttpGetPort;
    /**
     * @schema TenantSpecSideCarsContainersLifecyclePostStartHttpGet#scheme
     */
    readonly scheme?: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersLifecyclePostStartHttpGet' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersLifecyclePostStartHttpGet(obj: TenantSpecSideCarsContainersLifecyclePostStartHttpGet | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersLifecyclePostStartTcpSocket
 */
export interface TenantSpecSideCarsContainersLifecyclePostStartTcpSocket {
    /**
     * @schema TenantSpecSideCarsContainersLifecyclePostStartTcpSocket#host
     */
    readonly host?: string;
    /**
     * @schema TenantSpecSideCarsContainersLifecyclePostStartTcpSocket#port
     */
    readonly port: TenantSpecSideCarsContainersLifecyclePostStartTcpSocketPort;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersLifecyclePostStartTcpSocket' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersLifecyclePostStartTcpSocket(obj: TenantSpecSideCarsContainersLifecyclePostStartTcpSocket | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersLifecyclePreStopExec
 */
export interface TenantSpecSideCarsContainersLifecyclePreStopExec {
    /**
     * @schema TenantSpecSideCarsContainersLifecyclePreStopExec#command
     */
    readonly command?: string[];
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersLifecyclePreStopExec' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersLifecyclePreStopExec(obj: TenantSpecSideCarsContainersLifecyclePreStopExec | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersLifecyclePreStopHttpGet
 */
export interface TenantSpecSideCarsContainersLifecyclePreStopHttpGet {
    /**
     * @schema TenantSpecSideCarsContainersLifecyclePreStopHttpGet#host
     */
    readonly host?: string;
    /**
     * @schema TenantSpecSideCarsContainersLifecyclePreStopHttpGet#httpHeaders
     */
    readonly httpHeaders?: TenantSpecSideCarsContainersLifecyclePreStopHttpGetHttpHeaders[];
    /**
     * @schema TenantSpecSideCarsContainersLifecyclePreStopHttpGet#path
     */
    readonly path?: string;
    /**
     * @schema TenantSpecSideCarsContainersLifecyclePreStopHttpGet#port
     */
    readonly port: TenantSpecSideCarsContainersLifecyclePreStopHttpGetPort;
    /**
     * @schema TenantSpecSideCarsContainersLifecyclePreStopHttpGet#scheme
     */
    readonly scheme?: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersLifecyclePreStopHttpGet' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersLifecyclePreStopHttpGet(obj: TenantSpecSideCarsContainersLifecyclePreStopHttpGet | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersLifecyclePreStopTcpSocket
 */
export interface TenantSpecSideCarsContainersLifecyclePreStopTcpSocket {
    /**
     * @schema TenantSpecSideCarsContainersLifecyclePreStopTcpSocket#host
     */
    readonly host?: string;
    /**
     * @schema TenantSpecSideCarsContainersLifecyclePreStopTcpSocket#port
     */
    readonly port: TenantSpecSideCarsContainersLifecyclePreStopTcpSocketPort;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersLifecyclePreStopTcpSocket' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersLifecyclePreStopTcpSocket(obj: TenantSpecSideCarsContainersLifecyclePreStopTcpSocket | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersLivenessProbeHttpGetHttpHeaders
 */
export interface TenantSpecSideCarsContainersLivenessProbeHttpGetHttpHeaders {
    /**
     * @schema TenantSpecSideCarsContainersLivenessProbeHttpGetHttpHeaders#name
     */
    readonly name: string;
    /**
     * @schema TenantSpecSideCarsContainersLivenessProbeHttpGetHttpHeaders#value
     */
    readonly value: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersLivenessProbeHttpGetHttpHeaders' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersLivenessProbeHttpGetHttpHeaders(obj: TenantSpecSideCarsContainersLivenessProbeHttpGetHttpHeaders | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersLivenessProbeHttpGetPort
 */
export declare class TenantSpecSideCarsContainersLivenessProbeHttpGetPort {
    readonly value: any;
    static fromNumber(value: number): TenantSpecSideCarsContainersLivenessProbeHttpGetPort;
    static fromString(value: string): TenantSpecSideCarsContainersLivenessProbeHttpGetPort;
    private constructor();
}
/**
 * @schema TenantSpecSideCarsContainersLivenessProbeTcpSocketPort
 */
export declare class TenantSpecSideCarsContainersLivenessProbeTcpSocketPort {
    readonly value: any;
    static fromNumber(value: number): TenantSpecSideCarsContainersLivenessProbeTcpSocketPort;
    static fromString(value: string): TenantSpecSideCarsContainersLivenessProbeTcpSocketPort;
    private constructor();
}
/**
 * @schema TenantSpecSideCarsContainersReadinessProbeHttpGetHttpHeaders
 */
export interface TenantSpecSideCarsContainersReadinessProbeHttpGetHttpHeaders {
    /**
     * @schema TenantSpecSideCarsContainersReadinessProbeHttpGetHttpHeaders#name
     */
    readonly name: string;
    /**
     * @schema TenantSpecSideCarsContainersReadinessProbeHttpGetHttpHeaders#value
     */
    readonly value: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersReadinessProbeHttpGetHttpHeaders' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersReadinessProbeHttpGetHttpHeaders(obj: TenantSpecSideCarsContainersReadinessProbeHttpGetHttpHeaders | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersReadinessProbeHttpGetPort
 */
export declare class TenantSpecSideCarsContainersReadinessProbeHttpGetPort {
    readonly value: any;
    static fromNumber(value: number): TenantSpecSideCarsContainersReadinessProbeHttpGetPort;
    static fromString(value: string): TenantSpecSideCarsContainersReadinessProbeHttpGetPort;
    private constructor();
}
/**
 * @schema TenantSpecSideCarsContainersReadinessProbeTcpSocketPort
 */
export declare class TenantSpecSideCarsContainersReadinessProbeTcpSocketPort {
    readonly value: any;
    static fromNumber(value: number): TenantSpecSideCarsContainersReadinessProbeTcpSocketPort;
    static fromString(value: string): TenantSpecSideCarsContainersReadinessProbeTcpSocketPort;
    private constructor();
}
/**
 * @schema TenantSpecSideCarsContainersStartupProbeHttpGetHttpHeaders
 */
export interface TenantSpecSideCarsContainersStartupProbeHttpGetHttpHeaders {
    /**
     * @schema TenantSpecSideCarsContainersStartupProbeHttpGetHttpHeaders#name
     */
    readonly name: string;
    /**
     * @schema TenantSpecSideCarsContainersStartupProbeHttpGetHttpHeaders#value
     */
    readonly value: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersStartupProbeHttpGetHttpHeaders' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersStartupProbeHttpGetHttpHeaders(obj: TenantSpecSideCarsContainersStartupProbeHttpGetHttpHeaders | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersStartupProbeHttpGetPort
 */
export declare class TenantSpecSideCarsContainersStartupProbeHttpGetPort {
    readonly value: any;
    static fromNumber(value: number): TenantSpecSideCarsContainersStartupProbeHttpGetPort;
    static fromString(value: string): TenantSpecSideCarsContainersStartupProbeHttpGetPort;
    private constructor();
}
/**
 * @schema TenantSpecSideCarsContainersStartupProbeTcpSocketPort
 */
export declare class TenantSpecSideCarsContainersStartupProbeTcpSocketPort {
    readonly value: any;
    static fromNumber(value: number): TenantSpecSideCarsContainersStartupProbeTcpSocketPort;
    static fromString(value: string): TenantSpecSideCarsContainersStartupProbeTcpSocketPort;
    private constructor();
}
/**
 * @schema TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesLimits
 */
export declare class TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesLimits {
    readonly value: any;
    static fromNumber(value: number): TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesLimits;
    static fromString(value: string): TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesLimits;
    private constructor();
}
/**
 * @schema TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesRequests
 */
export declare class TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesRequests {
    readonly value: any;
    static fromNumber(value: number): TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesRequests;
    static fromString(value: string): TenantSpecSideCarsVolumeClaimTemplatesSpecResourcesRequests;
    private constructor();
}
/**
 * @schema TenantSpecSideCarsVolumeClaimTemplatesSpecSelectorMatchExpressions
 */
export interface TenantSpecSideCarsVolumeClaimTemplatesSpecSelectorMatchExpressions {
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplatesSpecSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplatesSpecSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecSideCarsVolumeClaimTemplatesSpecSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumeClaimTemplatesSpecSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumeClaimTemplatesSpecSelectorMatchExpressions(obj: TenantSpecSideCarsVolumeClaimTemplatesSpecSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesDownwardApiItemsFieldRef
 */
export interface TenantSpecSideCarsVolumesDownwardApiItemsFieldRef {
    /**
     * @schema TenantSpecSideCarsVolumesDownwardApiItemsFieldRef#apiVersion
     */
    readonly apiVersion?: string;
    /**
     * @schema TenantSpecSideCarsVolumesDownwardApiItemsFieldRef#fieldPath
     */
    readonly fieldPath: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesDownwardApiItemsFieldRef' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesDownwardApiItemsFieldRef(obj: TenantSpecSideCarsVolumesDownwardApiItemsFieldRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRef
 */
export interface TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRef {
    /**
     * @schema TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRef#containerName
     */
    readonly containerName?: string;
    /**
     * @schema TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRef#divisor
     */
    readonly divisor?: TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRefDivisor;
    /**
     * @schema TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRef#resource
     */
    readonly resource: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRef' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRef(obj: TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateMetadata
 */
export interface TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateMetadata {
    /**
     * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateMetadata#annotations
     */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
     * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateMetadata#finalizers
     */
    readonly finalizers?: string[];
    /**
     * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateMetadata#labels
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateMetadata#name
     */
    readonly name?: string;
    /**
     * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateMetadata#namespace
     */
    readonly namespace?: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateMetadata' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateMetadata(obj: TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateMetadata | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpec
 */
export interface TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpec {
    /**
     * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpec#accessModes
     */
    readonly accessModes?: string[];
    /**
     * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpec#dataSource
     */
    readonly dataSource?: TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecDataSource;
    /**
     * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpec#resources
     */
    readonly resources?: TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResources;
    /**
     * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpec#selector
     */
    readonly selector?: TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelector;
    /**
     * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpec#storageClassName
     */
    readonly storageClassName?: string;
    /**
     * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpec#volumeMode
     */
    readonly volumeMode?: string;
    /**
     * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpec#volumeName
     */
    readonly volumeName?: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpec' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpec(obj: TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpec | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesProjectedSourcesConfigMap
 */
export interface TenantSpecSideCarsVolumesProjectedSourcesConfigMap {
    /**
     * @schema TenantSpecSideCarsVolumesProjectedSourcesConfigMap#items
     */
    readonly items?: TenantSpecSideCarsVolumesProjectedSourcesConfigMapItems[];
    /**
     * @schema TenantSpecSideCarsVolumesProjectedSourcesConfigMap#name
     */
    readonly name?: string;
    /**
     * @schema TenantSpecSideCarsVolumesProjectedSourcesConfigMap#optional
     */
    readonly optional?: boolean;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesProjectedSourcesConfigMap' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesProjectedSourcesConfigMap(obj: TenantSpecSideCarsVolumesProjectedSourcesConfigMap | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesProjectedSourcesDownwardApi
 */
export interface TenantSpecSideCarsVolumesProjectedSourcesDownwardApi {
    /**
     * @schema TenantSpecSideCarsVolumesProjectedSourcesDownwardApi#items
     */
    readonly items?: TenantSpecSideCarsVolumesProjectedSourcesDownwardApiItems[];
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesProjectedSourcesDownwardApi' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesProjectedSourcesDownwardApi(obj: TenantSpecSideCarsVolumesProjectedSourcesDownwardApi | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesProjectedSourcesSecret
 */
export interface TenantSpecSideCarsVolumesProjectedSourcesSecret {
    /**
     * @schema TenantSpecSideCarsVolumesProjectedSourcesSecret#items
     */
    readonly items?: TenantSpecSideCarsVolumesProjectedSourcesSecretItems[];
    /**
     * @schema TenantSpecSideCarsVolumesProjectedSourcesSecret#name
     */
    readonly name?: string;
    /**
     * @schema TenantSpecSideCarsVolumesProjectedSourcesSecret#optional
     */
    readonly optional?: boolean;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesProjectedSourcesSecret' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesProjectedSourcesSecret(obj: TenantSpecSideCarsVolumesProjectedSourcesSecret | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesProjectedSourcesServiceAccountToken
 */
export interface TenantSpecSideCarsVolumesProjectedSourcesServiceAccountToken {
    /**
     * @schema TenantSpecSideCarsVolumesProjectedSourcesServiceAccountToken#audience
     */
    readonly audience?: string;
    /**
     * @schema TenantSpecSideCarsVolumesProjectedSourcesServiceAccountToken#expirationSeconds
     */
    readonly expirationSeconds?: number;
    /**
     * @schema TenantSpecSideCarsVolumesProjectedSourcesServiceAccountToken#path
     */
    readonly path: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesProjectedSourcesServiceAccountToken' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesProjectedSourcesServiceAccountToken(obj: TenantSpecSideCarsVolumesProjectedSourcesServiceAccountToken | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference
 */
export interface TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference {
    /**
     * @schema TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference#matchExpressions
     */
    readonly matchExpressions?: TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions[];
    /**
     * @schema TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference#matchFields
     */
    readonly matchFields?: TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields[];
}
/**
 * Converts an object of type 'TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference' to JSON representation.
 */
export declare function toJson_TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference(obj: TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms
 */
export interface TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms {
    /**
     * @schema TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms#matchExpressions
     */
    readonly matchExpressions?: TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions[];
    /**
     * @schema TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms#matchFields
     */
    readonly matchFields?: TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields[];
}
/**
 * Converts an object of type 'TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms' to JSON representation.
 */
export declare function toJson_TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms(obj: TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm
 */
export interface TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm {
    /**
     * @schema TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#labelSelector
     */
    readonly labelSelector?: TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector;
    /**
     * @schema TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm' to JSON representation.
 */
export declare function toJson_TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(obj: TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector
 */
export interface TenantSpecZonesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector {
    /**
     * @schema TenantSpecZonesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantSpecZonesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[];
    /**
     * @schema TenantSpecZonesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantSpecZonesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector' to JSON representation.
 */
export declare function toJson_TenantSpecZonesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(obj: TenantSpecZonesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm
 */
export interface TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm {
    /**
     * @schema TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#labelSelector
     */
    readonly labelSelector?: TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector;
    /**
     * @schema TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm' to JSON representation.
 */
export declare function toJson_TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(obj: TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector
 */
export interface TenantSpecZonesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector {
    /**
     * @schema TenantSpecZonesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantSpecZonesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[];
    /**
     * @schema TenantSpecZonesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantSpecZonesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector' to JSON representation.
 */
export declare function toJson_TenantSpecZonesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(obj: TenantSpecZonesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesVolumeClaimTemplateSpecResourcesLimits
 */
export declare class TenantSpecZonesVolumeClaimTemplateSpecResourcesLimits {
    readonly value: any;
    static fromNumber(value: number): TenantSpecZonesVolumeClaimTemplateSpecResourcesLimits;
    static fromString(value: string): TenantSpecZonesVolumeClaimTemplateSpecResourcesLimits;
    private constructor();
}
/**
 * @schema TenantSpecZonesVolumeClaimTemplateSpecResourcesRequests
 */
export declare class TenantSpecZonesVolumeClaimTemplateSpecResourcesRequests {
    readonly value: any;
    static fromNumber(value: number): TenantSpecZonesVolumeClaimTemplateSpecResourcesRequests;
    static fromString(value: string): TenantSpecZonesVolumeClaimTemplateSpecResourcesRequests;
    private constructor();
}
/**
 * @schema TenantSpecZonesVolumeClaimTemplateSpecSelectorMatchExpressions
 */
export interface TenantSpecZonesVolumeClaimTemplateSpecSelectorMatchExpressions {
    /**
     * @schema TenantSpecZonesVolumeClaimTemplateSpecSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecZonesVolumeClaimTemplateSpecSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecZonesVolumeClaimTemplateSpecSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecZonesVolumeClaimTemplateSpecSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecZonesVolumeClaimTemplateSpecSelectorMatchExpressions(obj: TenantSpecZonesVolumeClaimTemplateSpecSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions
 */
export interface TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions {
    /**
     * @schema TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions(obj: TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields
 */
export interface TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields {
    /**
     * @schema TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields' to JSON representation.
 */
export declare function toJson_TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields(obj: TenantSpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions
 */
export interface TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions {
    /**
     * @schema TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions(obj: TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields
 */
export interface TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields {
    /**
     * @schema TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields' to JSON representation.
 */
export declare function toJson_TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields(obj: TenantSpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector
 */
export interface TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector {
    /**
     * @schema TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[];
    /**
     * @schema TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector' to JSON representation.
 */
export declare function toJson_TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(obj: TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions
 */
export interface TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions {
    /**
     * @schema TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions(obj: TenantSpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector
 */
export interface TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector {
    /**
     * @schema TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[];
    /**
     * @schema TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector' to JSON representation.
 */
export declare function toJson_TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(obj: TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions
 */
export interface TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions {
    /**
     * @schema TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions(obj: TenantSpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions
 */
export interface TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions {
    /**
     * @schema TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions(obj: TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields
 */
export interface TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields {
    /**
     * @schema TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields' to JSON representation.
 */
export declare function toJson_TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields(obj: TenantSpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions
 */
export interface TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions {
    /**
     * @schema TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions(obj: TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields
 */
export interface TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields {
    /**
     * @schema TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields' to JSON representation.
 */
export declare function toJson_TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields(obj: TenantSpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector
 */
export interface TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector {
    /**
     * @schema TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[];
    /**
     * @schema TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector' to JSON representation.
 */
export declare function toJson_TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(obj: TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions
 */
export interface TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions {
    /**
     * @schema TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions(obj: TenantSpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector
 */
export interface TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector {
    /**
     * @schema TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[];
    /**
     * @schema TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector' to JSON representation.
 */
export declare function toJson_TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(obj: TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions
 */
export interface TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions {
    /**
     * @schema TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions(obj: TenantSpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference
 */
export interface TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference {
    /**
     * @schema TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference#matchExpressions
     */
    readonly matchExpressions?: TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions[];
    /**
     * @schema TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference#matchFields
     */
    readonly matchFields?: TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields[];
}
/**
 * Converts an object of type 'TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference(obj: TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms
 */
export interface TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms {
    /**
     * @schema TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms#matchExpressions
     */
    readonly matchExpressions?: TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions[];
    /**
     * @schema TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms#matchFields
     */
    readonly matchFields?: TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields[];
}
/**
 * Converts an object of type 'TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms(obj: TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm
 */
export interface TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm {
    /**
     * @schema TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#labelSelector
     */
    readonly labelSelector?: TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector;
    /**
     * @schema TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(obj: TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector
 */
export interface TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector {
    /**
     * @schema TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[];
    /**
     * @schema TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(obj: TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm
 */
export interface TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm {
    /**
     * @schema TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#labelSelector
     */
    readonly labelSelector?: TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector;
    /**
     * @schema TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(obj: TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector
 */
export interface TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector {
    /**
     * @schema TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[];
    /**
     * @schema TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(obj: TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbVolumeClaimTemplateSpecResourcesLimits
 */
export declare class TenantSpecLogDbVolumeClaimTemplateSpecResourcesLimits {
    readonly value: any;
    static fromNumber(value: number): TenantSpecLogDbVolumeClaimTemplateSpecResourcesLimits;
    static fromString(value: string): TenantSpecLogDbVolumeClaimTemplateSpecResourcesLimits;
    private constructor();
}
/**
 * @schema TenantSpecLogDbVolumeClaimTemplateSpecResourcesRequests
 */
export declare class TenantSpecLogDbVolumeClaimTemplateSpecResourcesRequests {
    readonly value: any;
    static fromNumber(value: number): TenantSpecLogDbVolumeClaimTemplateSpecResourcesRequests;
    static fromString(value: string): TenantSpecLogDbVolumeClaimTemplateSpecResourcesRequests;
    private constructor();
}
/**
 * @schema TenantSpecLogDbVolumeClaimTemplateSpecSelectorMatchExpressions
 */
export interface TenantSpecLogDbVolumeClaimTemplateSpecSelectorMatchExpressions {
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplateSpecSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplateSpecSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecLogDbVolumeClaimTemplateSpecSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecLogDbVolumeClaimTemplateSpecSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbVolumeClaimTemplateSpecSelectorMatchExpressions(obj: TenantSpecLogDbVolumeClaimTemplateSpecSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions
 */
export interface TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions {
    /**
     * @schema TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions(obj: TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields
 */
export interface TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields {
    /**
     * @schema TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields(obj: TenantSpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions
 */
export interface TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions {
    /**
     * @schema TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions(obj: TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields
 */
export interface TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields {
    /**
     * @schema TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields(obj: TenantSpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector
 */
export interface TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector {
    /**
     * @schema TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[];
    /**
     * @schema TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(obj: TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions
 */
export interface TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions {
    /**
     * @schema TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions(obj: TenantSpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector
 */
export interface TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector {
    /**
     * @schema TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[];
    /**
     * @schema TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(obj: TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions
 */
export interface TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions {
    /**
     * @schema TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions(obj: TenantSpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersEnvValueFromResourceFieldRefDivisor
 */
export declare class TenantSpecSideCarsContainersEnvValueFromResourceFieldRefDivisor {
    readonly value: any;
    static fromNumber(value: number): TenantSpecSideCarsContainersEnvValueFromResourceFieldRefDivisor;
    static fromString(value: string): TenantSpecSideCarsContainersEnvValueFromResourceFieldRefDivisor;
    private constructor();
}
/**
 * @schema TenantSpecSideCarsContainersLifecyclePostStartHttpGetHttpHeaders
 */
export interface TenantSpecSideCarsContainersLifecyclePostStartHttpGetHttpHeaders {
    /**
     * @schema TenantSpecSideCarsContainersLifecyclePostStartHttpGetHttpHeaders#name
     */
    readonly name: string;
    /**
     * @schema TenantSpecSideCarsContainersLifecyclePostStartHttpGetHttpHeaders#value
     */
    readonly value: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersLifecyclePostStartHttpGetHttpHeaders' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersLifecyclePostStartHttpGetHttpHeaders(obj: TenantSpecSideCarsContainersLifecyclePostStartHttpGetHttpHeaders | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersLifecyclePostStartHttpGetPort
 */
export declare class TenantSpecSideCarsContainersLifecyclePostStartHttpGetPort {
    readonly value: any;
    static fromNumber(value: number): TenantSpecSideCarsContainersLifecyclePostStartHttpGetPort;
    static fromString(value: string): TenantSpecSideCarsContainersLifecyclePostStartHttpGetPort;
    private constructor();
}
/**
 * @schema TenantSpecSideCarsContainersLifecyclePostStartTcpSocketPort
 */
export declare class TenantSpecSideCarsContainersLifecyclePostStartTcpSocketPort {
    readonly value: any;
    static fromNumber(value: number): TenantSpecSideCarsContainersLifecyclePostStartTcpSocketPort;
    static fromString(value: string): TenantSpecSideCarsContainersLifecyclePostStartTcpSocketPort;
    private constructor();
}
/**
 * @schema TenantSpecSideCarsContainersLifecyclePreStopHttpGetHttpHeaders
 */
export interface TenantSpecSideCarsContainersLifecyclePreStopHttpGetHttpHeaders {
    /**
     * @schema TenantSpecSideCarsContainersLifecyclePreStopHttpGetHttpHeaders#name
     */
    readonly name: string;
    /**
     * @schema TenantSpecSideCarsContainersLifecyclePreStopHttpGetHttpHeaders#value
     */
    readonly value: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsContainersLifecyclePreStopHttpGetHttpHeaders' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsContainersLifecyclePreStopHttpGetHttpHeaders(obj: TenantSpecSideCarsContainersLifecyclePreStopHttpGetHttpHeaders | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsContainersLifecyclePreStopHttpGetPort
 */
export declare class TenantSpecSideCarsContainersLifecyclePreStopHttpGetPort {
    readonly value: any;
    static fromNumber(value: number): TenantSpecSideCarsContainersLifecyclePreStopHttpGetPort;
    static fromString(value: string): TenantSpecSideCarsContainersLifecyclePreStopHttpGetPort;
    private constructor();
}
/**
 * @schema TenantSpecSideCarsContainersLifecyclePreStopTcpSocketPort
 */
export declare class TenantSpecSideCarsContainersLifecyclePreStopTcpSocketPort {
    readonly value: any;
    static fromNumber(value: number): TenantSpecSideCarsContainersLifecyclePreStopTcpSocketPort;
    static fromString(value: string): TenantSpecSideCarsContainersLifecyclePreStopTcpSocketPort;
    private constructor();
}
/**
 * @schema TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRefDivisor
 */
export declare class TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRefDivisor {
    readonly value: any;
    static fromNumber(value: number): TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRefDivisor;
    static fromString(value: string): TenantSpecSideCarsVolumesDownwardApiItemsResourceFieldRefDivisor;
    private constructor();
}
/**
 * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecDataSource
 */
export interface TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecDataSource {
    /**
     * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecDataSource#apiGroup
     */
    readonly apiGroup?: string;
    /**
     * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecDataSource#kind
     */
    readonly kind: string;
    /**
     * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecDataSource#name
     */
    readonly name: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecDataSource' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecDataSource(obj: TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecDataSource | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResources
 */
export interface TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResources {
    /**
     * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResources#limits
     */
    readonly limits?: {
        [key: string]: TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResourcesLimits;
    };
    /**
     * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResources#requests
     */
    readonly requests?: {
        [key: string]: TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResourcesRequests;
    };
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResources' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResources(obj: TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResources | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelector
 */
export interface TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelector {
    /**
     * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelector#matchExpressions
     */
    readonly matchExpressions?: TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelectorMatchExpressions[];
    /**
     * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelector' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelector(obj: TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesProjectedSourcesConfigMapItems
 */
export interface TenantSpecSideCarsVolumesProjectedSourcesConfigMapItems {
    /**
     * @schema TenantSpecSideCarsVolumesProjectedSourcesConfigMapItems#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecSideCarsVolumesProjectedSourcesConfigMapItems#mode
     */
    readonly mode?: number;
    /**
     * @schema TenantSpecSideCarsVolumesProjectedSourcesConfigMapItems#path
     */
    readonly path: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesProjectedSourcesConfigMapItems' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesProjectedSourcesConfigMapItems(obj: TenantSpecSideCarsVolumesProjectedSourcesConfigMapItems | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesProjectedSourcesDownwardApiItems
 */
export interface TenantSpecSideCarsVolumesProjectedSourcesDownwardApiItems {
    /**
     * @schema TenantSpecSideCarsVolumesProjectedSourcesDownwardApiItems#fieldRef
     */
    readonly fieldRef?: TenantSpecSideCarsVolumesProjectedSourcesDownwardApiItemsFieldRef;
    /**
     * @schema TenantSpecSideCarsVolumesProjectedSourcesDownwardApiItems#mode
     */
    readonly mode?: number;
    /**
     * @schema TenantSpecSideCarsVolumesProjectedSourcesDownwardApiItems#path
     */
    readonly path: string;
    /**
     * @schema TenantSpecSideCarsVolumesProjectedSourcesDownwardApiItems#resourceFieldRef
     */
    readonly resourceFieldRef?: TenantSpecSideCarsVolumesProjectedSourcesDownwardApiItemsResourceFieldRef;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesProjectedSourcesDownwardApiItems' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesProjectedSourcesDownwardApiItems(obj: TenantSpecSideCarsVolumesProjectedSourcesDownwardApiItems | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesProjectedSourcesSecretItems
 */
export interface TenantSpecSideCarsVolumesProjectedSourcesSecretItems {
    /**
     * @schema TenantSpecSideCarsVolumesProjectedSourcesSecretItems#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecSideCarsVolumesProjectedSourcesSecretItems#mode
     */
    readonly mode?: number;
    /**
     * @schema TenantSpecSideCarsVolumesProjectedSourcesSecretItems#path
     */
    readonly path: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesProjectedSourcesSecretItems' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesProjectedSourcesSecretItems(obj: TenantSpecSideCarsVolumesProjectedSourcesSecretItems | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions
 */
export interface TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions {
    /**
     * @schema TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions(obj: TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields
 */
export interface TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields {
    /**
     * @schema TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields' to JSON representation.
 */
export declare function toJson_TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields(obj: TenantSpecZonesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions
 */
export interface TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions {
    /**
     * @schema TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions(obj: TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields
 */
export interface TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields {
    /**
     * @schema TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields' to JSON representation.
 */
export declare function toJson_TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields(obj: TenantSpecZonesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector
 */
export interface TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector {
    /**
     * @schema TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[];
    /**
     * @schema TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector' to JSON representation.
 */
export declare function toJson_TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(obj: TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions
 */
export interface TenantSpecZonesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions {
    /**
     * @schema TenantSpecZonesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecZonesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecZonesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecZonesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecZonesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions(obj: TenantSpecZonesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector
 */
export interface TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector {
    /**
     * @schema TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[];
    /**
     * @schema TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector' to JSON representation.
 */
export declare function toJson_TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(obj: TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions
 */
export interface TenantSpecZonesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions {
    /**
     * @schema TenantSpecZonesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecZonesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecZonesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecZonesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecZonesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions(obj: TenantSpecZonesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions
 */
export interface TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions {
    /**
     * @schema TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions(obj: TenantSpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions
 */
export interface TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions {
    /**
     * @schema TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions(obj: TenantSpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions
 */
export interface TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions {
    /**
     * @schema TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions(obj: TenantSpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions
 */
export interface TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions {
    /**
     * @schema TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions(obj: TenantSpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions
 */
export interface TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions {
    /**
     * @schema TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions(obj: TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields
 */
export interface TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields {
    /**
     * @schema TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields(obj: TenantSpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions
 */
export interface TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions {
    /**
     * @schema TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions(obj: TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields
 */
export interface TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields {
    /**
     * @schema TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields(obj: TenantSpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector
 */
export interface TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector {
    /**
     * @schema TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[];
    /**
     * @schema TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(obj: TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions
 */
export interface TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions {
    /**
     * @schema TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions(obj: TenantSpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector
 */
export interface TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector {
    /**
     * @schema TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[];
    /**
     * @schema TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(obj: TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions
 */
export interface TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions {
    /**
     * @schema TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions(obj: TenantSpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions
 */
export interface TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions {
    /**
     * @schema TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions(obj: TenantSpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions
 */
export interface TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions {
    /**
     * @schema TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions(obj: TenantSpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResourcesLimits
 */
export declare class TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResourcesLimits {
    readonly value: any;
    static fromNumber(value: number): TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResourcesLimits;
    static fromString(value: string): TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResourcesLimits;
    private constructor();
}
/**
 * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResourcesRequests
 */
export declare class TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResourcesRequests {
    readonly value: any;
    static fromNumber(value: number): TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResourcesRequests;
    static fromString(value: string): TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResourcesRequests;
    private constructor();
}
/**
 * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelectorMatchExpressions
 */
export interface TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelectorMatchExpressions {
    /**
     * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelectorMatchExpressions(obj: TenantSpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesProjectedSourcesDownwardApiItemsFieldRef
 */
export interface TenantSpecSideCarsVolumesProjectedSourcesDownwardApiItemsFieldRef {
    /**
     * @schema TenantSpecSideCarsVolumesProjectedSourcesDownwardApiItemsFieldRef#apiVersion
     */
    readonly apiVersion?: string;
    /**
     * @schema TenantSpecSideCarsVolumesProjectedSourcesDownwardApiItemsFieldRef#fieldPath
     */
    readonly fieldPath: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesProjectedSourcesDownwardApiItemsFieldRef' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesProjectedSourcesDownwardApiItemsFieldRef(obj: TenantSpecSideCarsVolumesProjectedSourcesDownwardApiItemsFieldRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesProjectedSourcesDownwardApiItemsResourceFieldRef
 */
export interface TenantSpecSideCarsVolumesProjectedSourcesDownwardApiItemsResourceFieldRef {
    /**
     * @schema TenantSpecSideCarsVolumesProjectedSourcesDownwardApiItemsResourceFieldRef#containerName
     */
    readonly containerName?: string;
    /**
     * @schema TenantSpecSideCarsVolumesProjectedSourcesDownwardApiItemsResourceFieldRef#divisor
     */
    readonly divisor?: TenantSpecSideCarsVolumesProjectedSourcesDownwardApiItemsResourceFieldRefDivisor;
    /**
     * @schema TenantSpecSideCarsVolumesProjectedSourcesDownwardApiItemsResourceFieldRef#resource
     */
    readonly resource: string;
}
/**
 * Converts an object of type 'TenantSpecSideCarsVolumesProjectedSourcesDownwardApiItemsResourceFieldRef' to JSON representation.
 */
export declare function toJson_TenantSpecSideCarsVolumesProjectedSourcesDownwardApiItemsResourceFieldRef(obj: TenantSpecSideCarsVolumesProjectedSourcesDownwardApiItemsResourceFieldRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions
 */
export interface TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions {
    /**
     * @schema TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions(obj: TenantSpecZonesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions
 */
export interface TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions {
    /**
     * @schema TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions(obj: TenantSpecZonesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions
 */
export interface TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions {
    /**
     * @schema TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions(obj: TenantSpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions
 */
export interface TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions {
    /**
     * @schema TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions(obj: TenantSpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantSpecSideCarsVolumesProjectedSourcesDownwardApiItemsResourceFieldRefDivisor
 */
export declare class TenantSpecSideCarsVolumesProjectedSourcesDownwardApiItemsResourceFieldRefDivisor {
    readonly value: any;
    static fromNumber(value: number): TenantSpecSideCarsVolumesProjectedSourcesDownwardApiItemsResourceFieldRefDivisor;
    static fromString(value: string): TenantSpecSideCarsVolumesProjectedSourcesDownwardApiItemsResourceFieldRefDivisor;
    private constructor();
}
/**
 *
 *
 * @schema TenantV2
 */
export declare class TenantV2 extends ApiObject {
    /**
     * Returns the apiVersion and kind for "TenantV2"
     */
    static readonly GVK: GroupVersionKind;
    /**
     * Renders a Kubernetes manifest for "TenantV2".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props
     */
    static manifest(props: TenantV2Props): any;
    /**
     * Defines a "TenantV2" API object
     * @param scope the scope in which to define this object
     * @param id a scope-local name for the object
     * @param props initialization props
     */
    constructor(scope: Construct, id: string, props: TenantV2Props);
    /**
     * Renders the object to Kubernetes JSON.
     */
    toJson(): any;
}
/**
 * @schema TenantV2
 */
export interface TenantV2Props {
    /**
     * @schema TenantV2#metadata
     */
    readonly metadata?: ApiObjectMetadata;
    /**
     * @schema TenantV2#scheduler
     */
    readonly scheduler?: TenantV2Scheduler;
    /**
     * @schema TenantV2#spec
     */
    readonly spec: TenantV2Spec;
}
/**
 * Converts an object of type 'TenantV2Props' to JSON representation.
 */
export declare function toJson_TenantV2Props(obj: TenantV2Props | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2Scheduler
 */
export interface TenantV2Scheduler {
    /**
     * @schema TenantV2Scheduler#name
     */
    readonly name: string;
}
/**
 * Converts an object of type 'TenantV2Scheduler' to JSON representation.
 */
export declare function toJson_TenantV2Scheduler(obj: TenantV2Scheduler | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2Spec
 */
export interface TenantV2Spec {
    /**
     * @schema TenantV2Spec#buckets
     */
    readonly buckets?: TenantV2SpecBuckets[];
    /**
     * @schema TenantV2Spec#certConfig
     */
    readonly certConfig?: TenantV2SpecCertConfig;
    /**
     * @schema TenantV2Spec#configuration
     */
    readonly configuration?: TenantV2SpecConfiguration;
    /**
     * @schema TenantV2Spec#credsSecret
     */
    readonly credsSecret?: TenantV2SpecCredsSecret;
    /**
     * @schema TenantV2Spec#env
     */
    readonly env?: TenantV2SpecEnv[];
    /**
     * @schema TenantV2Spec#exposeServices
     */
    readonly exposeServices?: TenantV2SpecExposeServices;
    /**
     * @schema TenantV2Spec#externalCaCertSecret
     */
    readonly externalCaCertSecret?: TenantV2SpecExternalCaCertSecret[];
    /**
     * @schema TenantV2Spec#externalCertSecret
     */
    readonly externalCertSecret?: TenantV2SpecExternalCertSecret[];
    /**
     * @schema TenantV2Spec#externalClientCertSecret
     */
    readonly externalClientCertSecret?: TenantV2SpecExternalClientCertSecret;
    /**
     * @schema TenantV2Spec#features
     */
    readonly features?: TenantV2SpecFeatures;
    /**
     * @schema TenantV2Spec#image
     */
    readonly image?: string;
    /**
     * @schema TenantV2Spec#imagePullPolicy
     */
    readonly imagePullPolicy?: string;
    /**
     * @schema TenantV2Spec#imagePullSecret
     */
    readonly imagePullSecret?: TenantV2SpecImagePullSecret;
    /**
     * @schema TenantV2Spec#kes
     */
    readonly kes?: TenantV2SpecKes;
    /**
     * @schema TenantV2Spec#liveness
     */
    readonly liveness?: TenantV2SpecLiveness;
    /**
     * @schema TenantV2Spec#log
     */
    readonly log?: TenantV2SpecLog;
    /**
     * @schema TenantV2Spec#logging
     */
    readonly logging?: TenantV2SpecLogging;
    /**
     * @schema TenantV2Spec#mountPath
     */
    readonly mountPath?: string;
    /**
     * @schema TenantV2Spec#podManagementPolicy
     */
    readonly podManagementPolicy?: string;
    /**
     * @schema TenantV2Spec#pools
     */
    readonly pools: TenantV2SpecPools[];
    /**
     * @schema TenantV2Spec#priorityClassName
     */
    readonly priorityClassName?: string;
    /**
     * @schema TenantV2Spec#prometheus
     */
    readonly prometheus?: TenantV2SpecPrometheus;
    /**
     * @schema TenantV2Spec#prometheusOperator
     */
    readonly prometheusOperator?: boolean;
    /**
     * @schema TenantV2Spec#readiness
     */
    readonly readiness?: TenantV2SpecReadiness;
    /**
     * @schema TenantV2Spec#requestAutoCert
     */
    readonly requestAutoCert?: boolean;
    /**
     * @schema TenantV2Spec#s3
     */
    readonly s3?: TenantV2SpecS3;
    /**
     * @schema TenantV2Spec#serviceAccountName
     */
    readonly serviceAccountName?: string;
    /**
     * @schema TenantV2Spec#serviceMetadata
     */
    readonly serviceMetadata?: TenantV2SpecServiceMetadata;
    /**
     * @schema TenantV2Spec#sideCars
     */
    readonly sideCars?: TenantV2SpecSideCars;
    /**
     * @schema TenantV2Spec#subPath
     */
    readonly subPath?: string;
    /**
     * @schema TenantV2Spec#users
     */
    readonly users?: TenantV2SpecUsers[];
}
/**
 * Converts an object of type 'TenantV2Spec' to JSON representation.
 */
export declare function toJson_TenantV2Spec(obj: TenantV2Spec | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecBuckets
 */
export interface TenantV2SpecBuckets {
    /**
     * @schema TenantV2SpecBuckets#name
     */
    readonly name?: string;
    /**
     * @schema TenantV2SpecBuckets#objectLock
     */
    readonly objectLock?: boolean;
    /**
     * @schema TenantV2SpecBuckets#region
     */
    readonly region?: string;
}
/**
 * Converts an object of type 'TenantV2SpecBuckets' to JSON representation.
 */
export declare function toJson_TenantV2SpecBuckets(obj: TenantV2SpecBuckets | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecCertConfig
 */
export interface TenantV2SpecCertConfig {
    /**
     * @schema TenantV2SpecCertConfig#commonName
     */
    readonly commonName?: string;
    /**
     * @schema TenantV2SpecCertConfig#dnsNames
     */
    readonly dnsNames?: string[];
    /**
     * @schema TenantV2SpecCertConfig#organizationName
     */
    readonly organizationName?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecCertConfig' to JSON representation.
 */
export declare function toJson_TenantV2SpecCertConfig(obj: TenantV2SpecCertConfig | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecConfiguration
 */
export interface TenantV2SpecConfiguration {
    /**
     * @schema TenantV2SpecConfiguration#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'TenantV2SpecConfiguration' to JSON representation.
 */
export declare function toJson_TenantV2SpecConfiguration(obj: TenantV2SpecConfiguration | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecCredsSecret
 */
export interface TenantV2SpecCredsSecret {
    /**
     * @schema TenantV2SpecCredsSecret#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'TenantV2SpecCredsSecret' to JSON representation.
 */
export declare function toJson_TenantV2SpecCredsSecret(obj: TenantV2SpecCredsSecret | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecEnv
 */
export interface TenantV2SpecEnv {
    /**
     * @schema TenantV2SpecEnv#name
     */
    readonly name: string;
    /**
     * @schema TenantV2SpecEnv#value
     */
    readonly value?: string;
    /**
     * @schema TenantV2SpecEnv#valueFrom
     */
    readonly valueFrom?: TenantV2SpecEnvValueFrom;
}
/**
 * Converts an object of type 'TenantV2SpecEnv' to JSON representation.
 */
export declare function toJson_TenantV2SpecEnv(obj: TenantV2SpecEnv | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecExposeServices
 */
export interface TenantV2SpecExposeServices {
    /**
     * @schema TenantV2SpecExposeServices#console
     */
    readonly console?: boolean;
    /**
     * @schema TenantV2SpecExposeServices#minio
     */
    readonly minio?: boolean;
}
/**
 * Converts an object of type 'TenantV2SpecExposeServices' to JSON representation.
 */
export declare function toJson_TenantV2SpecExposeServices(obj: TenantV2SpecExposeServices | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecExternalCaCertSecret
 */
export interface TenantV2SpecExternalCaCertSecret {
    /**
     * @schema TenantV2SpecExternalCaCertSecret#name
     */
    readonly name: string;
    /**
     * @schema TenantV2SpecExternalCaCertSecret#type
     */
    readonly type?: string;
}
/**
 * Converts an object of type 'TenantV2SpecExternalCaCertSecret' to JSON representation.
 */
export declare function toJson_TenantV2SpecExternalCaCertSecret(obj: TenantV2SpecExternalCaCertSecret | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecExternalCertSecret
 */
export interface TenantV2SpecExternalCertSecret {
    /**
     * @schema TenantV2SpecExternalCertSecret#name
     */
    readonly name: string;
    /**
     * @schema TenantV2SpecExternalCertSecret#type
     */
    readonly type?: string;
}
/**
 * Converts an object of type 'TenantV2SpecExternalCertSecret' to JSON representation.
 */
export declare function toJson_TenantV2SpecExternalCertSecret(obj: TenantV2SpecExternalCertSecret | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecExternalClientCertSecret
 */
export interface TenantV2SpecExternalClientCertSecret {
    /**
     * @schema TenantV2SpecExternalClientCertSecret#name
     */
    readonly name: string;
    /**
     * @schema TenantV2SpecExternalClientCertSecret#type
     */
    readonly type?: string;
}
/**
 * Converts an object of type 'TenantV2SpecExternalClientCertSecret' to JSON representation.
 */
export declare function toJson_TenantV2SpecExternalClientCertSecret(obj: TenantV2SpecExternalClientCertSecret | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecFeatures
 */
export interface TenantV2SpecFeatures {
    /**
     * @schema TenantV2SpecFeatures#bucketDNS
     */
    readonly bucketDns?: boolean;
    /**
     * @schema TenantV2SpecFeatures#domains
     */
    readonly domains?: TenantV2SpecFeaturesDomains;
}
/**
 * Converts an object of type 'TenantV2SpecFeatures' to JSON representation.
 */
export declare function toJson_TenantV2SpecFeatures(obj: TenantV2SpecFeatures | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecImagePullSecret
 */
export interface TenantV2SpecImagePullSecret {
    /**
     * @schema TenantV2SpecImagePullSecret#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'TenantV2SpecImagePullSecret' to JSON representation.
 */
export declare function toJson_TenantV2SpecImagePullSecret(obj: TenantV2SpecImagePullSecret | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKes
 */
export interface TenantV2SpecKes {
    /**
     * @schema TenantV2SpecKes#affinity
     */
    readonly affinity?: TenantV2SpecKesAffinity;
    /**
     * @schema TenantV2SpecKes#annotations
     */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
     * @schema TenantV2SpecKes#clientCertSecret
     */
    readonly clientCertSecret?: TenantV2SpecKesClientCertSecret;
    /**
     * @schema TenantV2SpecKes#externalCertSecret
     */
    readonly externalCertSecret?: TenantV2SpecKesExternalCertSecret;
    /**
     * @schema TenantV2SpecKes#image
     */
    readonly image?: string;
    /**
     * @schema TenantV2SpecKes#imagePullPolicy
     */
    readonly imagePullPolicy?: string;
    /**
     * @schema TenantV2SpecKes#kesSecret
     */
    readonly kesSecret: TenantV2SpecKesKesSecret;
    /**
     * @schema TenantV2SpecKes#keyName
     */
    readonly keyName?: string;
    /**
     * @schema TenantV2SpecKes#labels
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * @schema TenantV2SpecKes#nodeSelector
     */
    readonly nodeSelector?: {
        [key: string]: string;
    };
    /**
     * @schema TenantV2SpecKes#replicas
     */
    readonly replicas?: number;
    /**
     * @schema TenantV2SpecKes#resources
     */
    readonly resources?: TenantV2SpecKesResources;
    /**
     * @schema TenantV2SpecKes#securityContext
     */
    readonly securityContext?: TenantV2SpecKesSecurityContext;
    /**
     * @schema TenantV2SpecKes#serviceAccountName
     */
    readonly serviceAccountName?: string;
    /**
     * @schema TenantV2SpecKes#tolerations
     */
    readonly tolerations?: TenantV2SpecKesTolerations[];
    /**
     * @schema TenantV2SpecKes#topologySpreadConstraints
     */
    readonly topologySpreadConstraints?: TenantV2SpecKesTopologySpreadConstraints[];
}
/**
 * Converts an object of type 'TenantV2SpecKes' to JSON representation.
 */
export declare function toJson_TenantV2SpecKes(obj: TenantV2SpecKes | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLiveness
 */
export interface TenantV2SpecLiveness {
    /**
     * @schema TenantV2SpecLiveness#exec
     */
    readonly exec?: TenantV2SpecLivenessExec;
    /**
     * @schema TenantV2SpecLiveness#failureThreshold
     */
    readonly failureThreshold?: number;
    /**
     * @schema TenantV2SpecLiveness#httpGet
     */
    readonly httpGet?: TenantV2SpecLivenessHttpGet;
    /**
     * @schema TenantV2SpecLiveness#initialDelaySeconds
     */
    readonly initialDelaySeconds?: number;
    /**
     * @schema TenantV2SpecLiveness#periodSeconds
     */
    readonly periodSeconds?: number;
    /**
     * @schema TenantV2SpecLiveness#successThreshold
     */
    readonly successThreshold?: number;
    /**
     * @schema TenantV2SpecLiveness#tcpSocket
     */
    readonly tcpSocket?: TenantV2SpecLivenessTcpSocket;
    /**
     * @schema TenantV2SpecLiveness#timeoutSeconds
     */
    readonly timeoutSeconds?: number;
}
/**
 * Converts an object of type 'TenantV2SpecLiveness' to JSON representation.
 */
export declare function toJson_TenantV2SpecLiveness(obj: TenantV2SpecLiveness | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLog
 */
export interface TenantV2SpecLog {
    /**
     * @schema TenantV2SpecLog#affinity
     */
    readonly affinity?: TenantV2SpecLogAffinity;
    /**
     * @schema TenantV2SpecLog#annotations
     */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
     * @schema TenantV2SpecLog#audit
     */
    readonly audit?: TenantV2SpecLogAudit;
    /**
     * @schema TenantV2SpecLog#db
     */
    readonly db?: TenantV2SpecLogDb;
    /**
     * @schema TenantV2SpecLog#image
     */
    readonly image?: string;
    /**
     * @schema TenantV2SpecLog#labels
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * @schema TenantV2SpecLog#nodeSelector
     */
    readonly nodeSelector?: {
        [key: string]: string;
    };
    /**
     * @schema TenantV2SpecLog#resources
     */
    readonly resources?: TenantV2SpecLogResources;
    /**
     * @schema TenantV2SpecLog#securityContext
     */
    readonly securityContext?: TenantV2SpecLogSecurityContext;
    /**
     * @schema TenantV2SpecLog#serviceAccountName
     */
    readonly serviceAccountName?: string;
    /**
     * @schema TenantV2SpecLog#tolerations
     */
    readonly tolerations?: TenantV2SpecLogTolerations[];
    /**
     * @schema TenantV2SpecLog#topologySpreadConstraints
     */
    readonly topologySpreadConstraints?: TenantV2SpecLogTopologySpreadConstraints[];
}
/**
 * Converts an object of type 'TenantV2SpecLog' to JSON representation.
 */
export declare function toJson_TenantV2SpecLog(obj: TenantV2SpecLog | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogging
 */
export interface TenantV2SpecLogging {
    /**
     * @schema TenantV2SpecLogging#anonymous
     */
    readonly anonymous?: boolean;
    /**
     * @schema TenantV2SpecLogging#json
     */
    readonly json?: boolean;
    /**
     * @schema TenantV2SpecLogging#quiet
     */
    readonly quiet?: boolean;
}
/**
 * Converts an object of type 'TenantV2SpecLogging' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogging(obj: TenantV2SpecLogging | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPools
 */
export interface TenantV2SpecPools {
    /**
     * @schema TenantV2SpecPools#affinity
     */
    readonly affinity?: TenantV2SpecPoolsAffinity;
    /**
     * @schema TenantV2SpecPools#annotations
     */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
     * @schema TenantV2SpecPools#labels
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * @schema TenantV2SpecPools#name
     */
    readonly name?: string;
    /**
     * @schema TenantV2SpecPools#nodeSelector
     */
    readonly nodeSelector?: {
        [key: string]: string;
    };
    /**
     * @schema TenantV2SpecPools#resources
     */
    readonly resources?: TenantV2SpecPoolsResources;
    /**
     * @schema TenantV2SpecPools#securityContext
     */
    readonly securityContext?: TenantV2SpecPoolsSecurityContext;
    /**
     * @schema TenantV2SpecPools#servers
     */
    readonly servers: number;
    /**
     * @schema TenantV2SpecPools#tolerations
     */
    readonly tolerations?: TenantV2SpecPoolsTolerations[];
    /**
     * @schema TenantV2SpecPools#topologySpreadConstraints
     */
    readonly topologySpreadConstraints?: TenantV2SpecPoolsTopologySpreadConstraints[];
    /**
     * @schema TenantV2SpecPools#volumeClaimTemplate
     */
    readonly volumeClaimTemplate: TenantV2SpecPoolsVolumeClaimTemplate;
    /**
     * @schema TenantV2SpecPools#volumesPerServer
     */
    readonly volumesPerServer: number;
}
/**
 * Converts an object of type 'TenantV2SpecPools' to JSON representation.
 */
export declare function toJson_TenantV2SpecPools(obj: TenantV2SpecPools | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheus
 */
export interface TenantV2SpecPrometheus {
    /**
     * @schema TenantV2SpecPrometheus#affinity
     */
    readonly affinity?: TenantV2SpecPrometheusAffinity;
    /**
     * @schema TenantV2SpecPrometheus#annotations
     */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
     * @schema TenantV2SpecPrometheus#diskCapacityGB
     */
    readonly diskCapacityGb?: number;
    /**
     * @schema TenantV2SpecPrometheus#image
     */
    readonly image?: string;
    /**
     * @schema TenantV2SpecPrometheus#initimage
     */
    readonly initimage?: string;
    /**
     * @schema TenantV2SpecPrometheus#labels
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * @schema TenantV2SpecPrometheus#nodeSelector
     */
    readonly nodeSelector?: {
        [key: string]: string;
    };
    /**
     * @schema TenantV2SpecPrometheus#resources
     */
    readonly resources?: TenantV2SpecPrometheusResources;
    /**
     * @schema TenantV2SpecPrometheus#securityContext
     */
    readonly securityContext?: TenantV2SpecPrometheusSecurityContext;
    /**
     * @schema TenantV2SpecPrometheus#serviceAccountName
     */
    readonly serviceAccountName?: string;
    /**
     * @schema TenantV2SpecPrometheus#sidecarimage
     */
    readonly sidecarimage?: string;
    /**
     * @schema TenantV2SpecPrometheus#storageClassName
     */
    readonly storageClassName?: string;
    /**
     * @schema TenantV2SpecPrometheus#topologySpreadConstraints
     */
    readonly topologySpreadConstraints?: TenantV2SpecPrometheusTopologySpreadConstraints[];
}
/**
 * Converts an object of type 'TenantV2SpecPrometheus' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheus(obj: TenantV2SpecPrometheus | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecReadiness
 */
export interface TenantV2SpecReadiness {
    /**
     * @schema TenantV2SpecReadiness#exec
     */
    readonly exec?: TenantV2SpecReadinessExec;
    /**
     * @schema TenantV2SpecReadiness#failureThreshold
     */
    readonly failureThreshold?: number;
    /**
     * @schema TenantV2SpecReadiness#httpGet
     */
    readonly httpGet?: TenantV2SpecReadinessHttpGet;
    /**
     * @schema TenantV2SpecReadiness#initialDelaySeconds
     */
    readonly initialDelaySeconds?: number;
    /**
     * @schema TenantV2SpecReadiness#periodSeconds
     */
    readonly periodSeconds?: number;
    /**
     * @schema TenantV2SpecReadiness#successThreshold
     */
    readonly successThreshold?: number;
    /**
     * @schema TenantV2SpecReadiness#tcpSocket
     */
    readonly tcpSocket?: TenantV2SpecReadinessTcpSocket;
    /**
     * @schema TenantV2SpecReadiness#timeoutSeconds
     */
    readonly timeoutSeconds?: number;
}
/**
 * Converts an object of type 'TenantV2SpecReadiness' to JSON representation.
 */
export declare function toJson_TenantV2SpecReadiness(obj: TenantV2SpecReadiness | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecS3
 */
export interface TenantV2SpecS3 {
    /**
     * @schema TenantV2SpecS3#bucketDNS
     */
    readonly bucketDns?: boolean;
}
/**
 * Converts an object of type 'TenantV2SpecS3' to JSON representation.
 */
export declare function toJson_TenantV2SpecS3(obj: TenantV2SpecS3 | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecServiceMetadata
 */
export interface TenantV2SpecServiceMetadata {
    /**
     * @schema TenantV2SpecServiceMetadata#consoleServiceAnnotations
     */
    readonly consoleServiceAnnotations?: {
        [key: string]: string;
    };
    /**
     * @schema TenantV2SpecServiceMetadata#consoleServiceLabels
     */
    readonly consoleServiceLabels?: {
        [key: string]: string;
    };
    /**
     * @schema TenantV2SpecServiceMetadata#minioServiceAnnotations
     */
    readonly minioServiceAnnotations?: {
        [key: string]: string;
    };
    /**
     * @schema TenantV2SpecServiceMetadata#minioServiceLabels
     */
    readonly minioServiceLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantV2SpecServiceMetadata' to JSON representation.
 */
export declare function toJson_TenantV2SpecServiceMetadata(obj: TenantV2SpecServiceMetadata | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCars
 */
export interface TenantV2SpecSideCars {
    /**
     * @schema TenantV2SpecSideCars#containers
     */
    readonly containers: TenantV2SpecSideCarsContainers[];
    /**
     * @schema TenantV2SpecSideCars#volumeClaimTemplates
     */
    readonly volumeClaimTemplates?: TenantV2SpecSideCarsVolumeClaimTemplates[];
    /**
     * @schema TenantV2SpecSideCars#volumes
     */
    readonly volumes?: TenantV2SpecSideCarsVolumes[];
}
/**
 * Converts an object of type 'TenantV2SpecSideCars' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCars(obj: TenantV2SpecSideCars | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecUsers
 */
export interface TenantV2SpecUsers {
    /**
     * @schema TenantV2SpecUsers#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'TenantV2SpecUsers' to JSON representation.
 */
export declare function toJson_TenantV2SpecUsers(obj: TenantV2SpecUsers | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecEnvValueFrom
 */
export interface TenantV2SpecEnvValueFrom {
    /**
     * @schema TenantV2SpecEnvValueFrom#configMapKeyRef
     */
    readonly configMapKeyRef?: TenantV2SpecEnvValueFromConfigMapKeyRef;
    /**
     * @schema TenantV2SpecEnvValueFrom#fieldRef
     */
    readonly fieldRef?: TenantV2SpecEnvValueFromFieldRef;
    /**
     * @schema TenantV2SpecEnvValueFrom#resourceFieldRef
     */
    readonly resourceFieldRef?: TenantV2SpecEnvValueFromResourceFieldRef;
    /**
     * @schema TenantV2SpecEnvValueFrom#secretKeyRef
     */
    readonly secretKeyRef?: TenantV2SpecEnvValueFromSecretKeyRef;
}
/**
 * Converts an object of type 'TenantV2SpecEnvValueFrom' to JSON representation.
 */
export declare function toJson_TenantV2SpecEnvValueFrom(obj: TenantV2SpecEnvValueFrom | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecFeaturesDomains
 */
export interface TenantV2SpecFeaturesDomains {
    /**
     * @schema TenantV2SpecFeaturesDomains#console
     */
    readonly console?: string;
    /**
     * @schema TenantV2SpecFeaturesDomains#minio
     */
    readonly minio?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecFeaturesDomains' to JSON representation.
 */
export declare function toJson_TenantV2SpecFeaturesDomains(obj: TenantV2SpecFeaturesDomains | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesAffinity
 */
export interface TenantV2SpecKesAffinity {
    /**
     * @schema TenantV2SpecKesAffinity#nodeAffinity
     */
    readonly nodeAffinity?: TenantV2SpecKesAffinityNodeAffinity;
    /**
     * @schema TenantV2SpecKesAffinity#podAffinity
     */
    readonly podAffinity?: TenantV2SpecKesAffinityPodAffinity;
    /**
     * @schema TenantV2SpecKesAffinity#podAntiAffinity
     */
    readonly podAntiAffinity?: TenantV2SpecKesAffinityPodAntiAffinity;
}
/**
 * Converts an object of type 'TenantV2SpecKesAffinity' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesAffinity(obj: TenantV2SpecKesAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesClientCertSecret
 */
export interface TenantV2SpecKesClientCertSecret {
    /**
     * @schema TenantV2SpecKesClientCertSecret#name
     */
    readonly name: string;
    /**
     * @schema TenantV2SpecKesClientCertSecret#type
     */
    readonly type?: string;
}
/**
 * Converts an object of type 'TenantV2SpecKesClientCertSecret' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesClientCertSecret(obj: TenantV2SpecKesClientCertSecret | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesExternalCertSecret
 */
export interface TenantV2SpecKesExternalCertSecret {
    /**
     * @schema TenantV2SpecKesExternalCertSecret#name
     */
    readonly name: string;
    /**
     * @schema TenantV2SpecKesExternalCertSecret#type
     */
    readonly type?: string;
}
/**
 * Converts an object of type 'TenantV2SpecKesExternalCertSecret' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesExternalCertSecret(obj: TenantV2SpecKesExternalCertSecret | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesKesSecret
 */
export interface TenantV2SpecKesKesSecret {
    /**
     * @schema TenantV2SpecKesKesSecret#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'TenantV2SpecKesKesSecret' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesKesSecret(obj: TenantV2SpecKesKesSecret | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesResources
 */
export interface TenantV2SpecKesResources {
    /**
     * @schema TenantV2SpecKesResources#limits
     */
    readonly limits?: {
        [key: string]: TenantV2SpecKesResourcesLimits;
    };
    /**
     * @schema TenantV2SpecKesResources#requests
     */
    readonly requests?: {
        [key: string]: TenantV2SpecKesResourcesRequests;
    };
}
/**
 * Converts an object of type 'TenantV2SpecKesResources' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesResources(obj: TenantV2SpecKesResources | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesSecurityContext
 */
export interface TenantV2SpecKesSecurityContext {
    /**
     * @schema TenantV2SpecKesSecurityContext#fsGroup
     */
    readonly fsGroup?: number;
    /**
     * @schema TenantV2SpecKesSecurityContext#fsGroupChangePolicy
     */
    readonly fsGroupChangePolicy?: string;
    /**
     * @schema TenantV2SpecKesSecurityContext#runAsGroup
     */
    readonly runAsGroup?: number;
    /**
     * @schema TenantV2SpecKesSecurityContext#runAsNonRoot
     */
    readonly runAsNonRoot?: boolean;
    /**
     * @schema TenantV2SpecKesSecurityContext#runAsUser
     */
    readonly runAsUser?: number;
    /**
     * @schema TenantV2SpecKesSecurityContext#seLinuxOptions
     */
    readonly seLinuxOptions?: TenantV2SpecKesSecurityContextSeLinuxOptions;
    /**
     * @schema TenantV2SpecKesSecurityContext#seccompProfile
     */
    readonly seccompProfile?: TenantV2SpecKesSecurityContextSeccompProfile;
    /**
     * @schema TenantV2SpecKesSecurityContext#supplementalGroups
     */
    readonly supplementalGroups?: number[];
    /**
     * @schema TenantV2SpecKesSecurityContext#sysctls
     */
    readonly sysctls?: TenantV2SpecKesSecurityContextSysctls[];
    /**
     * @schema TenantV2SpecKesSecurityContext#windowsOptions
     */
    readonly windowsOptions?: TenantV2SpecKesSecurityContextWindowsOptions;
}
/**
 * Converts an object of type 'TenantV2SpecKesSecurityContext' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesSecurityContext(obj: TenantV2SpecKesSecurityContext | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesTolerations
 */
export interface TenantV2SpecKesTolerations {
    /**
     * @schema TenantV2SpecKesTolerations#effect
     */
    readonly effect?: string;
    /**
     * @schema TenantV2SpecKesTolerations#key
     */
    readonly key?: string;
    /**
     * @schema TenantV2SpecKesTolerations#operator
     */
    readonly operator?: string;
    /**
     * @schema TenantV2SpecKesTolerations#tolerationSeconds
     */
    readonly tolerationSeconds?: number;
    /**
     * @schema TenantV2SpecKesTolerations#value
     */
    readonly value?: string;
}
/**
 * Converts an object of type 'TenantV2SpecKesTolerations' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesTolerations(obj: TenantV2SpecKesTolerations | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesTopologySpreadConstraints
 */
export interface TenantV2SpecKesTopologySpreadConstraints {
    /**
     * @schema TenantV2SpecKesTopologySpreadConstraints#labelSelector
     */
    readonly labelSelector?: TenantV2SpecKesTopologySpreadConstraintsLabelSelector;
    /**
     * @schema TenantV2SpecKesTopologySpreadConstraints#maxSkew
     */
    readonly maxSkew: number;
    /**
     * @schema TenantV2SpecKesTopologySpreadConstraints#topologyKey
     */
    readonly topologyKey: string;
    /**
     * @schema TenantV2SpecKesTopologySpreadConstraints#whenUnsatisfiable
     */
    readonly whenUnsatisfiable: string;
}
/**
 * Converts an object of type 'TenantV2SpecKesTopologySpreadConstraints' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesTopologySpreadConstraints(obj: TenantV2SpecKesTopologySpreadConstraints | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLivenessExec
 */
export interface TenantV2SpecLivenessExec {
    /**
     * @schema TenantV2SpecLivenessExec#command
     */
    readonly command?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecLivenessExec' to JSON representation.
 */
export declare function toJson_TenantV2SpecLivenessExec(obj: TenantV2SpecLivenessExec | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLivenessHttpGet
 */
export interface TenantV2SpecLivenessHttpGet {
    /**
     * @schema TenantV2SpecLivenessHttpGet#host
     */
    readonly host?: string;
    /**
     * @schema TenantV2SpecLivenessHttpGet#httpHeaders
     */
    readonly httpHeaders?: TenantV2SpecLivenessHttpGetHttpHeaders[];
    /**
     * @schema TenantV2SpecLivenessHttpGet#path
     */
    readonly path?: string;
    /**
     * @schema TenantV2SpecLivenessHttpGet#port
     */
    readonly port: TenantV2SpecLivenessHttpGetPort;
    /**
     * @schema TenantV2SpecLivenessHttpGet#scheme
     */
    readonly scheme?: string;
}
/**
 * Converts an object of type 'TenantV2SpecLivenessHttpGet' to JSON representation.
 */
export declare function toJson_TenantV2SpecLivenessHttpGet(obj: TenantV2SpecLivenessHttpGet | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLivenessTcpSocket
 */
export interface TenantV2SpecLivenessTcpSocket {
    /**
     * @schema TenantV2SpecLivenessTcpSocket#host
     */
    readonly host?: string;
    /**
     * @schema TenantV2SpecLivenessTcpSocket#port
     */
    readonly port: TenantV2SpecLivenessTcpSocketPort;
}
/**
 * Converts an object of type 'TenantV2SpecLivenessTcpSocket' to JSON representation.
 */
export declare function toJson_TenantV2SpecLivenessTcpSocket(obj: TenantV2SpecLivenessTcpSocket | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogAffinity
 */
export interface TenantV2SpecLogAffinity {
    /**
     * @schema TenantV2SpecLogAffinity#nodeAffinity
     */
    readonly nodeAffinity?: TenantV2SpecLogAffinityNodeAffinity;
    /**
     * @schema TenantV2SpecLogAffinity#podAffinity
     */
    readonly podAffinity?: TenantV2SpecLogAffinityPodAffinity;
    /**
     * @schema TenantV2SpecLogAffinity#podAntiAffinity
     */
    readonly podAntiAffinity?: TenantV2SpecLogAffinityPodAntiAffinity;
}
/**
 * Converts an object of type 'TenantV2SpecLogAffinity' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogAffinity(obj: TenantV2SpecLogAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogAudit
 */
export interface TenantV2SpecLogAudit {
    /**
     * @schema TenantV2SpecLogAudit#diskCapacityGB
     */
    readonly diskCapacityGb?: number;
}
/**
 * Converts an object of type 'TenantV2SpecLogAudit' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogAudit(obj: TenantV2SpecLogAudit | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDb
 */
export interface TenantV2SpecLogDb {
    /**
     * @schema TenantV2SpecLogDb#affinity
     */
    readonly affinity?: TenantV2SpecLogDbAffinity;
    /**
     * @schema TenantV2SpecLogDb#annotations
     */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
     * @schema TenantV2SpecLogDb#image
     */
    readonly image?: string;
    /**
     * @schema TenantV2SpecLogDb#initimage
     */
    readonly initimage?: string;
    /**
     * @schema TenantV2SpecLogDb#labels
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * @schema TenantV2SpecLogDb#nodeSelector
     */
    readonly nodeSelector?: {
        [key: string]: string;
    };
    /**
     * @schema TenantV2SpecLogDb#resources
     */
    readonly resources?: TenantV2SpecLogDbResources;
    /**
     * @schema TenantV2SpecLogDb#securityContext
     */
    readonly securityContext?: TenantV2SpecLogDbSecurityContext;
    /**
     * @schema TenantV2SpecLogDb#serviceAccountName
     */
    readonly serviceAccountName?: string;
    /**
     * @schema TenantV2SpecLogDb#tolerations
     */
    readonly tolerations?: TenantV2SpecLogDbTolerations[];
    /**
     * @schema TenantV2SpecLogDb#topologySpreadConstraints
     */
    readonly topologySpreadConstraints?: TenantV2SpecLogDbTopologySpreadConstraints[];
    /**
     * @schema TenantV2SpecLogDb#volumeClaimTemplate
     */
    readonly volumeClaimTemplate: TenantV2SpecLogDbVolumeClaimTemplate;
}
/**
 * Converts an object of type 'TenantV2SpecLogDb' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDb(obj: TenantV2SpecLogDb | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogResources
 */
export interface TenantV2SpecLogResources {
    /**
     * @schema TenantV2SpecLogResources#limits
     */
    readonly limits?: {
        [key: string]: TenantV2SpecLogResourcesLimits;
    };
    /**
     * @schema TenantV2SpecLogResources#requests
     */
    readonly requests?: {
        [key: string]: TenantV2SpecLogResourcesRequests;
    };
}
/**
 * Converts an object of type 'TenantV2SpecLogResources' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogResources(obj: TenantV2SpecLogResources | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogSecurityContext
 */
export interface TenantV2SpecLogSecurityContext {
    /**
     * @schema TenantV2SpecLogSecurityContext#fsGroup
     */
    readonly fsGroup?: number;
    /**
     * @schema TenantV2SpecLogSecurityContext#fsGroupChangePolicy
     */
    readonly fsGroupChangePolicy?: string;
    /**
     * @schema TenantV2SpecLogSecurityContext#runAsGroup
     */
    readonly runAsGroup?: number;
    /**
     * @schema TenantV2SpecLogSecurityContext#runAsNonRoot
     */
    readonly runAsNonRoot?: boolean;
    /**
     * @schema TenantV2SpecLogSecurityContext#runAsUser
     */
    readonly runAsUser?: number;
    /**
     * @schema TenantV2SpecLogSecurityContext#seLinuxOptions
     */
    readonly seLinuxOptions?: TenantV2SpecLogSecurityContextSeLinuxOptions;
    /**
     * @schema TenantV2SpecLogSecurityContext#seccompProfile
     */
    readonly seccompProfile?: TenantV2SpecLogSecurityContextSeccompProfile;
    /**
     * @schema TenantV2SpecLogSecurityContext#supplementalGroups
     */
    readonly supplementalGroups?: number[];
    /**
     * @schema TenantV2SpecLogSecurityContext#sysctls
     */
    readonly sysctls?: TenantV2SpecLogSecurityContextSysctls[];
    /**
     * @schema TenantV2SpecLogSecurityContext#windowsOptions
     */
    readonly windowsOptions?: TenantV2SpecLogSecurityContextWindowsOptions;
}
/**
 * Converts an object of type 'TenantV2SpecLogSecurityContext' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogSecurityContext(obj: TenantV2SpecLogSecurityContext | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogTolerations
 */
export interface TenantV2SpecLogTolerations {
    /**
     * @schema TenantV2SpecLogTolerations#effect
     */
    readonly effect?: string;
    /**
     * @schema TenantV2SpecLogTolerations#key
     */
    readonly key?: string;
    /**
     * @schema TenantV2SpecLogTolerations#operator
     */
    readonly operator?: string;
    /**
     * @schema TenantV2SpecLogTolerations#tolerationSeconds
     */
    readonly tolerationSeconds?: number;
    /**
     * @schema TenantV2SpecLogTolerations#value
     */
    readonly value?: string;
}
/**
 * Converts an object of type 'TenantV2SpecLogTolerations' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogTolerations(obj: TenantV2SpecLogTolerations | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogTopologySpreadConstraints
 */
export interface TenantV2SpecLogTopologySpreadConstraints {
    /**
     * @schema TenantV2SpecLogTopologySpreadConstraints#labelSelector
     */
    readonly labelSelector?: TenantV2SpecLogTopologySpreadConstraintsLabelSelector;
    /**
     * @schema TenantV2SpecLogTopologySpreadConstraints#maxSkew
     */
    readonly maxSkew: number;
    /**
     * @schema TenantV2SpecLogTopologySpreadConstraints#topologyKey
     */
    readonly topologyKey: string;
    /**
     * @schema TenantV2SpecLogTopologySpreadConstraints#whenUnsatisfiable
     */
    readonly whenUnsatisfiable: string;
}
/**
 * Converts an object of type 'TenantV2SpecLogTopologySpreadConstraints' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogTopologySpreadConstraints(obj: TenantV2SpecLogTopologySpreadConstraints | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsAffinity
 */
export interface TenantV2SpecPoolsAffinity {
    /**
     * @schema TenantV2SpecPoolsAffinity#nodeAffinity
     */
    readonly nodeAffinity?: TenantV2SpecPoolsAffinityNodeAffinity;
    /**
     * @schema TenantV2SpecPoolsAffinity#podAffinity
     */
    readonly podAffinity?: TenantV2SpecPoolsAffinityPodAffinity;
    /**
     * @schema TenantV2SpecPoolsAffinity#podAntiAffinity
     */
    readonly podAntiAffinity?: TenantV2SpecPoolsAffinityPodAntiAffinity;
}
/**
 * Converts an object of type 'TenantV2SpecPoolsAffinity' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsAffinity(obj: TenantV2SpecPoolsAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsResources
 */
export interface TenantV2SpecPoolsResources {
    /**
     * @schema TenantV2SpecPoolsResources#limits
     */
    readonly limits?: {
        [key: string]: TenantV2SpecPoolsResourcesLimits;
    };
    /**
     * @schema TenantV2SpecPoolsResources#requests
     */
    readonly requests?: {
        [key: string]: TenantV2SpecPoolsResourcesRequests;
    };
}
/**
 * Converts an object of type 'TenantV2SpecPoolsResources' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsResources(obj: TenantV2SpecPoolsResources | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsSecurityContext
 */
export interface TenantV2SpecPoolsSecurityContext {
    /**
     * @schema TenantV2SpecPoolsSecurityContext#fsGroup
     */
    readonly fsGroup?: number;
    /**
     * @schema TenantV2SpecPoolsSecurityContext#fsGroupChangePolicy
     */
    readonly fsGroupChangePolicy?: string;
    /**
     * @schema TenantV2SpecPoolsSecurityContext#runAsGroup
     */
    readonly runAsGroup?: number;
    /**
     * @schema TenantV2SpecPoolsSecurityContext#runAsNonRoot
     */
    readonly runAsNonRoot?: boolean;
    /**
     * @schema TenantV2SpecPoolsSecurityContext#runAsUser
     */
    readonly runAsUser?: number;
    /**
     * @schema TenantV2SpecPoolsSecurityContext#seLinuxOptions
     */
    readonly seLinuxOptions?: TenantV2SpecPoolsSecurityContextSeLinuxOptions;
    /**
     * @schema TenantV2SpecPoolsSecurityContext#seccompProfile
     */
    readonly seccompProfile?: TenantV2SpecPoolsSecurityContextSeccompProfile;
    /**
     * @schema TenantV2SpecPoolsSecurityContext#supplementalGroups
     */
    readonly supplementalGroups?: number[];
    /**
     * @schema TenantV2SpecPoolsSecurityContext#sysctls
     */
    readonly sysctls?: TenantV2SpecPoolsSecurityContextSysctls[];
    /**
     * @schema TenantV2SpecPoolsSecurityContext#windowsOptions
     */
    readonly windowsOptions?: TenantV2SpecPoolsSecurityContextWindowsOptions;
}
/**
 * Converts an object of type 'TenantV2SpecPoolsSecurityContext' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsSecurityContext(obj: TenantV2SpecPoolsSecurityContext | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsTolerations
 */
export interface TenantV2SpecPoolsTolerations {
    /**
     * @schema TenantV2SpecPoolsTolerations#effect
     */
    readonly effect?: string;
    /**
     * @schema TenantV2SpecPoolsTolerations#key
     */
    readonly key?: string;
    /**
     * @schema TenantV2SpecPoolsTolerations#operator
     */
    readonly operator?: string;
    /**
     * @schema TenantV2SpecPoolsTolerations#tolerationSeconds
     */
    readonly tolerationSeconds?: number;
    /**
     * @schema TenantV2SpecPoolsTolerations#value
     */
    readonly value?: string;
}
/**
 * Converts an object of type 'TenantV2SpecPoolsTolerations' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsTolerations(obj: TenantV2SpecPoolsTolerations | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsTopologySpreadConstraints
 */
export interface TenantV2SpecPoolsTopologySpreadConstraints {
    /**
     * @schema TenantV2SpecPoolsTopologySpreadConstraints#labelSelector
     */
    readonly labelSelector?: TenantV2SpecPoolsTopologySpreadConstraintsLabelSelector;
    /**
     * @schema TenantV2SpecPoolsTopologySpreadConstraints#maxSkew
     */
    readonly maxSkew: number;
    /**
     * @schema TenantV2SpecPoolsTopologySpreadConstraints#topologyKey
     */
    readonly topologyKey: string;
    /**
     * @schema TenantV2SpecPoolsTopologySpreadConstraints#whenUnsatisfiable
     */
    readonly whenUnsatisfiable: string;
}
/**
 * Converts an object of type 'TenantV2SpecPoolsTopologySpreadConstraints' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsTopologySpreadConstraints(obj: TenantV2SpecPoolsTopologySpreadConstraints | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsVolumeClaimTemplate
 */
export interface TenantV2SpecPoolsVolumeClaimTemplate {
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplate#apiVersion
     */
    readonly apiVersion?: string;
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplate#kind
     */
    readonly kind?: string;
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplate#metadata
     */
    readonly metadata?: TenantV2SpecPoolsVolumeClaimTemplateMetadata;
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplate#spec
     */
    readonly spec?: TenantV2SpecPoolsVolumeClaimTemplateSpec;
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplate#status
     */
    readonly status?: TenantV2SpecPoolsVolumeClaimTemplateStatus;
}
/**
 * Converts an object of type 'TenantV2SpecPoolsVolumeClaimTemplate' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsVolumeClaimTemplate(obj: TenantV2SpecPoolsVolumeClaimTemplate | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusAffinity
 */
export interface TenantV2SpecPrometheusAffinity {
    /**
     * @schema TenantV2SpecPrometheusAffinity#nodeAffinity
     */
    readonly nodeAffinity?: TenantV2SpecPrometheusAffinityNodeAffinity;
    /**
     * @schema TenantV2SpecPrometheusAffinity#podAffinity
     */
    readonly podAffinity?: TenantV2SpecPrometheusAffinityPodAffinity;
    /**
     * @schema TenantV2SpecPrometheusAffinity#podAntiAffinity
     */
    readonly podAntiAffinity?: TenantV2SpecPrometheusAffinityPodAntiAffinity;
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusAffinity' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusAffinity(obj: TenantV2SpecPrometheusAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusResources
 */
export interface TenantV2SpecPrometheusResources {
    /**
     * @schema TenantV2SpecPrometheusResources#limits
     */
    readonly limits?: {
        [key: string]: TenantV2SpecPrometheusResourcesLimits;
    };
    /**
     * @schema TenantV2SpecPrometheusResources#requests
     */
    readonly requests?: {
        [key: string]: TenantV2SpecPrometheusResourcesRequests;
    };
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusResources' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusResources(obj: TenantV2SpecPrometheusResources | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusSecurityContext
 */
export interface TenantV2SpecPrometheusSecurityContext {
    /**
     * @schema TenantV2SpecPrometheusSecurityContext#fsGroup
     */
    readonly fsGroup?: number;
    /**
     * @schema TenantV2SpecPrometheusSecurityContext#fsGroupChangePolicy
     */
    readonly fsGroupChangePolicy?: string;
    /**
     * @schema TenantV2SpecPrometheusSecurityContext#runAsGroup
     */
    readonly runAsGroup?: number;
    /**
     * @schema TenantV2SpecPrometheusSecurityContext#runAsNonRoot
     */
    readonly runAsNonRoot?: boolean;
    /**
     * @schema TenantV2SpecPrometheusSecurityContext#runAsUser
     */
    readonly runAsUser?: number;
    /**
     * @schema TenantV2SpecPrometheusSecurityContext#seLinuxOptions
     */
    readonly seLinuxOptions?: TenantV2SpecPrometheusSecurityContextSeLinuxOptions;
    /**
     * @schema TenantV2SpecPrometheusSecurityContext#seccompProfile
     */
    readonly seccompProfile?: TenantV2SpecPrometheusSecurityContextSeccompProfile;
    /**
     * @schema TenantV2SpecPrometheusSecurityContext#supplementalGroups
     */
    readonly supplementalGroups?: number[];
    /**
     * @schema TenantV2SpecPrometheusSecurityContext#sysctls
     */
    readonly sysctls?: TenantV2SpecPrometheusSecurityContextSysctls[];
    /**
     * @schema TenantV2SpecPrometheusSecurityContext#windowsOptions
     */
    readonly windowsOptions?: TenantV2SpecPrometheusSecurityContextWindowsOptions;
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusSecurityContext' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusSecurityContext(obj: TenantV2SpecPrometheusSecurityContext | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusTopologySpreadConstraints
 */
export interface TenantV2SpecPrometheusTopologySpreadConstraints {
    /**
     * @schema TenantV2SpecPrometheusTopologySpreadConstraints#labelSelector
     */
    readonly labelSelector?: TenantV2SpecPrometheusTopologySpreadConstraintsLabelSelector;
    /**
     * @schema TenantV2SpecPrometheusTopologySpreadConstraints#maxSkew
     */
    readonly maxSkew: number;
    /**
     * @schema TenantV2SpecPrometheusTopologySpreadConstraints#topologyKey
     */
    readonly topologyKey: string;
    /**
     * @schema TenantV2SpecPrometheusTopologySpreadConstraints#whenUnsatisfiable
     */
    readonly whenUnsatisfiable: string;
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusTopologySpreadConstraints' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusTopologySpreadConstraints(obj: TenantV2SpecPrometheusTopologySpreadConstraints | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecReadinessExec
 */
export interface TenantV2SpecReadinessExec {
    /**
     * @schema TenantV2SpecReadinessExec#command
     */
    readonly command?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecReadinessExec' to JSON representation.
 */
export declare function toJson_TenantV2SpecReadinessExec(obj: TenantV2SpecReadinessExec | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecReadinessHttpGet
 */
export interface TenantV2SpecReadinessHttpGet {
    /**
     * @schema TenantV2SpecReadinessHttpGet#host
     */
    readonly host?: string;
    /**
     * @schema TenantV2SpecReadinessHttpGet#httpHeaders
     */
    readonly httpHeaders?: TenantV2SpecReadinessHttpGetHttpHeaders[];
    /**
     * @schema TenantV2SpecReadinessHttpGet#path
     */
    readonly path?: string;
    /**
     * @schema TenantV2SpecReadinessHttpGet#port
     */
    readonly port: TenantV2SpecReadinessHttpGetPort;
    /**
     * @schema TenantV2SpecReadinessHttpGet#scheme
     */
    readonly scheme?: string;
}
/**
 * Converts an object of type 'TenantV2SpecReadinessHttpGet' to JSON representation.
 */
export declare function toJson_TenantV2SpecReadinessHttpGet(obj: TenantV2SpecReadinessHttpGet | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecReadinessTcpSocket
 */
export interface TenantV2SpecReadinessTcpSocket {
    /**
     * @schema TenantV2SpecReadinessTcpSocket#host
     */
    readonly host?: string;
    /**
     * @schema TenantV2SpecReadinessTcpSocket#port
     */
    readonly port: TenantV2SpecReadinessTcpSocketPort;
}
/**
 * Converts an object of type 'TenantV2SpecReadinessTcpSocket' to JSON representation.
 */
export declare function toJson_TenantV2SpecReadinessTcpSocket(obj: TenantV2SpecReadinessTcpSocket | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainers
 */
export interface TenantV2SpecSideCarsContainers {
    /**
     * @schema TenantV2SpecSideCarsContainers#args
     */
    readonly args?: string[];
    /**
     * @schema TenantV2SpecSideCarsContainers#command
     */
    readonly command?: string[];
    /**
     * @schema TenantV2SpecSideCarsContainers#env
     */
    readonly env?: TenantV2SpecSideCarsContainersEnv[];
    /**
     * @schema TenantV2SpecSideCarsContainers#envFrom
     */
    readonly envFrom?: TenantV2SpecSideCarsContainersEnvFrom[];
    /**
     * @schema TenantV2SpecSideCarsContainers#image
     */
    readonly image?: string;
    /**
     * @schema TenantV2SpecSideCarsContainers#imagePullPolicy
     */
    readonly imagePullPolicy?: string;
    /**
     * @schema TenantV2SpecSideCarsContainers#lifecycle
     */
    readonly lifecycle?: TenantV2SpecSideCarsContainersLifecycle;
    /**
     * @schema TenantV2SpecSideCarsContainers#livenessProbe
     */
    readonly livenessProbe?: TenantV2SpecSideCarsContainersLivenessProbe;
    /**
     * @schema TenantV2SpecSideCarsContainers#name
     */
    readonly name: string;
    /**
     * @schema TenantV2SpecSideCarsContainers#ports
     */
    readonly ports?: TenantV2SpecSideCarsContainersPorts[];
    /**
     * @schema TenantV2SpecSideCarsContainers#readinessProbe
     */
    readonly readinessProbe?: TenantV2SpecSideCarsContainersReadinessProbe;
    /**
     * @schema TenantV2SpecSideCarsContainers#resources
     */
    readonly resources?: TenantV2SpecSideCarsContainersResources;
    /**
     * @schema TenantV2SpecSideCarsContainers#securityContext
     */
    readonly securityContext?: TenantV2SpecSideCarsContainersSecurityContext;
    /**
     * @schema TenantV2SpecSideCarsContainers#startupProbe
     */
    readonly startupProbe?: TenantV2SpecSideCarsContainersStartupProbe;
    /**
     * @schema TenantV2SpecSideCarsContainers#stdin
     */
    readonly stdin?: boolean;
    /**
     * @schema TenantV2SpecSideCarsContainers#stdinOnce
     */
    readonly stdinOnce?: boolean;
    /**
     * @schema TenantV2SpecSideCarsContainers#terminationMessagePath
     */
    readonly terminationMessagePath?: string;
    /**
     * @schema TenantV2SpecSideCarsContainers#terminationMessagePolicy
     */
    readonly terminationMessagePolicy?: string;
    /**
     * @schema TenantV2SpecSideCarsContainers#tty
     */
    readonly tty?: boolean;
    /**
     * @schema TenantV2SpecSideCarsContainers#volumeDevices
     */
    readonly volumeDevices?: TenantV2SpecSideCarsContainersVolumeDevices[];
    /**
     * @schema TenantV2SpecSideCarsContainers#volumeMounts
     */
    readonly volumeMounts?: TenantV2SpecSideCarsContainersVolumeMounts[];
    /**
     * @schema TenantV2SpecSideCarsContainers#workingDir
     */
    readonly workingDir?: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainers' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainers(obj: TenantV2SpecSideCarsContainers | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumeClaimTemplates
 */
export interface TenantV2SpecSideCarsVolumeClaimTemplates {
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplates#apiVersion
     */
    readonly apiVersion?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplates#kind
     */
    readonly kind?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplates#metadata
     */
    readonly metadata?: TenantV2SpecSideCarsVolumeClaimTemplatesMetadata;
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplates#spec
     */
    readonly spec?: TenantV2SpecSideCarsVolumeClaimTemplatesSpec;
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplates#status
     */
    readonly status?: TenantV2SpecSideCarsVolumeClaimTemplatesStatus;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumeClaimTemplates' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumeClaimTemplates(obj: TenantV2SpecSideCarsVolumeClaimTemplates | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumes
 */
export interface TenantV2SpecSideCarsVolumes {
    /**
     * @schema TenantV2SpecSideCarsVolumes#awsElasticBlockStore
     */
    readonly awsElasticBlockStore?: TenantV2SpecSideCarsVolumesAwsElasticBlockStore;
    /**
     * @schema TenantV2SpecSideCarsVolumes#azureDisk
     */
    readonly azureDisk?: TenantV2SpecSideCarsVolumesAzureDisk;
    /**
     * @schema TenantV2SpecSideCarsVolumes#azureFile
     */
    readonly azureFile?: TenantV2SpecSideCarsVolumesAzureFile;
    /**
     * @schema TenantV2SpecSideCarsVolumes#cephfs
     */
    readonly cephfs?: TenantV2SpecSideCarsVolumesCephfs;
    /**
     * @schema TenantV2SpecSideCarsVolumes#cinder
     */
    readonly cinder?: TenantV2SpecSideCarsVolumesCinder;
    /**
     * @schema TenantV2SpecSideCarsVolumes#configMap
     */
    readonly configMap?: TenantV2SpecSideCarsVolumesConfigMap;
    /**
     * @schema TenantV2SpecSideCarsVolumes#csi
     */
    readonly csi?: TenantV2SpecSideCarsVolumesCsi;
    /**
     * @schema TenantV2SpecSideCarsVolumes#downwardAPI
     */
    readonly downwardApi?: TenantV2SpecSideCarsVolumesDownwardApi;
    /**
     * @schema TenantV2SpecSideCarsVolumes#emptyDir
     */
    readonly emptyDir?: TenantV2SpecSideCarsVolumesEmptyDir;
    /**
     * @schema TenantV2SpecSideCarsVolumes#ephemeral
     */
    readonly ephemeral?: TenantV2SpecSideCarsVolumesEphemeral;
    /**
     * @schema TenantV2SpecSideCarsVolumes#fc
     */
    readonly fc?: TenantV2SpecSideCarsVolumesFc;
    /**
     * @schema TenantV2SpecSideCarsVolumes#flexVolume
     */
    readonly flexVolume?: TenantV2SpecSideCarsVolumesFlexVolume;
    /**
     * @schema TenantV2SpecSideCarsVolumes#flocker
     */
    readonly flocker?: TenantV2SpecSideCarsVolumesFlocker;
    /**
     * @schema TenantV2SpecSideCarsVolumes#gcePersistentDisk
     */
    readonly gcePersistentDisk?: TenantV2SpecSideCarsVolumesGcePersistentDisk;
    /**
     * @schema TenantV2SpecSideCarsVolumes#gitRepo
     */
    readonly gitRepo?: TenantV2SpecSideCarsVolumesGitRepo;
    /**
     * @schema TenantV2SpecSideCarsVolumes#glusterfs
     */
    readonly glusterfs?: TenantV2SpecSideCarsVolumesGlusterfs;
    /**
     * @schema TenantV2SpecSideCarsVolumes#hostPath
     */
    readonly hostPath?: TenantV2SpecSideCarsVolumesHostPath;
    /**
     * @schema TenantV2SpecSideCarsVolumes#iscsi
     */
    readonly iscsi?: TenantV2SpecSideCarsVolumesIscsi;
    /**
     * @schema TenantV2SpecSideCarsVolumes#name
     */
    readonly name: string;
    /**
     * @schema TenantV2SpecSideCarsVolumes#nfs
     */
    readonly nfs?: TenantV2SpecSideCarsVolumesNfs;
    /**
     * @schema TenantV2SpecSideCarsVolumes#persistentVolumeClaim
     */
    readonly persistentVolumeClaim?: TenantV2SpecSideCarsVolumesPersistentVolumeClaim;
    /**
     * @schema TenantV2SpecSideCarsVolumes#photonPersistentDisk
     */
    readonly photonPersistentDisk?: TenantV2SpecSideCarsVolumesPhotonPersistentDisk;
    /**
     * @schema TenantV2SpecSideCarsVolumes#portworxVolume
     */
    readonly portworxVolume?: TenantV2SpecSideCarsVolumesPortworxVolume;
    /**
     * @schema TenantV2SpecSideCarsVolumes#projected
     */
    readonly projected?: TenantV2SpecSideCarsVolumesProjected;
    /**
     * @schema TenantV2SpecSideCarsVolumes#quobyte
     */
    readonly quobyte?: TenantV2SpecSideCarsVolumesQuobyte;
    /**
     * @schema TenantV2SpecSideCarsVolumes#rbd
     */
    readonly rbd?: TenantV2SpecSideCarsVolumesRbd;
    /**
     * @schema TenantV2SpecSideCarsVolumes#scaleIO
     */
    readonly scaleIo?: TenantV2SpecSideCarsVolumesScaleIo;
    /**
     * @schema TenantV2SpecSideCarsVolumes#secret
     */
    readonly secret?: TenantV2SpecSideCarsVolumesSecret;
    /**
     * @schema TenantV2SpecSideCarsVolumes#storageos
     */
    readonly storageos?: TenantV2SpecSideCarsVolumesStorageos;
    /**
     * @schema TenantV2SpecSideCarsVolumes#vsphereVolume
     */
    readonly vsphereVolume?: TenantV2SpecSideCarsVolumesVsphereVolume;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumes' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumes(obj: TenantV2SpecSideCarsVolumes | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecEnvValueFromConfigMapKeyRef
 */
export interface TenantV2SpecEnvValueFromConfigMapKeyRef {
    /**
     * @schema TenantV2SpecEnvValueFromConfigMapKeyRef#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecEnvValueFromConfigMapKeyRef#name
     */
    readonly name?: string;
    /**
     * @schema TenantV2SpecEnvValueFromConfigMapKeyRef#optional
     */
    readonly optional?: boolean;
}
/**
 * Converts an object of type 'TenantV2SpecEnvValueFromConfigMapKeyRef' to JSON representation.
 */
export declare function toJson_TenantV2SpecEnvValueFromConfigMapKeyRef(obj: TenantV2SpecEnvValueFromConfigMapKeyRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecEnvValueFromFieldRef
 */
export interface TenantV2SpecEnvValueFromFieldRef {
    /**
     * @schema TenantV2SpecEnvValueFromFieldRef#apiVersion
     */
    readonly apiVersion?: string;
    /**
     * @schema TenantV2SpecEnvValueFromFieldRef#fieldPath
     */
    readonly fieldPath: string;
}
/**
 * Converts an object of type 'TenantV2SpecEnvValueFromFieldRef' to JSON representation.
 */
export declare function toJson_TenantV2SpecEnvValueFromFieldRef(obj: TenantV2SpecEnvValueFromFieldRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecEnvValueFromResourceFieldRef
 */
export interface TenantV2SpecEnvValueFromResourceFieldRef {
    /**
     * @schema TenantV2SpecEnvValueFromResourceFieldRef#containerName
     */
    readonly containerName?: string;
    /**
     * @schema TenantV2SpecEnvValueFromResourceFieldRef#divisor
     */
    readonly divisor?: TenantV2SpecEnvValueFromResourceFieldRefDivisor;
    /**
     * @schema TenantV2SpecEnvValueFromResourceFieldRef#resource
     */
    readonly resource: string;
}
/**
 * Converts an object of type 'TenantV2SpecEnvValueFromResourceFieldRef' to JSON representation.
 */
export declare function toJson_TenantV2SpecEnvValueFromResourceFieldRef(obj: TenantV2SpecEnvValueFromResourceFieldRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecEnvValueFromSecretKeyRef
 */
export interface TenantV2SpecEnvValueFromSecretKeyRef {
    /**
     * @schema TenantV2SpecEnvValueFromSecretKeyRef#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecEnvValueFromSecretKeyRef#name
     */
    readonly name?: string;
    /**
     * @schema TenantV2SpecEnvValueFromSecretKeyRef#optional
     */
    readonly optional?: boolean;
}
/**
 * Converts an object of type 'TenantV2SpecEnvValueFromSecretKeyRef' to JSON representation.
 */
export declare function toJson_TenantV2SpecEnvValueFromSecretKeyRef(obj: TenantV2SpecEnvValueFromSecretKeyRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesAffinityNodeAffinity
 */
export interface TenantV2SpecKesAffinityNodeAffinity {
    /**
     * @schema TenantV2SpecKesAffinityNodeAffinity#preferredDuringSchedulingIgnoredDuringExecution
     */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution[];
    /**
     * @schema TenantV2SpecKesAffinityNodeAffinity#requiredDuringSchedulingIgnoredDuringExecution
     */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution;
}
/**
 * Converts an object of type 'TenantV2SpecKesAffinityNodeAffinity' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesAffinityNodeAffinity(obj: TenantV2SpecKesAffinityNodeAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesAffinityPodAffinity
 */
export interface TenantV2SpecKesAffinityPodAffinity {
    /**
     * @schema TenantV2SpecKesAffinityPodAffinity#preferredDuringSchedulingIgnoredDuringExecution
     */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution[];
    /**
     * @schema TenantV2SpecKesAffinityPodAffinity#requiredDuringSchedulingIgnoredDuringExecution
     */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: TenantV2SpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution[];
}
/**
 * Converts an object of type 'TenantV2SpecKesAffinityPodAffinity' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesAffinityPodAffinity(obj: TenantV2SpecKesAffinityPodAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesAffinityPodAntiAffinity
 */
export interface TenantV2SpecKesAffinityPodAntiAffinity {
    /**
     * @schema TenantV2SpecKesAffinityPodAntiAffinity#preferredDuringSchedulingIgnoredDuringExecution
     */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution[];
    /**
     * @schema TenantV2SpecKesAffinityPodAntiAffinity#requiredDuringSchedulingIgnoredDuringExecution
     */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: TenantV2SpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution[];
}
/**
 * Converts an object of type 'TenantV2SpecKesAffinityPodAntiAffinity' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesAffinityPodAntiAffinity(obj: TenantV2SpecKesAffinityPodAntiAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesResourcesLimits
 */
export declare class TenantV2SpecKesResourcesLimits {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecKesResourcesLimits;
    static fromString(value: string): TenantV2SpecKesResourcesLimits;
    private constructor();
}
/**
 * @schema TenantV2SpecKesResourcesRequests
 */
export declare class TenantV2SpecKesResourcesRequests {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecKesResourcesRequests;
    static fromString(value: string): TenantV2SpecKesResourcesRequests;
    private constructor();
}
/**
 * @schema TenantV2SpecKesSecurityContextSeLinuxOptions
 */
export interface TenantV2SpecKesSecurityContextSeLinuxOptions {
    /**
     * @schema TenantV2SpecKesSecurityContextSeLinuxOptions#level
     */
    readonly level?: string;
    /**
     * @schema TenantV2SpecKesSecurityContextSeLinuxOptions#role
     */
    readonly role?: string;
    /**
     * @schema TenantV2SpecKesSecurityContextSeLinuxOptions#type
     */
    readonly type?: string;
    /**
     * @schema TenantV2SpecKesSecurityContextSeLinuxOptions#user
     */
    readonly user?: string;
}
/**
 * Converts an object of type 'TenantV2SpecKesSecurityContextSeLinuxOptions' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesSecurityContextSeLinuxOptions(obj: TenantV2SpecKesSecurityContextSeLinuxOptions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesSecurityContextSeccompProfile
 */
export interface TenantV2SpecKesSecurityContextSeccompProfile {
    /**
     * @schema TenantV2SpecKesSecurityContextSeccompProfile#localhostProfile
     */
    readonly localhostProfile?: string;
    /**
     * @schema TenantV2SpecKesSecurityContextSeccompProfile#type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'TenantV2SpecKesSecurityContextSeccompProfile' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesSecurityContextSeccompProfile(obj: TenantV2SpecKesSecurityContextSeccompProfile | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesSecurityContextSysctls
 */
export interface TenantV2SpecKesSecurityContextSysctls {
    /**
     * @schema TenantV2SpecKesSecurityContextSysctls#name
     */
    readonly name: string;
    /**
     * @schema TenantV2SpecKesSecurityContextSysctls#value
     */
    readonly value: string;
}
/**
 * Converts an object of type 'TenantV2SpecKesSecurityContextSysctls' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesSecurityContextSysctls(obj: TenantV2SpecKesSecurityContextSysctls | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesSecurityContextWindowsOptions
 */
export interface TenantV2SpecKesSecurityContextWindowsOptions {
    /**
     * @schema TenantV2SpecKesSecurityContextWindowsOptions#gmsaCredentialSpec
     */
    readonly gmsaCredentialSpec?: string;
    /**
     * @schema TenantV2SpecKesSecurityContextWindowsOptions#gmsaCredentialSpecName
     */
    readonly gmsaCredentialSpecName?: string;
    /**
     * @schema TenantV2SpecKesSecurityContextWindowsOptions#runAsUserName
     */
    readonly runAsUserName?: string;
}
/**
 * Converts an object of type 'TenantV2SpecKesSecurityContextWindowsOptions' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesSecurityContextWindowsOptions(obj: TenantV2SpecKesSecurityContextWindowsOptions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesTopologySpreadConstraintsLabelSelector
 */
export interface TenantV2SpecKesTopologySpreadConstraintsLabelSelector {
    /**
     * @schema TenantV2SpecKesTopologySpreadConstraintsLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecKesTopologySpreadConstraintsLabelSelectorMatchExpressions[];
    /**
     * @schema TenantV2SpecKesTopologySpreadConstraintsLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantV2SpecKesTopologySpreadConstraintsLabelSelector' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesTopologySpreadConstraintsLabelSelector(obj: TenantV2SpecKesTopologySpreadConstraintsLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLivenessHttpGetHttpHeaders
 */
export interface TenantV2SpecLivenessHttpGetHttpHeaders {
    /**
     * @schema TenantV2SpecLivenessHttpGetHttpHeaders#name
     */
    readonly name: string;
    /**
     * @schema TenantV2SpecLivenessHttpGetHttpHeaders#value
     */
    readonly value: string;
}
/**
 * Converts an object of type 'TenantV2SpecLivenessHttpGetHttpHeaders' to JSON representation.
 */
export declare function toJson_TenantV2SpecLivenessHttpGetHttpHeaders(obj: TenantV2SpecLivenessHttpGetHttpHeaders | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLivenessHttpGetPort
 */
export declare class TenantV2SpecLivenessHttpGetPort {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecLivenessHttpGetPort;
    static fromString(value: string): TenantV2SpecLivenessHttpGetPort;
    private constructor();
}
/**
 * @schema TenantV2SpecLivenessTcpSocketPort
 */
export declare class TenantV2SpecLivenessTcpSocketPort {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecLivenessTcpSocketPort;
    static fromString(value: string): TenantV2SpecLivenessTcpSocketPort;
    private constructor();
}
/**
 * @schema TenantV2SpecLogAffinityNodeAffinity
 */
export interface TenantV2SpecLogAffinityNodeAffinity {
    /**
     * @schema TenantV2SpecLogAffinityNodeAffinity#preferredDuringSchedulingIgnoredDuringExecution
     */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution[];
    /**
     * @schema TenantV2SpecLogAffinityNodeAffinity#requiredDuringSchedulingIgnoredDuringExecution
     */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution;
}
/**
 * Converts an object of type 'TenantV2SpecLogAffinityNodeAffinity' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogAffinityNodeAffinity(obj: TenantV2SpecLogAffinityNodeAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogAffinityPodAffinity
 */
export interface TenantV2SpecLogAffinityPodAffinity {
    /**
     * @schema TenantV2SpecLogAffinityPodAffinity#preferredDuringSchedulingIgnoredDuringExecution
     */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution[];
    /**
     * @schema TenantV2SpecLogAffinityPodAffinity#requiredDuringSchedulingIgnoredDuringExecution
     */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: TenantV2SpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution[];
}
/**
 * Converts an object of type 'TenantV2SpecLogAffinityPodAffinity' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogAffinityPodAffinity(obj: TenantV2SpecLogAffinityPodAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogAffinityPodAntiAffinity
 */
export interface TenantV2SpecLogAffinityPodAntiAffinity {
    /**
     * @schema TenantV2SpecLogAffinityPodAntiAffinity#preferredDuringSchedulingIgnoredDuringExecution
     */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution[];
    /**
     * @schema TenantV2SpecLogAffinityPodAntiAffinity#requiredDuringSchedulingIgnoredDuringExecution
     */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: TenantV2SpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution[];
}
/**
 * Converts an object of type 'TenantV2SpecLogAffinityPodAntiAffinity' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogAffinityPodAntiAffinity(obj: TenantV2SpecLogAffinityPodAntiAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbAffinity
 */
export interface TenantV2SpecLogDbAffinity {
    /**
     * @schema TenantV2SpecLogDbAffinity#nodeAffinity
     */
    readonly nodeAffinity?: TenantV2SpecLogDbAffinityNodeAffinity;
    /**
     * @schema TenantV2SpecLogDbAffinity#podAffinity
     */
    readonly podAffinity?: TenantV2SpecLogDbAffinityPodAffinity;
    /**
     * @schema TenantV2SpecLogDbAffinity#podAntiAffinity
     */
    readonly podAntiAffinity?: TenantV2SpecLogDbAffinityPodAntiAffinity;
}
/**
 * Converts an object of type 'TenantV2SpecLogDbAffinity' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbAffinity(obj: TenantV2SpecLogDbAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbResources
 */
export interface TenantV2SpecLogDbResources {
    /**
     * @schema TenantV2SpecLogDbResources#limits
     */
    readonly limits?: {
        [key: string]: TenantV2SpecLogDbResourcesLimits;
    };
    /**
     * @schema TenantV2SpecLogDbResources#requests
     */
    readonly requests?: {
        [key: string]: TenantV2SpecLogDbResourcesRequests;
    };
}
/**
 * Converts an object of type 'TenantV2SpecLogDbResources' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbResources(obj: TenantV2SpecLogDbResources | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbSecurityContext
 */
export interface TenantV2SpecLogDbSecurityContext {
    /**
     * @schema TenantV2SpecLogDbSecurityContext#fsGroup
     */
    readonly fsGroup?: number;
    /**
     * @schema TenantV2SpecLogDbSecurityContext#fsGroupChangePolicy
     */
    readonly fsGroupChangePolicy?: string;
    /**
     * @schema TenantV2SpecLogDbSecurityContext#runAsGroup
     */
    readonly runAsGroup?: number;
    /**
     * @schema TenantV2SpecLogDbSecurityContext#runAsNonRoot
     */
    readonly runAsNonRoot?: boolean;
    /**
     * @schema TenantV2SpecLogDbSecurityContext#runAsUser
     */
    readonly runAsUser?: number;
    /**
     * @schema TenantV2SpecLogDbSecurityContext#seLinuxOptions
     */
    readonly seLinuxOptions?: TenantV2SpecLogDbSecurityContextSeLinuxOptions;
    /**
     * @schema TenantV2SpecLogDbSecurityContext#seccompProfile
     */
    readonly seccompProfile?: TenantV2SpecLogDbSecurityContextSeccompProfile;
    /**
     * @schema TenantV2SpecLogDbSecurityContext#supplementalGroups
     */
    readonly supplementalGroups?: number[];
    /**
     * @schema TenantV2SpecLogDbSecurityContext#sysctls
     */
    readonly sysctls?: TenantV2SpecLogDbSecurityContextSysctls[];
    /**
     * @schema TenantV2SpecLogDbSecurityContext#windowsOptions
     */
    readonly windowsOptions?: TenantV2SpecLogDbSecurityContextWindowsOptions;
}
/**
 * Converts an object of type 'TenantV2SpecLogDbSecurityContext' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbSecurityContext(obj: TenantV2SpecLogDbSecurityContext | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbTolerations
 */
export interface TenantV2SpecLogDbTolerations {
    /**
     * @schema TenantV2SpecLogDbTolerations#effect
     */
    readonly effect?: string;
    /**
     * @schema TenantV2SpecLogDbTolerations#key
     */
    readonly key?: string;
    /**
     * @schema TenantV2SpecLogDbTolerations#operator
     */
    readonly operator?: string;
    /**
     * @schema TenantV2SpecLogDbTolerations#tolerationSeconds
     */
    readonly tolerationSeconds?: number;
    /**
     * @schema TenantV2SpecLogDbTolerations#value
     */
    readonly value?: string;
}
/**
 * Converts an object of type 'TenantV2SpecLogDbTolerations' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbTolerations(obj: TenantV2SpecLogDbTolerations | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbTopologySpreadConstraints
 */
export interface TenantV2SpecLogDbTopologySpreadConstraints {
    /**
     * @schema TenantV2SpecLogDbTopologySpreadConstraints#labelSelector
     */
    readonly labelSelector?: TenantV2SpecLogDbTopologySpreadConstraintsLabelSelector;
    /**
     * @schema TenantV2SpecLogDbTopologySpreadConstraints#maxSkew
     */
    readonly maxSkew: number;
    /**
     * @schema TenantV2SpecLogDbTopologySpreadConstraints#topologyKey
     */
    readonly topologyKey: string;
    /**
     * @schema TenantV2SpecLogDbTopologySpreadConstraints#whenUnsatisfiable
     */
    readonly whenUnsatisfiable: string;
}
/**
 * Converts an object of type 'TenantV2SpecLogDbTopologySpreadConstraints' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbTopologySpreadConstraints(obj: TenantV2SpecLogDbTopologySpreadConstraints | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbVolumeClaimTemplate
 */
export interface TenantV2SpecLogDbVolumeClaimTemplate {
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplate#apiVersion
     */
    readonly apiVersion?: string;
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplate#kind
     */
    readonly kind?: string;
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplate#metadata
     */
    readonly metadata?: TenantV2SpecLogDbVolumeClaimTemplateMetadata;
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplate#spec
     */
    readonly spec?: TenantV2SpecLogDbVolumeClaimTemplateSpec;
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplate#status
     */
    readonly status?: TenantV2SpecLogDbVolumeClaimTemplateStatus;
}
/**
 * Converts an object of type 'TenantV2SpecLogDbVolumeClaimTemplate' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbVolumeClaimTemplate(obj: TenantV2SpecLogDbVolumeClaimTemplate | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogResourcesLimits
 */
export declare class TenantV2SpecLogResourcesLimits {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecLogResourcesLimits;
    static fromString(value: string): TenantV2SpecLogResourcesLimits;
    private constructor();
}
/**
 * @schema TenantV2SpecLogResourcesRequests
 */
export declare class TenantV2SpecLogResourcesRequests {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecLogResourcesRequests;
    static fromString(value: string): TenantV2SpecLogResourcesRequests;
    private constructor();
}
/**
 * @schema TenantV2SpecLogSecurityContextSeLinuxOptions
 */
export interface TenantV2SpecLogSecurityContextSeLinuxOptions {
    /**
     * @schema TenantV2SpecLogSecurityContextSeLinuxOptions#level
     */
    readonly level?: string;
    /**
     * @schema TenantV2SpecLogSecurityContextSeLinuxOptions#role
     */
    readonly role?: string;
    /**
     * @schema TenantV2SpecLogSecurityContextSeLinuxOptions#type
     */
    readonly type?: string;
    /**
     * @schema TenantV2SpecLogSecurityContextSeLinuxOptions#user
     */
    readonly user?: string;
}
/**
 * Converts an object of type 'TenantV2SpecLogSecurityContextSeLinuxOptions' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogSecurityContextSeLinuxOptions(obj: TenantV2SpecLogSecurityContextSeLinuxOptions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogSecurityContextSeccompProfile
 */
export interface TenantV2SpecLogSecurityContextSeccompProfile {
    /**
     * @schema TenantV2SpecLogSecurityContextSeccompProfile#localhostProfile
     */
    readonly localhostProfile?: string;
    /**
     * @schema TenantV2SpecLogSecurityContextSeccompProfile#type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'TenantV2SpecLogSecurityContextSeccompProfile' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogSecurityContextSeccompProfile(obj: TenantV2SpecLogSecurityContextSeccompProfile | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogSecurityContextSysctls
 */
export interface TenantV2SpecLogSecurityContextSysctls {
    /**
     * @schema TenantV2SpecLogSecurityContextSysctls#name
     */
    readonly name: string;
    /**
     * @schema TenantV2SpecLogSecurityContextSysctls#value
     */
    readonly value: string;
}
/**
 * Converts an object of type 'TenantV2SpecLogSecurityContextSysctls' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogSecurityContextSysctls(obj: TenantV2SpecLogSecurityContextSysctls | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogSecurityContextWindowsOptions
 */
export interface TenantV2SpecLogSecurityContextWindowsOptions {
    /**
     * @schema TenantV2SpecLogSecurityContextWindowsOptions#gmsaCredentialSpec
     */
    readonly gmsaCredentialSpec?: string;
    /**
     * @schema TenantV2SpecLogSecurityContextWindowsOptions#gmsaCredentialSpecName
     */
    readonly gmsaCredentialSpecName?: string;
    /**
     * @schema TenantV2SpecLogSecurityContextWindowsOptions#runAsUserName
     */
    readonly runAsUserName?: string;
}
/**
 * Converts an object of type 'TenantV2SpecLogSecurityContextWindowsOptions' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogSecurityContextWindowsOptions(obj: TenantV2SpecLogSecurityContextWindowsOptions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogTopologySpreadConstraintsLabelSelector
 */
export interface TenantV2SpecLogTopologySpreadConstraintsLabelSelector {
    /**
     * @schema TenantV2SpecLogTopologySpreadConstraintsLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecLogTopologySpreadConstraintsLabelSelectorMatchExpressions[];
    /**
     * @schema TenantV2SpecLogTopologySpreadConstraintsLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantV2SpecLogTopologySpreadConstraintsLabelSelector' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogTopologySpreadConstraintsLabelSelector(obj: TenantV2SpecLogTopologySpreadConstraintsLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsAffinityNodeAffinity
 */
export interface TenantV2SpecPoolsAffinityNodeAffinity {
    /**
     * @schema TenantV2SpecPoolsAffinityNodeAffinity#preferredDuringSchedulingIgnoredDuringExecution
     */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution[];
    /**
     * @schema TenantV2SpecPoolsAffinityNodeAffinity#requiredDuringSchedulingIgnoredDuringExecution
     */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution;
}
/**
 * Converts an object of type 'TenantV2SpecPoolsAffinityNodeAffinity' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsAffinityNodeAffinity(obj: TenantV2SpecPoolsAffinityNodeAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsAffinityPodAffinity
 */
export interface TenantV2SpecPoolsAffinityPodAffinity {
    /**
     * @schema TenantV2SpecPoolsAffinityPodAffinity#preferredDuringSchedulingIgnoredDuringExecution
     */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution[];
    /**
     * @schema TenantV2SpecPoolsAffinityPodAffinity#requiredDuringSchedulingIgnoredDuringExecution
     */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: TenantV2SpecPoolsAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution[];
}
/**
 * Converts an object of type 'TenantV2SpecPoolsAffinityPodAffinity' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsAffinityPodAffinity(obj: TenantV2SpecPoolsAffinityPodAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsAffinityPodAntiAffinity
 */
export interface TenantV2SpecPoolsAffinityPodAntiAffinity {
    /**
     * @schema TenantV2SpecPoolsAffinityPodAntiAffinity#preferredDuringSchedulingIgnoredDuringExecution
     */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution[];
    /**
     * @schema TenantV2SpecPoolsAffinityPodAntiAffinity#requiredDuringSchedulingIgnoredDuringExecution
     */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: TenantV2SpecPoolsAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution[];
}
/**
 * Converts an object of type 'TenantV2SpecPoolsAffinityPodAntiAffinity' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsAffinityPodAntiAffinity(obj: TenantV2SpecPoolsAffinityPodAntiAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsResourcesLimits
 */
export declare class TenantV2SpecPoolsResourcesLimits {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecPoolsResourcesLimits;
    static fromString(value: string): TenantV2SpecPoolsResourcesLimits;
    private constructor();
}
/**
 * @schema TenantV2SpecPoolsResourcesRequests
 */
export declare class TenantV2SpecPoolsResourcesRequests {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecPoolsResourcesRequests;
    static fromString(value: string): TenantV2SpecPoolsResourcesRequests;
    private constructor();
}
/**
 * @schema TenantV2SpecPoolsSecurityContextSeLinuxOptions
 */
export interface TenantV2SpecPoolsSecurityContextSeLinuxOptions {
    /**
     * @schema TenantV2SpecPoolsSecurityContextSeLinuxOptions#level
     */
    readonly level?: string;
    /**
     * @schema TenantV2SpecPoolsSecurityContextSeLinuxOptions#role
     */
    readonly role?: string;
    /**
     * @schema TenantV2SpecPoolsSecurityContextSeLinuxOptions#type
     */
    readonly type?: string;
    /**
     * @schema TenantV2SpecPoolsSecurityContextSeLinuxOptions#user
     */
    readonly user?: string;
}
/**
 * Converts an object of type 'TenantV2SpecPoolsSecurityContextSeLinuxOptions' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsSecurityContextSeLinuxOptions(obj: TenantV2SpecPoolsSecurityContextSeLinuxOptions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsSecurityContextSeccompProfile
 */
export interface TenantV2SpecPoolsSecurityContextSeccompProfile {
    /**
     * @schema TenantV2SpecPoolsSecurityContextSeccompProfile#localhostProfile
     */
    readonly localhostProfile?: string;
    /**
     * @schema TenantV2SpecPoolsSecurityContextSeccompProfile#type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'TenantV2SpecPoolsSecurityContextSeccompProfile' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsSecurityContextSeccompProfile(obj: TenantV2SpecPoolsSecurityContextSeccompProfile | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsSecurityContextSysctls
 */
export interface TenantV2SpecPoolsSecurityContextSysctls {
    /**
     * @schema TenantV2SpecPoolsSecurityContextSysctls#name
     */
    readonly name: string;
    /**
     * @schema TenantV2SpecPoolsSecurityContextSysctls#value
     */
    readonly value: string;
}
/**
 * Converts an object of type 'TenantV2SpecPoolsSecurityContextSysctls' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsSecurityContextSysctls(obj: TenantV2SpecPoolsSecurityContextSysctls | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsSecurityContextWindowsOptions
 */
export interface TenantV2SpecPoolsSecurityContextWindowsOptions {
    /**
     * @schema TenantV2SpecPoolsSecurityContextWindowsOptions#gmsaCredentialSpec
     */
    readonly gmsaCredentialSpec?: string;
    /**
     * @schema TenantV2SpecPoolsSecurityContextWindowsOptions#gmsaCredentialSpecName
     */
    readonly gmsaCredentialSpecName?: string;
    /**
     * @schema TenantV2SpecPoolsSecurityContextWindowsOptions#runAsUserName
     */
    readonly runAsUserName?: string;
}
/**
 * Converts an object of type 'TenantV2SpecPoolsSecurityContextWindowsOptions' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsSecurityContextWindowsOptions(obj: TenantV2SpecPoolsSecurityContextWindowsOptions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsTopologySpreadConstraintsLabelSelector
 */
export interface TenantV2SpecPoolsTopologySpreadConstraintsLabelSelector {
    /**
     * @schema TenantV2SpecPoolsTopologySpreadConstraintsLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecPoolsTopologySpreadConstraintsLabelSelectorMatchExpressions[];
    /**
     * @schema TenantV2SpecPoolsTopologySpreadConstraintsLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantV2SpecPoolsTopologySpreadConstraintsLabelSelector' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsTopologySpreadConstraintsLabelSelector(obj: TenantV2SpecPoolsTopologySpreadConstraintsLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsVolumeClaimTemplateMetadata
 */
export interface TenantV2SpecPoolsVolumeClaimTemplateMetadata {
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplateMetadata#annotations
     */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplateMetadata#finalizers
     */
    readonly finalizers?: string[];
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplateMetadata#labels
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplateMetadata#name
     */
    readonly name?: string;
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplateMetadata#namespace
     */
    readonly namespace?: string;
}
/**
 * Converts an object of type 'TenantV2SpecPoolsVolumeClaimTemplateMetadata' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsVolumeClaimTemplateMetadata(obj: TenantV2SpecPoolsVolumeClaimTemplateMetadata | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsVolumeClaimTemplateSpec
 */
export interface TenantV2SpecPoolsVolumeClaimTemplateSpec {
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplateSpec#accessModes
     */
    readonly accessModes?: string[];
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplateSpec#dataSource
     */
    readonly dataSource?: TenantV2SpecPoolsVolumeClaimTemplateSpecDataSource;
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplateSpec#resources
     */
    readonly resources?: TenantV2SpecPoolsVolumeClaimTemplateSpecResources;
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplateSpec#selector
     */
    readonly selector?: TenantV2SpecPoolsVolumeClaimTemplateSpecSelector;
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplateSpec#storageClassName
     */
    readonly storageClassName?: string;
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplateSpec#volumeMode
     */
    readonly volumeMode?: string;
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplateSpec#volumeName
     */
    readonly volumeName?: string;
}
/**
 * Converts an object of type 'TenantV2SpecPoolsVolumeClaimTemplateSpec' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsVolumeClaimTemplateSpec(obj: TenantV2SpecPoolsVolumeClaimTemplateSpec | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsVolumeClaimTemplateStatus
 */
export interface TenantV2SpecPoolsVolumeClaimTemplateStatus {
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplateStatus#accessModes
     */
    readonly accessModes?: string[];
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplateStatus#capacity
     */
    readonly capacity?: {
        [key: string]: TenantV2SpecPoolsVolumeClaimTemplateStatusCapacity;
    };
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplateStatus#conditions
     */
    readonly conditions?: TenantV2SpecPoolsVolumeClaimTemplateStatusConditions[];
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplateStatus#phase
     */
    readonly phase?: string;
}
/**
 * Converts an object of type 'TenantV2SpecPoolsVolumeClaimTemplateStatus' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsVolumeClaimTemplateStatus(obj: TenantV2SpecPoolsVolumeClaimTemplateStatus | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusAffinityNodeAffinity
 */
export interface TenantV2SpecPrometheusAffinityNodeAffinity {
    /**
     * @schema TenantV2SpecPrometheusAffinityNodeAffinity#preferredDuringSchedulingIgnoredDuringExecution
     */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution[];
    /**
     * @schema TenantV2SpecPrometheusAffinityNodeAffinity#requiredDuringSchedulingIgnoredDuringExecution
     */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution;
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusAffinityNodeAffinity' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusAffinityNodeAffinity(obj: TenantV2SpecPrometheusAffinityNodeAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusAffinityPodAffinity
 */
export interface TenantV2SpecPrometheusAffinityPodAffinity {
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAffinity#preferredDuringSchedulingIgnoredDuringExecution
     */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution[];
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAffinity#requiredDuringSchedulingIgnoredDuringExecution
     */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: TenantV2SpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution[];
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusAffinityPodAffinity' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusAffinityPodAffinity(obj: TenantV2SpecPrometheusAffinityPodAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusAffinityPodAntiAffinity
 */
export interface TenantV2SpecPrometheusAffinityPodAntiAffinity {
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAntiAffinity#preferredDuringSchedulingIgnoredDuringExecution
     */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution[];
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAntiAffinity#requiredDuringSchedulingIgnoredDuringExecution
     */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: TenantV2SpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution[];
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusAffinityPodAntiAffinity' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusAffinityPodAntiAffinity(obj: TenantV2SpecPrometheusAffinityPodAntiAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusResourcesLimits
 */
export declare class TenantV2SpecPrometheusResourcesLimits {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecPrometheusResourcesLimits;
    static fromString(value: string): TenantV2SpecPrometheusResourcesLimits;
    private constructor();
}
/**
 * @schema TenantV2SpecPrometheusResourcesRequests
 */
export declare class TenantV2SpecPrometheusResourcesRequests {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecPrometheusResourcesRequests;
    static fromString(value: string): TenantV2SpecPrometheusResourcesRequests;
    private constructor();
}
/**
 * @schema TenantV2SpecPrometheusSecurityContextSeLinuxOptions
 */
export interface TenantV2SpecPrometheusSecurityContextSeLinuxOptions {
    /**
     * @schema TenantV2SpecPrometheusSecurityContextSeLinuxOptions#level
     */
    readonly level?: string;
    /**
     * @schema TenantV2SpecPrometheusSecurityContextSeLinuxOptions#role
     */
    readonly role?: string;
    /**
     * @schema TenantV2SpecPrometheusSecurityContextSeLinuxOptions#type
     */
    readonly type?: string;
    /**
     * @schema TenantV2SpecPrometheusSecurityContextSeLinuxOptions#user
     */
    readonly user?: string;
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusSecurityContextSeLinuxOptions' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusSecurityContextSeLinuxOptions(obj: TenantV2SpecPrometheusSecurityContextSeLinuxOptions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusSecurityContextSeccompProfile
 */
export interface TenantV2SpecPrometheusSecurityContextSeccompProfile {
    /**
     * @schema TenantV2SpecPrometheusSecurityContextSeccompProfile#localhostProfile
     */
    readonly localhostProfile?: string;
    /**
     * @schema TenantV2SpecPrometheusSecurityContextSeccompProfile#type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusSecurityContextSeccompProfile' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusSecurityContextSeccompProfile(obj: TenantV2SpecPrometheusSecurityContextSeccompProfile | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusSecurityContextSysctls
 */
export interface TenantV2SpecPrometheusSecurityContextSysctls {
    /**
     * @schema TenantV2SpecPrometheusSecurityContextSysctls#name
     */
    readonly name: string;
    /**
     * @schema TenantV2SpecPrometheusSecurityContextSysctls#value
     */
    readonly value: string;
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusSecurityContextSysctls' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusSecurityContextSysctls(obj: TenantV2SpecPrometheusSecurityContextSysctls | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusSecurityContextWindowsOptions
 */
export interface TenantV2SpecPrometheusSecurityContextWindowsOptions {
    /**
     * @schema TenantV2SpecPrometheusSecurityContextWindowsOptions#gmsaCredentialSpec
     */
    readonly gmsaCredentialSpec?: string;
    /**
     * @schema TenantV2SpecPrometheusSecurityContextWindowsOptions#gmsaCredentialSpecName
     */
    readonly gmsaCredentialSpecName?: string;
    /**
     * @schema TenantV2SpecPrometheusSecurityContextWindowsOptions#runAsUserName
     */
    readonly runAsUserName?: string;
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusSecurityContextWindowsOptions' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusSecurityContextWindowsOptions(obj: TenantV2SpecPrometheusSecurityContextWindowsOptions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusTopologySpreadConstraintsLabelSelector
 */
export interface TenantV2SpecPrometheusTopologySpreadConstraintsLabelSelector {
    /**
     * @schema TenantV2SpecPrometheusTopologySpreadConstraintsLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecPrometheusTopologySpreadConstraintsLabelSelectorMatchExpressions[];
    /**
     * @schema TenantV2SpecPrometheusTopologySpreadConstraintsLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusTopologySpreadConstraintsLabelSelector' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusTopologySpreadConstraintsLabelSelector(obj: TenantV2SpecPrometheusTopologySpreadConstraintsLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecReadinessHttpGetHttpHeaders
 */
export interface TenantV2SpecReadinessHttpGetHttpHeaders {
    /**
     * @schema TenantV2SpecReadinessHttpGetHttpHeaders#name
     */
    readonly name: string;
    /**
     * @schema TenantV2SpecReadinessHttpGetHttpHeaders#value
     */
    readonly value: string;
}
/**
 * Converts an object of type 'TenantV2SpecReadinessHttpGetHttpHeaders' to JSON representation.
 */
export declare function toJson_TenantV2SpecReadinessHttpGetHttpHeaders(obj: TenantV2SpecReadinessHttpGetHttpHeaders | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecReadinessHttpGetPort
 */
export declare class TenantV2SpecReadinessHttpGetPort {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecReadinessHttpGetPort;
    static fromString(value: string): TenantV2SpecReadinessHttpGetPort;
    private constructor();
}
/**
 * @schema TenantV2SpecReadinessTcpSocketPort
 */
export declare class TenantV2SpecReadinessTcpSocketPort {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecReadinessTcpSocketPort;
    static fromString(value: string): TenantV2SpecReadinessTcpSocketPort;
    private constructor();
}
/**
 * @schema TenantV2SpecSideCarsContainersEnv
 */
export interface TenantV2SpecSideCarsContainersEnv {
    /**
     * @schema TenantV2SpecSideCarsContainersEnv#name
     */
    readonly name: string;
    /**
     * @schema TenantV2SpecSideCarsContainersEnv#value
     */
    readonly value?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersEnv#valueFrom
     */
    readonly valueFrom?: TenantV2SpecSideCarsContainersEnvValueFrom;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersEnv' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersEnv(obj: TenantV2SpecSideCarsContainersEnv | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersEnvFrom
 */
export interface TenantV2SpecSideCarsContainersEnvFrom {
    /**
     * @schema TenantV2SpecSideCarsContainersEnvFrom#configMapRef
     */
    readonly configMapRef?: TenantV2SpecSideCarsContainersEnvFromConfigMapRef;
    /**
     * @schema TenantV2SpecSideCarsContainersEnvFrom#prefix
     */
    readonly prefix?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersEnvFrom#secretRef
     */
    readonly secretRef?: TenantV2SpecSideCarsContainersEnvFromSecretRef;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersEnvFrom' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersEnvFrom(obj: TenantV2SpecSideCarsContainersEnvFrom | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersLifecycle
 */
export interface TenantV2SpecSideCarsContainersLifecycle {
    /**
     * @schema TenantV2SpecSideCarsContainersLifecycle#postStart
     */
    readonly postStart?: TenantV2SpecSideCarsContainersLifecyclePostStart;
    /**
     * @schema TenantV2SpecSideCarsContainersLifecycle#preStop
     */
    readonly preStop?: TenantV2SpecSideCarsContainersLifecyclePreStop;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersLifecycle' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersLifecycle(obj: TenantV2SpecSideCarsContainersLifecycle | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersLivenessProbe
 */
export interface TenantV2SpecSideCarsContainersLivenessProbe {
    /**
     * @schema TenantV2SpecSideCarsContainersLivenessProbe#exec
     */
    readonly exec?: TenantV2SpecSideCarsContainersLivenessProbeExec;
    /**
     * @schema TenantV2SpecSideCarsContainersLivenessProbe#failureThreshold
     */
    readonly failureThreshold?: number;
    /**
     * @schema TenantV2SpecSideCarsContainersLivenessProbe#httpGet
     */
    readonly httpGet?: TenantV2SpecSideCarsContainersLivenessProbeHttpGet;
    /**
     * @schema TenantV2SpecSideCarsContainersLivenessProbe#initialDelaySeconds
     */
    readonly initialDelaySeconds?: number;
    /**
     * @schema TenantV2SpecSideCarsContainersLivenessProbe#periodSeconds
     */
    readonly periodSeconds?: number;
    /**
     * @schema TenantV2SpecSideCarsContainersLivenessProbe#successThreshold
     */
    readonly successThreshold?: number;
    /**
     * @schema TenantV2SpecSideCarsContainersLivenessProbe#tcpSocket
     */
    readonly tcpSocket?: TenantV2SpecSideCarsContainersLivenessProbeTcpSocket;
    /**
     * @schema TenantV2SpecSideCarsContainersLivenessProbe#timeoutSeconds
     */
    readonly timeoutSeconds?: number;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersLivenessProbe' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersLivenessProbe(obj: TenantV2SpecSideCarsContainersLivenessProbe | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersPorts
 */
export interface TenantV2SpecSideCarsContainersPorts {
    /**
     * @schema TenantV2SpecSideCarsContainersPorts#containerPort
     */
    readonly containerPort: number;
    /**
     * @schema TenantV2SpecSideCarsContainersPorts#hostIP
     */
    readonly hostIp?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersPorts#hostPort
     */
    readonly hostPort?: number;
    /**
     * @schema TenantV2SpecSideCarsContainersPorts#name
     */
    readonly name?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersPorts#protocol
     */
    readonly protocol?: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersPorts' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersPorts(obj: TenantV2SpecSideCarsContainersPorts | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersReadinessProbe
 */
export interface TenantV2SpecSideCarsContainersReadinessProbe {
    /**
     * @schema TenantV2SpecSideCarsContainersReadinessProbe#exec
     */
    readonly exec?: TenantV2SpecSideCarsContainersReadinessProbeExec;
    /**
     * @schema TenantV2SpecSideCarsContainersReadinessProbe#failureThreshold
     */
    readonly failureThreshold?: number;
    /**
     * @schema TenantV2SpecSideCarsContainersReadinessProbe#httpGet
     */
    readonly httpGet?: TenantV2SpecSideCarsContainersReadinessProbeHttpGet;
    /**
     * @schema TenantV2SpecSideCarsContainersReadinessProbe#initialDelaySeconds
     */
    readonly initialDelaySeconds?: number;
    /**
     * @schema TenantV2SpecSideCarsContainersReadinessProbe#periodSeconds
     */
    readonly periodSeconds?: number;
    /**
     * @schema TenantV2SpecSideCarsContainersReadinessProbe#successThreshold
     */
    readonly successThreshold?: number;
    /**
     * @schema TenantV2SpecSideCarsContainersReadinessProbe#tcpSocket
     */
    readonly tcpSocket?: TenantV2SpecSideCarsContainersReadinessProbeTcpSocket;
    /**
     * @schema TenantV2SpecSideCarsContainersReadinessProbe#timeoutSeconds
     */
    readonly timeoutSeconds?: number;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersReadinessProbe' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersReadinessProbe(obj: TenantV2SpecSideCarsContainersReadinessProbe | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersResources
 */
export interface TenantV2SpecSideCarsContainersResources {
    /**
     * @schema TenantV2SpecSideCarsContainersResources#limits
     */
    readonly limits?: {
        [key: string]: TenantV2SpecSideCarsContainersResourcesLimits;
    };
    /**
     * @schema TenantV2SpecSideCarsContainersResources#requests
     */
    readonly requests?: {
        [key: string]: TenantV2SpecSideCarsContainersResourcesRequests;
    };
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersResources' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersResources(obj: TenantV2SpecSideCarsContainersResources | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersSecurityContext
 */
export interface TenantV2SpecSideCarsContainersSecurityContext {
    /**
     * @schema TenantV2SpecSideCarsContainersSecurityContext#allowPrivilegeEscalation
     */
    readonly allowPrivilegeEscalation?: boolean;
    /**
     * @schema TenantV2SpecSideCarsContainersSecurityContext#capabilities
     */
    readonly capabilities?: TenantV2SpecSideCarsContainersSecurityContextCapabilities;
    /**
     * @schema TenantV2SpecSideCarsContainersSecurityContext#privileged
     */
    readonly privileged?: boolean;
    /**
     * @schema TenantV2SpecSideCarsContainersSecurityContext#procMount
     */
    readonly procMount?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersSecurityContext#readOnlyRootFilesystem
     */
    readonly readOnlyRootFilesystem?: boolean;
    /**
     * @schema TenantV2SpecSideCarsContainersSecurityContext#runAsGroup
     */
    readonly runAsGroup?: number;
    /**
     * @schema TenantV2SpecSideCarsContainersSecurityContext#runAsNonRoot
     */
    readonly runAsNonRoot?: boolean;
    /**
     * @schema TenantV2SpecSideCarsContainersSecurityContext#runAsUser
     */
    readonly runAsUser?: number;
    /**
     * @schema TenantV2SpecSideCarsContainersSecurityContext#seLinuxOptions
     */
    readonly seLinuxOptions?: TenantV2SpecSideCarsContainersSecurityContextSeLinuxOptions;
    /**
     * @schema TenantV2SpecSideCarsContainersSecurityContext#seccompProfile
     */
    readonly seccompProfile?: TenantV2SpecSideCarsContainersSecurityContextSeccompProfile;
    /**
     * @schema TenantV2SpecSideCarsContainersSecurityContext#windowsOptions
     */
    readonly windowsOptions?: TenantV2SpecSideCarsContainersSecurityContextWindowsOptions;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersSecurityContext' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersSecurityContext(obj: TenantV2SpecSideCarsContainersSecurityContext | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersStartupProbe
 */
export interface TenantV2SpecSideCarsContainersStartupProbe {
    /**
     * @schema TenantV2SpecSideCarsContainersStartupProbe#exec
     */
    readonly exec?: TenantV2SpecSideCarsContainersStartupProbeExec;
    /**
     * @schema TenantV2SpecSideCarsContainersStartupProbe#failureThreshold
     */
    readonly failureThreshold?: number;
    /**
     * @schema TenantV2SpecSideCarsContainersStartupProbe#httpGet
     */
    readonly httpGet?: TenantV2SpecSideCarsContainersStartupProbeHttpGet;
    /**
     * @schema TenantV2SpecSideCarsContainersStartupProbe#initialDelaySeconds
     */
    readonly initialDelaySeconds?: number;
    /**
     * @schema TenantV2SpecSideCarsContainersStartupProbe#periodSeconds
     */
    readonly periodSeconds?: number;
    /**
     * @schema TenantV2SpecSideCarsContainersStartupProbe#successThreshold
     */
    readonly successThreshold?: number;
    /**
     * @schema TenantV2SpecSideCarsContainersStartupProbe#tcpSocket
     */
    readonly tcpSocket?: TenantV2SpecSideCarsContainersStartupProbeTcpSocket;
    /**
     * @schema TenantV2SpecSideCarsContainersStartupProbe#timeoutSeconds
     */
    readonly timeoutSeconds?: number;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersStartupProbe' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersStartupProbe(obj: TenantV2SpecSideCarsContainersStartupProbe | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersVolumeDevices
 */
export interface TenantV2SpecSideCarsContainersVolumeDevices {
    /**
     * @schema TenantV2SpecSideCarsContainersVolumeDevices#devicePath
     */
    readonly devicePath: string;
    /**
     * @schema TenantV2SpecSideCarsContainersVolumeDevices#name
     */
    readonly name: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersVolumeDevices' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersVolumeDevices(obj: TenantV2SpecSideCarsContainersVolumeDevices | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersVolumeMounts
 */
export interface TenantV2SpecSideCarsContainersVolumeMounts {
    /**
     * @schema TenantV2SpecSideCarsContainersVolumeMounts#mountPath
     */
    readonly mountPath: string;
    /**
     * @schema TenantV2SpecSideCarsContainersVolumeMounts#mountPropagation
     */
    readonly mountPropagation?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersVolumeMounts#name
     */
    readonly name: string;
    /**
     * @schema TenantV2SpecSideCarsContainersVolumeMounts#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * @schema TenantV2SpecSideCarsContainersVolumeMounts#subPath
     */
    readonly subPath?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersVolumeMounts#subPathExpr
     */
    readonly subPathExpr?: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersVolumeMounts' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersVolumeMounts(obj: TenantV2SpecSideCarsContainersVolumeMounts | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumeClaimTemplatesMetadata
 */
export interface TenantV2SpecSideCarsVolumeClaimTemplatesMetadata {
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplatesMetadata#annotations
     */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplatesMetadata#finalizers
     */
    readonly finalizers?: string[];
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplatesMetadata#labels
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplatesMetadata#name
     */
    readonly name?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplatesMetadata#namespace
     */
    readonly namespace?: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumeClaimTemplatesMetadata' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumeClaimTemplatesMetadata(obj: TenantV2SpecSideCarsVolumeClaimTemplatesMetadata | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumeClaimTemplatesSpec
 */
export interface TenantV2SpecSideCarsVolumeClaimTemplatesSpec {
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplatesSpec#accessModes
     */
    readonly accessModes?: string[];
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplatesSpec#dataSource
     */
    readonly dataSource?: TenantV2SpecSideCarsVolumeClaimTemplatesSpecDataSource;
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplatesSpec#resources
     */
    readonly resources?: TenantV2SpecSideCarsVolumeClaimTemplatesSpecResources;
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplatesSpec#selector
     */
    readonly selector?: TenantV2SpecSideCarsVolumeClaimTemplatesSpecSelector;
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplatesSpec#storageClassName
     */
    readonly storageClassName?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplatesSpec#volumeMode
     */
    readonly volumeMode?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplatesSpec#volumeName
     */
    readonly volumeName?: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumeClaimTemplatesSpec' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumeClaimTemplatesSpec(obj: TenantV2SpecSideCarsVolumeClaimTemplatesSpec | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumeClaimTemplatesStatus
 */
export interface TenantV2SpecSideCarsVolumeClaimTemplatesStatus {
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplatesStatus#accessModes
     */
    readonly accessModes?: string[];
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplatesStatus#capacity
     */
    readonly capacity?: {
        [key: string]: TenantV2SpecSideCarsVolumeClaimTemplatesStatusCapacity;
    };
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplatesStatus#conditions
     */
    readonly conditions?: TenantV2SpecSideCarsVolumeClaimTemplatesStatusConditions[];
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplatesStatus#phase
     */
    readonly phase?: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumeClaimTemplatesStatus' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumeClaimTemplatesStatus(obj: TenantV2SpecSideCarsVolumeClaimTemplatesStatus | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesAwsElasticBlockStore
 */
export interface TenantV2SpecSideCarsVolumesAwsElasticBlockStore {
    /**
     * @schema TenantV2SpecSideCarsVolumesAwsElasticBlockStore#fsType
     */
    readonly fsType?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesAwsElasticBlockStore#partition
     */
    readonly partition?: number;
    /**
     * @schema TenantV2SpecSideCarsVolumesAwsElasticBlockStore#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * @schema TenantV2SpecSideCarsVolumesAwsElasticBlockStore#volumeID
     */
    readonly volumeId: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesAwsElasticBlockStore' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesAwsElasticBlockStore(obj: TenantV2SpecSideCarsVolumesAwsElasticBlockStore | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesAzureDisk
 */
export interface TenantV2SpecSideCarsVolumesAzureDisk {
    /**
     * @schema TenantV2SpecSideCarsVolumesAzureDisk#cachingMode
     */
    readonly cachingMode?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesAzureDisk#diskName
     */
    readonly diskName: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesAzureDisk#diskURI
     */
    readonly diskUri: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesAzureDisk#fsType
     */
    readonly fsType?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesAzureDisk#kind
     */
    readonly kind?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesAzureDisk#readOnly
     */
    readonly readOnly?: boolean;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesAzureDisk' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesAzureDisk(obj: TenantV2SpecSideCarsVolumesAzureDisk | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesAzureFile
 */
export interface TenantV2SpecSideCarsVolumesAzureFile {
    /**
     * @schema TenantV2SpecSideCarsVolumesAzureFile#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * @schema TenantV2SpecSideCarsVolumesAzureFile#secretName
     */
    readonly secretName: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesAzureFile#shareName
     */
    readonly shareName: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesAzureFile' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesAzureFile(obj: TenantV2SpecSideCarsVolumesAzureFile | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesCephfs
 */
export interface TenantV2SpecSideCarsVolumesCephfs {
    /**
     * @schema TenantV2SpecSideCarsVolumesCephfs#monitors
     */
    readonly monitors: string[];
    /**
     * @schema TenantV2SpecSideCarsVolumesCephfs#path
     */
    readonly path?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesCephfs#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * @schema TenantV2SpecSideCarsVolumesCephfs#secretFile
     */
    readonly secretFile?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesCephfs#secretRef
     */
    readonly secretRef?: TenantV2SpecSideCarsVolumesCephfsSecretRef;
    /**
     * @schema TenantV2SpecSideCarsVolumesCephfs#user
     */
    readonly user?: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesCephfs' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesCephfs(obj: TenantV2SpecSideCarsVolumesCephfs | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesCinder
 */
export interface TenantV2SpecSideCarsVolumesCinder {
    /**
     * @schema TenantV2SpecSideCarsVolumesCinder#fsType
     */
    readonly fsType?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesCinder#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * @schema TenantV2SpecSideCarsVolumesCinder#secretRef
     */
    readonly secretRef?: TenantV2SpecSideCarsVolumesCinderSecretRef;
    /**
     * @schema TenantV2SpecSideCarsVolumesCinder#volumeID
     */
    readonly volumeId: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesCinder' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesCinder(obj: TenantV2SpecSideCarsVolumesCinder | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesConfigMap
 */
export interface TenantV2SpecSideCarsVolumesConfigMap {
    /**
     * @schema TenantV2SpecSideCarsVolumesConfigMap#defaultMode
     */
    readonly defaultMode?: number;
    /**
     * @schema TenantV2SpecSideCarsVolumesConfigMap#items
     */
    readonly items?: TenantV2SpecSideCarsVolumesConfigMapItems[];
    /**
     * @schema TenantV2SpecSideCarsVolumesConfigMap#name
     */
    readonly name?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesConfigMap#optional
     */
    readonly optional?: boolean;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesConfigMap' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesConfigMap(obj: TenantV2SpecSideCarsVolumesConfigMap | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesCsi
 */
export interface TenantV2SpecSideCarsVolumesCsi {
    /**
     * @schema TenantV2SpecSideCarsVolumesCsi#driver
     */
    readonly driver: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesCsi#fsType
     */
    readonly fsType?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesCsi#nodePublishSecretRef
     */
    readonly nodePublishSecretRef?: TenantV2SpecSideCarsVolumesCsiNodePublishSecretRef;
    /**
     * @schema TenantV2SpecSideCarsVolumesCsi#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * @schema TenantV2SpecSideCarsVolumesCsi#volumeAttributes
     */
    readonly volumeAttributes?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesCsi' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesCsi(obj: TenantV2SpecSideCarsVolumesCsi | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesDownwardApi
 */
export interface TenantV2SpecSideCarsVolumesDownwardApi {
    /**
     * @schema TenantV2SpecSideCarsVolumesDownwardApi#defaultMode
     */
    readonly defaultMode?: number;
    /**
     * @schema TenantV2SpecSideCarsVolumesDownwardApi#items
     */
    readonly items?: TenantV2SpecSideCarsVolumesDownwardApiItems[];
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesDownwardApi' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesDownwardApi(obj: TenantV2SpecSideCarsVolumesDownwardApi | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesEmptyDir
 */
export interface TenantV2SpecSideCarsVolumesEmptyDir {
    /**
     * @schema TenantV2SpecSideCarsVolumesEmptyDir#medium
     */
    readonly medium?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesEmptyDir#sizeLimit
     */
    readonly sizeLimit?: TenantV2SpecSideCarsVolumesEmptyDirSizeLimit;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesEmptyDir' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesEmptyDir(obj: TenantV2SpecSideCarsVolumesEmptyDir | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesEphemeral
 */
export interface TenantV2SpecSideCarsVolumesEphemeral {
    /**
     * @schema TenantV2SpecSideCarsVolumesEphemeral#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * @schema TenantV2SpecSideCarsVolumesEphemeral#volumeClaimTemplate
     */
    readonly volumeClaimTemplate?: TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplate;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesEphemeral' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesEphemeral(obj: TenantV2SpecSideCarsVolumesEphemeral | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesFc
 */
export interface TenantV2SpecSideCarsVolumesFc {
    /**
     * @schema TenantV2SpecSideCarsVolumesFc#fsType
     */
    readonly fsType?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesFc#lun
     */
    readonly lun?: number;
    /**
     * @schema TenantV2SpecSideCarsVolumesFc#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * @schema TenantV2SpecSideCarsVolumesFc#targetWWNs
     */
    readonly targetWwNs?: string[];
    /**
     * @schema TenantV2SpecSideCarsVolumesFc#wwids
     */
    readonly wwids?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesFc' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesFc(obj: TenantV2SpecSideCarsVolumesFc | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesFlexVolume
 */
export interface TenantV2SpecSideCarsVolumesFlexVolume {
    /**
     * @schema TenantV2SpecSideCarsVolumesFlexVolume#driver
     */
    readonly driver: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesFlexVolume#fsType
     */
    readonly fsType?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesFlexVolume#options
     */
    readonly options?: {
        [key: string]: string;
    };
    /**
     * @schema TenantV2SpecSideCarsVolumesFlexVolume#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * @schema TenantV2SpecSideCarsVolumesFlexVolume#secretRef
     */
    readonly secretRef?: TenantV2SpecSideCarsVolumesFlexVolumeSecretRef;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesFlexVolume' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesFlexVolume(obj: TenantV2SpecSideCarsVolumesFlexVolume | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesFlocker
 */
export interface TenantV2SpecSideCarsVolumesFlocker {
    /**
     * @schema TenantV2SpecSideCarsVolumesFlocker#datasetName
     */
    readonly datasetName?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesFlocker#datasetUUID
     */
    readonly datasetUuid?: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesFlocker' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesFlocker(obj: TenantV2SpecSideCarsVolumesFlocker | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesGcePersistentDisk
 */
export interface TenantV2SpecSideCarsVolumesGcePersistentDisk {
    /**
     * @schema TenantV2SpecSideCarsVolumesGcePersistentDisk#fsType
     */
    readonly fsType?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesGcePersistentDisk#partition
     */
    readonly partition?: number;
    /**
     * @schema TenantV2SpecSideCarsVolumesGcePersistentDisk#pdName
     */
    readonly pdName: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesGcePersistentDisk#readOnly
     */
    readonly readOnly?: boolean;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesGcePersistentDisk' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesGcePersistentDisk(obj: TenantV2SpecSideCarsVolumesGcePersistentDisk | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesGitRepo
 */
export interface TenantV2SpecSideCarsVolumesGitRepo {
    /**
     * @schema TenantV2SpecSideCarsVolumesGitRepo#directory
     */
    readonly directory?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesGitRepo#repository
     */
    readonly repository: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesGitRepo#revision
     */
    readonly revision?: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesGitRepo' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesGitRepo(obj: TenantV2SpecSideCarsVolumesGitRepo | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesGlusterfs
 */
export interface TenantV2SpecSideCarsVolumesGlusterfs {
    /**
     * @schema TenantV2SpecSideCarsVolumesGlusterfs#endpoints
     */
    readonly endpoints: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesGlusterfs#path
     */
    readonly path: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesGlusterfs#readOnly
     */
    readonly readOnly?: boolean;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesGlusterfs' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesGlusterfs(obj: TenantV2SpecSideCarsVolumesGlusterfs | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesHostPath
 */
export interface TenantV2SpecSideCarsVolumesHostPath {
    /**
     * @schema TenantV2SpecSideCarsVolumesHostPath#path
     */
    readonly path: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesHostPath#type
     */
    readonly type?: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesHostPath' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesHostPath(obj: TenantV2SpecSideCarsVolumesHostPath | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesIscsi
 */
export interface TenantV2SpecSideCarsVolumesIscsi {
    /**
     * @schema TenantV2SpecSideCarsVolumesIscsi#chapAuthDiscovery
     */
    readonly chapAuthDiscovery?: boolean;
    /**
     * @schema TenantV2SpecSideCarsVolumesIscsi#chapAuthSession
     */
    readonly chapAuthSession?: boolean;
    /**
     * @schema TenantV2SpecSideCarsVolumesIscsi#fsType
     */
    readonly fsType?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesIscsi#initiatorName
     */
    readonly initiatorName?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesIscsi#iqn
     */
    readonly iqn: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesIscsi#iscsiInterface
     */
    readonly iscsiInterface?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesIscsi#lun
     */
    readonly lun: number;
    /**
     * @schema TenantV2SpecSideCarsVolumesIscsi#portals
     */
    readonly portals?: string[];
    /**
     * @schema TenantV2SpecSideCarsVolumesIscsi#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * @schema TenantV2SpecSideCarsVolumesIscsi#secretRef
     */
    readonly secretRef?: TenantV2SpecSideCarsVolumesIscsiSecretRef;
    /**
     * @schema TenantV2SpecSideCarsVolumesIscsi#targetPortal
     */
    readonly targetPortal: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesIscsi' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesIscsi(obj: TenantV2SpecSideCarsVolumesIscsi | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesNfs
 */
export interface TenantV2SpecSideCarsVolumesNfs {
    /**
     * @schema TenantV2SpecSideCarsVolumesNfs#path
     */
    readonly path: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesNfs#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * @schema TenantV2SpecSideCarsVolumesNfs#server
     */
    readonly server: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesNfs' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesNfs(obj: TenantV2SpecSideCarsVolumesNfs | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesPersistentVolumeClaim
 */
export interface TenantV2SpecSideCarsVolumesPersistentVolumeClaim {
    /**
     * @schema TenantV2SpecSideCarsVolumesPersistentVolumeClaim#claimName
     */
    readonly claimName: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesPersistentVolumeClaim#readOnly
     */
    readonly readOnly?: boolean;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesPersistentVolumeClaim' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesPersistentVolumeClaim(obj: TenantV2SpecSideCarsVolumesPersistentVolumeClaim | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesPhotonPersistentDisk
 */
export interface TenantV2SpecSideCarsVolumesPhotonPersistentDisk {
    /**
     * @schema TenantV2SpecSideCarsVolumesPhotonPersistentDisk#fsType
     */
    readonly fsType?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesPhotonPersistentDisk#pdID
     */
    readonly pdId: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesPhotonPersistentDisk' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesPhotonPersistentDisk(obj: TenantV2SpecSideCarsVolumesPhotonPersistentDisk | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesPortworxVolume
 */
export interface TenantV2SpecSideCarsVolumesPortworxVolume {
    /**
     * @schema TenantV2SpecSideCarsVolumesPortworxVolume#fsType
     */
    readonly fsType?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesPortworxVolume#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * @schema TenantV2SpecSideCarsVolumesPortworxVolume#volumeID
     */
    readonly volumeId: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesPortworxVolume' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesPortworxVolume(obj: TenantV2SpecSideCarsVolumesPortworxVolume | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesProjected
 */
export interface TenantV2SpecSideCarsVolumesProjected {
    /**
     * @schema TenantV2SpecSideCarsVolumesProjected#defaultMode
     */
    readonly defaultMode?: number;
    /**
     * @schema TenantV2SpecSideCarsVolumesProjected#sources
     */
    readonly sources?: TenantV2SpecSideCarsVolumesProjectedSources[];
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesProjected' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesProjected(obj: TenantV2SpecSideCarsVolumesProjected | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesQuobyte
 */
export interface TenantV2SpecSideCarsVolumesQuobyte {
    /**
     * @schema TenantV2SpecSideCarsVolumesQuobyte#group
     */
    readonly group?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesQuobyte#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * @schema TenantV2SpecSideCarsVolumesQuobyte#registry
     */
    readonly registry: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesQuobyte#tenant
     */
    readonly tenant?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesQuobyte#user
     */
    readonly user?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesQuobyte#volume
     */
    readonly volume: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesQuobyte' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesQuobyte(obj: TenantV2SpecSideCarsVolumesQuobyte | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesRbd
 */
export interface TenantV2SpecSideCarsVolumesRbd {
    /**
     * @schema TenantV2SpecSideCarsVolumesRbd#fsType
     */
    readonly fsType?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesRbd#image
     */
    readonly image: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesRbd#keyring
     */
    readonly keyring?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesRbd#monitors
     */
    readonly monitors: string[];
    /**
     * @schema TenantV2SpecSideCarsVolumesRbd#pool
     */
    readonly pool?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesRbd#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * @schema TenantV2SpecSideCarsVolumesRbd#secretRef
     */
    readonly secretRef?: TenantV2SpecSideCarsVolumesRbdSecretRef;
    /**
     * @schema TenantV2SpecSideCarsVolumesRbd#user
     */
    readonly user?: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesRbd' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesRbd(obj: TenantV2SpecSideCarsVolumesRbd | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesScaleIo
 */
export interface TenantV2SpecSideCarsVolumesScaleIo {
    /**
     * @schema TenantV2SpecSideCarsVolumesScaleIo#fsType
     */
    readonly fsType?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesScaleIo#gateway
     */
    readonly gateway: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesScaleIo#protectionDomain
     */
    readonly protectionDomain?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesScaleIo#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * @schema TenantV2SpecSideCarsVolumesScaleIo#secretRef
     */
    readonly secretRef: TenantV2SpecSideCarsVolumesScaleIoSecretRef;
    /**
     * @schema TenantV2SpecSideCarsVolumesScaleIo#sslEnabled
     */
    readonly sslEnabled?: boolean;
    /**
     * @schema TenantV2SpecSideCarsVolumesScaleIo#storageMode
     */
    readonly storageMode?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesScaleIo#storagePool
     */
    readonly storagePool?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesScaleIo#system
     */
    readonly system: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesScaleIo#volumeName
     */
    readonly volumeName?: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesScaleIo' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesScaleIo(obj: TenantV2SpecSideCarsVolumesScaleIo | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesSecret
 */
export interface TenantV2SpecSideCarsVolumesSecret {
    /**
     * @schema TenantV2SpecSideCarsVolumesSecret#defaultMode
     */
    readonly defaultMode?: number;
    /**
     * @schema TenantV2SpecSideCarsVolumesSecret#items
     */
    readonly items?: TenantV2SpecSideCarsVolumesSecretItems[];
    /**
     * @schema TenantV2SpecSideCarsVolumesSecret#optional
     */
    readonly optional?: boolean;
    /**
     * @schema TenantV2SpecSideCarsVolumesSecret#secretName
     */
    readonly secretName?: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesSecret' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesSecret(obj: TenantV2SpecSideCarsVolumesSecret | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesStorageos
 */
export interface TenantV2SpecSideCarsVolumesStorageos {
    /**
     * @schema TenantV2SpecSideCarsVolumesStorageos#fsType
     */
    readonly fsType?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesStorageos#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * @schema TenantV2SpecSideCarsVolumesStorageos#secretRef
     */
    readonly secretRef?: TenantV2SpecSideCarsVolumesStorageosSecretRef;
    /**
     * @schema TenantV2SpecSideCarsVolumesStorageos#volumeName
     */
    readonly volumeName?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesStorageos#volumeNamespace
     */
    readonly volumeNamespace?: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesStorageos' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesStorageos(obj: TenantV2SpecSideCarsVolumesStorageos | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesVsphereVolume
 */
export interface TenantV2SpecSideCarsVolumesVsphereVolume {
    /**
     * @schema TenantV2SpecSideCarsVolumesVsphereVolume#fsType
     */
    readonly fsType?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesVsphereVolume#storagePolicyID
     */
    readonly storagePolicyId?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesVsphereVolume#storagePolicyName
     */
    readonly storagePolicyName?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesVsphereVolume#volumePath
     */
    readonly volumePath: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesVsphereVolume' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesVsphereVolume(obj: TenantV2SpecSideCarsVolumesVsphereVolume | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecEnvValueFromResourceFieldRefDivisor
 */
export declare class TenantV2SpecEnvValueFromResourceFieldRefDivisor {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecEnvValueFromResourceFieldRefDivisor;
    static fromString(value: string): TenantV2SpecEnvValueFromResourceFieldRefDivisor;
    private constructor();
}
/**
 * @schema TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution#preference
     */
    readonly preference: TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference;
    /**
     * @schema TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
     */
    readonly weight: number;
}
/**
 * Converts an object of type 'TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution(obj: TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution#nodeSelectorTerms
     */
    readonly nodeSelectorTerms: TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms[];
}
/**
 * Converts an object of type 'TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution(obj: TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution#podAffinityTerm
     */
    readonly podAffinityTerm: TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm;
    /**
     * @schema TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
     */
    readonly weight: number;
}
/**
 * Converts an object of type 'TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution(obj: TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantV2SpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantV2SpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#labelSelector
     */
    readonly labelSelector?: TenantV2SpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector;
    /**
     * @schema TenantV2SpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantV2SpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantV2SpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution(obj: TenantV2SpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution#podAffinityTerm
     */
    readonly podAffinityTerm: TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm;
    /**
     * @schema TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
     */
    readonly weight: number;
}
/**
 * Converts an object of type 'TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution(obj: TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantV2SpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantV2SpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#labelSelector
     */
    readonly labelSelector?: TenantV2SpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector;
    /**
     * @schema TenantV2SpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantV2SpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantV2SpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution(obj: TenantV2SpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesTopologySpreadConstraintsLabelSelectorMatchExpressions
 */
export interface TenantV2SpecKesTopologySpreadConstraintsLabelSelectorMatchExpressions {
    /**
     * @schema TenantV2SpecKesTopologySpreadConstraintsLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecKesTopologySpreadConstraintsLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecKesTopologySpreadConstraintsLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecKesTopologySpreadConstraintsLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesTopologySpreadConstraintsLabelSelectorMatchExpressions(obj: TenantV2SpecKesTopologySpreadConstraintsLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution#preference
     */
    readonly preference: TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference;
    /**
     * @schema TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
     */
    readonly weight: number;
}
/**
 * Converts an object of type 'TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution(obj: TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution#nodeSelectorTerms
     */
    readonly nodeSelectorTerms: TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms[];
}
/**
 * Converts an object of type 'TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution(obj: TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution#podAffinityTerm
     */
    readonly podAffinityTerm: TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm;
    /**
     * @schema TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
     */
    readonly weight: number;
}
/**
 * Converts an object of type 'TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution(obj: TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantV2SpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantV2SpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#labelSelector
     */
    readonly labelSelector?: TenantV2SpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector;
    /**
     * @schema TenantV2SpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantV2SpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantV2SpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution(obj: TenantV2SpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution#podAffinityTerm
     */
    readonly podAffinityTerm: TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm;
    /**
     * @schema TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
     */
    readonly weight: number;
}
/**
 * Converts an object of type 'TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution(obj: TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantV2SpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantV2SpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#labelSelector
     */
    readonly labelSelector?: TenantV2SpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector;
    /**
     * @schema TenantV2SpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantV2SpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantV2SpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution(obj: TenantV2SpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbAffinityNodeAffinity
 */
export interface TenantV2SpecLogDbAffinityNodeAffinity {
    /**
     * @schema TenantV2SpecLogDbAffinityNodeAffinity#preferredDuringSchedulingIgnoredDuringExecution
     */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution[];
    /**
     * @schema TenantV2SpecLogDbAffinityNodeAffinity#requiredDuringSchedulingIgnoredDuringExecution
     */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution;
}
/**
 * Converts an object of type 'TenantV2SpecLogDbAffinityNodeAffinity' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbAffinityNodeAffinity(obj: TenantV2SpecLogDbAffinityNodeAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbAffinityPodAffinity
 */
export interface TenantV2SpecLogDbAffinityPodAffinity {
    /**
     * @schema TenantV2SpecLogDbAffinityPodAffinity#preferredDuringSchedulingIgnoredDuringExecution
     */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution[];
    /**
     * @schema TenantV2SpecLogDbAffinityPodAffinity#requiredDuringSchedulingIgnoredDuringExecution
     */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: TenantV2SpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution[];
}
/**
 * Converts an object of type 'TenantV2SpecLogDbAffinityPodAffinity' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbAffinityPodAffinity(obj: TenantV2SpecLogDbAffinityPodAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbAffinityPodAntiAffinity
 */
export interface TenantV2SpecLogDbAffinityPodAntiAffinity {
    /**
     * @schema TenantV2SpecLogDbAffinityPodAntiAffinity#preferredDuringSchedulingIgnoredDuringExecution
     */
    readonly preferredDuringSchedulingIgnoredDuringExecution?: TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution[];
    /**
     * @schema TenantV2SpecLogDbAffinityPodAntiAffinity#requiredDuringSchedulingIgnoredDuringExecution
     */
    readonly requiredDuringSchedulingIgnoredDuringExecution?: TenantV2SpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution[];
}
/**
 * Converts an object of type 'TenantV2SpecLogDbAffinityPodAntiAffinity' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbAffinityPodAntiAffinity(obj: TenantV2SpecLogDbAffinityPodAntiAffinity | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbResourcesLimits
 */
export declare class TenantV2SpecLogDbResourcesLimits {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecLogDbResourcesLimits;
    static fromString(value: string): TenantV2SpecLogDbResourcesLimits;
    private constructor();
}
/**
 * @schema TenantV2SpecLogDbResourcesRequests
 */
export declare class TenantV2SpecLogDbResourcesRequests {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecLogDbResourcesRequests;
    static fromString(value: string): TenantV2SpecLogDbResourcesRequests;
    private constructor();
}
/**
 * @schema TenantV2SpecLogDbSecurityContextSeLinuxOptions
 */
export interface TenantV2SpecLogDbSecurityContextSeLinuxOptions {
    /**
     * @schema TenantV2SpecLogDbSecurityContextSeLinuxOptions#level
     */
    readonly level?: string;
    /**
     * @schema TenantV2SpecLogDbSecurityContextSeLinuxOptions#role
     */
    readonly role?: string;
    /**
     * @schema TenantV2SpecLogDbSecurityContextSeLinuxOptions#type
     */
    readonly type?: string;
    /**
     * @schema TenantV2SpecLogDbSecurityContextSeLinuxOptions#user
     */
    readonly user?: string;
}
/**
 * Converts an object of type 'TenantV2SpecLogDbSecurityContextSeLinuxOptions' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbSecurityContextSeLinuxOptions(obj: TenantV2SpecLogDbSecurityContextSeLinuxOptions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbSecurityContextSeccompProfile
 */
export interface TenantV2SpecLogDbSecurityContextSeccompProfile {
    /**
     * @schema TenantV2SpecLogDbSecurityContextSeccompProfile#localhostProfile
     */
    readonly localhostProfile?: string;
    /**
     * @schema TenantV2SpecLogDbSecurityContextSeccompProfile#type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'TenantV2SpecLogDbSecurityContextSeccompProfile' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbSecurityContextSeccompProfile(obj: TenantV2SpecLogDbSecurityContextSeccompProfile | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbSecurityContextSysctls
 */
export interface TenantV2SpecLogDbSecurityContextSysctls {
    /**
     * @schema TenantV2SpecLogDbSecurityContextSysctls#name
     */
    readonly name: string;
    /**
     * @schema TenantV2SpecLogDbSecurityContextSysctls#value
     */
    readonly value: string;
}
/**
 * Converts an object of type 'TenantV2SpecLogDbSecurityContextSysctls' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbSecurityContextSysctls(obj: TenantV2SpecLogDbSecurityContextSysctls | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbSecurityContextWindowsOptions
 */
export interface TenantV2SpecLogDbSecurityContextWindowsOptions {
    /**
     * @schema TenantV2SpecLogDbSecurityContextWindowsOptions#gmsaCredentialSpec
     */
    readonly gmsaCredentialSpec?: string;
    /**
     * @schema TenantV2SpecLogDbSecurityContextWindowsOptions#gmsaCredentialSpecName
     */
    readonly gmsaCredentialSpecName?: string;
    /**
     * @schema TenantV2SpecLogDbSecurityContextWindowsOptions#runAsUserName
     */
    readonly runAsUserName?: string;
}
/**
 * Converts an object of type 'TenantV2SpecLogDbSecurityContextWindowsOptions' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbSecurityContextWindowsOptions(obj: TenantV2SpecLogDbSecurityContextWindowsOptions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbTopologySpreadConstraintsLabelSelector
 */
export interface TenantV2SpecLogDbTopologySpreadConstraintsLabelSelector {
    /**
     * @schema TenantV2SpecLogDbTopologySpreadConstraintsLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecLogDbTopologySpreadConstraintsLabelSelectorMatchExpressions[];
    /**
     * @schema TenantV2SpecLogDbTopologySpreadConstraintsLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantV2SpecLogDbTopologySpreadConstraintsLabelSelector' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbTopologySpreadConstraintsLabelSelector(obj: TenantV2SpecLogDbTopologySpreadConstraintsLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbVolumeClaimTemplateMetadata
 */
export interface TenantV2SpecLogDbVolumeClaimTemplateMetadata {
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplateMetadata#annotations
     */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplateMetadata#finalizers
     */
    readonly finalizers?: string[];
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplateMetadata#labels
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplateMetadata#name
     */
    readonly name?: string;
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplateMetadata#namespace
     */
    readonly namespace?: string;
}
/**
 * Converts an object of type 'TenantV2SpecLogDbVolumeClaimTemplateMetadata' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbVolumeClaimTemplateMetadata(obj: TenantV2SpecLogDbVolumeClaimTemplateMetadata | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbVolumeClaimTemplateSpec
 */
export interface TenantV2SpecLogDbVolumeClaimTemplateSpec {
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplateSpec#accessModes
     */
    readonly accessModes?: string[];
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplateSpec#dataSource
     */
    readonly dataSource?: TenantV2SpecLogDbVolumeClaimTemplateSpecDataSource;
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplateSpec#resources
     */
    readonly resources?: TenantV2SpecLogDbVolumeClaimTemplateSpecResources;
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplateSpec#selector
     */
    readonly selector?: TenantV2SpecLogDbVolumeClaimTemplateSpecSelector;
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplateSpec#storageClassName
     */
    readonly storageClassName?: string;
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplateSpec#volumeMode
     */
    readonly volumeMode?: string;
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplateSpec#volumeName
     */
    readonly volumeName?: string;
}
/**
 * Converts an object of type 'TenantV2SpecLogDbVolumeClaimTemplateSpec' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbVolumeClaimTemplateSpec(obj: TenantV2SpecLogDbVolumeClaimTemplateSpec | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbVolumeClaimTemplateStatus
 */
export interface TenantV2SpecLogDbVolumeClaimTemplateStatus {
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplateStatus#accessModes
     */
    readonly accessModes?: string[];
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplateStatus#capacity
     */
    readonly capacity?: {
        [key: string]: TenantV2SpecLogDbVolumeClaimTemplateStatusCapacity;
    };
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplateStatus#conditions
     */
    readonly conditions?: TenantV2SpecLogDbVolumeClaimTemplateStatusConditions[];
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplateStatus#phase
     */
    readonly phase?: string;
}
/**
 * Converts an object of type 'TenantV2SpecLogDbVolumeClaimTemplateStatus' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbVolumeClaimTemplateStatus(obj: TenantV2SpecLogDbVolumeClaimTemplateStatus | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogTopologySpreadConstraintsLabelSelectorMatchExpressions
 */
export interface TenantV2SpecLogTopologySpreadConstraintsLabelSelectorMatchExpressions {
    /**
     * @schema TenantV2SpecLogTopologySpreadConstraintsLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecLogTopologySpreadConstraintsLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecLogTopologySpreadConstraintsLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecLogTopologySpreadConstraintsLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogTopologySpreadConstraintsLabelSelectorMatchExpressions(obj: TenantV2SpecLogTopologySpreadConstraintsLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution#preference
     */
    readonly preference: TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference;
    /**
     * @schema TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
     */
    readonly weight: number;
}
/**
 * Converts an object of type 'TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution(obj: TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution#nodeSelectorTerms
     */
    readonly nodeSelectorTerms: TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms[];
}
/**
 * Converts an object of type 'TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution(obj: TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution#podAffinityTerm
     */
    readonly podAffinityTerm: TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm;
    /**
     * @schema TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
     */
    readonly weight: number;
}
/**
 * Converts an object of type 'TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution(obj: TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantV2SpecPoolsAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantV2SpecPoolsAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#labelSelector
     */
    readonly labelSelector?: TenantV2SpecPoolsAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector;
    /**
     * @schema TenantV2SpecPoolsAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantV2SpecPoolsAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantV2SpecPoolsAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution(obj: TenantV2SpecPoolsAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution#podAffinityTerm
     */
    readonly podAffinityTerm: TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm;
    /**
     * @schema TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
     */
    readonly weight: number;
}
/**
 * Converts an object of type 'TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution(obj: TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantV2SpecPoolsAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantV2SpecPoolsAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#labelSelector
     */
    readonly labelSelector?: TenantV2SpecPoolsAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector;
    /**
     * @schema TenantV2SpecPoolsAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantV2SpecPoolsAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantV2SpecPoolsAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution(obj: TenantV2SpecPoolsAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsTopologySpreadConstraintsLabelSelectorMatchExpressions
 */
export interface TenantV2SpecPoolsTopologySpreadConstraintsLabelSelectorMatchExpressions {
    /**
     * @schema TenantV2SpecPoolsTopologySpreadConstraintsLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecPoolsTopologySpreadConstraintsLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecPoolsTopologySpreadConstraintsLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecPoolsTopologySpreadConstraintsLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsTopologySpreadConstraintsLabelSelectorMatchExpressions(obj: TenantV2SpecPoolsTopologySpreadConstraintsLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsVolumeClaimTemplateSpecDataSource
 */
export interface TenantV2SpecPoolsVolumeClaimTemplateSpecDataSource {
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplateSpecDataSource#apiGroup
     */
    readonly apiGroup?: string;
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplateSpecDataSource#kind
     */
    readonly kind: string;
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplateSpecDataSource#name
     */
    readonly name: string;
}
/**
 * Converts an object of type 'TenantV2SpecPoolsVolumeClaimTemplateSpecDataSource' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsVolumeClaimTemplateSpecDataSource(obj: TenantV2SpecPoolsVolumeClaimTemplateSpecDataSource | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsVolumeClaimTemplateSpecResources
 */
export interface TenantV2SpecPoolsVolumeClaimTemplateSpecResources {
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplateSpecResources#limits
     */
    readonly limits?: {
        [key: string]: TenantV2SpecPoolsVolumeClaimTemplateSpecResourcesLimits;
    };
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplateSpecResources#requests
     */
    readonly requests?: {
        [key: string]: TenantV2SpecPoolsVolumeClaimTemplateSpecResourcesRequests;
    };
}
/**
 * Converts an object of type 'TenantV2SpecPoolsVolumeClaimTemplateSpecResources' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsVolumeClaimTemplateSpecResources(obj: TenantV2SpecPoolsVolumeClaimTemplateSpecResources | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsVolumeClaimTemplateSpecSelector
 */
export interface TenantV2SpecPoolsVolumeClaimTemplateSpecSelector {
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplateSpecSelector#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecPoolsVolumeClaimTemplateSpecSelectorMatchExpressions[];
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplateSpecSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantV2SpecPoolsVolumeClaimTemplateSpecSelector' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsVolumeClaimTemplateSpecSelector(obj: TenantV2SpecPoolsVolumeClaimTemplateSpecSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsVolumeClaimTemplateStatusCapacity
 */
export declare class TenantV2SpecPoolsVolumeClaimTemplateStatusCapacity {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecPoolsVolumeClaimTemplateStatusCapacity;
    static fromString(value: string): TenantV2SpecPoolsVolumeClaimTemplateStatusCapacity;
    private constructor();
}
/**
 * @schema TenantV2SpecPoolsVolumeClaimTemplateStatusConditions
 */
export interface TenantV2SpecPoolsVolumeClaimTemplateStatusConditions {
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplateStatusConditions#lastProbeTime
     */
    readonly lastProbeTime?: Date;
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplateStatusConditions#lastTransitionTime
     */
    readonly lastTransitionTime?: Date;
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplateStatusConditions#message
     */
    readonly message?: string;
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplateStatusConditions#reason
     */
    readonly reason?: string;
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplateStatusConditions#status
     */
    readonly status: string;
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplateStatusConditions#type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'TenantV2SpecPoolsVolumeClaimTemplateStatusConditions' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsVolumeClaimTemplateStatusConditions(obj: TenantV2SpecPoolsVolumeClaimTemplateStatusConditions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution#preference
     */
    readonly preference: TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference;
    /**
     * @schema TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
     */
    readonly weight: number;
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution(obj: TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution#nodeSelectorTerms
     */
    readonly nodeSelectorTerms: TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms[];
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution(obj: TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution#podAffinityTerm
     */
    readonly podAffinityTerm: TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm;
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
     */
    readonly weight: number;
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution(obj: TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantV2SpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#labelSelector
     */
    readonly labelSelector?: TenantV2SpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector;
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution(obj: TenantV2SpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution#podAffinityTerm
     */
    readonly podAffinityTerm: TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm;
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
     */
    readonly weight: number;
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution(obj: TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantV2SpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#labelSelector
     */
    readonly labelSelector?: TenantV2SpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector;
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution(obj: TenantV2SpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusTopologySpreadConstraintsLabelSelectorMatchExpressions
 */
export interface TenantV2SpecPrometheusTopologySpreadConstraintsLabelSelectorMatchExpressions {
    /**
     * @schema TenantV2SpecPrometheusTopologySpreadConstraintsLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecPrometheusTopologySpreadConstraintsLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecPrometheusTopologySpreadConstraintsLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusTopologySpreadConstraintsLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusTopologySpreadConstraintsLabelSelectorMatchExpressions(obj: TenantV2SpecPrometheusTopologySpreadConstraintsLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersEnvValueFrom
 */
export interface TenantV2SpecSideCarsContainersEnvValueFrom {
    /**
     * @schema TenantV2SpecSideCarsContainersEnvValueFrom#configMapKeyRef
     */
    readonly configMapKeyRef?: TenantV2SpecSideCarsContainersEnvValueFromConfigMapKeyRef;
    /**
     * @schema TenantV2SpecSideCarsContainersEnvValueFrom#fieldRef
     */
    readonly fieldRef?: TenantV2SpecSideCarsContainersEnvValueFromFieldRef;
    /**
     * @schema TenantV2SpecSideCarsContainersEnvValueFrom#resourceFieldRef
     */
    readonly resourceFieldRef?: TenantV2SpecSideCarsContainersEnvValueFromResourceFieldRef;
    /**
     * @schema TenantV2SpecSideCarsContainersEnvValueFrom#secretKeyRef
     */
    readonly secretKeyRef?: TenantV2SpecSideCarsContainersEnvValueFromSecretKeyRef;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersEnvValueFrom' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersEnvValueFrom(obj: TenantV2SpecSideCarsContainersEnvValueFrom | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersEnvFromConfigMapRef
 */
export interface TenantV2SpecSideCarsContainersEnvFromConfigMapRef {
    /**
     * @schema TenantV2SpecSideCarsContainersEnvFromConfigMapRef#name
     */
    readonly name?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersEnvFromConfigMapRef#optional
     */
    readonly optional?: boolean;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersEnvFromConfigMapRef' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersEnvFromConfigMapRef(obj: TenantV2SpecSideCarsContainersEnvFromConfigMapRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersEnvFromSecretRef
 */
export interface TenantV2SpecSideCarsContainersEnvFromSecretRef {
    /**
     * @schema TenantV2SpecSideCarsContainersEnvFromSecretRef#name
     */
    readonly name?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersEnvFromSecretRef#optional
     */
    readonly optional?: boolean;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersEnvFromSecretRef' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersEnvFromSecretRef(obj: TenantV2SpecSideCarsContainersEnvFromSecretRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersLifecyclePostStart
 */
export interface TenantV2SpecSideCarsContainersLifecyclePostStart {
    /**
     * @schema TenantV2SpecSideCarsContainersLifecyclePostStart#exec
     */
    readonly exec?: TenantV2SpecSideCarsContainersLifecyclePostStartExec;
    /**
     * @schema TenantV2SpecSideCarsContainersLifecyclePostStart#httpGet
     */
    readonly httpGet?: TenantV2SpecSideCarsContainersLifecyclePostStartHttpGet;
    /**
     * @schema TenantV2SpecSideCarsContainersLifecyclePostStart#tcpSocket
     */
    readonly tcpSocket?: TenantV2SpecSideCarsContainersLifecyclePostStartTcpSocket;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersLifecyclePostStart' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersLifecyclePostStart(obj: TenantV2SpecSideCarsContainersLifecyclePostStart | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersLifecyclePreStop
 */
export interface TenantV2SpecSideCarsContainersLifecyclePreStop {
    /**
     * @schema TenantV2SpecSideCarsContainersLifecyclePreStop#exec
     */
    readonly exec?: TenantV2SpecSideCarsContainersLifecyclePreStopExec;
    /**
     * @schema TenantV2SpecSideCarsContainersLifecyclePreStop#httpGet
     */
    readonly httpGet?: TenantV2SpecSideCarsContainersLifecyclePreStopHttpGet;
    /**
     * @schema TenantV2SpecSideCarsContainersLifecyclePreStop#tcpSocket
     */
    readonly tcpSocket?: TenantV2SpecSideCarsContainersLifecyclePreStopTcpSocket;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersLifecyclePreStop' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersLifecyclePreStop(obj: TenantV2SpecSideCarsContainersLifecyclePreStop | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersLivenessProbeExec
 */
export interface TenantV2SpecSideCarsContainersLivenessProbeExec {
    /**
     * @schema TenantV2SpecSideCarsContainersLivenessProbeExec#command
     */
    readonly command?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersLivenessProbeExec' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersLivenessProbeExec(obj: TenantV2SpecSideCarsContainersLivenessProbeExec | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersLivenessProbeHttpGet
 */
export interface TenantV2SpecSideCarsContainersLivenessProbeHttpGet {
    /**
     * @schema TenantV2SpecSideCarsContainersLivenessProbeHttpGet#host
     */
    readonly host?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersLivenessProbeHttpGet#httpHeaders
     */
    readonly httpHeaders?: TenantV2SpecSideCarsContainersLivenessProbeHttpGetHttpHeaders[];
    /**
     * @schema TenantV2SpecSideCarsContainersLivenessProbeHttpGet#path
     */
    readonly path?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersLivenessProbeHttpGet#port
     */
    readonly port: TenantV2SpecSideCarsContainersLivenessProbeHttpGetPort;
    /**
     * @schema TenantV2SpecSideCarsContainersLivenessProbeHttpGet#scheme
     */
    readonly scheme?: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersLivenessProbeHttpGet' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersLivenessProbeHttpGet(obj: TenantV2SpecSideCarsContainersLivenessProbeHttpGet | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersLivenessProbeTcpSocket
 */
export interface TenantV2SpecSideCarsContainersLivenessProbeTcpSocket {
    /**
     * @schema TenantV2SpecSideCarsContainersLivenessProbeTcpSocket#host
     */
    readonly host?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersLivenessProbeTcpSocket#port
     */
    readonly port: TenantV2SpecSideCarsContainersLivenessProbeTcpSocketPort;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersLivenessProbeTcpSocket' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersLivenessProbeTcpSocket(obj: TenantV2SpecSideCarsContainersLivenessProbeTcpSocket | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersReadinessProbeExec
 */
export interface TenantV2SpecSideCarsContainersReadinessProbeExec {
    /**
     * @schema TenantV2SpecSideCarsContainersReadinessProbeExec#command
     */
    readonly command?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersReadinessProbeExec' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersReadinessProbeExec(obj: TenantV2SpecSideCarsContainersReadinessProbeExec | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersReadinessProbeHttpGet
 */
export interface TenantV2SpecSideCarsContainersReadinessProbeHttpGet {
    /**
     * @schema TenantV2SpecSideCarsContainersReadinessProbeHttpGet#host
     */
    readonly host?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersReadinessProbeHttpGet#httpHeaders
     */
    readonly httpHeaders?: TenantV2SpecSideCarsContainersReadinessProbeHttpGetHttpHeaders[];
    /**
     * @schema TenantV2SpecSideCarsContainersReadinessProbeHttpGet#path
     */
    readonly path?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersReadinessProbeHttpGet#port
     */
    readonly port: TenantV2SpecSideCarsContainersReadinessProbeHttpGetPort;
    /**
     * @schema TenantV2SpecSideCarsContainersReadinessProbeHttpGet#scheme
     */
    readonly scheme?: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersReadinessProbeHttpGet' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersReadinessProbeHttpGet(obj: TenantV2SpecSideCarsContainersReadinessProbeHttpGet | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersReadinessProbeTcpSocket
 */
export interface TenantV2SpecSideCarsContainersReadinessProbeTcpSocket {
    /**
     * @schema TenantV2SpecSideCarsContainersReadinessProbeTcpSocket#host
     */
    readonly host?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersReadinessProbeTcpSocket#port
     */
    readonly port: TenantV2SpecSideCarsContainersReadinessProbeTcpSocketPort;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersReadinessProbeTcpSocket' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersReadinessProbeTcpSocket(obj: TenantV2SpecSideCarsContainersReadinessProbeTcpSocket | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersResourcesLimits
 */
export declare class TenantV2SpecSideCarsContainersResourcesLimits {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecSideCarsContainersResourcesLimits;
    static fromString(value: string): TenantV2SpecSideCarsContainersResourcesLimits;
    private constructor();
}
/**
 * @schema TenantV2SpecSideCarsContainersResourcesRequests
 */
export declare class TenantV2SpecSideCarsContainersResourcesRequests {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecSideCarsContainersResourcesRequests;
    static fromString(value: string): TenantV2SpecSideCarsContainersResourcesRequests;
    private constructor();
}
/**
 * @schema TenantV2SpecSideCarsContainersSecurityContextCapabilities
 */
export interface TenantV2SpecSideCarsContainersSecurityContextCapabilities {
    /**
     * @schema TenantV2SpecSideCarsContainersSecurityContextCapabilities#add
     */
    readonly add?: string[];
    /**
     * @schema TenantV2SpecSideCarsContainersSecurityContextCapabilities#drop
     */
    readonly drop?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersSecurityContextCapabilities' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersSecurityContextCapabilities(obj: TenantV2SpecSideCarsContainersSecurityContextCapabilities | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersSecurityContextSeLinuxOptions
 */
export interface TenantV2SpecSideCarsContainersSecurityContextSeLinuxOptions {
    /**
     * @schema TenantV2SpecSideCarsContainersSecurityContextSeLinuxOptions#level
     */
    readonly level?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersSecurityContextSeLinuxOptions#role
     */
    readonly role?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersSecurityContextSeLinuxOptions#type
     */
    readonly type?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersSecurityContextSeLinuxOptions#user
     */
    readonly user?: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersSecurityContextSeLinuxOptions' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersSecurityContextSeLinuxOptions(obj: TenantV2SpecSideCarsContainersSecurityContextSeLinuxOptions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersSecurityContextSeccompProfile
 */
export interface TenantV2SpecSideCarsContainersSecurityContextSeccompProfile {
    /**
     * @schema TenantV2SpecSideCarsContainersSecurityContextSeccompProfile#localhostProfile
     */
    readonly localhostProfile?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersSecurityContextSeccompProfile#type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersSecurityContextSeccompProfile' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersSecurityContextSeccompProfile(obj: TenantV2SpecSideCarsContainersSecurityContextSeccompProfile | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersSecurityContextWindowsOptions
 */
export interface TenantV2SpecSideCarsContainersSecurityContextWindowsOptions {
    /**
     * @schema TenantV2SpecSideCarsContainersSecurityContextWindowsOptions#gmsaCredentialSpec
     */
    readonly gmsaCredentialSpec?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersSecurityContextWindowsOptions#gmsaCredentialSpecName
     */
    readonly gmsaCredentialSpecName?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersSecurityContextWindowsOptions#runAsUserName
     */
    readonly runAsUserName?: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersSecurityContextWindowsOptions' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersSecurityContextWindowsOptions(obj: TenantV2SpecSideCarsContainersSecurityContextWindowsOptions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersStartupProbeExec
 */
export interface TenantV2SpecSideCarsContainersStartupProbeExec {
    /**
     * @schema TenantV2SpecSideCarsContainersStartupProbeExec#command
     */
    readonly command?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersStartupProbeExec' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersStartupProbeExec(obj: TenantV2SpecSideCarsContainersStartupProbeExec | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersStartupProbeHttpGet
 */
export interface TenantV2SpecSideCarsContainersStartupProbeHttpGet {
    /**
     * @schema TenantV2SpecSideCarsContainersStartupProbeHttpGet#host
     */
    readonly host?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersStartupProbeHttpGet#httpHeaders
     */
    readonly httpHeaders?: TenantV2SpecSideCarsContainersStartupProbeHttpGetHttpHeaders[];
    /**
     * @schema TenantV2SpecSideCarsContainersStartupProbeHttpGet#path
     */
    readonly path?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersStartupProbeHttpGet#port
     */
    readonly port: TenantV2SpecSideCarsContainersStartupProbeHttpGetPort;
    /**
     * @schema TenantV2SpecSideCarsContainersStartupProbeHttpGet#scheme
     */
    readonly scheme?: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersStartupProbeHttpGet' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersStartupProbeHttpGet(obj: TenantV2SpecSideCarsContainersStartupProbeHttpGet | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersStartupProbeTcpSocket
 */
export interface TenantV2SpecSideCarsContainersStartupProbeTcpSocket {
    /**
     * @schema TenantV2SpecSideCarsContainersStartupProbeTcpSocket#host
     */
    readonly host?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersStartupProbeTcpSocket#port
     */
    readonly port: TenantV2SpecSideCarsContainersStartupProbeTcpSocketPort;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersStartupProbeTcpSocket' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersStartupProbeTcpSocket(obj: TenantV2SpecSideCarsContainersStartupProbeTcpSocket | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumeClaimTemplatesSpecDataSource
 */
export interface TenantV2SpecSideCarsVolumeClaimTemplatesSpecDataSource {
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplatesSpecDataSource#apiGroup
     */
    readonly apiGroup?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplatesSpecDataSource#kind
     */
    readonly kind: string;
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplatesSpecDataSource#name
     */
    readonly name: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumeClaimTemplatesSpecDataSource' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumeClaimTemplatesSpecDataSource(obj: TenantV2SpecSideCarsVolumeClaimTemplatesSpecDataSource | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumeClaimTemplatesSpecResources
 */
export interface TenantV2SpecSideCarsVolumeClaimTemplatesSpecResources {
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplatesSpecResources#limits
     */
    readonly limits?: {
        [key: string]: TenantV2SpecSideCarsVolumeClaimTemplatesSpecResourcesLimits;
    };
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplatesSpecResources#requests
     */
    readonly requests?: {
        [key: string]: TenantV2SpecSideCarsVolumeClaimTemplatesSpecResourcesRequests;
    };
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumeClaimTemplatesSpecResources' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumeClaimTemplatesSpecResources(obj: TenantV2SpecSideCarsVolumeClaimTemplatesSpecResources | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumeClaimTemplatesSpecSelector
 */
export interface TenantV2SpecSideCarsVolumeClaimTemplatesSpecSelector {
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplatesSpecSelector#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecSideCarsVolumeClaimTemplatesSpecSelectorMatchExpressions[];
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplatesSpecSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumeClaimTemplatesSpecSelector' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumeClaimTemplatesSpecSelector(obj: TenantV2SpecSideCarsVolumeClaimTemplatesSpecSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumeClaimTemplatesStatusCapacity
 */
export declare class TenantV2SpecSideCarsVolumeClaimTemplatesStatusCapacity {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecSideCarsVolumeClaimTemplatesStatusCapacity;
    static fromString(value: string): TenantV2SpecSideCarsVolumeClaimTemplatesStatusCapacity;
    private constructor();
}
/**
 * @schema TenantV2SpecSideCarsVolumeClaimTemplatesStatusConditions
 */
export interface TenantV2SpecSideCarsVolumeClaimTemplatesStatusConditions {
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplatesStatusConditions#lastProbeTime
     */
    readonly lastProbeTime?: Date;
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplatesStatusConditions#lastTransitionTime
     */
    readonly lastTransitionTime?: Date;
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplatesStatusConditions#message
     */
    readonly message?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplatesStatusConditions#reason
     */
    readonly reason?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplatesStatusConditions#status
     */
    readonly status: string;
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplatesStatusConditions#type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumeClaimTemplatesStatusConditions' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumeClaimTemplatesStatusConditions(obj: TenantV2SpecSideCarsVolumeClaimTemplatesStatusConditions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesCephfsSecretRef
 */
export interface TenantV2SpecSideCarsVolumesCephfsSecretRef {
    /**
     * @schema TenantV2SpecSideCarsVolumesCephfsSecretRef#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesCephfsSecretRef' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesCephfsSecretRef(obj: TenantV2SpecSideCarsVolumesCephfsSecretRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesCinderSecretRef
 */
export interface TenantV2SpecSideCarsVolumesCinderSecretRef {
    /**
     * @schema TenantV2SpecSideCarsVolumesCinderSecretRef#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesCinderSecretRef' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesCinderSecretRef(obj: TenantV2SpecSideCarsVolumesCinderSecretRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesConfigMapItems
 */
export interface TenantV2SpecSideCarsVolumesConfigMapItems {
    /**
     * @schema TenantV2SpecSideCarsVolumesConfigMapItems#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesConfigMapItems#mode
     */
    readonly mode?: number;
    /**
     * @schema TenantV2SpecSideCarsVolumesConfigMapItems#path
     */
    readonly path: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesConfigMapItems' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesConfigMapItems(obj: TenantV2SpecSideCarsVolumesConfigMapItems | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesCsiNodePublishSecretRef
 */
export interface TenantV2SpecSideCarsVolumesCsiNodePublishSecretRef {
    /**
     * @schema TenantV2SpecSideCarsVolumesCsiNodePublishSecretRef#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesCsiNodePublishSecretRef' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesCsiNodePublishSecretRef(obj: TenantV2SpecSideCarsVolumesCsiNodePublishSecretRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesDownwardApiItems
 */
export interface TenantV2SpecSideCarsVolumesDownwardApiItems {
    /**
     * @schema TenantV2SpecSideCarsVolumesDownwardApiItems#fieldRef
     */
    readonly fieldRef?: TenantV2SpecSideCarsVolumesDownwardApiItemsFieldRef;
    /**
     * @schema TenantV2SpecSideCarsVolumesDownwardApiItems#mode
     */
    readonly mode?: number;
    /**
     * @schema TenantV2SpecSideCarsVolumesDownwardApiItems#path
     */
    readonly path: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesDownwardApiItems#resourceFieldRef
     */
    readonly resourceFieldRef?: TenantV2SpecSideCarsVolumesDownwardApiItemsResourceFieldRef;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesDownwardApiItems' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesDownwardApiItems(obj: TenantV2SpecSideCarsVolumesDownwardApiItems | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesEmptyDirSizeLimit
 */
export declare class TenantV2SpecSideCarsVolumesEmptyDirSizeLimit {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecSideCarsVolumesEmptyDirSizeLimit;
    static fromString(value: string): TenantV2SpecSideCarsVolumesEmptyDirSizeLimit;
    private constructor();
}
/**
 * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplate
 */
export interface TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplate {
    /**
     * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplate#metadata
     */
    readonly metadata?: TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateMetadata;
    /**
     * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplate#spec
     */
    readonly spec: TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpec;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplate' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplate(obj: TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplate | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesFlexVolumeSecretRef
 */
export interface TenantV2SpecSideCarsVolumesFlexVolumeSecretRef {
    /**
     * @schema TenantV2SpecSideCarsVolumesFlexVolumeSecretRef#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesFlexVolumeSecretRef' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesFlexVolumeSecretRef(obj: TenantV2SpecSideCarsVolumesFlexVolumeSecretRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesIscsiSecretRef
 */
export interface TenantV2SpecSideCarsVolumesIscsiSecretRef {
    /**
     * @schema TenantV2SpecSideCarsVolumesIscsiSecretRef#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesIscsiSecretRef' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesIscsiSecretRef(obj: TenantV2SpecSideCarsVolumesIscsiSecretRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesProjectedSources
 */
export interface TenantV2SpecSideCarsVolumesProjectedSources {
    /**
     * @schema TenantV2SpecSideCarsVolumesProjectedSources#configMap
     */
    readonly configMap?: TenantV2SpecSideCarsVolumesProjectedSourcesConfigMap;
    /**
     * @schema TenantV2SpecSideCarsVolumesProjectedSources#downwardAPI
     */
    readonly downwardApi?: TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApi;
    /**
     * @schema TenantV2SpecSideCarsVolumesProjectedSources#secret
     */
    readonly secret?: TenantV2SpecSideCarsVolumesProjectedSourcesSecret;
    /**
     * @schema TenantV2SpecSideCarsVolumesProjectedSources#serviceAccountToken
     */
    readonly serviceAccountToken?: TenantV2SpecSideCarsVolumesProjectedSourcesServiceAccountToken;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesProjectedSources' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesProjectedSources(obj: TenantV2SpecSideCarsVolumesProjectedSources | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesRbdSecretRef
 */
export interface TenantV2SpecSideCarsVolumesRbdSecretRef {
    /**
     * @schema TenantV2SpecSideCarsVolumesRbdSecretRef#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesRbdSecretRef' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesRbdSecretRef(obj: TenantV2SpecSideCarsVolumesRbdSecretRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesScaleIoSecretRef
 */
export interface TenantV2SpecSideCarsVolumesScaleIoSecretRef {
    /**
     * @schema TenantV2SpecSideCarsVolumesScaleIoSecretRef#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesScaleIoSecretRef' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesScaleIoSecretRef(obj: TenantV2SpecSideCarsVolumesScaleIoSecretRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesSecretItems
 */
export interface TenantV2SpecSideCarsVolumesSecretItems {
    /**
     * @schema TenantV2SpecSideCarsVolumesSecretItems#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesSecretItems#mode
     */
    readonly mode?: number;
    /**
     * @schema TenantV2SpecSideCarsVolumesSecretItems#path
     */
    readonly path: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesSecretItems' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesSecretItems(obj: TenantV2SpecSideCarsVolumesSecretItems | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesStorageosSecretRef
 */
export interface TenantV2SpecSideCarsVolumesStorageosSecretRef {
    /**
     * @schema TenantV2SpecSideCarsVolumesStorageosSecretRef#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesStorageosSecretRef' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesStorageosSecretRef(obj: TenantV2SpecSideCarsVolumesStorageosSecretRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference
 */
export interface TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference {
    /**
     * @schema TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions[];
    /**
     * @schema TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference#matchFields
     */
    readonly matchFields?: TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields[];
}
/**
 * Converts an object of type 'TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference(obj: TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms
 */
export interface TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms {
    /**
     * @schema TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions[];
    /**
     * @schema TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms#matchFields
     */
    readonly matchFields?: TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields[];
}
/**
 * Converts an object of type 'TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms(obj: TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm
 */
export interface TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm {
    /**
     * @schema TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#labelSelector
     */
    readonly labelSelector?: TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector;
    /**
     * @schema TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(obj: TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector
 */
export interface TenantV2SpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector {
    /**
     * @schema TenantV2SpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[];
    /**
     * @schema TenantV2SpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantV2SpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(obj: TenantV2SpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm
 */
export interface TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm {
    /**
     * @schema TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#labelSelector
     */
    readonly labelSelector?: TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector;
    /**
     * @schema TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(obj: TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector
 */
export interface TenantV2SpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector {
    /**
     * @schema TenantV2SpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[];
    /**
     * @schema TenantV2SpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantV2SpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(obj: TenantV2SpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference
 */
export interface TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference {
    /**
     * @schema TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions[];
    /**
     * @schema TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference#matchFields
     */
    readonly matchFields?: TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields[];
}
/**
 * Converts an object of type 'TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference(obj: TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms
 */
export interface TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms {
    /**
     * @schema TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions[];
    /**
     * @schema TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms#matchFields
     */
    readonly matchFields?: TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields[];
}
/**
 * Converts an object of type 'TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms(obj: TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm
 */
export interface TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm {
    /**
     * @schema TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#labelSelector
     */
    readonly labelSelector?: TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector;
    /**
     * @schema TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(obj: TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector
 */
export interface TenantV2SpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector {
    /**
     * @schema TenantV2SpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[];
    /**
     * @schema TenantV2SpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantV2SpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(obj: TenantV2SpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm
 */
export interface TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm {
    /**
     * @schema TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#labelSelector
     */
    readonly labelSelector?: TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector;
    /**
     * @schema TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(obj: TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector
 */
export interface TenantV2SpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector {
    /**
     * @schema TenantV2SpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[];
    /**
     * @schema TenantV2SpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantV2SpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(obj: TenantV2SpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution#preference
     */
    readonly preference: TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference;
    /**
     * @schema TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
     */
    readonly weight: number;
}
/**
 * Converts an object of type 'TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution(obj: TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution#nodeSelectorTerms
     */
    readonly nodeSelectorTerms: TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms[];
}
/**
 * Converts an object of type 'TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution(obj: TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution#podAffinityTerm
     */
    readonly podAffinityTerm: TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm;
    /**
     * @schema TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
     */
    readonly weight: number;
}
/**
 * Converts an object of type 'TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution(obj: TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantV2SpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantV2SpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#labelSelector
     */
    readonly labelSelector?: TenantV2SpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector;
    /**
     * @schema TenantV2SpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantV2SpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantV2SpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution(obj: TenantV2SpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution#podAffinityTerm
     */
    readonly podAffinityTerm: TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm;
    /**
     * @schema TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution#weight
     */
    readonly weight: number;
}
/**
 * Converts an object of type 'TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution(obj: TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution
 */
export interface TenantV2SpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution {
    /**
     * @schema TenantV2SpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#labelSelector
     */
    readonly labelSelector?: TenantV2SpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector;
    /**
     * @schema TenantV2SpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantV2SpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantV2SpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution(obj: TenantV2SpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecution | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbTopologySpreadConstraintsLabelSelectorMatchExpressions
 */
export interface TenantV2SpecLogDbTopologySpreadConstraintsLabelSelectorMatchExpressions {
    /**
     * @schema TenantV2SpecLogDbTopologySpreadConstraintsLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecLogDbTopologySpreadConstraintsLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecLogDbTopologySpreadConstraintsLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecLogDbTopologySpreadConstraintsLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbTopologySpreadConstraintsLabelSelectorMatchExpressions(obj: TenantV2SpecLogDbTopologySpreadConstraintsLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbVolumeClaimTemplateSpecDataSource
 */
export interface TenantV2SpecLogDbVolumeClaimTemplateSpecDataSource {
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplateSpecDataSource#apiGroup
     */
    readonly apiGroup?: string;
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplateSpecDataSource#kind
     */
    readonly kind: string;
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplateSpecDataSource#name
     */
    readonly name: string;
}
/**
 * Converts an object of type 'TenantV2SpecLogDbVolumeClaimTemplateSpecDataSource' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbVolumeClaimTemplateSpecDataSource(obj: TenantV2SpecLogDbVolumeClaimTemplateSpecDataSource | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbVolumeClaimTemplateSpecResources
 */
export interface TenantV2SpecLogDbVolumeClaimTemplateSpecResources {
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplateSpecResources#limits
     */
    readonly limits?: {
        [key: string]: TenantV2SpecLogDbVolumeClaimTemplateSpecResourcesLimits;
    };
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplateSpecResources#requests
     */
    readonly requests?: {
        [key: string]: TenantV2SpecLogDbVolumeClaimTemplateSpecResourcesRequests;
    };
}
/**
 * Converts an object of type 'TenantV2SpecLogDbVolumeClaimTemplateSpecResources' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbVolumeClaimTemplateSpecResources(obj: TenantV2SpecLogDbVolumeClaimTemplateSpecResources | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbVolumeClaimTemplateSpecSelector
 */
export interface TenantV2SpecLogDbVolumeClaimTemplateSpecSelector {
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplateSpecSelector#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecLogDbVolumeClaimTemplateSpecSelectorMatchExpressions[];
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplateSpecSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantV2SpecLogDbVolumeClaimTemplateSpecSelector' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbVolumeClaimTemplateSpecSelector(obj: TenantV2SpecLogDbVolumeClaimTemplateSpecSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbVolumeClaimTemplateStatusCapacity
 */
export declare class TenantV2SpecLogDbVolumeClaimTemplateStatusCapacity {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecLogDbVolumeClaimTemplateStatusCapacity;
    static fromString(value: string): TenantV2SpecLogDbVolumeClaimTemplateStatusCapacity;
    private constructor();
}
/**
 * @schema TenantV2SpecLogDbVolumeClaimTemplateStatusConditions
 */
export interface TenantV2SpecLogDbVolumeClaimTemplateStatusConditions {
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplateStatusConditions#lastProbeTime
     */
    readonly lastProbeTime?: Date;
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplateStatusConditions#lastTransitionTime
     */
    readonly lastTransitionTime?: Date;
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplateStatusConditions#message
     */
    readonly message?: string;
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplateStatusConditions#reason
     */
    readonly reason?: string;
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplateStatusConditions#status
     */
    readonly status: string;
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplateStatusConditions#type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'TenantV2SpecLogDbVolumeClaimTemplateStatusConditions' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbVolumeClaimTemplateStatusConditions(obj: TenantV2SpecLogDbVolumeClaimTemplateStatusConditions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference
 */
export interface TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference {
    /**
     * @schema TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions[];
    /**
     * @schema TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference#matchFields
     */
    readonly matchFields?: TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields[];
}
/**
 * Converts an object of type 'TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference(obj: TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms
 */
export interface TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms {
    /**
     * @schema TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions[];
    /**
     * @schema TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms#matchFields
     */
    readonly matchFields?: TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields[];
}
/**
 * Converts an object of type 'TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms(obj: TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm
 */
export interface TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm {
    /**
     * @schema TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#labelSelector
     */
    readonly labelSelector?: TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector;
    /**
     * @schema TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(obj: TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector
 */
export interface TenantV2SpecPoolsAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector {
    /**
     * @schema TenantV2SpecPoolsAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecPoolsAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[];
    /**
     * @schema TenantV2SpecPoolsAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantV2SpecPoolsAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(obj: TenantV2SpecPoolsAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm
 */
export interface TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm {
    /**
     * @schema TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#labelSelector
     */
    readonly labelSelector?: TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector;
    /**
     * @schema TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(obj: TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector
 */
export interface TenantV2SpecPoolsAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector {
    /**
     * @schema TenantV2SpecPoolsAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecPoolsAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[];
    /**
     * @schema TenantV2SpecPoolsAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantV2SpecPoolsAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(obj: TenantV2SpecPoolsAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsVolumeClaimTemplateSpecResourcesLimits
 */
export declare class TenantV2SpecPoolsVolumeClaimTemplateSpecResourcesLimits {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecPoolsVolumeClaimTemplateSpecResourcesLimits;
    static fromString(value: string): TenantV2SpecPoolsVolumeClaimTemplateSpecResourcesLimits;
    private constructor();
}
/**
 * @schema TenantV2SpecPoolsVolumeClaimTemplateSpecResourcesRequests
 */
export declare class TenantV2SpecPoolsVolumeClaimTemplateSpecResourcesRequests {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecPoolsVolumeClaimTemplateSpecResourcesRequests;
    static fromString(value: string): TenantV2SpecPoolsVolumeClaimTemplateSpecResourcesRequests;
    private constructor();
}
/**
 * @schema TenantV2SpecPoolsVolumeClaimTemplateSpecSelectorMatchExpressions
 */
export interface TenantV2SpecPoolsVolumeClaimTemplateSpecSelectorMatchExpressions {
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplateSpecSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplateSpecSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecPoolsVolumeClaimTemplateSpecSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecPoolsVolumeClaimTemplateSpecSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsVolumeClaimTemplateSpecSelectorMatchExpressions(obj: TenantV2SpecPoolsVolumeClaimTemplateSpecSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference
 */
export interface TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference {
    /**
     * @schema TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions[];
    /**
     * @schema TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference#matchFields
     */
    readonly matchFields?: TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields[];
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference(obj: TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms
 */
export interface TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms {
    /**
     * @schema TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions[];
    /**
     * @schema TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms#matchFields
     */
    readonly matchFields?: TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields[];
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms(obj: TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm
 */
export interface TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm {
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#labelSelector
     */
    readonly labelSelector?: TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector;
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(obj: TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector
 */
export interface TenantV2SpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector {
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[];
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(obj: TenantV2SpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm
 */
export interface TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm {
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#labelSelector
     */
    readonly labelSelector?: TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector;
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(obj: TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector
 */
export interface TenantV2SpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector {
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[];
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(obj: TenantV2SpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersEnvValueFromConfigMapKeyRef
 */
export interface TenantV2SpecSideCarsContainersEnvValueFromConfigMapKeyRef {
    /**
     * @schema TenantV2SpecSideCarsContainersEnvValueFromConfigMapKeyRef#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecSideCarsContainersEnvValueFromConfigMapKeyRef#name
     */
    readonly name?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersEnvValueFromConfigMapKeyRef#optional
     */
    readonly optional?: boolean;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersEnvValueFromConfigMapKeyRef' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersEnvValueFromConfigMapKeyRef(obj: TenantV2SpecSideCarsContainersEnvValueFromConfigMapKeyRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersEnvValueFromFieldRef
 */
export interface TenantV2SpecSideCarsContainersEnvValueFromFieldRef {
    /**
     * @schema TenantV2SpecSideCarsContainersEnvValueFromFieldRef#apiVersion
     */
    readonly apiVersion?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersEnvValueFromFieldRef#fieldPath
     */
    readonly fieldPath: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersEnvValueFromFieldRef' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersEnvValueFromFieldRef(obj: TenantV2SpecSideCarsContainersEnvValueFromFieldRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersEnvValueFromResourceFieldRef
 */
export interface TenantV2SpecSideCarsContainersEnvValueFromResourceFieldRef {
    /**
     * @schema TenantV2SpecSideCarsContainersEnvValueFromResourceFieldRef#containerName
     */
    readonly containerName?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersEnvValueFromResourceFieldRef#divisor
     */
    readonly divisor?: TenantV2SpecSideCarsContainersEnvValueFromResourceFieldRefDivisor;
    /**
     * @schema TenantV2SpecSideCarsContainersEnvValueFromResourceFieldRef#resource
     */
    readonly resource: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersEnvValueFromResourceFieldRef' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersEnvValueFromResourceFieldRef(obj: TenantV2SpecSideCarsContainersEnvValueFromResourceFieldRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersEnvValueFromSecretKeyRef
 */
export interface TenantV2SpecSideCarsContainersEnvValueFromSecretKeyRef {
    /**
     * @schema TenantV2SpecSideCarsContainersEnvValueFromSecretKeyRef#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecSideCarsContainersEnvValueFromSecretKeyRef#name
     */
    readonly name?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersEnvValueFromSecretKeyRef#optional
     */
    readonly optional?: boolean;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersEnvValueFromSecretKeyRef' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersEnvValueFromSecretKeyRef(obj: TenantV2SpecSideCarsContainersEnvValueFromSecretKeyRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersLifecyclePostStartExec
 */
export interface TenantV2SpecSideCarsContainersLifecyclePostStartExec {
    /**
     * @schema TenantV2SpecSideCarsContainersLifecyclePostStartExec#command
     */
    readonly command?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersLifecyclePostStartExec' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersLifecyclePostStartExec(obj: TenantV2SpecSideCarsContainersLifecyclePostStartExec | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersLifecyclePostStartHttpGet
 */
export interface TenantV2SpecSideCarsContainersLifecyclePostStartHttpGet {
    /**
     * @schema TenantV2SpecSideCarsContainersLifecyclePostStartHttpGet#host
     */
    readonly host?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersLifecyclePostStartHttpGet#httpHeaders
     */
    readonly httpHeaders?: TenantV2SpecSideCarsContainersLifecyclePostStartHttpGetHttpHeaders[];
    /**
     * @schema TenantV2SpecSideCarsContainersLifecyclePostStartHttpGet#path
     */
    readonly path?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersLifecyclePostStartHttpGet#port
     */
    readonly port: TenantV2SpecSideCarsContainersLifecyclePostStartHttpGetPort;
    /**
     * @schema TenantV2SpecSideCarsContainersLifecyclePostStartHttpGet#scheme
     */
    readonly scheme?: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersLifecyclePostStartHttpGet' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersLifecyclePostStartHttpGet(obj: TenantV2SpecSideCarsContainersLifecyclePostStartHttpGet | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersLifecyclePostStartTcpSocket
 */
export interface TenantV2SpecSideCarsContainersLifecyclePostStartTcpSocket {
    /**
     * @schema TenantV2SpecSideCarsContainersLifecyclePostStartTcpSocket#host
     */
    readonly host?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersLifecyclePostStartTcpSocket#port
     */
    readonly port: TenantV2SpecSideCarsContainersLifecyclePostStartTcpSocketPort;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersLifecyclePostStartTcpSocket' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersLifecyclePostStartTcpSocket(obj: TenantV2SpecSideCarsContainersLifecyclePostStartTcpSocket | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersLifecyclePreStopExec
 */
export interface TenantV2SpecSideCarsContainersLifecyclePreStopExec {
    /**
     * @schema TenantV2SpecSideCarsContainersLifecyclePreStopExec#command
     */
    readonly command?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersLifecyclePreStopExec' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersLifecyclePreStopExec(obj: TenantV2SpecSideCarsContainersLifecyclePreStopExec | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersLifecyclePreStopHttpGet
 */
export interface TenantV2SpecSideCarsContainersLifecyclePreStopHttpGet {
    /**
     * @schema TenantV2SpecSideCarsContainersLifecyclePreStopHttpGet#host
     */
    readonly host?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersLifecyclePreStopHttpGet#httpHeaders
     */
    readonly httpHeaders?: TenantV2SpecSideCarsContainersLifecyclePreStopHttpGetHttpHeaders[];
    /**
     * @schema TenantV2SpecSideCarsContainersLifecyclePreStopHttpGet#path
     */
    readonly path?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersLifecyclePreStopHttpGet#port
     */
    readonly port: TenantV2SpecSideCarsContainersLifecyclePreStopHttpGetPort;
    /**
     * @schema TenantV2SpecSideCarsContainersLifecyclePreStopHttpGet#scheme
     */
    readonly scheme?: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersLifecyclePreStopHttpGet' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersLifecyclePreStopHttpGet(obj: TenantV2SpecSideCarsContainersLifecyclePreStopHttpGet | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersLifecyclePreStopTcpSocket
 */
export interface TenantV2SpecSideCarsContainersLifecyclePreStopTcpSocket {
    /**
     * @schema TenantV2SpecSideCarsContainersLifecyclePreStopTcpSocket#host
     */
    readonly host?: string;
    /**
     * @schema TenantV2SpecSideCarsContainersLifecyclePreStopTcpSocket#port
     */
    readonly port: TenantV2SpecSideCarsContainersLifecyclePreStopTcpSocketPort;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersLifecyclePreStopTcpSocket' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersLifecyclePreStopTcpSocket(obj: TenantV2SpecSideCarsContainersLifecyclePreStopTcpSocket | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersLivenessProbeHttpGetHttpHeaders
 */
export interface TenantV2SpecSideCarsContainersLivenessProbeHttpGetHttpHeaders {
    /**
     * @schema TenantV2SpecSideCarsContainersLivenessProbeHttpGetHttpHeaders#name
     */
    readonly name: string;
    /**
     * @schema TenantV2SpecSideCarsContainersLivenessProbeHttpGetHttpHeaders#value
     */
    readonly value: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersLivenessProbeHttpGetHttpHeaders' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersLivenessProbeHttpGetHttpHeaders(obj: TenantV2SpecSideCarsContainersLivenessProbeHttpGetHttpHeaders | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersLivenessProbeHttpGetPort
 */
export declare class TenantV2SpecSideCarsContainersLivenessProbeHttpGetPort {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecSideCarsContainersLivenessProbeHttpGetPort;
    static fromString(value: string): TenantV2SpecSideCarsContainersLivenessProbeHttpGetPort;
    private constructor();
}
/**
 * @schema TenantV2SpecSideCarsContainersLivenessProbeTcpSocketPort
 */
export declare class TenantV2SpecSideCarsContainersLivenessProbeTcpSocketPort {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecSideCarsContainersLivenessProbeTcpSocketPort;
    static fromString(value: string): TenantV2SpecSideCarsContainersLivenessProbeTcpSocketPort;
    private constructor();
}
/**
 * @schema TenantV2SpecSideCarsContainersReadinessProbeHttpGetHttpHeaders
 */
export interface TenantV2SpecSideCarsContainersReadinessProbeHttpGetHttpHeaders {
    /**
     * @schema TenantV2SpecSideCarsContainersReadinessProbeHttpGetHttpHeaders#name
     */
    readonly name: string;
    /**
     * @schema TenantV2SpecSideCarsContainersReadinessProbeHttpGetHttpHeaders#value
     */
    readonly value: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersReadinessProbeHttpGetHttpHeaders' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersReadinessProbeHttpGetHttpHeaders(obj: TenantV2SpecSideCarsContainersReadinessProbeHttpGetHttpHeaders | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersReadinessProbeHttpGetPort
 */
export declare class TenantV2SpecSideCarsContainersReadinessProbeHttpGetPort {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecSideCarsContainersReadinessProbeHttpGetPort;
    static fromString(value: string): TenantV2SpecSideCarsContainersReadinessProbeHttpGetPort;
    private constructor();
}
/**
 * @schema TenantV2SpecSideCarsContainersReadinessProbeTcpSocketPort
 */
export declare class TenantV2SpecSideCarsContainersReadinessProbeTcpSocketPort {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecSideCarsContainersReadinessProbeTcpSocketPort;
    static fromString(value: string): TenantV2SpecSideCarsContainersReadinessProbeTcpSocketPort;
    private constructor();
}
/**
 * @schema TenantV2SpecSideCarsContainersStartupProbeHttpGetHttpHeaders
 */
export interface TenantV2SpecSideCarsContainersStartupProbeHttpGetHttpHeaders {
    /**
     * @schema TenantV2SpecSideCarsContainersStartupProbeHttpGetHttpHeaders#name
     */
    readonly name: string;
    /**
     * @schema TenantV2SpecSideCarsContainersStartupProbeHttpGetHttpHeaders#value
     */
    readonly value: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersStartupProbeHttpGetHttpHeaders' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersStartupProbeHttpGetHttpHeaders(obj: TenantV2SpecSideCarsContainersStartupProbeHttpGetHttpHeaders | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersStartupProbeHttpGetPort
 */
export declare class TenantV2SpecSideCarsContainersStartupProbeHttpGetPort {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecSideCarsContainersStartupProbeHttpGetPort;
    static fromString(value: string): TenantV2SpecSideCarsContainersStartupProbeHttpGetPort;
    private constructor();
}
/**
 * @schema TenantV2SpecSideCarsContainersStartupProbeTcpSocketPort
 */
export declare class TenantV2SpecSideCarsContainersStartupProbeTcpSocketPort {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecSideCarsContainersStartupProbeTcpSocketPort;
    static fromString(value: string): TenantV2SpecSideCarsContainersStartupProbeTcpSocketPort;
    private constructor();
}
/**
 * @schema TenantV2SpecSideCarsVolumeClaimTemplatesSpecResourcesLimits
 */
export declare class TenantV2SpecSideCarsVolumeClaimTemplatesSpecResourcesLimits {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecSideCarsVolumeClaimTemplatesSpecResourcesLimits;
    static fromString(value: string): TenantV2SpecSideCarsVolumeClaimTemplatesSpecResourcesLimits;
    private constructor();
}
/**
 * @schema TenantV2SpecSideCarsVolumeClaimTemplatesSpecResourcesRequests
 */
export declare class TenantV2SpecSideCarsVolumeClaimTemplatesSpecResourcesRequests {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecSideCarsVolumeClaimTemplatesSpecResourcesRequests;
    static fromString(value: string): TenantV2SpecSideCarsVolumeClaimTemplatesSpecResourcesRequests;
    private constructor();
}
/**
 * @schema TenantV2SpecSideCarsVolumeClaimTemplatesSpecSelectorMatchExpressions
 */
export interface TenantV2SpecSideCarsVolumeClaimTemplatesSpecSelectorMatchExpressions {
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplatesSpecSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplatesSpecSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecSideCarsVolumeClaimTemplatesSpecSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumeClaimTemplatesSpecSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumeClaimTemplatesSpecSelectorMatchExpressions(obj: TenantV2SpecSideCarsVolumeClaimTemplatesSpecSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesDownwardApiItemsFieldRef
 */
export interface TenantV2SpecSideCarsVolumesDownwardApiItemsFieldRef {
    /**
     * @schema TenantV2SpecSideCarsVolumesDownwardApiItemsFieldRef#apiVersion
     */
    readonly apiVersion?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesDownwardApiItemsFieldRef#fieldPath
     */
    readonly fieldPath: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesDownwardApiItemsFieldRef' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesDownwardApiItemsFieldRef(obj: TenantV2SpecSideCarsVolumesDownwardApiItemsFieldRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesDownwardApiItemsResourceFieldRef
 */
export interface TenantV2SpecSideCarsVolumesDownwardApiItemsResourceFieldRef {
    /**
     * @schema TenantV2SpecSideCarsVolumesDownwardApiItemsResourceFieldRef#containerName
     */
    readonly containerName?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesDownwardApiItemsResourceFieldRef#divisor
     */
    readonly divisor?: TenantV2SpecSideCarsVolumesDownwardApiItemsResourceFieldRefDivisor;
    /**
     * @schema TenantV2SpecSideCarsVolumesDownwardApiItemsResourceFieldRef#resource
     */
    readonly resource: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesDownwardApiItemsResourceFieldRef' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesDownwardApiItemsResourceFieldRef(obj: TenantV2SpecSideCarsVolumesDownwardApiItemsResourceFieldRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateMetadata
 */
export interface TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateMetadata {
    /**
     * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateMetadata#annotations
     */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
     * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateMetadata#finalizers
     */
    readonly finalizers?: string[];
    /**
     * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateMetadata#labels
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateMetadata#name
     */
    readonly name?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateMetadata#namespace
     */
    readonly namespace?: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateMetadata' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateMetadata(obj: TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateMetadata | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpec
 */
export interface TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpec {
    /**
     * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpec#accessModes
     */
    readonly accessModes?: string[];
    /**
     * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpec#dataSource
     */
    readonly dataSource?: TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecDataSource;
    /**
     * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpec#resources
     */
    readonly resources?: TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResources;
    /**
     * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpec#selector
     */
    readonly selector?: TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelector;
    /**
     * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpec#storageClassName
     */
    readonly storageClassName?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpec#volumeMode
     */
    readonly volumeMode?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpec#volumeName
     */
    readonly volumeName?: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpec' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpec(obj: TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpec | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesProjectedSourcesConfigMap
 */
export interface TenantV2SpecSideCarsVolumesProjectedSourcesConfigMap {
    /**
     * @schema TenantV2SpecSideCarsVolumesProjectedSourcesConfigMap#items
     */
    readonly items?: TenantV2SpecSideCarsVolumesProjectedSourcesConfigMapItems[];
    /**
     * @schema TenantV2SpecSideCarsVolumesProjectedSourcesConfigMap#name
     */
    readonly name?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesProjectedSourcesConfigMap#optional
     */
    readonly optional?: boolean;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesProjectedSourcesConfigMap' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesProjectedSourcesConfigMap(obj: TenantV2SpecSideCarsVolumesProjectedSourcesConfigMap | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApi
 */
export interface TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApi {
    /**
     * @schema TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApi#items
     */
    readonly items?: TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApiItems[];
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApi' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApi(obj: TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApi | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesProjectedSourcesSecret
 */
export interface TenantV2SpecSideCarsVolumesProjectedSourcesSecret {
    /**
     * @schema TenantV2SpecSideCarsVolumesProjectedSourcesSecret#items
     */
    readonly items?: TenantV2SpecSideCarsVolumesProjectedSourcesSecretItems[];
    /**
     * @schema TenantV2SpecSideCarsVolumesProjectedSourcesSecret#name
     */
    readonly name?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesProjectedSourcesSecret#optional
     */
    readonly optional?: boolean;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesProjectedSourcesSecret' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesProjectedSourcesSecret(obj: TenantV2SpecSideCarsVolumesProjectedSourcesSecret | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesProjectedSourcesServiceAccountToken
 */
export interface TenantV2SpecSideCarsVolumesProjectedSourcesServiceAccountToken {
    /**
     * @schema TenantV2SpecSideCarsVolumesProjectedSourcesServiceAccountToken#audience
     */
    readonly audience?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesProjectedSourcesServiceAccountToken#expirationSeconds
     */
    readonly expirationSeconds?: number;
    /**
     * @schema TenantV2SpecSideCarsVolumesProjectedSourcesServiceAccountToken#path
     */
    readonly path: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesProjectedSourcesServiceAccountToken' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesProjectedSourcesServiceAccountToken(obj: TenantV2SpecSideCarsVolumesProjectedSourcesServiceAccountToken | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions
 */
export interface TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions {
    /**
     * @schema TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions(obj: TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields
 */
export interface TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields {
    /**
     * @schema TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields(obj: TenantV2SpecKesAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions
 */
export interface TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions {
    /**
     * @schema TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions(obj: TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields
 */
export interface TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields {
    /**
     * @schema TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields(obj: TenantV2SpecKesAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector
 */
export interface TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector {
    /**
     * @schema TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[];
    /**
     * @schema TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(obj: TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions
 */
export interface TenantV2SpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions {
    /**
     * @schema TenantV2SpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions(obj: TenantV2SpecKesAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector
 */
export interface TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector {
    /**
     * @schema TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[];
    /**
     * @schema TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(obj: TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions
 */
export interface TenantV2SpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions {
    /**
     * @schema TenantV2SpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions(obj: TenantV2SpecKesAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions
 */
export interface TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions {
    /**
     * @schema TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions(obj: TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields
 */
export interface TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields {
    /**
     * @schema TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields(obj: TenantV2SpecLogAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions
 */
export interface TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions {
    /**
     * @schema TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions(obj: TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields
 */
export interface TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields {
    /**
     * @schema TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields(obj: TenantV2SpecLogAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector
 */
export interface TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector {
    /**
     * @schema TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[];
    /**
     * @schema TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(obj: TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions
 */
export interface TenantV2SpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions {
    /**
     * @schema TenantV2SpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions(obj: TenantV2SpecLogAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector
 */
export interface TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector {
    /**
     * @schema TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[];
    /**
     * @schema TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(obj: TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions
 */
export interface TenantV2SpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions {
    /**
     * @schema TenantV2SpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions(obj: TenantV2SpecLogAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference
 */
export interface TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference {
    /**
     * @schema TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions[];
    /**
     * @schema TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference#matchFields
     */
    readonly matchFields?: TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields[];
}
/**
 * Converts an object of type 'TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference(obj: TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreference | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms
 */
export interface TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms {
    /**
     * @schema TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions[];
    /**
     * @schema TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms#matchFields
     */
    readonly matchFields?: TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields[];
}
/**
 * Converts an object of type 'TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms(obj: TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTerms | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm
 */
export interface TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm {
    /**
     * @schema TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#labelSelector
     */
    readonly labelSelector?: TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector;
    /**
     * @schema TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(obj: TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector
 */
export interface TenantV2SpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector {
    /**
     * @schema TenantV2SpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[];
    /**
     * @schema TenantV2SpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantV2SpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(obj: TenantV2SpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm
 */
export interface TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm {
    /**
     * @schema TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#labelSelector
     */
    readonly labelSelector?: TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector;
    /**
     * @schema TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#namespaces
     */
    readonly namespaces?: string[];
    /**
     * @schema TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm#topologyKey
     */
    readonly topologyKey: string;
}
/**
 * Converts an object of type 'TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm(obj: TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTerm | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector
 */
export interface TenantV2SpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector {
    /**
     * @schema TenantV2SpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions[];
    /**
     * @schema TenantV2SpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantV2SpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector(obj: TenantV2SpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbVolumeClaimTemplateSpecResourcesLimits
 */
export declare class TenantV2SpecLogDbVolumeClaimTemplateSpecResourcesLimits {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecLogDbVolumeClaimTemplateSpecResourcesLimits;
    static fromString(value: string): TenantV2SpecLogDbVolumeClaimTemplateSpecResourcesLimits;
    private constructor();
}
/**
 * @schema TenantV2SpecLogDbVolumeClaimTemplateSpecResourcesRequests
 */
export declare class TenantV2SpecLogDbVolumeClaimTemplateSpecResourcesRequests {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecLogDbVolumeClaimTemplateSpecResourcesRequests;
    static fromString(value: string): TenantV2SpecLogDbVolumeClaimTemplateSpecResourcesRequests;
    private constructor();
}
/**
 * @schema TenantV2SpecLogDbVolumeClaimTemplateSpecSelectorMatchExpressions
 */
export interface TenantV2SpecLogDbVolumeClaimTemplateSpecSelectorMatchExpressions {
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplateSpecSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplateSpecSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecLogDbVolumeClaimTemplateSpecSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecLogDbVolumeClaimTemplateSpecSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbVolumeClaimTemplateSpecSelectorMatchExpressions(obj: TenantV2SpecLogDbVolumeClaimTemplateSpecSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions
 */
export interface TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions {
    /**
     * @schema TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions(obj: TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields
 */
export interface TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields {
    /**
     * @schema TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields(obj: TenantV2SpecPoolsAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions
 */
export interface TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions {
    /**
     * @schema TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions(obj: TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields
 */
export interface TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields {
    /**
     * @schema TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields(obj: TenantV2SpecPoolsAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector
 */
export interface TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector {
    /**
     * @schema TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[];
    /**
     * @schema TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(obj: TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions
 */
export interface TenantV2SpecPoolsAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions {
    /**
     * @schema TenantV2SpecPoolsAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecPoolsAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecPoolsAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecPoolsAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions(obj: TenantV2SpecPoolsAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector
 */
export interface TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector {
    /**
     * @schema TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[];
    /**
     * @schema TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(obj: TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions
 */
export interface TenantV2SpecPoolsAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions {
    /**
     * @schema TenantV2SpecPoolsAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecPoolsAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecPoolsAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecPoolsAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions(obj: TenantV2SpecPoolsAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions
 */
export interface TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions {
    /**
     * @schema TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions(obj: TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields
 */
export interface TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields {
    /**
     * @schema TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields(obj: TenantV2SpecPrometheusAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions
 */
export interface TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions {
    /**
     * @schema TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions(obj: TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields
 */
export interface TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields {
    /**
     * @schema TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields(obj: TenantV2SpecPrometheusAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector
 */
export interface TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector {
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[];
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(obj: TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions
 */
export interface TenantV2SpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions {
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions(obj: TenantV2SpecPrometheusAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector
 */
export interface TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector {
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[];
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(obj: TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions
 */
export interface TenantV2SpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions {
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions(obj: TenantV2SpecPrometheusAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersEnvValueFromResourceFieldRefDivisor
 */
export declare class TenantV2SpecSideCarsContainersEnvValueFromResourceFieldRefDivisor {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecSideCarsContainersEnvValueFromResourceFieldRefDivisor;
    static fromString(value: string): TenantV2SpecSideCarsContainersEnvValueFromResourceFieldRefDivisor;
    private constructor();
}
/**
 * @schema TenantV2SpecSideCarsContainersLifecyclePostStartHttpGetHttpHeaders
 */
export interface TenantV2SpecSideCarsContainersLifecyclePostStartHttpGetHttpHeaders {
    /**
     * @schema TenantV2SpecSideCarsContainersLifecyclePostStartHttpGetHttpHeaders#name
     */
    readonly name: string;
    /**
     * @schema TenantV2SpecSideCarsContainersLifecyclePostStartHttpGetHttpHeaders#value
     */
    readonly value: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersLifecyclePostStartHttpGetHttpHeaders' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersLifecyclePostStartHttpGetHttpHeaders(obj: TenantV2SpecSideCarsContainersLifecyclePostStartHttpGetHttpHeaders | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersLifecyclePostStartHttpGetPort
 */
export declare class TenantV2SpecSideCarsContainersLifecyclePostStartHttpGetPort {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecSideCarsContainersLifecyclePostStartHttpGetPort;
    static fromString(value: string): TenantV2SpecSideCarsContainersLifecyclePostStartHttpGetPort;
    private constructor();
}
/**
 * @schema TenantV2SpecSideCarsContainersLifecyclePostStartTcpSocketPort
 */
export declare class TenantV2SpecSideCarsContainersLifecyclePostStartTcpSocketPort {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecSideCarsContainersLifecyclePostStartTcpSocketPort;
    static fromString(value: string): TenantV2SpecSideCarsContainersLifecyclePostStartTcpSocketPort;
    private constructor();
}
/**
 * @schema TenantV2SpecSideCarsContainersLifecyclePreStopHttpGetHttpHeaders
 */
export interface TenantV2SpecSideCarsContainersLifecyclePreStopHttpGetHttpHeaders {
    /**
     * @schema TenantV2SpecSideCarsContainersLifecyclePreStopHttpGetHttpHeaders#name
     */
    readonly name: string;
    /**
     * @schema TenantV2SpecSideCarsContainersLifecyclePreStopHttpGetHttpHeaders#value
     */
    readonly value: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsContainersLifecyclePreStopHttpGetHttpHeaders' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsContainersLifecyclePreStopHttpGetHttpHeaders(obj: TenantV2SpecSideCarsContainersLifecyclePreStopHttpGetHttpHeaders | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsContainersLifecyclePreStopHttpGetPort
 */
export declare class TenantV2SpecSideCarsContainersLifecyclePreStopHttpGetPort {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecSideCarsContainersLifecyclePreStopHttpGetPort;
    static fromString(value: string): TenantV2SpecSideCarsContainersLifecyclePreStopHttpGetPort;
    private constructor();
}
/**
 * @schema TenantV2SpecSideCarsContainersLifecyclePreStopTcpSocketPort
 */
export declare class TenantV2SpecSideCarsContainersLifecyclePreStopTcpSocketPort {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecSideCarsContainersLifecyclePreStopTcpSocketPort;
    static fromString(value: string): TenantV2SpecSideCarsContainersLifecyclePreStopTcpSocketPort;
    private constructor();
}
/**
 * @schema TenantV2SpecSideCarsVolumesDownwardApiItemsResourceFieldRefDivisor
 */
export declare class TenantV2SpecSideCarsVolumesDownwardApiItemsResourceFieldRefDivisor {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecSideCarsVolumesDownwardApiItemsResourceFieldRefDivisor;
    static fromString(value: string): TenantV2SpecSideCarsVolumesDownwardApiItemsResourceFieldRefDivisor;
    private constructor();
}
/**
 * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecDataSource
 */
export interface TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecDataSource {
    /**
     * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecDataSource#apiGroup
     */
    readonly apiGroup?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecDataSource#kind
     */
    readonly kind: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecDataSource#name
     */
    readonly name: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecDataSource' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecDataSource(obj: TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecDataSource | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResources
 */
export interface TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResources {
    /**
     * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResources#limits
     */
    readonly limits?: {
        [key: string]: TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResourcesLimits;
    };
    /**
     * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResources#requests
     */
    readonly requests?: {
        [key: string]: TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResourcesRequests;
    };
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResources' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResources(obj: TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResources | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelector
 */
export interface TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelector {
    /**
     * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelector#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelectorMatchExpressions[];
    /**
     * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelector' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelector(obj: TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesProjectedSourcesConfigMapItems
 */
export interface TenantV2SpecSideCarsVolumesProjectedSourcesConfigMapItems {
    /**
     * @schema TenantV2SpecSideCarsVolumesProjectedSourcesConfigMapItems#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesProjectedSourcesConfigMapItems#mode
     */
    readonly mode?: number;
    /**
     * @schema TenantV2SpecSideCarsVolumesProjectedSourcesConfigMapItems#path
     */
    readonly path: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesProjectedSourcesConfigMapItems' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesProjectedSourcesConfigMapItems(obj: TenantV2SpecSideCarsVolumesProjectedSourcesConfigMapItems | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApiItems
 */
export interface TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApiItems {
    /**
     * @schema TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApiItems#fieldRef
     */
    readonly fieldRef?: TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApiItemsFieldRef;
    /**
     * @schema TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApiItems#mode
     */
    readonly mode?: number;
    /**
     * @schema TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApiItems#path
     */
    readonly path: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApiItems#resourceFieldRef
     */
    readonly resourceFieldRef?: TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApiItemsResourceFieldRef;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApiItems' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApiItems(obj: TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApiItems | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesProjectedSourcesSecretItems
 */
export interface TenantV2SpecSideCarsVolumesProjectedSourcesSecretItems {
    /**
     * @schema TenantV2SpecSideCarsVolumesProjectedSourcesSecretItems#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesProjectedSourcesSecretItems#mode
     */
    readonly mode?: number;
    /**
     * @schema TenantV2SpecSideCarsVolumesProjectedSourcesSecretItems#path
     */
    readonly path: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesProjectedSourcesSecretItems' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesProjectedSourcesSecretItems(obj: TenantV2SpecSideCarsVolumesProjectedSourcesSecretItems | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions
 */
export interface TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions {
    /**
     * @schema TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions(obj: TenantV2SpecKesAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions
 */
export interface TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions {
    /**
     * @schema TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions(obj: TenantV2SpecKesAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions
 */
export interface TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions {
    /**
     * @schema TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions(obj: TenantV2SpecLogAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions
 */
export interface TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions {
    /**
     * @schema TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions(obj: TenantV2SpecLogAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions
 */
export interface TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions {
    /**
     * @schema TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions(obj: TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields
 */
export interface TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields {
    /**
     * @schema TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields(obj: TenantV2SpecLogDbAffinityNodeAffinityPreferredDuringSchedulingIgnoredDuringExecutionPreferenceMatchFields | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions
 */
export interface TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions {
    /**
     * @schema TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions(obj: TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields
 */
export interface TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields {
    /**
     * @schema TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields(obj: TenantV2SpecLogDbAffinityNodeAffinityRequiredDuringSchedulingIgnoredDuringExecutionNodeSelectorTermsMatchFields | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector
 */
export interface TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector {
    /**
     * @schema TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[];
    /**
     * @schema TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(obj: TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions
 */
export interface TenantV2SpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions {
    /**
     * @schema TenantV2SpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions(obj: TenantV2SpecLogDbAffinityPodAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector
 */
export interface TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector {
    /**
     * @schema TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchExpressions
     */
    readonly matchExpressions?: TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions[];
    /**
     * @schema TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector(obj: TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelector | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions
 */
export interface TenantV2SpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions {
    /**
     * @schema TenantV2SpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions(obj: TenantV2SpecLogDbAffinityPodAntiAffinityRequiredDuringSchedulingIgnoredDuringExecutionLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions
 */
export interface TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions {
    /**
     * @schema TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions(obj: TenantV2SpecPoolsAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions
 */
export interface TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions {
    /**
     * @schema TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions(obj: TenantV2SpecPoolsAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions
 */
export interface TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions {
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions(obj: TenantV2SpecPrometheusAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions
 */
export interface TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions {
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions(obj: TenantV2SpecPrometheusAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResourcesLimits
 */
export declare class TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResourcesLimits {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResourcesLimits;
    static fromString(value: string): TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResourcesLimits;
    private constructor();
}
/**
 * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResourcesRequests
 */
export declare class TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResourcesRequests {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResourcesRequests;
    static fromString(value: string): TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecResourcesRequests;
    private constructor();
}
/**
 * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelectorMatchExpressions
 */
export interface TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelectorMatchExpressions {
    /**
     * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelectorMatchExpressions(obj: TenantV2SpecSideCarsVolumesEphemeralVolumeClaimTemplateSpecSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApiItemsFieldRef
 */
export interface TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApiItemsFieldRef {
    /**
     * @schema TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApiItemsFieldRef#apiVersion
     */
    readonly apiVersion?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApiItemsFieldRef#fieldPath
     */
    readonly fieldPath: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApiItemsFieldRef' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApiItemsFieldRef(obj: TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApiItemsFieldRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApiItemsResourceFieldRef
 */
export interface TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApiItemsResourceFieldRef {
    /**
     * @schema TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApiItemsResourceFieldRef#containerName
     */
    readonly containerName?: string;
    /**
     * @schema TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApiItemsResourceFieldRef#divisor
     */
    readonly divisor?: TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApiItemsResourceFieldRefDivisor;
    /**
     * @schema TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApiItemsResourceFieldRef#resource
     */
    readonly resource: string;
}
/**
 * Converts an object of type 'TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApiItemsResourceFieldRef' to JSON representation.
 */
export declare function toJson_TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApiItemsResourceFieldRef(obj: TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApiItemsResourceFieldRef | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions
 */
export interface TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions {
    /**
     * @schema TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions(obj: TenantV2SpecLogDbAffinityPodAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions
 */
export interface TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions {
    /**
     * @schema TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * @schema TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * @schema TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions(obj: TenantV2SpecLogDbAffinityPodAntiAffinityPreferredDuringSchedulingIgnoredDuringExecutionPodAffinityTermLabelSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * @schema TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApiItemsResourceFieldRefDivisor
 */
export declare class TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApiItemsResourceFieldRefDivisor {
    readonly value: any;
    static fromNumber(value: number): TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApiItemsResourceFieldRefDivisor;
    static fromString(value: string): TenantV2SpecSideCarsVolumesProjectedSourcesDownwardApiItemsResourceFieldRefDivisor;
    private constructor();
}
