from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import mpi_cbs.mediforms.models
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='FormDataMRT',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('last_name', models.CharField(max_length=255, verbose_name='Last name')),
                ('first_name', models.CharField(max_length=255, verbose_name='First name')),
                ('height', models.IntegerField(blank=True, null=True, verbose_name='Height')),
                ('weight', models.IntegerField(blank=True, null=True, verbose_name='Weight')),
                ('date_of_birth', models.DateField(verbose_name='Date of birth')),
                ('birthplace', models.CharField(blank=True, max_length=255, null=True, verbose_name='Birthplace')),
                ('gender', models.CharField(blank=True, choices=[('f', 'Female'), ('m', 'Male'), ('d', 'Diverse')], max_length=1, null=True, verbose_name='Gender')),
                ('street', models.CharField(blank=True, max_length=255, null=True, verbose_name='Street')),
                ('zip_code', models.CharField(blank=True, max_length=5, null=True, verbose_name='Zip code')),
                ('city', models.CharField(blank=True, max_length=255, null=True, verbose_name='City')),
                ('phone_number', models.CharField(blank=True, max_length=20, null=True, verbose_name='Phone number')),
                ('mobile_number', models.CharField(blank=True, max_length=20, null=True, verbose_name='Mobile number')),
                ('email', models.EmailField(max_length=254, verbose_name='E-mail')),
                ('schwanger', mpi_cbs.mediforms.models.YesNoField(blank=True, choices=[('yes', 'yes'), ('no', 'no')], max_length=3, null=True, verbose_name='schwanger')),
                ('spirale', mpi_cbs.mediforms.models.YesNoField(blank=True, choices=[('yes', 'yes'), ('no', 'no')], max_length=3, null=True, verbose_name='spirale')),
                ('fehlsicht', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='fehlsicht')),
                ('kontaktlinsen', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='kontaktlinsen')),
                ('brille', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='brille')),
                ('astigmatismus', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='astigmatismus')),
                ('klaustrophobie', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='klaustrophobie')),
                ('geraeusch', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='geraeusch')),
                ('tinnitus', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='tinnitus')),
                ('operationen', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='operationen')),
                ('operationenwelchewann', models.TextField(blank=True, default='', verbose_name='operationenwelchewann')),
                ('metallclips', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='metallclips')),
                ('metallplatten', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='metallplatten')),
                ('gelenkprothesen', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='gelenkprothesen')),
                ('stent', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='stent')),
                ('herzschrittmacher', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='herzschrittmacher')),
                ('herzklappen', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='herzklappen')),
                ('innenohrimplantate', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='innenohrimplantate')),
                ('shunt', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='shunt')),
                ('hirnschrittmacher', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='hirnschrittmacher')),
                ('medikamentenpumpe', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='medikamentenpumpe')),
                ('metallsplitter', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='metallsplitter')),
                ('metalljob', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='metalljob')),
                ('metalleintrag', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='metalleintrag')),
                ('metallteile', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='metallteile')),
                ('metallteilewas', models.TextField(blank=True, default='', verbose_name='metallteilewas')),
                ('tattoos', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='tattoos')),
                ('tattoosort', models.TextField(blank=True, default='', verbose_name='tattoosort')),
                ('nikotinpflaster', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='nikotinpflaster')),
                ('rueckenlage', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='rueckenlage')),
                ('medikamente', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='medikamente')),
                ('medikamentewelche', models.TextField(blank=True, default='', verbose_name='medikamentewelche')),
                ('neuro', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='neuro')),
                ('neurowelche', models.TextField(blank=True, default='', verbose_name='neurowelche')),
                ('kopfverletzung', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='kopfverletzung')),
                ('kopfwelche', models.TextField(blank=True, default='', verbose_name='kopfwelche')),
                ('epilepsie', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='epilepsie')),
                ('herzrhythmus', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='herzrhythmus')),
                ('herzkrank', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='herzkrank')),
                ('durchblutung', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='durchblutung')),
                ('atemwege', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='atemwege')),
                ('allergie', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='allergie')),
                ('allergiewelche', models.TextField(blank=True, default='', verbose_name='allergiewelche')),
                ('niere', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='niere')),
                ('mrt12', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='mrt12')),
                ('mrtanzahl', models.PositiveIntegerField(verbose_name='mrtanzahl')),
                ('pseudonym', models.CharField(editable=False, max_length=64, verbose_name='Pseudonym')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('token_created_by', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL, verbose_name='Token created by')),
            ],
            options={
                'verbose_name': 'Form data MRT',
                'verbose_name_plural': 'Form data MRT',
                'ordering': ('last_name', 'first_name', 'date_of_birth'),
            },
        ),
        migrations.CreateModel(
            name='FormDataMRT7TpTx',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('last_name', models.CharField(max_length=255, verbose_name='Last name')),
                ('first_name', models.CharField(max_length=255, verbose_name='First name')),
                ('height', models.IntegerField(blank=True, null=True, verbose_name='Height')),
                ('weight', models.IntegerField(blank=True, null=True, verbose_name='Weight')),
                ('date_of_birth', models.DateField(verbose_name='Date of birth')),
                ('birthplace', models.CharField(blank=True, max_length=255, null=True, verbose_name='Birthplace')),
                ('gender', models.CharField(blank=True, choices=[('f', 'Female'), ('m', 'Male'), ('d', 'Diverse')], max_length=1, null=True, verbose_name='Gender')),
                ('street', models.CharField(blank=True, max_length=255, null=True, verbose_name='Street')),
                ('zip_code', models.CharField(blank=True, max_length=5, null=True, verbose_name='Zip code')),
                ('city', models.CharField(blank=True, max_length=255, null=True, verbose_name='City')),
                ('phone_number', models.CharField(blank=True, max_length=20, null=True, verbose_name='Phone number')),
                ('mobile_number', models.CharField(blank=True, max_length=20, null=True, verbose_name='Mobile number')),
                ('email', models.EmailField(max_length=254, verbose_name='E-mail')),
                ('schwanger', mpi_cbs.mediforms.models.YesNoField(blank=True, choices=[('yes', 'yes'), ('no', 'no')], max_length=3, null=True, verbose_name='schwanger')),
                ('spirale', mpi_cbs.mediforms.models.YesNoField(blank=True, choices=[('yes', 'yes'), ('no', 'no')], max_length=3, null=True, verbose_name='spirale')),
                ('fehlsicht', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='fehlsicht')),
                ('kontaktlinsen', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='kontaktlinsen')),
                ('brille', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='brille')),
                ('astigmatismus', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='astigmatismus')),
                ('klaustrophobie', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='klaustrophobie')),
                ('geraeusch', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='geraeusch')),
                ('tinnitus', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='tinnitus')),
                ('operationen', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='operationen')),
                ('operationenwelchewann', models.TextField(blank=True, default='', verbose_name='operationenwelchewann')),
                ('metallclips', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='metallclips')),
                ('metallplatten', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='metallplatten')),
                ('gelenkprothesen', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='gelenkprothesen')),
                ('stent', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='stent')),
                ('herzschrittmacher', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='herzschrittmacher')),
                ('herzklappen', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='herzklappen')),
                ('innenohrimplantate', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='innenohrimplantate')),
                ('shunt', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='shunt')),
                ('hirnschrittmacher', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='hirnschrittmacher')),
                ('medikamentenpumpe', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='medikamentenpumpe')),
                ('metallsplitter', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='metallsplitter')),
                ('metalljob', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='metalljob')),
                ('metalleintrag', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='metalleintrag')),
                ('metallteile', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='metallteile')),
                ('metallteilewas', models.TextField(blank=True, default='', verbose_name='metallteilewas')),
                ('tattoos', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='tattoos')),
                ('tattoosort', models.TextField(blank=True, default='', verbose_name='tattoosort')),
                ('nikotinpflaster', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='nikotinpflaster')),
                ('rueckenlage', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='rueckenlage')),
                ('medikamente', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='medikamente')),
                ('medikamentewelche', models.TextField(blank=True, default='', verbose_name='medikamentewelche')),
                ('neuro', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='neuro')),
                ('neurowelche', models.TextField(blank=True, default='', verbose_name='neurowelche')),
                ('kopfverletzung', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='kopfverletzung')),
                ('kopfwelche', models.TextField(blank=True, default='', verbose_name='kopfwelche')),
                ('epilepsie', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='epilepsie')),
                ('herzrhythmus', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='herzrhythmus')),
                ('herzkrank', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='herzkrank')),
                ('durchblutung', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='durchblutung')),
                ('atemwege', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='atemwege')),
                ('allergie', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='allergie')),
                ('allergiewelche', models.TextField(blank=True, default='', verbose_name='allergiewelche')),
                ('niere', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='niere')),
                ('mrt12', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='mrt12')),
                ('mrtanzahl', models.PositiveIntegerField(verbose_name='mrtanzahl')),
                ('pseudonym', models.CharField(editable=False, max_length=64, verbose_name='Pseudonym')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('token_created_by', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL, verbose_name='Token created by')),
            ],
            options={
                'verbose_name': 'Form data MRT 7T pTx',
                'verbose_name_plural': 'Form data MRT 7T pTx',
                'ordering': ('last_name', 'first_name', 'date_of_birth'),
            },
        ),
        migrations.CreateModel(
            name='FormDataMRTBegleitung',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('last_name', models.CharField(max_length=255, verbose_name='Last name')),
                ('first_name', models.CharField(max_length=255, verbose_name='First name')),
                ('height', models.IntegerField(blank=True, null=True, verbose_name='Height')),
                ('weight', models.IntegerField(blank=True, null=True, verbose_name='Weight')),
                ('date_of_birth', models.DateField(verbose_name='Date of birth')),
                ('birthplace', models.CharField(blank=True, max_length=255, null=True, verbose_name='Birthplace')),
                ('gender', models.CharField(blank=True, choices=[('f', 'Female'), ('m', 'Male'), ('d', 'Diverse')], max_length=1, null=True, verbose_name='Gender')),
                ('street', models.CharField(blank=True, max_length=255, null=True, verbose_name='Street')),
                ('zip_code', models.CharField(blank=True, max_length=5, null=True, verbose_name='Zip code')),
                ('city', models.CharField(blank=True, max_length=255, null=True, verbose_name='City')),
                ('phone_number', models.CharField(blank=True, max_length=20, null=True, verbose_name='Phone number')),
                ('mobile_number', models.CharField(blank=True, max_length=20, null=True, verbose_name='Mobile number')),
                ('email', models.EmailField(max_length=254, verbose_name='E-mail')),
                ('schwanger', mpi_cbs.mediforms.models.YesNoField(blank=True, choices=[('yes', 'yes'), ('no', 'no')], max_length=3, null=True, verbose_name='schwanger')),
                ('spirale', mpi_cbs.mediforms.models.YesNoField(blank=True, choices=[('yes', 'yes'), ('no', 'no')], max_length=3, null=True, verbose_name='spirale')),
                ('fehlsicht', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='fehlsicht')),
                ('kontaktlinsen', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='kontaktlinsen')),
                ('brille', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='brille')),
                ('astigmatismus', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='astigmatismus')),
                ('klaustrophobie', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='klaustrophobie')),
                ('geraeusch', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='geraeusch')),
                ('tinnitus', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='tinnitus')),
                ('operationen', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='operationen')),
                ('operationenwelchewann', models.TextField(blank=True, default='', verbose_name='operationenwelchewann')),
                ('metallclips', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='metallclips')),
                ('metallplatten', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='metallplatten')),
                ('gelenkprothesen', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='gelenkprothesen')),
                ('stent', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='stent')),
                ('herzschrittmacher', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='herzschrittmacher')),
                ('herzklappen', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='herzklappen')),
                ('innenohrimplantate', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='innenohrimplantate')),
                ('shunt', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='shunt')),
                ('hirnschrittmacher', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='hirnschrittmacher')),
                ('medikamentenpumpe', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='medikamentenpumpe')),
                ('metallsplitter', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='metallsplitter')),
                ('metalljob', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='metalljob')),
                ('metalleintrag', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='metalleintrag')),
                ('metallteile', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='metallteile')),
                ('metallteilewas', models.TextField(blank=True, default='', verbose_name='metallteilewas')),
                ('tattoos', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='tattoos')),
                ('tattoosort', models.TextField(blank=True, default='', verbose_name='tattoosort')),
                ('nikotinpflaster', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='nikotinpflaster')),
                ('rueckenlage', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='rueckenlage')),
                ('medikamente', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='medikamente')),
                ('medikamentewelche', models.TextField(blank=True, default='', verbose_name='medikamentewelche')),
                ('neuro', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='neuro')),
                ('neurowelche', models.TextField(blank=True, default='', verbose_name='neurowelche')),
                ('kopfverletzung', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='kopfverletzung')),
                ('kopfwelche', models.TextField(blank=True, default='', verbose_name='kopfwelche')),
                ('epilepsie', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='epilepsie')),
                ('herzrhythmus', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='herzrhythmus')),
                ('herzkrank', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='herzkrank')),
                ('durchblutung', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='durchblutung')),
                ('atemwege', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='atemwege')),
                ('allergie', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='allergie')),
                ('allergiewelche', models.TextField(blank=True, default='', verbose_name='allergiewelche')),
                ('niere', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='niere')),
                ('mrt12', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='mrt12')),
                ('mrtanzahl', models.PositiveIntegerField(verbose_name='mrtanzahl')),
                ('pseudonym', models.CharField(editable=False, max_length=64, verbose_name='Pseudonym')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('token_created_by', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL, verbose_name='Token created by')),
            ],
            options={
                'verbose_name': 'Form data MRT Begleitung',
                'verbose_name_plural': 'Form data MRT Begleitung',
                'ordering': ('last_name', 'first_name', 'date_of_birth'),
            },
        ),
        migrations.CreateModel(
            name='FormDataMRTConnectom',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('last_name', models.CharField(max_length=255, verbose_name='Last name')),
                ('first_name', models.CharField(max_length=255, verbose_name='First name')),
                ('height', models.IntegerField(blank=True, null=True, verbose_name='Height')),
                ('weight', models.IntegerField(blank=True, null=True, verbose_name='Weight')),
                ('date_of_birth', models.DateField(verbose_name='Date of birth')),
                ('birthplace', models.CharField(blank=True, max_length=255, null=True, verbose_name='Birthplace')),
                ('gender', models.CharField(blank=True, choices=[('f', 'Female'), ('m', 'Male'), ('d', 'Diverse')], max_length=1, null=True, verbose_name='Gender')),
                ('street', models.CharField(blank=True, max_length=255, null=True, verbose_name='Street')),
                ('zip_code', models.CharField(blank=True, max_length=5, null=True, verbose_name='Zip code')),
                ('city', models.CharField(blank=True, max_length=255, null=True, verbose_name='City')),
                ('phone_number', models.CharField(blank=True, max_length=20, null=True, verbose_name='Phone number')),
                ('mobile_number', models.CharField(blank=True, max_length=20, null=True, verbose_name='Mobile number')),
                ('email', models.EmailField(max_length=254, verbose_name='E-mail')),
                ('schwanger', mpi_cbs.mediforms.models.YesNoField(blank=True, choices=[('yes', 'yes'), ('no', 'no')], max_length=3, null=True, verbose_name='schwanger')),
                ('spirale', mpi_cbs.mediforms.models.YesNoField(blank=True, choices=[('yes', 'yes'), ('no', 'no')], max_length=3, null=True, verbose_name='spirale')),
                ('fehlsicht', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='fehlsicht')),
                ('kontaktlinsen', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='kontaktlinsen')),
                ('brille', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='brille')),
                ('astigmatismus', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='astigmatismus')),
                ('klaustrophobie', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='klaustrophobie')),
                ('geraeusch', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='geraeusch')),
                ('tinnitus', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='tinnitus')),
                ('operationen', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='operationen')),
                ('operationenwelchewann', models.TextField(blank=True, default='', verbose_name='operationenwelchewann')),
                ('metallclips', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='metallclips')),
                ('metallplatten', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='metallplatten')),
                ('gelenkprothesen', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='gelenkprothesen')),
                ('stent', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='stent')),
                ('herzschrittmacher', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='herzschrittmacher')),
                ('herzklappen', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='herzklappen')),
                ('innenohrimplantate', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='innenohrimplantate')),
                ('shunt', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='shunt')),
                ('hirnschrittmacher', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='hirnschrittmacher')),
                ('medikamentenpumpe', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='medikamentenpumpe')),
                ('metallsplitter', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='metallsplitter')),
                ('metalljob', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='metalljob')),
                ('metalleintrag', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='metalleintrag')),
                ('metallteile', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='metallteile')),
                ('metallteilewas', models.TextField(blank=True, default='', verbose_name='metallteilewas')),
                ('tattoos', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='tattoos')),
                ('tattoosort', models.TextField(blank=True, default='', verbose_name='tattoosort')),
                ('nikotinpflaster', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='nikotinpflaster')),
                ('rueckenlage', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='rueckenlage')),
                ('medikamente', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='medikamente')),
                ('medikamentewelche', models.TextField(blank=True, default='', verbose_name='medikamentewelche')),
                ('neuro', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='neuro')),
                ('neurowelche', models.TextField(blank=True, default='', verbose_name='neurowelche')),
                ('kopfverletzung', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='kopfverletzung')),
                ('kopfwelche', models.TextField(blank=True, default='', verbose_name='kopfwelche')),
                ('epilepsie', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='epilepsie')),
                ('herzrhythmus', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='herzrhythmus')),
                ('herzkrank', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='herzkrank')),
                ('durchblutung', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='durchblutung')),
                ('atemwege', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='atemwege')),
                ('allergie', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='allergie')),
                ('allergiewelche', models.TextField(blank=True, default='', verbose_name='allergiewelche')),
                ('niere', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='niere')),
                ('mrt12', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='mrt12')),
                ('mrtanzahl', models.PositiveIntegerField(verbose_name='mrtanzahl')),
                ('pseudonym', models.CharField(editable=False, max_length=64, verbose_name='Pseudonym')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('token_created_by', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL, verbose_name='Token created by')),
            ],
            options={
                'verbose_name': 'Form data MRT Connectom',
                'verbose_name_plural': 'Form data MRT Connectom',
                'ordering': ('last_name', 'first_name', 'date_of_birth'),
            },
        ),
        migrations.CreateModel(
            name='FormDataTMS',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('last_name', models.CharField(max_length=255, verbose_name='Last name')),
                ('first_name', models.CharField(max_length=255, verbose_name='First name')),
                ('height', models.IntegerField(blank=True, null=True, verbose_name='Height')),
                ('weight', models.IntegerField(blank=True, null=True, verbose_name='Weight')),
                ('date_of_birth', models.DateField(verbose_name='Date of birth')),
                ('birthplace', models.CharField(blank=True, max_length=255, null=True, verbose_name='Birthplace')),
                ('gender', models.CharField(blank=True, choices=[('f', 'Female'), ('m', 'Male'), ('d', 'Diverse')], max_length=1, null=True, verbose_name='Gender')),
                ('street', models.CharField(blank=True, max_length=255, null=True, verbose_name='Street')),
                ('zip_code', models.CharField(blank=True, max_length=5, null=True, verbose_name='Zip code')),
                ('city', models.CharField(blank=True, max_length=255, null=True, verbose_name='City')),
                ('phone_number', models.CharField(blank=True, max_length=20, null=True, verbose_name='Phone number')),
                ('mobile_number', models.CharField(blank=True, max_length=20, null=True, verbose_name='Mobile number')),
                ('email', models.EmailField(max_length=254, verbose_name='E-mail')),
                ('schwanger', mpi_cbs.mediforms.models.YesNoField(blank=True, choices=[('yes', 'yes'), ('no', 'no')], max_length=3, null=True, verbose_name='schwanger')),
                ('epilepsie', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='epilepsie')),
                ('fieberkrampf', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='fieberkrampf')),
                ('familieepilepsie', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='familieepilepsie')),
                ('bewusstlosigkeit', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='bewusstlosigkeit')),
                ('kopfschmerzen', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='kopfschmerzen')),
                ('migraene', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='migraene')),
                ('schlafstoerung', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='schlafstoerung')),
                ('drogen', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='drogen')),
                ('medikamente', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='medikamente')),
                ('medikamentewelche', models.TextField(blank=True, default='', verbose_name='medikamentewelche')),
                ('neuro', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='neuro')),
                ('neurowelche', models.TextField(blank=True, default='', verbose_name='neurowelche')),
                ('psycho', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='psycho')),
                ('psychowelche', models.TextField(blank=True, default='', verbose_name='psychowelche')),
                ('kopfverletzung', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='kopfverletzung')),
                ('kopfwelche', models.TextField(blank=True, default='', verbose_name='kopfwelche')),
                ('operationen', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='operationen')),
                ('operationenwelchewann', models.TextField(blank=True, default='', verbose_name='operationenwelchewann')),
                ('metallclips', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='metallclips')),
                ('metallplatten', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='metallplatten')),
                ('gelenkprothesen', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='gelenkprothesen')),
                ('stent', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='stent')),
                ('herzschrittmacher', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='herzschrittmacher')),
                ('herzklappen', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='herzklappen')),
                ('innenohrimplantate', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='innenohrimplantate')),
                ('shunt', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='shunt')),
                ('hirnschrittmacher', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='hirnschrittmacher')),
                ('medikamentenpumpe', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='medikamentenpumpe')),
                ('metallsplitter', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='metallsplitter')),
                ('metalljob', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='metalljob')),
                ('metalleintrag', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='metalleintrag')),
                ('herzrhythmus', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='herzrhythmus')),
                ('herzkrank', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='herzkrank')),
                ('durchblutung', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='durchblutung')),
                ('atemwege', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, verbose_name='atemwege')),
                ('hauterkrankungen', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, null=True, verbose_name='hauterkrankungen')),
                ('narben', mpi_cbs.mediforms.models.YesNoField(choices=[('yes', 'yes'), ('no', 'no')], max_length=3, null=True, verbose_name='narben')),
                ('pseudonym', models.CharField(editable=False, max_length=64, verbose_name='Pseudonym')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('token_created_by', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL, verbose_name='Token created by')),
            ],
            options={
                'verbose_name': 'Form data TMS',
                'verbose_name_plural': 'Form data TMS',
                'ordering': ('last_name', 'first_name', 'date_of_birth'),
            },
        ),
        migrations.CreateModel(
            name='Method',
            fields=[
                ('key', models.CharField(max_length=16, primary_key=True, serialize=False, verbose_name='Key')),
                ('name', models.CharField(max_length=64, verbose_name='Name')),
                ('color', models.CharField(default='#0070c0', max_length=8, verbose_name='Color')),
            ],
            options={
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='PDFTMS',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file_handle', models.FileField(max_length=128, upload_to=mpi_cbs.mediforms.models.PDF.get_upload_path, verbose_name='File handle')),
                ('form_data', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mediforms.formdatatms', verbose_name='Form data TMS')),
            ],
            options={
                'verbose_name': 'PDF TMS',
                'verbose_name_plural': 'PDFs TMS',
            },
        ),
        migrations.CreateModel(
            name='PDFMRTConnectom',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file_handle', models.FileField(max_length=128, upload_to=mpi_cbs.mediforms.models.PDF.get_upload_path, verbose_name='File handle')),
                ('form_data', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mediforms.formdatamrtconnectom', verbose_name='Form data MRT Connectom')),
            ],
            options={
                'verbose_name': 'PDF MRT Connectom',
                'verbose_name_plural': 'PDFs MRT Connectom',
            },
        ),
        migrations.CreateModel(
            name='PDFMRTBegleitung',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file_handle', models.FileField(max_length=128, upload_to=mpi_cbs.mediforms.models.PDF.get_upload_path, verbose_name='File handle')),
                ('form_data', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mediforms.formdatamrtbegleitung', verbose_name='Form data MRT Begleitung')),
            ],
            options={
                'verbose_name': 'PDF MRT Begleitung',
                'verbose_name_plural': 'PDFs MRT Begleitung',
            },
        ),
        migrations.CreateModel(
            name='PDFMRT7TpTx',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file_handle', models.FileField(max_length=128, upload_to=mpi_cbs.mediforms.models.PDF.get_upload_path, verbose_name='File handle')),
                ('form_data', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mediforms.formdatamrt7tptx', verbose_name='Form data MRT 7T pTx')),
            ],
            options={
                'verbose_name': 'PDF MRT 7T pTx',
                'verbose_name_plural': 'PDFs MRT 7T pTx',
            },
        ),
        migrations.CreateModel(
            name='PDFMRT',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file_handle', models.FileField(max_length=128, upload_to=mpi_cbs.mediforms.models.PDF.get_upload_path, verbose_name='File handle')),
                ('form_data', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mediforms.formdatamrt', verbose_name='Form data MRT')),
            ],
            options={
                'verbose_name': 'PDF MRT',
                'verbose_name_plural': 'PDFs MRT',
            },
        ),
        migrations.CreateModel(
            name='Token',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False, verbose_name='ID')),
                ('pseudonym', models.CharField(max_length=64, verbose_name='Pseudonym')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL, verbose_name='Created by')),
                ('method', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='mediforms.method', verbose_name='Method')),
            ],
            options={
                'verbose_name': 'Token',
                'verbose_name_plural': 'Tokens',
                'ordering': ('-created_at',),
                'unique_together': {('method', 'pseudonym')},
            },
        ),
    ]
