# Generated by Django 2.2.8 on 2019-12-13 16:29

import django.db.models.deletion
import jsonfield.fields
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("unplugged", "0008_auto_20190715_1944"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("services_listing", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="ContentRating",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=50, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name="Genre",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=50, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name="Language",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=50, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name="Network",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=50, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name="Status",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=50, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name="Metadata",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("priority", models.SmallIntegerField(default=20)),
                (
                    "last_update_status",
                    models.CharField(
                        choices=[
                            ("do-not-fetch", "Do not fetch"),
                            ("pending", "Pending"),
                            ("updating", "Updating"),
                            ("failed", "Failed"),
                            ("success", "Success"),
                        ],
                        db_index=True,
                        default="pending",
                        max_length=20,
                    ),
                ),
                ("last_updated", models.DateTimeField(null=True)),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("identifier", models.CharField(max_length=255, unique=True)),
                ("populated", models.BooleanField(default=False)),
                ("title", models.CharField(max_length=300, null=True)),
                ("cover", models.URLField(max_length=1000, null=True)),
                (
                    "prefetch_related_denormalized",
                    jsonfield.fields.JSONField(blank=True, null=True),
                ),
                ("imdb_id", models.IntegerField(null=True)),
                (
                    "rating",
                    models.DecimalField(decimal_places=2, max_digits=4, null=True),
                ),
                ("votes", models.IntegerField(null=True)),
                ("duration", models.IntegerField(null=True)),
                ("year", models.IntegerField(null=True)),
                ("synopsis", models.TextField(null=True)),
                (
                    "content_rating",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="metadata_thetvdb.ContentRating",
                    ),
                ),
                ("genres", models.ManyToManyField(to="metadata_thetvdb.Genre")),
                (
                    "network",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="metadata_thetvdb.Network",
                    ),
                ),
                (
                    "plugin",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="metadata_metadata_thetvdb",
                        to="unplugged.Plugin",
                    ),
                ),
                (
                    "primary_language",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="metadata_thetvdb.Language",
                    ),
                ),
                (
                    "status",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="metadata_thetvdb.Status",
                    ),
                ),
            ],
            options={"abstract": False,},
        ),
        migrations.CreateModel(
            name="MetadataResolutionLink",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("priority", models.SmallIntegerField(default=20)),
                (
                    "last_update_status",
                    models.CharField(
                        choices=[
                            ("do-not-fetch", "Do not fetch"),
                            ("pending", "Pending"),
                            ("updating", "Updating"),
                            ("failed", "Failed"),
                            ("success", "Success"),
                        ],
                        db_index=True,
                        default="pending",
                        max_length=20,
                    ),
                ),
                ("last_updated", models.DateTimeField(null=True)),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("name", models.CharField(max_length=255)),
                ("search_resolve", models.CharField(max_length=30)),
                (
                    "listingitems",
                    models.ManyToManyField(
                        related_name="resolution_metadata_thetvdb",
                        to="services_listing.ListingItem",
                    ),
                ),
                (
                    "metadata",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="metadata_thetvdb.Metadata",
                    ),
                ),
                (
                    "plugin",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="resolution_metadata_thetvdb",
                        to="unplugged.Plugin",
                    ),
                ),
            ],
            options={
                "abstract": False,
                "unique_together": {("name", "search_resolve")},
            },
        ),
        migrations.CreateModel(
            name="ListingItemRelation",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "listingitem",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="metadata_thetvdb",
                        to="services_listing.ListingItem",
                    ),
                ),
                (
                    "metadata",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="metadata_thetvdb.Metadata",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="metadata_thetvdb",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "abstract": False,
                "unique_together": {("listingitem", "metadata", "user")},
            },
        ),
        migrations.CreateModel(
            name="Episode",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("season", models.IntegerField()),
                ("episode", models.IntegerField()),
                ("title", models.CharField(max_length=200, null=True)),
                ("air_date", models.DateField(null=True)),
                (
                    "metadata",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="metadata_thetvdb.Metadata",
                    ),
                ),
            ],
            options={"unique_together": {("metadata", "season", "episode")},},
        ),
    ]
