# Generated by Django 2.2.8 on 2019-12-13 16:29

import django.db.models.deletion
import jsonfield.fields
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("unplugged", "0008_auto_20190715_1944"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("services_listing", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="Genre",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=50, unique=True)),
                ("identifier", models.IntegerField(unique=True)),
            ],
        ),
        migrations.CreateModel(
            name="Metadata",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("priority", models.SmallIntegerField(default=20)),
                (
                    "last_update_status",
                    models.CharField(
                        choices=[
                            ("do-not-fetch", "Do not fetch"),
                            ("pending", "Pending"),
                            ("updating", "Updating"),
                            ("failed", "Failed"),
                            ("success", "Success"),
                        ],
                        db_index=True,
                        default="pending",
                        max_length=20,
                    ),
                ),
                ("last_updated", models.DateTimeField(null=True)),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("identifier", models.CharField(max_length=255, unique=True)),
                ("populated", models.BooleanField(default=False)),
                ("title", models.CharField(max_length=300, null=True)),
                ("cover", models.URLField(max_length=1000, null=True)),
                (
                    "prefetch_related_denormalized",
                    jsonfield.fields.JSONField(blank=True, null=True),
                ),
                (
                    "rating",
                    models.DecimalField(decimal_places=2, max_digits=3, null=True),
                ),
                ("votes", models.IntegerField(null=True)),
                ("duration", models.IntegerField(null=True)),
                ("episodes", models.IntegerField(null=True)),
                ("aired_start", models.DateField(null=True)),
                ("aired_end", models.DateField(null=True)),
                ("plot", models.TextField(null=True)),
            ],
            options={"abstract": False,},
        ),
        migrations.CreateModel(
            name="TVRating",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=100, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name="Type",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=100, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name="Season",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("year", models.IntegerField()),
                (
                    "season",
                    models.CharField(
                        choices=[
                            ("summer", "Summer"),
                            ("winter", "Winter"),
                            ("spring", "Spring"),
                            ("fall", "Fall"),
                        ],
                        max_length=20,
                    ),
                ),
            ],
            options={"unique_together": {("year", "season")},},
        ),
        migrations.CreateModel(
            name="Related",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("relation_type", models.CharField(max_length=50)),
                ("to_metadata_identifier", models.CharField(max_length=100)),
                (
                    "from_metadata",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="related",
                        to="metadata_mal.Metadata",
                    ),
                ),
                (
                    "to_metadata",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="reverse_related",
                        to="metadata_mal.Metadata",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="metadata",
            name="anime_type",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="metadata_mal.Type",
            ),
        ),
        migrations.AddField(
            model_name="metadata",
            name="genres",
            field=models.ManyToManyField(to="metadata_mal.Genre"),
        ),
        migrations.AddField(
            model_name="metadata",
            name="plugin",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="metadata_metadata_mal",
                to="unplugged.Plugin",
            ),
        ),
        migrations.AddField(
            model_name="metadata",
            name="season",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="metadata_mal.Season",
            ),
        ),
        migrations.AddField(
            model_name="metadata",
            name="tv_rating",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="metadata_mal.TVRating",
            ),
        ),
        migrations.CreateModel(
            name="AlternativeTitle",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("title", models.CharField(max_length=500)),
                ("language", models.CharField(max_length=100)),
                (
                    "metadata",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="metadata_mal.Metadata",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="ListingItemRelation",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "listingitem",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="metadata_mal",
                        to="services_listing.ListingItem",
                    ),
                ),
                (
                    "metadata",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="metadata_mal.Metadata",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="metadata_mal",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "abstract": False,
                "unique_together": {("listingitem", "metadata", "user")},
            },
        ),
    ]
