# Generated by Django 2.2.8 on 2019-12-13 16:29

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("services_listing", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="Availability",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("app", models.CharField(max_length=50)),
                ("identifier", models.CharField(max_length=250)),
                ("created", models.DateTimeField(auto_now_add=True)),
            ],
            options={"unique_together": {("app", "identifier")},},
        ),
        migrations.CreateModel(
            name="ListingItemAvailability",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("app", models.CharField(max_length=50)),
                ("identifier", models.CharField(max_length=250)),
                (
                    "listingitem",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="services_listing.ListingItem",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="ListingItemRelation",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "listingitem",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="metadata_available",
                        to="services_listing.ListingItem",
                    ),
                ),
                (
                    "metadata",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="metadata_available.Availability",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="metadata_available",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "abstract": False,
                "unique_together": {("listingitem", "metadata", "user")},
            },
        ),
        migrations.AddIndex(
            model_name="listingitemavailability",
            index=models.Index(
                fields=["app", "identifier"], name="metadata_av_app_de4cd0_idx"
            ),
        ),
    ]
