# -*- coding: utf-8 -*-
r"""
The values computed in [Lab2021a]_.

Computing them from scratch takes 70 seconds. This file contains those
values.

REFERENCES:

.. [Lab2021a] S. Labbé. Substitutive structure of Jeandel-Rao aperiodic tilings,
   *Discrete & Computational Geometry* 65 (2021) 800-855.
   https://doi.org/10.1007/s00454-019-00153-3
   http://arxiv.org/abs/1808.07768

EXAMPLES:

    sage: from slabbe.arXiv_1808_07768 import omega6, T3
    sage: omega6
    Substitution 2d: {0: [[2]], 1: [[9]], 2: [[10]], 3: [[20]], 4: [[21]],
    5: [[22]], 6: [[27]], 7: [[1], [0]], 8: [[6], [5]], 9: [[7], [4]], 10:
    [[8], [4]], 11: [[11], [3]], 12: [[12], [3]], 13: [[16], [15]], 14:
    [[17], [15]], 15: [[18], [14]], 16: [[19], [14]], 17: [[23], [13]], 18:
    [[26], [25]], 19: [[28], [24]]}
    sage: T3
    Wang tile set of cardinality 24

"""
#*****************************************************************************
#       Copyright (C) 2018-2021 Sébastien Labbé <slabqc@gmail.com>
#
#  Distributed under the terms of the GNU General Public License version 2 (GPLv2)
#
#  The full text of the GPLv2 is available at:
#
#                  http://www.gnu.org/licenses/
#*****************************************************************************
from slabbe import WangTileSet, Substitution2d

T0 = WangTileSet([['2', '4', '2', '1'],
 ['2', '2', '2', '0'],
 ['1', '1', '3', '1'],
 ['1', '2', '3', '2'],
 ['3', '1', '3', '3'],
 ['0', '1', '3', '1'],
 ['0', '0', '0', '1'],
 ['3', '1', '0', '2'],
 ['0', '2', '1', '2'],
 ['1', '2', '1', '4'],
 ['3', '3', '1', '2']])
M0 = [0, 1]
omega0 = Substitution2d({0: [[2]], 1: [[3]], 2: [[4]], 3: [[5]], 4: [[6]],
    5: [[7]], 6: [[8]], 7: [[10]], 8: [[0, 9]], 9: [[1, 3]], 10: [[1, 7]],
    11: [[1, 8]], 12: [[1, 10]]})

T1 = WangTileSet([['1', '1', '3', '1'],
 ['1', '2', '3', '2'],
 ['3', '1', '3', '3'],
 ['0', '1', '3', '1'],
 ['0', '0', '0', '1'],
 ['3', '1', '0', '2'],
 ['0', '2', '1', '2'],
 ['3', '3', '1', '2'],
 ('21', '2', '21', '1'),
 ('21', '2', '23', '0'),
 ('23', '1', '20', '0'),
 ('20', '2', '21', '0'),
 ('23', '3', '21', '0')])
M1 = [8, 9, 10, 11, 12]
omega1 = Substitution2d({0: [[0]], 1: [[1]], 2: [[2]], 3: [[3]], 4: [[4]],
    5: [[5]], 6: [[6]], 7: [[7]], 8: [[8, 1]], 9: [[8, 5]], 10: [[8, 6]],
    11: [[8, 7]], 12: [[9, 1]], 13: [[9, 5]], 14: [[9, 6]], 15: [[10, 0]],
    16: [[10, 3]], 17: [[11, 5]], 18: [[11, 7]], 19: [[12, 2]]})

T2 = WangTileSet([['1', '1', '3', '1'],
 ['1', '2', '3', '2'],
 ['3', '1', '3', '3'],
 ['0', '1', '3', '1'],
 ['0', '0', '0', '1'],
 ['3', '1', '0', '2'],
 ['0', '2', '1', '2'],
 ['3', '3', '1', '2'],
 ('211', '2', '213', '1'),
 ('213', '1', '210', '1'),
 ('210', '2', '211', '1'),
 ('213', '3', '211', '1'),
 ('211', '2', '233', '0'),
 ('213', '1', '230', '0'),
 ('210', '2', '231', '0'),
 ('231', '1', '203', '0'),
 ('230', '1', '203', '0'),
 ('203', '1', '210', '0'),
 ('203', '3', '211', '0'),
 ('233', '1', '213', '0')])
M2 = [8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19]
omega2 = Substitution2d({0: [[2]], 1: [[3]], 2: [[4]], 3: [[5]], 4: [[8,
    1]], 5: [[8, 5]], 6: [[8, 6]], 7: [[9, 0]], 8: [[9, 3]], 9: [[10, 5]],
    10: [[10, 7]], 11: [[11, 2]], 12: [[12, 5]], 13: [[12, 6]], 14: [[13,
        4]], 15: [[14, 5]], 16: [[15, 3]], 17: [[16, 3]], 18: [[16, 4]],
    19: [[17, 3]], 20: [[18, 2]], 21: [[19, 0]], 22: [[19, 3]], 23: [[19,
        4]]})

T3 = WangTileSet([['3', '1', '3', '3'],
 ['0', '1', '3', '1'],
 ['0', '0', '0', '1'],
 ['3', '1', '0', '2'],
 ('2111', '2', '2133', '1'),
 ('2113', '1', '2130', '1'),
 ('2110', '2', '2131', '1'),
 ('2131', '1', '2103', '1'),
 ('2130', '1', '2103', '1'),
 ('2103', '1', '2110', '1'),
 ('2103', '3', '2111', '1'),
 ('2133', '1', '2113', '1'),
 ('2113', '1', '2330', '0'),
 ('2110', '2', '2331', '0'),
 ('2130', '0', '2300', '0'),
 ('2103', '1', '2310', '0'),
 ('2310', '1', '2033', '0'),
 ('2300', '1', '2033', '0'),
 ('2300', '0', '2030', '0'),
 ('2030', '1', '2103', '0'),
 ('2033', '1', '2113', '0'),
 ('2331', '1', '2133', '0'),
 ('2330', '1', '2133', '0'),
 ('2330', '0', '2130', '0')])
M3 = [0, 1, 2, 3]
omega3p = Substitution2d({0: [[5]], 1: [[8]], 2: [[11]], 3: [[12]], 4:
    [[14]], 5: [[15]], 6: [[16]], 7: [[17]], 8: [[18]], 9: [[19]], 10:
    [[20]], 11: [[22]], 12: [[23]], 13: [[4, 3]], 14: [[5, 2]], 15: [[6,
        3]], 16: [[7, 1]], 17: [[7, 2]], 18: [[8, 1]], 19: [[8, 2]], 20:
    [[9, 1]], 21: [[10, 0]], 22: [[11, 2]], 23: [[12, 2]], 24: [[13, 3]],
    25: [[15, 2]], 26: [[16, 2]], 27: [[20, 2]], 28: [[21, 2]], 29: [[22,
        2]]})

T4p = WangTileSet([('2113', '1', '2130', '1'),
 ('2130', '1', '2103', '1'),
 ('2133', '1', '2113', '1'),
 ('2113', '1', '2330', '0'),
 ('2130', '0', '2300', '0'),
 ('2103', '1', '2310', '0'),
 ('2310', '1', '2033', '0'),
 ('2300', '1', '2033', '0'),
 ('2300', '0', '2030', '0'),
 ('2030', '1', '2103', '0'),
 ('2033', '1', '2113', '0'),
 ('2330', '1', '2133', '0'),
 ('2330', '0', '2130', '0'),
 ('21113', '1', '21330', '1'),
 ('21130', '0', '21300', '1'),
 ('21103', '1', '21310', '1'),
 ('21310', '1', '21033', '1'),
 ('21310', '0', '21030', '1'),
 ('21300', '1', '21033', '1'),
 ('21300', '0', '21030', '1'),
 ('21030', '1', '21103', '1'),
 ('21033', '1', '21113', '1'),
 ('21330', '0', '21130', '1'),
 ('21130', '0', '23300', '0'),
 ('21103', '1', '23310', '0'),
 ('21030', '0', '23100', '0'),
 ('23100', '0', '20330', '0'),
 ('20330', '0', '21130', '0'),
 ('23310', '0', '21330', '0'),
 ('23300', '0', '21330', '0')])

forbidden = ('21103', '1', '23310', '0'), ('23310', '0', '21330', '0')
assert all(t in T4p.tiles() for t in forbidden)
id_tiles = [(i,t) for (i,t) in enumerate(T4p) if t not in forbidden]
indices,tiles4 = zip(*id_tiles)
d = dict(enumerate(indices))
iota = Substitution2d.from_permutation(d)
T4 = WangTileSet(tiles4)
omega3 = omega3p * iota

T5 = WangTileSet([['2113', '5', '2130', '1'],
 ['2130', '1', '2103', '5'],
 ['2133', '1', '2113', '1'],
 ['2113', '5', '2330', '0'],
 ['2130', '6', '2300', '0'],
 ['2103', '5', '2310', '0'],
 ['2310', '1', '2033', '6'],
 ['2300', '1', '2033', '6'],
 ['2300', '0', '2030', '6'],
 ['2030', '1', '2103', '0'],
 ['2033', '1', '2113', '0'],
 ['2330', '1', '2133', '6'],
 ['2330', '0', '2130', '6'],
 ['21113', '5', '21330', '1'],
 ['21130', '6', '21300', '1'],
 ['21103', '5', '21310', '1'],
 ['21310', '1', '21033', '5'],
 ['21310', '0', '21030', '5'],
 ['21300', '1', '21033', '5'],
 ['21300', '0', '21030', '5'],
 ['21030', '1', '21103', '1'],
 ['21033', '1', '21113', '1'],
 ['21330', '0', '21130', '1'],
 ['21330', '0', '21130', '5'],
 ['21130', '6', '23300', '0'],
 ['21030', '6', '23100', '0'],
 ['23100', '0', '20330', '6'],
 ['20330', '0', '21130', '0'],
 ['23300', '0', '21330', '6']])

def project_56(t, p56='10'):
    L = []
    d = dict(zip('56', p56))
    for w in t:
        for a in '56':
            w = w.replace(a, d[a])
        L.append(w)
    return tuple(L)
T4_tiles_list = T4.tiles()
d = {}
for i,t in enumerate(T5):
    pt = project_56(t, p56='10')
    j = T4_tiles_list.index(pt)
    d[i] = j
omega4_jmath = Substitution2d.from_permutation(d)

eta = Substitution2d({0: [[0]], 1: [[1]], 2: [[2]], 3: [[3]], 4: [[4]], 5:
    [[5]], 6: [[6]], 7: [[7]], 8: [[8]], 9: [[9]], 10: [[10]], 11: [[11]],
    12: [[12]], 13: [[13]], 14: [[14]], 15: [[15]], 16: [[16]], 17: [[17]],
    18: [[18]], 19: [[19]], 20: [[20]], 21: [[21]], 22: [[22]], 23: [[23]],
    24: [[24]], 25: [[25]], 26: [[26]], 27: [[27]], 28: [[28]]})

T6 = WangTileSet([('21131', '1', '21305', '1'),
 ('21305', '5', '21031', '5'),
 ('21331', '1', '21131', '1'),
 ('21131', '1', '23305', '0'),
 ('21300', '0', '23006', '0'),
 ('21031', '1', '23105', '0'),
 ('23105', '5', '20331', '6'),
 ('23006', '6', '20331', '6'),
 ('23006', '6', '20300', '6'),
 ('20300', '0', '21031', '0'),
 ('20331', '1', '21131', '0'),
 ('23305', '5', '21331', '6'),
 ('23305', '5', '21300', '6'),
 ('211131', '1', '213305', '1'),
 ('211300', '0', '213006', '1'),
 ('211031', '1', '213105', '1'),
 ('213105', '5', '210331', '5'),
 ('213105', '5', '210300', '5'),
 ('213006', '6', '210331', '5'),
 ('213006', '6', '210300', '5'),
 ('210300', '0', '211031', '1'),
 ('210331', '1', '211131', '1'),
 ('213300', '0', '211300', '1'),
 ('213305', '5', '211300', '5'),
 ('211300', '0', '233006', '0'),
 ('210300', '0', '231006', '0'),
 ('231006', '6', '203300', '6'),
 ('203300', '0', '211300', '0'),
 ('233006', '6', '213300', '6')])
M6 = [1, 6, 7, 8, 11, 12, 16, 17, 18, 19, 23, 26, 28]
omega6 = Substitution2d({0: [[2]], 1: [[9]], 2: [[10]], 3: [[20]], 4:
    [[21]], 5: [[22]], 6: [[27]], 7: [[1], [0]], 8: [[6], [5]], 9: [[7],
        [4]], 10: [[8], [4]], 11: [[11], [3]], 12: [[12], [3]], 13: [[16],
            [15]], 14: [[17], [15]], 15: [[18], [14]], 16: [[19], [14]],
        17: [[23], [13]], 18: [[26], [25]], 19: [[28], [24]]})

T7 = WangTileSet([('21331', '1', '21131', '1'),
 ('20300', '0', '21031', '0'),
 ('20331', '1', '21131', '0'),
 ('210300', '0', '211031', '1'),
 ('210331', '1', '211131', '1'),
 ('213300', '0', '211300', '1'),
 ('203300', '0', '211300', '0'),
 ('21131', '51', '21031', '51'),
 ('21031', '51', '20331', '60'),
 ('21300', '60', '20331', '60'),
 ('21300', '60', '20300', '60'),
 ('21131', '51', '21331', '60'),
 ('21131', '51', '21300', '60'),
 ('211031', '51', '210331', '51'),
 ('211031', '51', '210300', '51'),
 ('211300', '60', '210331', '51'),
 ('211300', '60', '210300', '51'),
 ('211131', '51', '211300', '51'),
 ('210300', '60', '203300', '60'),
 ('211300', '60', '213300', '60')])
M7 = [0, 1, 2, 3, 4, 5, 6]
omega7 = Substitution2d({0: [[8]], 1: [[9]], 2: [[10]], 3: [[15]], 4:
    [[16]], 5: [[18]], 6: [[19]], 7: [[7], [0]], 8: [[7], [2]], 9: [[8],
        [1]], 10: [[11], [2]], 11: [[12], [2]], 12: [[13], [3]], 13: [[14],
            [3]], 14: [[15], [5]], 15: [[15], [6]], 16: [[16], [5]], 17:
        [[16], [6]], 18: [[17], [4]], 19: [[19], [6]]})

T8 = WangTileSet([('21031', '51', '20331', '60'),
 ('21300', '60', '20331', '60'),
 ('21300', '60', '20300', '60'),
 ('211300', '60', '210331', '51'),
 ('211300', '60', '210300', '51'),
 ('210300', '60', '203300', '60'),
 ('211300', '60', '213300', '60'),
 ('21331', '511', '21031', '511'),
 ('20331', '511', '21031', '510'),
 ('20300', '510', '20331', '600'),
 ('20331', '511', '21331', '600'),
 ('20331', '511', '21300', '600'),
 ('210300', '510', '210331', '511'),
 ('210300', '510', '210300', '511'),
 ('213300', '600', '210331', '511'),
 ('203300', '600', '210331', '510'),
 ('213300', '600', '210300', '511'),
 ('203300', '600', '210300', '510'),
 ('210331', '511', '211300', '511'),
 ('203300', '600', '213300', '600')])
M8 = [0, 1, 2, 7, 8, 9, 10, 11]
omega8 = Substitution2d({0: [[3]], 1: [[4]], 2: [[5]], 3: [[6]], 4: [[12]],
    5: [[13]], 6: [[14]], 7: [[15]], 8: [[18]], 9: [[4, 0]], 10: [[5, 0]],
    11: [[5, 1]], 12: [[5, 2]], 13: [[6, 0]], 14: [[13, 8]], 15: [[14,
        10]], 16: [[15, 10]], 17: [[16, 11]], 18: [[17, 9]], 19: [[17,
            11]], 20: [[18, 7]], 21: [[19, 9]]})

T9 = WangTileSet([('211300', '60', '210331', '51'),
 ('211300', '60', '210300', '51'),
 ('210300', '60', '203300', '60'),
 ('211300', '60', '213300', '60'),
 ('210300', '510', '210331', '511'),
 ('210300', '510', '210300', '511'),
 ('213300', '600', '210331', '511'),
 ('203300', '600', '210331', '510'),
 ('210331', '511', '211300', '511'),
 ('21130021031', '51', '21030020331', '51'),
 ('21030021031', '51', '20330020331', '60'),
 ('21030021300', '60', '20330020331', '60'),
 ('21030021300', '60', '20330020300', '60'),
 ('21130021031', '51', '21330020331', '60'),
 ('21030020331', '511', '21030021031', '511'),
 ('21330020331', '511', '21033121331', '511'),
 ('20330020331', '511', '21033121331', '510'),
 ('21330020331', '511', '21030021300', '511'),
 ('20330020300', '510', '21030020331', '510'),
 ('20330020331', '511', '21030021300', '510'),
 ('21033121331', '511', '21130021031', '511'),
 ('20330020300', '510', '21330020331', '600')])
M9 = [0, 1, 2, 3, 9, 10, 11, 12, 13]
omega9 = Substitution2d({0: [[8]], 1: [[14]], 2: [[17]], 3: [[20]], 4:
    [[4], [1]], 5: [[5], [1]], 6: [[6], [3]], 7: [[7], [2]], 8: [[8], [0]],
    9: [[14], [9]], 10: [[15], [13]], 11: [[16], [10]], 12: [[16], [11]],
    13: [[17], [13]], 14: [[18], [12]], 15: [[19], [10]], 16: [[19], [11]],
    17: [[21], [12]]})

T10 = WangTileSet([('210331', '511', '211300', '511'),
 ('21030020331', '511', '21030021031', '511'),
 ('21330020331', '511', '21030021300', '511'),
 ('21033121331', '511', '21130021031', '511'),
 ('211300', '51060', '210331', '51151'),
 ('211300', '51060', '210300', '51151'),
 ('211300', '60060', '210331', '51160'),
 ('210300', '60060', '210331', '51060'),
 ('211300', '51160', '211300', '51151'),
 ('21130021031', '51151', '21030021031', '51151'),
 ('21130021031', '51151', '21033121331', '51160'),
 ('21030021031', '51151', '21033121331', '51060'),
 ('21030021300', '51160', '21033121331', '51060'),
 ('21130021031', '51151', '21030021300', '51160'),
 ('21030021300', '51060', '21030020331', '51060'),
 ('21030021031', '51151', '21030021300', '51060'),
 ('21030021300', '51160', '21030021300', '51060'),
 ('21030021300', '51060', '21330020331', '60060')])
M10 = [0, 4, 5, 6, 7, 8]
omega10 = Substitution2d({0: [[1]], 1: [[2]], 2: [[3]], 3: [[12]], 4:
    [[13]], 5: [[14]], 6: [[15]], 7: [[16]], 8: [[17]], 9: [[1, 0]], 10:
    [[2, 0]], 11: [[3, 0]], 12: [[9, 8]], 13: [[10, 4]], 14: [[11, 4]], 15:
    [[12, 6]], 16: [[13, 5]], 17: [[13, 8]], 18: [[14, 7]], 19: [[15, 5]],
    20: [[17, 7]]})

T11 = WangTileSet([('21030020331', '511', '21030021031', '511'),
 ('21330020331', '511', '21030021300', '511'),
 ('21033121331', '511', '21130021031', '511'),
 ('21030021300', '51160', '21033121331', '51060'),
 ('21130021031', '51151', '21030021300', '51160'),
 ('21030021300', '51060', '21030020331', '51060'),
 ('21030021031', '51151', '21030021300', '51060'),
 ('21030021300', '51160', '21030021300', '51060'),
 ('21030021300', '51060', '21330020331', '60060'),
 ('21030020331210331', '511', '21030021031211300', '511'),
 ('21330020331210331', '511', '21030021300211300', '511'),
 ('21033121331210331', '511', '21130021031211300', '511'),
 ('21130021031211300', '51160', '21030021031211300', '51151'),
 ('21130021031211300', '51060', '21033121331210331', '51160'),
 ('21030021031211300', '51060', '21033121331210331', '51060'),
 ('21030021300211300', '60060', '21033121331210331', '51060'),
 ('21130021031211300', '51060', '21030021300210300', '51160'),
 ('21130021031211300', '51160', '21030021300211300', '51160'),
 ('21030021300210300', '60060', '21030020331210331', '51060'),
 ('21030021031211300', '51060', '21030021300210300', '51060'),
 ('21030021300210300', '60060', '21330020331210331', '60060')])
M11 = [0, 1, 2, 9, 10, 11]
omega11 = Substitution2d({0: [[5]], 1: [[8]], 2: [[14]], 3: [[15]], 4:
    [[18]], 5: [[20]], 6: [[3], [1]], 7: [[4], [2]], 8: [[5], [1]], 9:
    [[6], [0]], 10: [[7], [1]], 11: [[8], [1]], 12: [[12], [11]], 13:
    [[13], [11]], 14: [[14], [9]], 15: [[15], [10]], 16: [[16], [11]], 17:
    [[17], [11]], 18: [[19], [9]]})

T12 = WangTileSet([('21030021300', '51060', '21030020331', '51060'),
 ('21030021300', '51060', '21330020331', '60060'),
 ('21030021031211300', '51060', '21033121331210331', '51060'),
 ('21030021300211300', '60060', '21033121331210331', '51060'),
 ('21030021300210300', '60060', '21030020331210331', '51060'),
 ('21030021300210300', '60060', '21330020331210331', '60060'),
 ('21330020331', '51160511', '21033121331', '51060511'),
 ('21033121331', '51151511', '21030021300', '51160511'),
 ('21330020331', '51060511', '21030020331', '51060511'),
 ('21030020331', '51151511', '21030021300', '51060511'),
 ('21330020331', '51160511', '21030021300', '51060511'),
 ('21330020331', '51060511', '21330020331', '60060511'),
 ('21033121331210331', '51160511', '21030021031211300', '51151511'),
 ('21033121331210331', '51060511', '21033121331210331', '51160511'),
 ('21030020331210331', '51060511', '21033121331210331', '51060511'),
 ('21330020331210331', '60060511', '21033121331210331', '51060511'),
 ('21033121331210331', '51060511', '21030021300210300', '51160511'),
 ('21033121331210331', '51160511', '21030021300211300', '51160511'),
 ('21030020331210331', '51060511', '21030021300210300', '51060511')])

S = T4p.solver(width=71, height=9, preassigned_tiles={(35,4):24})

D_horizontal = {(0, 2),
  (0, 10),
  (1, 0),
  (2, 11),
  (3, 10),
  (4, 12),
  (5, 1),
  (5, 9),
  (6, 5),
  (7, 4),
  (8, 4),
  (9, 8),
  (10, 6),
  (10, 7),
  (11, 3),
  (12, 3),
  (13, 21),
  (14, 22),
  (14, 23),
  (14, 27),
  (15, 20),
  (16, 15),
  (17, 15),
  (18, 14),
  (19, 14),
  (20, 19),
  (21, 16),
  (21, 18),
  (22, 28),
  (23, 13),
  (24, 23),
  (24, 27),
  (25, 17),
  (25, 19),
  (26, 25),
  (27, 26),
  (28, 24)},
D_vertical = {(0, 23),
  (1, 14),
  (2, 13),
  (3, 1),
  (3, 16),
  (3, 17),
  (3, 18),
  (3, 19),
  (3, 23),
  (4, 6),
  (4, 26),
  (4, 28),
  (5, 18),
  (5, 19),
  (6, 20),
  (6, 21),
  (7, 22),
  (8, 27),
  (9, 14),
  (10, 0),
  (10, 13),
  (10, 14),
  (10, 15),
  (11, 20),
  (11, 21),
  (12, 5),
  (12, 24),
  (12, 25),
  (13, 1),
  (13, 17),
  (13, 19),
  (13, 23),
  (14, 6),
  (14, 11),
  (14, 12),
  (14, 26),
  (14, 28),
  (15, 1),
  (15, 18),
  (15, 19),
  (16, 20),
  (16, 21),
  (17, 5),
  (17, 25),
  (18, 2),
  (18, 22),
  (19, 4),
  (19, 10),
  (19, 27),
  (20, 0),
  (20, 14),
  (21, 0),
  (21, 13),
  (21, 14),
  (21, 15),
  (22, 3),
  (22, 5),
  (22, 24),
  (23, 5),
  (23, 24),
  (23, 25),
  (24, 6),
  (24, 26),
  (25, 6),
  (25, 7),
  (25, 8),
  (25, 26),
  (26, 9),
  (26, 10),
  (26, 27),
  (27, 3),
  (27, 5),
  (27, 24),
  (28, 10),
  (28, 27)},

