# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: onos/uenib/ran.proto, onos/uenib/uenib.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import AsyncIterator, Dict, List

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase
import grpclib


class EventType(betterproto.Enum):
    """EventType is a UE operation event type"""

    NONE = 0
    ADDED = 1
    UPDATED = 2
    REMOVED = 3


@dataclass(eq=False, repr=False)
class CellConnection(betterproto.Message):
    """CellConnection represents UE cell connection."""

    id: str = betterproto.string_field(1)
    signal_strength: float = betterproto.double_field(2)


@dataclass(eq=False, repr=False)
class CellInfo(betterproto.Message):
    """CellInfo provides data on serving cell and candidate cells."""

    serving_cell: "CellConnection" = betterproto.message_field(1)
    candidate_cells: List["CellConnection"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class Event(betterproto.Message):
    """Event is a record of an operation on a UE"""

    type: "EventType" = betterproto.enum_field(1)
    ue: "Ue" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class CreateUeRequest(betterproto.Message):
    ue: "Ue" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class CreateUeResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetUeRequest(betterproto.Message):
    id: str = betterproto.string_field(1)
    aspect_types: List[str] = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class GetUeResponse(betterproto.Message):
    ue: "Ue" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class UpdateUeRequest(betterproto.Message):
    ue: "Ue" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class UpdateUeResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class DeleteUeRequest(betterproto.Message):
    id: str = betterproto.string_field(1)
    aspect_types: List[str] = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class DeleteUeResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class ListUeRequest(betterproto.Message):
    aspect_types: List[str] = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class ListUeResponse(betterproto.Message):
    ue: "Ue" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class WatchUeRequest(betterproto.Message):
    noreplay: bool = betterproto.bool_field(2)
    aspect_types: List[str] = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class WatchUeResponse(betterproto.Message):
    event: "Event" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class Ue(betterproto.Message):
    """UE entity is merely an ID and a map of arbitrary aspects."""

    id: str = betterproto.string_field(1)
    # Map of aspects as typed values
    aspects: Dict[str, "betterproto_lib_google_protobuf.Any"] = betterproto.map_field(
        2, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )


class UeServiceStub(betterproto.ServiceStub):
    async def create_ue(self) -> "CreateUeResponse":

        request = CreateUeRequest()

        return await self._unary_unary(
            "/onos.uenib.UEService/CreateUE", request, CreateUeResponse
        )

    async def get_ue(self) -> "GetUeResponse":

        request = GetUeRequest()

        return await self._unary_unary(
            "/onos.uenib.UEService/GetUE", request, GetUeResponse
        )

    async def update_ue(self) -> "UpdateUeResponse":

        request = UpdateUeRequest()

        return await self._unary_unary(
            "/onos.uenib.UEService/UpdateUE", request, UpdateUeResponse
        )

    async def delete_ue(self) -> "DeleteUeResponse":

        request = DeleteUeRequest()

        return await self._unary_unary(
            "/onos.uenib.UEService/DeleteUE", request, DeleteUeResponse
        )

    async def list_u_es(self) -> AsyncIterator["ListUeResponse"]:

        request = ListUeRequest()

        async for response in self._unary_stream(
            "/onos.uenib.UEService/ListUEs",
            request,
            ListUeResponse,
        ):
            yield response

    async def watch_u_es(self) -> AsyncIterator["WatchUeResponse"]:

        request = WatchUeRequest()

        async for response in self._unary_stream(
            "/onos.uenib.UEService/WatchUEs",
            request,
            WatchUeResponse,
        ):
            yield response


class UeServiceBase(ServiceBase):
    async def create_ue(self) -> "CreateUeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_ue(self) -> "GetUeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def update_ue(self) -> "UpdateUeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delete_ue(self) -> "DeleteUeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def list_u_es(self) -> AsyncIterator["ListUeResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def watch_u_es(self) -> AsyncIterator["WatchUeResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_create_ue(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.create_ue(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_get_ue(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.get_ue(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_update_ue(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.update_ue(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_delete_ue(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.delete_ue(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_list_u_es(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        await self._call_rpc_handler_server_stream(
            self.list_u_es,
            stream,
            request_kwargs,
        )

    async def __rpc_watch_u_es(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        await self._call_rpc_handler_server_stream(
            self.watch_u_es,
            stream,
            request_kwargs,
        )

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/onos.uenib.UEService/CreateUE": grpclib.const.Handler(
                self.__rpc_create_ue,
                grpclib.const.Cardinality.UNARY_UNARY,
                CreateUeRequest,
                CreateUeResponse,
            ),
            "/onos.uenib.UEService/GetUE": grpclib.const.Handler(
                self.__rpc_get_ue,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetUeRequest,
                GetUeResponse,
            ),
            "/onos.uenib.UEService/UpdateUE": grpclib.const.Handler(
                self.__rpc_update_ue,
                grpclib.const.Cardinality.UNARY_UNARY,
                UpdateUeRequest,
                UpdateUeResponse,
            ),
            "/onos.uenib.UEService/DeleteUE": grpclib.const.Handler(
                self.__rpc_delete_ue,
                grpclib.const.Cardinality.UNARY_UNARY,
                DeleteUeRequest,
                DeleteUeResponse,
            ),
            "/onos.uenib.UEService/ListUEs": grpclib.const.Handler(
                self.__rpc_list_u_es,
                grpclib.const.Cardinality.UNARY_STREAM,
                ListUeRequest,
                ListUeResponse,
            ),
            "/onos.uenib.UEService/WatchUEs": grpclib.const.Handler(
                self.__rpc_watch_u_es,
                grpclib.const.Cardinality.UNARY_STREAM,
                WatchUeRequest,
                WatchUeResponse,
            ),
        }


import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
