/**
 * The width of the grid we're filling
 */
export declare const GRID_WIDTH = 24;
/**
 * A single dashboard widget.
 */
export interface IWidget {
    /**
     * The amount of horizontal grid units the widget will take up.
     */
    readonly width: number;
    /**
     * The amount of vertical grid units the widget will take up.
     */
    readonly height: number;
    /**
     * Place the widget at a given position.
     */
    position(x: number, y: number): void;
    /**
     * Return the widget JSON for use in the dashboard.
     */
    toJson(): any[];
}
/**
 * A real CloudWatch widget that has its own fixed size and remembers its position.
 *
 * This is in contrast to other widgets which exist for layout purposes.
 */
export declare abstract class ConcreteWidget implements IWidget {
    /**
     * The amount of horizontal grid units the widget will take up.
     */
    readonly width: number;
    /**
     * The amount of vertical grid units the widget will take up.
     */
    readonly height: number;
    /**
     *
     */
    protected x?: number;
    /**
     *
     */
    protected y?: number;
    /**
     *
     */
    constructor(width: number, height: number);
    /**
     * Place the widget at a given position.
     */
    position(x: number, y: number): void;
    /**
     * Return the widget JSON for use in the dashboard.
     */
    abstract toJson(): any[];
}
