import { IWidget } from './widget';
/**
 * A widget that contains other widgets in a horizontal row.
 *
 * Widgets will be laid out next to each other
 */
export declare class Row implements IWidget {
    /**
     * The amount of horizontal grid units the widget will take up.
     */
    readonly width: number;
    /**
     * The amount of vertical grid units the widget will take up.
     */
    readonly height: number;
    /**
     * List of contained widgets
     */
    private readonly widgets;
    /**
     * Relative position of each widget inside this row
     */
    private readonly offsets;
    /**
     *
     */
    constructor(...widgets: IWidget[]);
    /**
     * Place the widget at a given position.
     */
    position(x: number, y: number): void;
    /**
     * Return the widget JSON for use in the dashboard.
     */
    toJson(): any[];
}
/**
 * A widget that contains other widgets in a vertical column.
 *
 * Widgets will be laid out next to each other
 */
export declare class Column implements IWidget {
    /**
     * The amount of horizontal grid units the widget will take up.
     */
    readonly width: number;
    /**
     * The amount of vertical grid units the widget will take up.
     */
    readonly height: number;
    /**
     * List of contained widgets
     */
    private readonly widgets;
    /**
     *
     */
    constructor(...widgets: IWidget[]);
    /**
     * Place the widget at a given position.
     */
    position(x: number, y: number): void;
    /**
     * Return the widget JSON for use in the dashboard.
     */
    toJson(): any[];
}
/**
 * Props of the spacer.
 */
export interface SpacerProps {
    /**
     * Width of the spacer.
     *
     * @default 1
     */
    readonly width?: number;
    /**
     * Height of the spacer.
     *
     * @default : 1
     */
    readonly height?: number;
}
/**
 * A widget that doesn't display anything but takes up space.
 */
export declare class Spacer implements IWidget {
    /**
     * The amount of horizontal grid units the widget will take up.
     */
    readonly width: number;
    /**
     * The amount of vertical grid units the widget will take up.
     */
    readonly height: number;
    /**
     *
     */
    constructor(props?: SpacerProps);
    /**
     * Place the widget at a given position.
     */
    position(_x: number, _y: number): void;
    /**
     * Return the widget JSON for use in the dashboard.
     */
    toJson(): any[];
}
