import * as cdk from '@aws-cdk/core';
/**
 * Properties for defining a `AWS::CloudWatch::Alarm`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html
 * @external
 */
export interface CfnAlarmProps {
    /**
     * `AWS::CloudWatch::Alarm.ComparisonOperator`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-comparisonoperator
     * @external
     */
    readonly comparisonOperator: string;
    /**
     * `AWS::CloudWatch::Alarm.EvaluationPeriods`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-evaluationperiods
     * @external
     */
    readonly evaluationPeriods: number;
    /**
     * `AWS::CloudWatch::Alarm.ActionsEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-actionsenabled
     * @external
     */
    readonly actionsEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::CloudWatch::Alarm.AlarmActions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-alarmactions
     * @external
     */
    readonly alarmActions?: string[];
    /**
     * `AWS::CloudWatch::Alarm.AlarmDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-alarmdescription
     * @external
     */
    readonly alarmDescription?: string;
    /**
     * `AWS::CloudWatch::Alarm.AlarmName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-alarmname
     * @external
     */
    readonly alarmName?: string;
    /**
     * `AWS::CloudWatch::Alarm.DatapointsToAlarm`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarm-datapointstoalarm
     * @external
     */
    readonly datapointsToAlarm?: number;
    /**
     * `AWS::CloudWatch::Alarm.Dimensions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-dimension
     * @external
     */
    readonly dimensions?: Array<CfnAlarm.DimensionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CloudWatch::Alarm.EvaluateLowSampleCountPercentile`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-evaluatelowsamplecountpercentile
     * @external
     */
    readonly evaluateLowSampleCountPercentile?: string;
    /**
     * `AWS::CloudWatch::Alarm.ExtendedStatistic`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-extendedstatistic
     * @external
     */
    readonly extendedStatistic?: string;
    /**
     * `AWS::CloudWatch::Alarm.InsufficientDataActions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-insufficientdataactions
     * @external
     */
    readonly insufficientDataActions?: string[];
    /**
     * `AWS::CloudWatch::Alarm.MetricName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-metricname
     * @external
     */
    readonly metricName?: string;
    /**
     * `AWS::CloudWatch::Alarm.Metrics`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarm-metrics
     * @external
     */
    readonly metrics?: Array<CfnAlarm.MetricDataQueryProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CloudWatch::Alarm.Namespace`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-namespace
     * @external
     */
    readonly namespace?: string;
    /**
     * `AWS::CloudWatch::Alarm.OKActions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-okactions
     * @external
     */
    readonly okActions?: string[];
    /**
     * `AWS::CloudWatch::Alarm.Period`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-period
     * @external
     */
    readonly period?: number;
    /**
     * `AWS::CloudWatch::Alarm.Statistic`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-statistic
     * @external
     */
    readonly statistic?: string;
    /**
     * `AWS::CloudWatch::Alarm.Threshold`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-threshold
     * @external
     */
    readonly threshold?: number;
    /**
     * `AWS::CloudWatch::Alarm.ThresholdMetricId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-dynamic-threshold
     * @external
     */
    readonly thresholdMetricId?: string;
    /**
     * `AWS::CloudWatch::Alarm.TreatMissingData`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-treatmissingdata
     * @external
     */
    readonly treatMissingData?: string;
    /**
     * `AWS::CloudWatch::Alarm.Unit`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-unit
     * @external
     */
    readonly unit?: string;
}
/**
 * A CloudFormation `AWS::CloudWatch::Alarm`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html
 * @external
 * @cloudformationResource AWS::CloudWatch::Alarm
 */
export declare class CfnAlarm extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudWatch::Alarm";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::CloudWatch::Alarm.ComparisonOperator`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-comparisonoperator
     * @external
     */
    comparisonOperator: string;
    /**
     * `AWS::CloudWatch::Alarm.EvaluationPeriods`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-evaluationperiods
     * @external
     */
    evaluationPeriods: number;
    /**
     * `AWS::CloudWatch::Alarm.ActionsEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-actionsenabled
     * @external
     */
    actionsEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::CloudWatch::Alarm.AlarmActions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-alarmactions
     * @external
     */
    alarmActions: string[] | undefined;
    /**
     * `AWS::CloudWatch::Alarm.AlarmDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-alarmdescription
     * @external
     */
    alarmDescription: string | undefined;
    /**
     * `AWS::CloudWatch::Alarm.AlarmName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-alarmname
     * @external
     */
    alarmName: string | undefined;
    /**
     * `AWS::CloudWatch::Alarm.DatapointsToAlarm`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarm-datapointstoalarm
     * @external
     */
    datapointsToAlarm: number | undefined;
    /**
     * `AWS::CloudWatch::Alarm.Dimensions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-dimension
     * @external
     */
    dimensions: Array<CfnAlarm.DimensionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::CloudWatch::Alarm.EvaluateLowSampleCountPercentile`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-evaluatelowsamplecountpercentile
     * @external
     */
    evaluateLowSampleCountPercentile: string | undefined;
    /**
     * `AWS::CloudWatch::Alarm.ExtendedStatistic`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-extendedstatistic
     * @external
     */
    extendedStatistic: string | undefined;
    /**
     * `AWS::CloudWatch::Alarm.InsufficientDataActions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-insufficientdataactions
     * @external
     */
    insufficientDataActions: string[] | undefined;
    /**
     * `AWS::CloudWatch::Alarm.MetricName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-metricname
     * @external
     */
    metricName: string | undefined;
    /**
     * `AWS::CloudWatch::Alarm.Metrics`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarm-metrics
     * @external
     */
    metrics: Array<CfnAlarm.MetricDataQueryProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::CloudWatch::Alarm.Namespace`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-namespace
     * @external
     */
    namespace: string | undefined;
    /**
     * `AWS::CloudWatch::Alarm.OKActions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-okactions
     * @external
     */
    okActions: string[] | undefined;
    /**
     * `AWS::CloudWatch::Alarm.Period`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-period
     * @external
     */
    period: number | undefined;
    /**
     * `AWS::CloudWatch::Alarm.Statistic`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-statistic
     * @external
     */
    statistic: string | undefined;
    /**
     * `AWS::CloudWatch::Alarm.Threshold`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-threshold
     * @external
     */
    threshold: number | undefined;
    /**
     * `AWS::CloudWatch::Alarm.ThresholdMetricId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-dynamic-threshold
     * @external
     */
    thresholdMetricId: string | undefined;
    /**
     * `AWS::CloudWatch::Alarm.TreatMissingData`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-treatmissingdata
     * @external
     */
    treatMissingData: string | undefined;
    /**
     * `AWS::CloudWatch::Alarm.Unit`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html#cfn-cloudwatch-alarms-unit
     * @external
     */
    unit: string | undefined;
    /**
     * Create a new `AWS::CloudWatch::Alarm`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAlarmProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::CloudWatch::Alarm`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html
 * @external
 * @cloudformationResource AWS::CloudWatch::Alarm
 */
export declare namespace CfnAlarm {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-dimension.html
     * @external
     */
    interface DimensionProperty {
        /**
         * `CfnAlarm.DimensionProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-dimension.html#cfn-cloudwatch-alarm-dimension-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnAlarm.DimensionProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-dimension.html#cfn-cloudwatch-alarm-dimension-value
         * @external
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::CloudWatch::Alarm`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html
 * @external
 * @cloudformationResource AWS::CloudWatch::Alarm
 */
export declare namespace CfnAlarm {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metric.html
     * @external
     */
    interface MetricProperty {
        /**
         * `CfnAlarm.MetricProperty.Dimensions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metric.html#cfn-cloudwatch-alarm-metric-dimensions
         * @external
         */
        readonly dimensions?: Array<CfnAlarm.DimensionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnAlarm.MetricProperty.MetricName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metric.html#cfn-cloudwatch-alarm-metric-metricname
         * @external
         */
        readonly metricName?: string;
        /**
         * `CfnAlarm.MetricProperty.Namespace`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metric.html#cfn-cloudwatch-alarm-metric-namespace
         * @external
         */
        readonly namespace?: string;
    }
}
/**
 * A CloudFormation `AWS::CloudWatch::Alarm`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html
 * @external
 * @cloudformationResource AWS::CloudWatch::Alarm
 */
export declare namespace CfnAlarm {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricdataquery.html
     * @external
     */
    interface MetricDataQueryProperty {
        /**
         * `CfnAlarm.MetricDataQueryProperty.Expression`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricdataquery.html#cfn-cloudwatch-alarm-metricdataquery-expression
         * @external
         */
        readonly expression?: string;
        /**
         * `CfnAlarm.MetricDataQueryProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricdataquery.html#cfn-cloudwatch-alarm-metricdataquery-id
         * @external
         */
        readonly id: string;
        /**
         * `CfnAlarm.MetricDataQueryProperty.Label`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricdataquery.html#cfn-cloudwatch-alarm-metricdataquery-label
         * @external
         */
        readonly label?: string;
        /**
         * `CfnAlarm.MetricDataQueryProperty.MetricStat`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricdataquery.html#cfn-cloudwatch-alarm-metricdataquery-metricstat
         * @external
         */
        readonly metricStat?: CfnAlarm.MetricStatProperty | cdk.IResolvable;
        /**
         * `CfnAlarm.MetricDataQueryProperty.Period`.
         *
         * @external
         */
        readonly period?: number;
        /**
         * `CfnAlarm.MetricDataQueryProperty.ReturnData`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricdataquery.html#cfn-cloudwatch-alarm-metricdataquery-returndata
         * @external
         */
        readonly returnData?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::CloudWatch::Alarm`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cw-alarm.html
 * @external
 * @cloudformationResource AWS::CloudWatch::Alarm
 */
export declare namespace CfnAlarm {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricstat.html
     * @external
     */
    interface MetricStatProperty {
        /**
         * `CfnAlarm.MetricStatProperty.Metric`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricstat.html#cfn-cloudwatch-alarm-metricstat-metric
         * @external
         */
        readonly metric: CfnAlarm.MetricProperty | cdk.IResolvable;
        /**
         * `CfnAlarm.MetricStatProperty.Period`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricstat.html#cfn-cloudwatch-alarm-metricstat-period
         * @external
         */
        readonly period: number;
        /**
         * `CfnAlarm.MetricStatProperty.Stat`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricstat.html#cfn-cloudwatch-alarm-metricstat-stat
         * @external
         */
        readonly stat: string;
        /**
         * `CfnAlarm.MetricStatProperty.Unit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-alarm-metricstat.html#cfn-cloudwatch-alarm-metricstat-unit
         * @external
         */
        readonly unit?: string;
    }
}
/**
 * Properties for defining a `AWS::CloudWatch::AnomalyDetector`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html
 * @external
 */
export interface CfnAnomalyDetectorProps {
    /**
     * `AWS::CloudWatch::AnomalyDetector.MetricName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-metricname
     * @external
     */
    readonly metricName: string;
    /**
     * `AWS::CloudWatch::AnomalyDetector.Namespace`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-namespace
     * @external
     */
    readonly namespace: string;
    /**
     * `AWS::CloudWatch::AnomalyDetector.Stat`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-stat
     * @external
     */
    readonly stat: string;
    /**
     * `AWS::CloudWatch::AnomalyDetector.Configuration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-configuration
     * @external
     */
    readonly configuration?: CfnAnomalyDetector.ConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::CloudWatch::AnomalyDetector.Dimensions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-dimensions
     * @external
     */
    readonly dimensions?: Array<CfnAnomalyDetector.DimensionProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::CloudWatch::AnomalyDetector`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html
 * @external
 * @cloudformationResource AWS::CloudWatch::AnomalyDetector
 */
export declare class CfnAnomalyDetector extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudWatch::AnomalyDetector";
    /**
     * `AWS::CloudWatch::AnomalyDetector.MetricName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-metricname
     * @external
     */
    metricName: string;
    /**
     * `AWS::CloudWatch::AnomalyDetector.Namespace`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-namespace
     * @external
     */
    namespace: string;
    /**
     * `AWS::CloudWatch::AnomalyDetector.Stat`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-stat
     * @external
     */
    stat: string;
    /**
     * `AWS::CloudWatch::AnomalyDetector.Configuration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-configuration
     * @external
     */
    configuration: CfnAnomalyDetector.ConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::CloudWatch::AnomalyDetector.Dimensions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html#cfn-cloudwatch-anomalydetector-dimensions
     * @external
     */
    dimensions: Array<CfnAnomalyDetector.DimensionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::CloudWatch::AnomalyDetector`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAnomalyDetectorProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::CloudWatch::AnomalyDetector`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html
 * @external
 * @cloudformationResource AWS::CloudWatch::AnomalyDetector
 */
export declare namespace CfnAnomalyDetector {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-anomalydetector-configuration.html
     * @external
     */
    interface ConfigurationProperty {
        /**
         * `CfnAnomalyDetector.ConfigurationProperty.ExcludedTimeRanges`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-anomalydetector-configuration.html#cfn-cloudwatch-anomalydetector-configuration-excludedtimeranges
         * @external
         */
        readonly excludedTimeRanges?: Array<CfnAnomalyDetector.RangeProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnAnomalyDetector.ConfigurationProperty.MetricTimeZone`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-anomalydetector-configuration.html#cfn-cloudwatch-anomalydetector-configuration-metrictimezone
         * @external
         */
        readonly metricTimeZone?: string;
    }
}
/**
 * A CloudFormation `AWS::CloudWatch::AnomalyDetector`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html
 * @external
 * @cloudformationResource AWS::CloudWatch::AnomalyDetector
 */
export declare namespace CfnAnomalyDetector {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-anomalydetector-dimension.html
     * @external
     */
    interface DimensionProperty {
        /**
         * `CfnAnomalyDetector.DimensionProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-anomalydetector-dimension.html#cfn-cloudwatch-anomalydetector-dimension-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnAnomalyDetector.DimensionProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-anomalydetector-dimension.html#cfn-cloudwatch-anomalydetector-dimension-value
         * @external
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::CloudWatch::AnomalyDetector`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-anomalydetector.html
 * @external
 * @cloudformationResource AWS::CloudWatch::AnomalyDetector
 */
export declare namespace CfnAnomalyDetector {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-anomalydetector-range.html
     * @external
     */
    interface RangeProperty {
        /**
         * `CfnAnomalyDetector.RangeProperty.EndTime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-anomalydetector-range.html#cfn-cloudwatch-anomalydetector-range-endtime
         * @external
         */
        readonly endTime: string;
        /**
         * `CfnAnomalyDetector.RangeProperty.StartTime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudwatch-anomalydetector-range.html#cfn-cloudwatch-anomalydetector-range-starttime
         * @external
         */
        readonly startTime: string;
    }
}
/**
 * Properties for defining a `AWS::CloudWatch::CompositeAlarm`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html
 * @external
 */
export interface CfnCompositeAlarmProps {
    /**
     * `AWS::CloudWatch::CompositeAlarm.AlarmName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-alarmname
     * @external
     */
    readonly alarmName: string;
    /**
     * `AWS::CloudWatch::CompositeAlarm.AlarmRule`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-alarmrule
     * @external
     */
    readonly alarmRule: string;
    /**
     * `AWS::CloudWatch::CompositeAlarm.ActionsEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-actionsenabled
     * @external
     */
    readonly actionsEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::CloudWatch::CompositeAlarm.AlarmActions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-alarmactions
     * @external
     */
    readonly alarmActions?: string[];
    /**
     * `AWS::CloudWatch::CompositeAlarm.AlarmDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-alarmdescription
     * @external
     */
    readonly alarmDescription?: string;
    /**
     * `AWS::CloudWatch::CompositeAlarm.InsufficientDataActions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-insufficientdataactions
     * @external
     */
    readonly insufficientDataActions?: string[];
    /**
     * `AWS::CloudWatch::CompositeAlarm.OKActions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-okactions
     * @external
     */
    readonly okActions?: string[];
}
/**
 * A CloudFormation `AWS::CloudWatch::CompositeAlarm`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html
 * @external
 * @cloudformationResource AWS::CloudWatch::CompositeAlarm
 */
export declare class CfnCompositeAlarm extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudWatch::CompositeAlarm";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::CloudWatch::CompositeAlarm.AlarmName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-alarmname
     * @external
     */
    alarmName: string;
    /**
     * `AWS::CloudWatch::CompositeAlarm.AlarmRule`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-alarmrule
     * @external
     */
    alarmRule: string;
    /**
     * `AWS::CloudWatch::CompositeAlarm.ActionsEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-actionsenabled
     * @external
     */
    actionsEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::CloudWatch::CompositeAlarm.AlarmActions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-alarmactions
     * @external
     */
    alarmActions: string[] | undefined;
    /**
     * `AWS::CloudWatch::CompositeAlarm.AlarmDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-alarmdescription
     * @external
     */
    alarmDescription: string | undefined;
    /**
     * `AWS::CloudWatch::CompositeAlarm.InsufficientDataActions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-insufficientdataactions
     * @external
     */
    insufficientDataActions: string[] | undefined;
    /**
     * `AWS::CloudWatch::CompositeAlarm.OKActions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-okactions
     * @external
     */
    okActions: string[] | undefined;
    /**
     * Create a new `AWS::CloudWatch::CompositeAlarm`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCompositeAlarmProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::CloudWatch::Dashboard`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-dashboard.html
 * @external
 */
export interface CfnDashboardProps {
    /**
     * `AWS::CloudWatch::Dashboard.DashboardBody`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-dashboard.html#cfn-cloudwatch-dashboard-dashboardbody
     * @external
     */
    readonly dashboardBody: string;
    /**
     * `AWS::CloudWatch::Dashboard.DashboardName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-dashboard.html#cfn-cloudwatch-dashboard-dashboardname
     * @external
     */
    readonly dashboardName?: string;
}
/**
 * A CloudFormation `AWS::CloudWatch::Dashboard`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-dashboard.html
 * @external
 * @cloudformationResource AWS::CloudWatch::Dashboard
 */
export declare class CfnDashboard extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudWatch::Dashboard";
    /**
     * `AWS::CloudWatch::Dashboard.DashboardBody`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-dashboard.html#cfn-cloudwatch-dashboard-dashboardbody
     * @external
     */
    dashboardBody: string;
    /**
     * `AWS::CloudWatch::Dashboard.DashboardName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-dashboard.html#cfn-cloudwatch-dashboard-dashboardname
     * @external
     */
    dashboardName: string | undefined;
    /**
     * Create a new `AWS::CloudWatch::Dashboard`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDashboardProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::CloudWatch::InsightRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-insightrule.html
 * @external
 */
export interface CfnInsightRuleProps {
    /**
     * `AWS::CloudWatch::InsightRule.RuleBody`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-insightrule.html#cfn-cloudwatch-insightrule-rulebody
     * @external
     */
    readonly ruleBody: string;
    /**
     * `AWS::CloudWatch::InsightRule.RuleName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-insightrule.html#cfn-cloudwatch-insightrule-rulename
     * @external
     */
    readonly ruleName: string;
    /**
     * `AWS::CloudWatch::InsightRule.RuleState`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-insightrule.html#cfn-cloudwatch-insightrule-rulestate
     * @external
     */
    readonly ruleState: string;
    /**
     * `AWS::CloudWatch::InsightRule.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-insightrule.html#cfn-cloudwatch-insightrule-tags
     * @external
     */
    readonly tags?: Array<cdk.CfnTag | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::CloudWatch::InsightRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-insightrule.html
 * @external
 * @cloudformationResource AWS::CloudWatch::InsightRule
 */
export declare class CfnInsightRule extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudWatch::InsightRule";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute RuleName
     */
    readonly attrRuleName: string;
    /**
     * `AWS::CloudWatch::InsightRule.RuleBody`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-insightrule.html#cfn-cloudwatch-insightrule-rulebody
     * @external
     */
    ruleBody: string;
    /**
     * `AWS::CloudWatch::InsightRule.RuleName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-insightrule.html#cfn-cloudwatch-insightrule-rulename
     * @external
     */
    ruleName: string;
    /**
     * `AWS::CloudWatch::InsightRule.RuleState`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-insightrule.html#cfn-cloudwatch-insightrule-rulestate
     * @external
     */
    ruleState: string;
    /**
     * `AWS::CloudWatch::InsightRule.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-insightrule.html#cfn-cloudwatch-insightrule-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::CloudWatch::InsightRule`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnInsightRuleProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
