# Copyright 2015 Cisco Systems, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

""" This is auto-generated module containing Constants information. """


class NamingId:
    DN = "dn"
    METHOD = "method"
    AAA_GET_COMPUTE_AUTH_TOKENS = "aaaGetComputeAuthTokens"
    AAA_KEEP_ALIVE = "aaaKeepAlive"
    AAA_LDAP = "aaaLdap"
    AAA_LDAP_ROLE_GROUP = "aaaLdapRoleGroup"
    AAA_LOGIN = "aaaLogin"
    AAA_LOGOUT = "aaaLogout"
    AAA_REFRESH = "aaaRefresh"
    AAA_SESSION = "aaaSession"
    AAA_TACACS_PLUS = "aaaTacacsPlus"
    AAA_TACACS_PLUS_SERVER = "aaaTacacsPlusServer"
    AAA_USER = "aaaUser"
    AAA_USER_AUTH_PRECEDENCE = "aaaUserAuthPrecedence"
    AAA_USER_EP = "aaaUserEp"
    AAA_USER_PASSWORD_EXPIRATION = "aaaUserPasswordExpiration"
    AAA_USER_POLICY = "aaaUserPolicy"
    AAA_USER_SSHKEY = "aaaUserSSHKey"
    ACTIVATE_PIDCATALOG = "activatePIDCatalog"
    ADAPTOR_CFG_BACKUP = "adaptorCfgBackup"
    ADAPTOR_CFG_IMPORTER = "adaptorCfgImporter"
    ADAPTOR_CONNECTOR_INFO = "adaptorConnectorInfo"
    ADAPTOR_ETH_COMP_QUEUE_PROFILE = "adaptorEthCompQueueProfile"
    ADAPTOR_ETH_GEN_PROFILE = "adaptorEthGenProfile"
    ADAPTOR_ETH_ISCSIPROFILE = "adaptorEthISCSIProfile"
    ADAPTOR_ETH_INTERRUPT_PROFILE = "adaptorEthInterruptProfile"
    ADAPTOR_ETH_MULTI_QUEUE_PROFILE = "adaptorEthMultiQueueProfile"
    ADAPTOR_ETH_OFFLOAD_PROFILE = "adaptorEthOffloadProfile"
    ADAPTOR_ETH_RDMA_PROFILE = "adaptorEthRdmaProfile"
    ADAPTOR_ETH_RECV_QUEUE_PROFILE = "adaptorEthRecvQueueProfile"
    ADAPTOR_ETH_USNICPROFILE = "adaptorEthUSNICProfile"
    ADAPTOR_ETH_WORK_QUEUE_PROFILE = "adaptorEthWorkQueueProfile"
    ADAPTOR_EXT_ETH_IF = "adaptorExtEthIf"
    ADAPTOR_EXT_IP_V6_RSS_HASH_PROFILE = "adaptorExtIpV6RssHashProfile"
    ADAPTOR_FC_BOOT_TABLE = "adaptorFcBootTable"
    ADAPTOR_FC_CDB_WORK_QUEUE_PROFILE = "adaptorFcCdbWorkQueueProfile"
    ADAPTOR_FC_ERROR_RECOVERY_PROFILE = "adaptorFcErrorRecoveryProfile"
    ADAPTOR_FC_GEN_PROFILE = "adaptorFcGenProfile"
    ADAPTOR_FC_INTERRUPT_PROFILE = "adaptorFcInterruptProfile"
    ADAPTOR_FC_PERSISTENT_BINDINGS = "adaptorFcPersistentBindings"
    ADAPTOR_FC_PORT_FLOGI_PROFILE = "adaptorFcPortFLogiProfile"
    ADAPTOR_FC_PORT_PLOGI_PROFILE = "adaptorFcPortPLogiProfile"
    ADAPTOR_FC_PORT_PROFILE = "adaptorFcPortProfile"
    ADAPTOR_FC_RECV_QUEUE_PROFILE = "adaptorFcRecvQueueProfile"
    ADAPTOR_FC_WORK_QUEUE_PROFILE = "adaptorFcWorkQueueProfile"
    ADAPTOR_GEN_PROFILE = "adaptorGenProfile"
    ADAPTOR_HOST_ETH_IF = "adaptorHostEthIf"
    ADAPTOR_HOST_FC_IF = "adaptorHostFcIf"
    ADAPTOR_IP_V4_RSS_HASH_PROFILE = "adaptorIpV4RssHashProfile"
    ADAPTOR_IP_V6_RSS_HASH_PROFILE = "adaptorIpV6RssHashProfile"
    ADAPTOR_LINK_TRAINING = "adaptorLinkTraining"
    ADAPTOR_PORT_PROFILES = "adaptorPortProfiles"
    ADAPTOR_RSS_PROFILE = "adaptorRssProfile"
    ADAPTOR_UNIT = "adaptorUnit"
    ADVANCED_POWER_PROFILE = "advancedPowerProfile"
    ALLBITS_FILTER = "allbitsFilter"
    AND_FILTER = "andFilter"
    ANYBIT_FILTER = "anybitFilter"
    BIOS_BOT = "biosBOT"
    BIOS_BOOT_DEV = "biosBootDev"
    BIOS_BOOT_DEV_GRP = "biosBootDevGrp"
    BIOS_BOOT_DEV_PRECISION = "biosBootDevPrecision"
    BIOS_BOOT_MODE = "biosBootMode"
    BIOS_PASSWORD = "biosPassword"
    BIOS_PLATFORM_DEFAULTS = "biosPlatformDefaults"
    BIOS_PROFILE = "biosProfile"
    BIOS_PROFILE_MANAGEMENT = "biosProfileManagement"
    BIOS_PROFILE_TOKEN = "biosProfileToken"
    BIOS_SETTINGS = "biosSettings"
    BIOS_UNIT = "biosUnit"
    BIOS_VF_ASPMSUPPORT = "biosVfASPMSupport"
    BIOS_VF_ADJACENT_CACHE_LINE_PREFETCH = "biosVfAdjacentCacheLinePrefetch"
    BIOS_VF_ADVANCED_MEM_TEST = "biosVfAdvancedMemTest"
    BIOS_VF_ALTITUDE = "biosVfAltitude"
    BIOS_VF_ASSERT_NMION_PERR = "biosVfAssertNMIOnPERR"
    BIOS_VF_ASSERT_NMION_SERR = "biosVfAssertNMIOnSERR"
    BIOS_VF_AUTO_CCSTATE = "biosVfAutoCCState"
    BIOS_VF_AUTONUMOUS_CSTATE_ENABLE = "biosVfAutonumousCstateEnable"
    BIOS_VF_BME_DMA_MITIGATION = "biosVfBmeDmaMitigation"
    BIOS_VF_BOOT_OPTION_NUM_RETRY = "biosVfBootOptionNumRetry"
    BIOS_VF_BOOT_OPTION_RE_COOL_DOWN = "biosVfBootOptionReCoolDown"
    BIOS_VF_BOOT_OPTION_RETRY = "biosVfBootOptionRetry"
    BIOS_VF_BOOT_PERFORMANCE_MODE = "biosVfBootPerformanceMode"
    BIOS_VF_BURST_AND_POSTPONED_REFRESH = "biosVfBurstAndPostponedRefresh"
    BIOS_VF_C1_AUTO_DEMOTION = "biosVfC1AutoDemotion"
    BIOS_VF_C1_AUTO_UN_DEMOTION = "biosVfC1AutoUnDemotion"
    BIOS_VF_CDNENABLE = "biosVfCDNEnable"
    BIOS_VF_CDNSUPPORT = "biosVfCDNSupport"
    BIOS_VF_CPUENERGY_PERFORMANCE = "biosVfCPUEnergyPerformance"
    BIOS_VF_CPUFREQUENCY_FLOOR = "biosVfCPUFrequencyFloor"
    BIOS_VF_CPUPERFORMANCE = "biosVfCPUPerformance"
    BIOS_VF_CPUPOWER_MANAGEMENT = "biosVfCPUPowerManagement"
    BIOS_VF_CRQOS = "biosVfCRQos"
    BIOS_VF_CBS_CMN_APBDIS = "biosVfCbsCmnApbdis"
    BIOS_VF_CBS_CMN_CPU_CPB = "biosVfCbsCmnCpuCpb"
    BIOS_VF_CBS_CMN_CPU_GEN_DOWNCORE_CTRL = "biosVfCbsCmnCpuGenDowncoreCtrl"
    BIOS_VF_CBS_CMN_CPU_GLOBAL_CSTATE_CTRL = "biosVfCbsCmnCpuGlobalCstateCtrl"
    BIOS_VF_CBS_CMN_CPU_L1_STREAM_HW_PREFETCHER = "biosVfCbsCmnCpuL1StreamHwPrefetcher"
    BIOS_VF_CBS_CMN_CPU_L2_STREAM_HW_PREFETCHER = "biosVfCbsCmnCpuL2StreamHwPrefetcher"
    BIOS_VF_CBS_CMN_CPU_SMEE = "biosVfCbsCmnCpuSmee"
    BIOS_VF_CBS_CMN_CPU_STREAMING_STORES_CTRL = "biosVfCbsCmnCpuStreamingStoresCtrl"
    BIOS_VF_CBS_CMN_DETERMINISM_SLIDER = "biosVfCbsCmnDeterminismSlider"
    BIOS_VF_CBS_CMN_EFFICIENCY_MODE_EN = "biosVfCbsCmnEfficiencyModeEn"
    BIOS_VF_CBS_CMN_FIXED_SOC_PSTATE = "biosVfCbsCmnFixedSocPstate"
    BIOS_VF_CBS_CMN_GNB_NB_IOMMU = "biosVfCbsCmnGnbNbIOMMU"
    BIOS_VF_CBS_CMN_GNB_SMUCPPC = "biosVfCbsCmnGnbSMUCPPC"
    BIOS_VF_CBS_CMN_GNB_SMUDF_CSTATES = "biosVfCbsCmnGnbSMUDfCstates"
    BIOS_VF_CBS_CMN_MEM_CTRL_BANK_GROUP_SWAP_DDR4 = "biosVfCbsCmnMemCtrlBankGroupSwapDdr4"
    BIOS_VF_CBS_CMN_MEM_MAP_BANK_INTERLEAVE_DDR4 = "biosVfCbsCmnMemMapBankInterleaveDdr4"
    BIOS_VF_CBS_CMNC_TDPCTL = "biosVfCbsCmncTDPCtl"
    BIOS_VF_CBS_CPU_CCD_CTRL_SSP = "biosVfCbsCpuCcdCtrlSsp"
    BIOS_VF_CBS_CPU_CORE_CTRL = "biosVfCbsCpuCoreCtrl"
    BIOS_VF_CBS_CPU_SMT_CTRL = "biosVfCbsCpuSmtCtrl"
    BIOS_VF_CBS_DBG_CPU_SNP_MEM_COVER = "biosVfCbsDbgCpuSnpMemCover"
    BIOS_VF_CBS_DBG_CPU_SNP_MEM_SIZE_COVER = "biosVfCbsDbgCpuSnpMemSizeCover"
    BIOS_VF_CBS_DF_CMN_ACPI_SRAT_L3_NUMA = "biosVfCbsDfCmnAcpiSratL3Numa"
    BIOS_VF_CBS_DF_CMN_DRAM_NPS = "biosVfCbsDfCmnDramNps"
    BIOS_VF_CBS_DF_CMN_MEM_INTLV = "biosVfCbsDfCmnMemIntlv"
    BIOS_VF_CBS_DF_CMN_MEM_INTLV_SIZE = "biosVfCbsDfCmnMemIntlvSize"
    BIOS_VF_CBS_SEV_SNP_SUPPORT = "biosVfCbsSevSnpSupport"
    BIOS_VF_CISCO_ADAPTIVE_MEM_TRAINING = "biosVfCiscoAdaptiveMemTraining"
    BIOS_VF_CISCO_DEBUG_LEVEL = "biosVfCiscoDebugLevel"
    BIOS_VF_CISCO_OPROM_LAUNCH_OPTIMIZATION = "biosVfCiscoOpromLaunchOptimization"
    BIOS_VF_CISCO_XGMI_MAX_SPEED = "biosVfCiscoXgmiMaxSpeed"
    BIOS_VF_CKE_LOW_POLICY = "biosVfCkeLowPolicy"
    BIOS_VF_CLOSED_LOOP_THERM_THROTL = "biosVfClosedLoopThermThrotl"
    BIOS_VF_CMCI_ENABLE = "biosVfCmciEnable"
    BIOS_VF_CONFIG_TDP = "biosVfConfigTDP"
    BIOS_VF_CONFIG_TDPLEVEL = "biosVfConfigTDPLevel"
    BIOS_VF_CONSOLE_REDIRECTION = "biosVfConsoleRedirection"
    BIOS_VF_CORE_MULTI_PROCESSING = "biosVfCoreMultiProcessing"
    BIOS_VF_CPU_PA_LIMIT = "biosVfCpuPaLimit"
    BIOS_VF_CPU_PERF_ENHANCEMENT = "biosVfCpuPerfEnhancement"
    BIOS_VF_CRFASTGO_CONFIG = "biosVfCrfastgoConfig"
    BIOS_VF_DCPMMFIRMWARE_DOWNGRADE = "biosVfDCPMMFirmwareDowngrade"
    BIOS_VF_DCUPREFETCH = "biosVfDCUPrefetch"
    BIOS_VF_DRAMCLOCK_THROTTLING = "biosVfDRAMClockThrottling"
    BIOS_VF_DEMAND_SCRUB = "biosVfDemandScrub"
    BIOS_VF_DIRECT_CACHE_ACCESS = "biosVfDirectCacheAccess"
    BIOS_VF_DRAM_REFRESH_RATE = "biosVfDramRefreshRate"
    BIOS_VF_DRAM_SW_THERMAL_THROTTLING = "biosVfDramSwThermalThrottling"
    BIOS_VF_EPPENABLE = "biosVfEPPEnable"
    BIOS_VF_EPPPROFILE = "biosVfEPPProfile"
    BIOS_VF_EADR_SUPPORT = "biosVfEadrSupport"
    BIOS_VF_EDPC_EN = "biosVfEdpcEn"
    BIOS_VF_ENABLE_CLOCK_SPREAD_SPEC = "biosVfEnableClockSpreadSpec"
    BIOS_VF_ENABLE_MKTME = "biosVfEnableMktme"
    BIOS_VF_ENABLE_TME = "biosVfEnableTme"
    BIOS_VF_ENERGY_EFFICIENT_TURBO = "biosVfEnergyEfficientTurbo"
    BIOS_VF_ENG_PERF_TUNING = "biosVfEngPerfTuning"
    BIOS_VF_ENHANCED_INTEL_SPEED_STEP_TECH = "biosVfEnhancedIntelSpeedStepTech"
    BIOS_VF_EPOCH_UPDATE = "biosVfEpochUpdate"
    BIOS_VF_EXECUTE_DISABLE_BIT = "biosVfExecuteDisableBit"
    BIOS_VF_EXTENDED_APIC = "biosVfExtendedAPIC"
    BIOS_VF_FRB2_ENABLE = "biosVfFRB2Enable"
    BIOS_VF_HWPMENABLE = "biosVfHWPMEnable"
    BIOS_VF_HARDWARE_PREFETCH = "biosVfHardwarePrefetch"
    BIOS_VF_IMCINTERLEAVE = "biosVfIMCInterleave"
    BIOS_VF_IOHRESOURCE = "biosVfIOHResource"
    BIOS_VF_IPV4_HTTP = "biosVfIPV4HTTP"
    BIOS_VF_IPV4_PXE = "biosVfIPV4PXE"
    BIOS_VF_IPV6_HTTP = "biosVfIPV6HTTP"
    BIOS_VF_IPV6_PXE = "biosVfIPV6PXE"
    BIOS_VF_INTEL_DYNAMIC_SPEED_SELECT = "biosVfIntelDynamicSpeedSelect"
    BIOS_VF_INTEL_HYPER_THREADING_TECH = "biosVfIntelHyperThreadingTech"
    BIOS_VF_INTEL_SPEED_SELECT = "biosVfIntelSpeedSelect"
    BIOS_VF_INTEL_TURBO_BOOST_TECH = "biosVfIntelTurboBoostTech"
    BIOS_VF_INTEL_VTFOR_DIRECTED_IO = "biosVfIntelVTForDirectedIO"
    BIOS_VF_INTEL_VIRTUALIZATION_TECHNOLOGY = "biosVfIntelVirtualizationTechnology"
    BIOS_VF_IOH_ERROR_EN = "biosVfIohErrorEn"
    BIOS_VF_KTIPREFETCH = "biosVfKTIPrefetch"
    BIOS_VF_LLCALLOC = "biosVfLLCAlloc"
    BIOS_VF_LLCPREFETCH = "biosVfLLCPrefetch"
    BIOS_VF_LOMPORT_OPTION_ROM = "biosVfLOMPortOptionROM"
    BIOS_VF_LEGACY_USBSUPPORT = "biosVfLegacyUSBSupport"
    BIOS_VF_LV_DIMMSUPPORT = "biosVfLvDIMMSupport"
    BIOS_VF_MMCFGBASE = "biosVfMMCFGBase"
    BIOS_VF_MEMORY_BANDWIDTH_BOOST = "biosVfMemoryBandwidthBoost"
    BIOS_VF_MEMORY_INTERLEAVE = "biosVfMemoryInterleave"
    BIOS_VF_MEMORY_MAPPED_IOABOVE4_GB = "biosVfMemoryMappedIOAbove4GB"
    BIOS_VF_MEMORY_REFRESH_RATE = "biosVfMemoryRefreshRate"
    BIOS_VF_MEMORY_SIZE_LIMIT = "biosVfMemorySizeLimit"
    BIOS_VF_MEMORY_THERMAL_THROTTLING = "biosVfMemoryThermalThrottling"
    BIOS_VF_MIRRORING_MODE = "biosVfMirroringMode"
    BIOS_VF_NUMAOPTIMIZED = "biosVfNUMAOptimized"
    BIOS_VF_NETWORK_STACK = "biosVfNetworkStack"
    BIOS_VF_NVMDIMM_PERFORM_CONFIG = "biosVfNvmdimmPerformConfig"
    BIOS_VF_OSBOOT_WATCHDOG_TIMER = "biosVfOSBootWatchdogTimer"
    BIOS_VF_OSBOOT_WATCHDOG_TIMER_POLICY = "biosVfOSBootWatchdogTimerPolicy"
    BIOS_VF_OSBOOT_WATCHDOG_TIMER_TIMEOUT = "biosVfOSBootWatchdogTimerTimeout"
    BIOS_VF_ONBOARD_NIC = "biosVfOnboardNIC"
    BIOS_VF_ONBOARD_STORAGE = "biosVfOnboardStorage"
    BIOS_VF_ONBOARD_STORAGE_SWSTACK = "biosVfOnboardStorageSWStack"
    BIOS_VF_OPERATION_MODE = "biosVfOperationMode"
    BIOS_VF_OUT_OF_BAND_MGMT_PORT = "biosVfOutOfBandMgmtPort"
    BIOS_VF_PCIOPTION_ROMS = "biosVfPCIOptionROMs"
    BIOS_VF_PCISLOT_OPTION_ROMENABLE = "biosVfPCISlotOptionROMEnable"
    BIOS_VF_PCIE_RASSUPPORT = "biosVfPCIeRASSupport"
    BIOS_VF_PCIE_SSDHOT_PLUG_SUPPORT = "biosVfPCIeSSDHotPlugSupport"
    BIOS_VF_POSTERROR_PAUSE = "biosVfPOSTErrorPause"
    BIOS_VF_PSATA = "biosVfPSata"
    BIOS_VF_PSTATE_COORD_TYPE = "biosVfPStateCoordType"
    BIOS_VF_PACKAGE_CSTATE_LIMIT = "biosVfPackageCStateLimit"
    BIOS_VF_PANIC_HIGH_WATERMARK = "biosVfPanicHighWatermark"
    BIOS_VF_PARTIAL_CACHE_LINE_SPARING = "biosVfPartialCacheLineSparing"
    BIOS_VF_PARTIAL_MIRROR_MODE_CONFIG = "biosVfPartialMirrorModeConfig"
    BIOS_VF_PARTIAL_MIRROR_PERCENT = "biosVfPartialMirrorPercent"
    BIOS_VF_PARTIAL_MIRROR_VALUE1 = "biosVfPartialMirrorValue1"
    BIOS_VF_PARTIAL_MIRROR_VALUE2 = "biosVfPartialMirrorValue2"
    BIOS_VF_PARTIAL_MIRROR_VALUE3 = "biosVfPartialMirrorValue3"
    BIOS_VF_PARTIAL_MIRROR_VALUE4 = "biosVfPartialMirrorValue4"
    BIOS_VF_PATROL_SCRUB = "biosVfPatrolScrub"
    BIOS_VF_PATROL_SCRUB_DURATION = "biosVfPatrolScrubDuration"
    BIOS_VF_PCH_USB30_MODE = "biosVfPchUsb30Mode"
    BIOS_VF_PCI_ROM_CLP = "biosVfPciRomClp"
    BIOS_VF_PCIE_ARISUPPORT = "biosVfPcieARISupport"
    BIOS_VF_PCIE_PLL_SSC = "biosVfPciePllSsc"
    BIOS_VF_PCIE_SLOTS_CDN_ENABLE = "biosVfPcieSlotsCdnEnable"
    BIOS_VF_POST_PACKAGE_REPAIR = "biosVfPostPackageRepair"
    BIOS_VF_POWER_ON_PASSWORD_SUPPORT = "biosVfPowerOnPasswordSupport"
    BIOS_VF_PROCESSOR_C1_E = "biosVfProcessorC1E"
    BIOS_VF_PROCESSOR_C3_REPORT = "biosVfProcessorC3Report"
    BIOS_VF_PROCESSOR_C6_REPORT = "biosVfProcessorC6Report"
    BIOS_VF_PROCESSOR_CSTATE = "biosVfProcessorCState"
    BIOS_VF_PWR_PERF_TUNING = "biosVfPwrPerfTuning"
    BIOS_VF_QPICONFIG = "biosVfQPIConfig"
    BIOS_VF_QPI_LINK_SPEED = "biosVfQpiLinkSpeed"
    BIOS_VF_QPI_SNOOP_MODE = "biosVfQpiSnoopMode"
    BIOS_VF_RESUME_ON_ACPOWER_LOSS = "biosVfResumeOnACPowerLoss"
    BIOS_VF_SEV = "biosVfSEV"
    BIOS_VF_SHA1_PCRBANK = "biosVfSHA1PCRBank"
    BIOS_VF_SHA256_PCRBANK = "biosVfSHA256PCRBank"
    BIOS_VF_SMEE = "biosVfSMEE"
    BIOS_VF_SATA_MODE_SELECT = "biosVfSataModeSelect"
    BIOS_VF_SELECT_MEMORY_RASCONFIGURATION = "biosVfSelectMemoryRASConfiguration"
    BIOS_VF_SELECT_PPR_TYPE = "biosVfSelectPprType"
    BIOS_VF_SERIAL_PORT_AENABLE = "biosVfSerialPortAEnable"
    BIOS_VF_SGX = "biosVfSgx"
    BIOS_VF_SGX_EPOCH = "biosVfSgxEpoch"
    BIOS_VF_SGX_LE_PUB_KEY_HASH = "biosVfSgxLePubKeyHash"
    BIOS_VF_SINGLE_PCTLENABLE = "biosVfSinglePCTLEnable"
    BIOS_VF_SMT_MODE = "biosVfSmtMode"
    BIOS_VF_SNOOPY_MODE_FOR2_LM = "biosVfSnoopyModeFor2LM"
    BIOS_VF_SNOOPY_MODE_FOR_AD = "biosVfSnoopyModeForAD"
    BIOS_VF_SPARING_MODE = "biosVfSparingMode"
    BIOS_VF_SR_IOV = "biosVfSrIov"
    BIOS_VF_SUB_NUMA_CLUSTERING = "biosVfSubNumaClustering"
    BIOS_VF_SVM_MODE = "biosVfSvmMode"
    BIOS_VF_TPMCONTROL = "biosVfTPMControl"
    BIOS_VF_TPMSUPPORT = "biosVfTPMSupport"
    BIOS_VF_TSME = "biosVfTSME"
    BIOS_VF_TXTSUPPORT = "biosVfTXTSupport"
    BIOS_VF_TPM_PPI_REQUIRED = "biosVfTpmPpiRequired"
    BIOS_VF_UCSMBOOT_ORDER_RULE_CONTROL = "biosVfUCSMBootOrderRuleControl"
    BIOS_VF_UFSDISABLE = "biosVfUFSDisable"
    BIOS_VF_UPILINK_ENABLEMENT = "biosVfUPILinkEnablement"
    BIOS_VF_UPIPOWER_MANAGEMENT = "biosVfUPIPowerManagement"
    BIOS_VF_USBBOOT_CONFIG = "biosVfUSBBootConfig"
    BIOS_VF_USBEMULATION = "biosVfUSBEmulation"
    BIOS_VF_USBPORTS_CONFIG = "biosVfUSBPortsConfig"
    BIOS_VF_UMA_BASED_CLUSTERING = "biosVfUmaBasedClustering"
    BIOS_VF_USB_XHCI_SUPPORT = "biosVfUsbXhciSupport"
    BIOS_VF_VMDENABLE = "biosVfVMDEnable"
    BIOS_VF_VGA_PRIORITY = "biosVfVgaPriority"
    BIOS_VF_VIRTUAL_NUMA = "biosVfVirtualNuma"
    BIOS_VF_VOL_MEMORY_MODE = "biosVfVolMemoryMode"
    BIOS_VF_WORK_LOAD_CONFIG = "biosVfWorkLoadConfig"
    BIOS_VF_XPTPREFETCH = "biosVfXPTPrefetch"
    BIOS_VF_XPTREMOTE_PREFETCH = "biosVfXPTRemotePrefetch"
    BW_FILTER = "bwFilter"
    CERTIFICATE_MANAGEMENT = "certificateManagement"
    CLOUD_DEVICE_CONNECTOR_EP = "cloudDeviceConnectorEp"
    CLOUD_MGMT_SVC = "cloudMgmtSvc"
    COMM_HTTP = "commHttp"
    COMM_HTTPS = "commHttps"
    COMM_IPMI_LAN = "commIpmiLan"
    COMM_KVM = "commKvm"
    COMM_MAIL_ALERT = "commMailAlert"
    COMM_NTP_PROVIDER = "commNtpProvider"
    COMM_REDFISH = "commRedfish"
    COMM_SAVED_VMEDIA_MAP = "commSavedVMediaMap"
    COMM_SNMP = "commSnmp"
    COMM_SNMP_CONFIG_COMMIT = "commSnmpConfigCommit"
    COMM_SNMP_TRAP = "commSnmpTrap"
    COMM_SNMP_USER = "commSnmpUser"
    COMM_SSH = "commSsh"
    COMM_SVC_EP = "commSvcEp"
    COMM_SYSLOG = "commSyslog"
    COMM_SYSLOG_CLIENT = "commSyslogClient"
    COMM_TLS_CONFIG = "commTlsConfig"
    COMM_VMEDIA = "commVMedia"
    COMM_VMEDIA_MAP = "commVMediaMap"
    COMPUTE_BOARD = "computeBoard"
    COMPUTE_MB_POWER_STATS = "computeMbPowerStats"
    COMPUTE_RACK_UNIT = "computeRackUnit"
    COMPUTE_RACK_UNIT_MB_TEMP_STATS = "computeRackUnitMbTempStats"
    CONFIG_CONF_MO = "configConfMo"
    CONFIG_CONF_MOS = "configConfMos"
    CONFIG_CONFIG = "configConfig"
    CONFIG_MAP = "configMap"
    CONFIG_RESOLVE_CHILDREN = "configResolveChildren"
    CONFIG_RESOLVE_CLASS = "configResolveClass"
    CONFIG_RESOLVE_DN = "configResolveDn"
    CONFIG_RESOLVE_PARENT = "configResolveParent"
    CONFIG_SET = "configSet"
    CURRENT_CERTIFICATE = "currentCertificate"
    DELETE_RSYSLOG_CACERTIFICATE = "deleteRsyslogCACertificate"
    DELETE_SECURE_BOOT_CERTIFICATE = "deleteSecureBootCertificate"
    DOWNLOAD_CLIENT_CERTIFICATE = "downloadClientCertificate"
    DOWNLOAD_CLIENT_PRIVATE_KEY = "downloadClientPrivateKey"
    DOWNLOAD_LDAP_CACERTIFICATE = "downloadLdapCACertificate"
    DOWNLOAD_ROOT_CACERTIFICATE = "downloadRootCACertificate"
    ENABLE_SECURED_RSYSLOG = "enableSecuredRsyslog"
    END_POINT = "endPoint"
    END_POINT_CERTIFICATE_CHAIN = "endPointCertificateChain"
    END_POINT_ROOT_CACERTIFICATE = "endPointRootCACertificate"
    END_POINT_ROOT_CACERTIFICATE_INFO = "endPointRootCACertificateInfo"
    EQ_FILTER = "eqFilter"
    EQUIPMENT_FAN = "equipmentFan"
    EQUIPMENT_FAN_MODULE = "equipmentFanModule"
    EQUIPMENT_INDICATOR_LED = "equipmentIndicatorLed"
    EQUIPMENT_LOCATOR_LED = "equipmentLocatorLed"
    EQUIPMENT_PSU = "equipmentPsu"
    EQUIPMENT_PSU_COLD_REDUNDANCY = "equipmentPsuColdRedundancy"
    EQUIPMENT_PSU_FAN = "equipmentPsuFan"
    EQUIPMENT_RACK_ENCLOSURE = "equipmentRackEnclosure"
    EQUIPMENT_TPM = "equipmentTpm"
    ERROR = "error"
    EVENT_MANAGEMENT = "eventManagement"
    EVENT_SUBSCRIBE = "eventSubscribe"
    EVENT_UNSUBSCRIBE = "eventUnsubscribe"
    EXPORT_CLIENT_CERTIFICATE = "exportClientCertificate"
    EXPORT_CLIENT_PRIVATE_KEY = "exportClientPrivateKey"
    EXPORT_LDAP_CACERTIFICATE = "exportLdapCACertificate"
    EXPORT_ROOT_CACERTIFICATE = "exportRootCACertificate"
    FAILED_MO = "failedMo"
    FAILED_MOS = "failedMos"
    FAN_POLICY = "fanPolicy"
    FAULT_INST = "faultInst"
    FILTER_FILTER = "filterFilter"
    FIRMWARE_BOOT_DEFINITION = "firmwareBootDefinition"
    FIRMWARE_BOOT_UNIT = "firmwareBootUnit"
    FIRMWARE_RUNNING = "firmwareRunning"
    FIRMWARE_UPDATABLE = "firmwareUpdatable"
    GE_FILTER = "geFilter"
    GENERATE_CERTIFICATE_SIGNING_REQUEST = "generateCertificateSigningRequest"
    GENERATE_RANDOM_PASSWORD = "generateRandomPassword"
    GENERATED_STORAGE_CONTROLLER_KEY_ID = "generatedStorageControllerKeyId"
    GPU_INVENTORY = "gpuInventory"
    GRAPHICS_CARD = "graphicsCard"
    GT_FILTER = "gtFilter"
    HUU_CONTROLLER = "huuController"
    HUU_FIRMWARE_CATALOG = "huuFirmwareCatalog"
    HUU_FIRMWARE_CATALOG_COMPONENT = "huuFirmwareCatalogComponent"
    HUU_FIRMWARE_COMPONENT = "huuFirmwareComponent"
    HUU_FIRMWARE_RUNNING = "huuFirmwareRunning"
    HUU_FIRMWARE_UPDATE_CANCEL = "huuFirmwareUpdateCancel"
    HUU_FIRMWARE_UPDATE_STATUS = "huuFirmwareUpdateStatus"
    HUU_FIRMWARE_UPDATER = "huuFirmwareUpdater"
    HUU_UPDATE_COMPONENT_STATUS = "huuUpdateComponentStatus"
    IOD_CONTROLLER = "iodController"
    IOD_SNAPSHOT_CANCEL = "iodSnapshotCancel"
    IOD_SNAPSHOT_START = "iodSnapshotStart"
    IOD_SNAPSHOT_STATUS = "iodSnapshotStatus"
    IP_BLOCKING = "ipBlocking"
    IP_FILTERING = "ipFiltering"
    KMIP_MANAGEMENT = "kmipManagement"
    KMIP_SERVER = "kmipServer"
    KMIP_SERVER_LOGIN = "kmipServerLogin"
    LDAP_CACERTIFICATE = "ldapCACertificate"
    LDAP_CACERTIFICATE_MANAGEMENT = "ldapCACertificateManagement"
    LE_FILTER = "leFilter"
    LSBOOT_BOOT_SECURITY = "lsbootBootSecurity"
    LSBOOT_CDD = "lsbootCdd"
    LSBOOT_DEF = "lsbootDef"
    LSBOOT_DEV_PRECISION = "lsbootDevPrecision"
    LSBOOT_EFI = "lsbootEfi"
    LSBOOT_EMBEDDED_STORAGE = "lsbootEmbeddedStorage"
    LSBOOT_HDD = "lsbootHdd"
    LSBOOT_HTTP = "lsbootHttp"
    LSBOOT_ISCSI = "lsbootIscsi"
    LSBOOT_LAN = "lsbootLan"
    LSBOOT_LOCAL_STORAGE = "lsbootLocalStorage"
    LSBOOT_NVME = "lsbootNVMe"
    LSBOOT_PCH_STORAGE = "lsbootPchStorage"
    LSBOOT_PXE = "lsbootPxe"
    LSBOOT_SAN = "lsbootSan"
    LSBOOT_SD = "lsbootSd"
    LSBOOT_STORAGE = "lsbootStorage"
    LSBOOT_UEFI_SHELL = "lsbootUefiShell"
    LSBOOT_USB = "lsbootUsb"
    LSBOOT_VMEDIA = "lsbootVMedia"
    LSBOOT_VIRTUAL_MEDIA = "lsbootVirtualMedia"
    LT_FILTER = "ltFilter"
    MAIL_RECIPIENT = "mailRecipient"
    MCTP_CERTIFICATE_MANAGEMENT = "mctpCertificateManagement"
    MEMORY_ARRAY = "memoryArray"
    MEMORY_PERSISTENT_MEMORY_BACKUP = "memoryPersistentMemoryBackup"
    MEMORY_PERSISTENT_MEMORY_CONFIG_RESULT = "memoryPersistentMemoryConfigResult"
    MEMORY_PERSISTENT_MEMORY_CONFIGURATION = "memoryPersistentMemoryConfiguration"
    MEMORY_PERSISTENT_MEMORY_DIMMS = "memoryPersistentMemoryDimms"
    MEMORY_PERSISTENT_MEMORY_GOAL = "memoryPersistentMemoryGoal"
    MEMORY_PERSISTENT_MEMORY_IMPORTER = "memoryPersistentMemoryImporter"
    MEMORY_PERSISTENT_MEMORY_LOCAL_SECURITY = "memoryPersistentMemoryLocalSecurity"
    MEMORY_PERSISTENT_MEMORY_LOGICAL_CONFIGURATION = "memoryPersistentMemoryLogicalConfiguration"
    MEMORY_PERSISTENT_MEMORY_LOGICAL_NAMESPACE = "memoryPersistentMemoryLogicalNamespace"
    MEMORY_PERSISTENT_MEMORY_NAMESPACE = "memoryPersistentMemoryNamespace"
    MEMORY_PERSISTENT_MEMORY_NAMESPACE_CONFIG_RESULT = "memoryPersistentMemoryNamespaceConfigResult"
    MEMORY_PERSISTENT_MEMORY_REGION = "memoryPersistentMemoryRegion"
    MEMORY_PERSISTENT_MEMORY_SECURITY = "memoryPersistentMemorySecurity"
    MEMORY_PERSISTENT_MEMORY_UNIT = "memoryPersistentMemoryUnit"
    MEMORY_UNIT = "memoryUnit"
    MEMORY_UNIT_ENV_STATS = "memoryUnitEnvStats"
    MGMT_BACKUP = "mgmtBackup"
    MGMT_CONTROLLER = "mgmtController"
    MGMT_IF = "mgmtIf"
    MGMT_IMPORTER = "mgmtImporter"
    MGMT_INVENTORY = "mgmtInventory"
    MO_INV_KV = "moInvKv"
    MO_KV_INV_HOLDER = "moKvInvHolder"
    NE_FILTER = "neFilter"
    NETWORK_ADAPTER_ETH_IF = "networkAdapterEthIf"
    NETWORK_ADAPTER_UNIT = "networkAdapterUnit"
    NOT_FILTER = "notFilter"
    ONE_TIME_BOOT_DEVICE = "oneTimeBootDevice"
    ONE_TIME_PRECISION_BOOT_DEVICE = "oneTimePrecisionBootDevice"
    OR_FILTER = "orFilter"
    OSI_CANCEL = "osiCancel"
    OSI_CONTROLLER = "osiController"
    OSI_START = "osiStart"
    OSI_STATUS = "osiStatus"
    PAIR = "pair"
    PCI_ADAPTER_FRU_INVENTORY = "pciAdapterFruInventory"
    PCI_ADAPTER_FRU_INVENTORY_INFO = "pciAdapterFruInventoryInfo"
    PCI_EQUIP_SLOT = "pciEquipSlot"
    PCI_LINK = "pciLink"
    PCI_SWITCH = "pciSwitch"
    PID_CATALOG = "pidCatalog"
    PID_CATALOG_CPU = "pidCatalogCpu"
    PID_CATALOG_DIMM = "pidCatalogDimm"
    PID_CATALOG_HDD = "pidCatalogHdd"
    PID_CATALOG_PCIADAPTER = "pidCatalogPCIAdapter"
    PLATFORM_EVENT_FILTERS = "platformEventFilters"
    POWER_BUDGET = "powerBudget"
    POWER_MONITOR = "powerMonitor"
    PROCESSOR_ENV_STATS = "processorEnvStats"
    PROCESSOR_UNIT = "processorUnit"
    PSU_REDUNDANCY_POLICY = "psuRedundancyPolicy"
    RACK_UNIT_PERSONALITY = "rackUnitPersonality"
    SECURE_BOOT_CACERTIFICATE_INFO = "secureBootCACertificateInfo"
    SECURE_BOOT_CERTIFICATE_MANAGEMENT = "secureBootCertificateManagement"
    SECURE_LDAP = "secureLdap"
    SELF_ENCRYPT_STORAGE_CONTROLLER = "selfEncryptStorageController"
    SERVER_UTILIZATION = "serverUtilization"
    SOL_IF = "solIf"
    STANDARD_POWER_PROFILE = "standardPowerProfile"
    STORAGE_CONTROLLER = "storageController"
    STORAGE_CONTROLLER_HEALTH = "storageControllerHealth"
    STORAGE_CONTROLLER_NVME = "storageControllerNVMe"
    STORAGE_CONTROLLER_NEXT_CONSISTENCY_CHECK_SCHEDULE = "storageControllerNextConsistencyCheckSchedule"
    STORAGE_CONTROLLER_NEXT_PATROL_READ_SCHEDULE = "storageControllerNextPatrolReadSchedule"
    STORAGE_CONTROLLER_PROPS = "storageControllerProps"
    STORAGE_CONTROLLER_SETTINGS = "storageControllerSettings"
    STORAGE_FLEX_FLASH_CONTROLLER = "storageFlexFlashController"
    STORAGE_FLEX_FLASH_CONTROLLER_PROPS = "storageFlexFlashControllerProps"
    STORAGE_FLEX_FLASH_OPERATIONAL_PROFILE = "storageFlexFlashOperationalProfile"
    STORAGE_FLEX_FLASH_PHYSICAL_DRIVE = "storageFlexFlashPhysicalDrive"
    STORAGE_FLEX_FLASH_VIRTUAL_DRIVE = "storageFlexFlashVirtualDrive"
    STORAGE_FLEX_FLASH_VIRTUAL_DRIVE_IMAGE_MAP = "storageFlexFlashVirtualDriveImageMap"
    STORAGE_FLEX_MMC = "storageFlexMMC"
    STORAGE_FLEX_MMCDOWNLOAD_FILE = "storageFlexMMCDownloadFile"
    STORAGE_FLEX_MMCFILE = "storageFlexMMCFile"
    STORAGE_FLEX_UTIL_CONTROLLER = "storageFlexUtilController"
    STORAGE_FLEX_UTIL_HEALTH = "storageFlexUtilHealth"
    STORAGE_FLEX_UTIL_OPERATIONAL_PROFILE = "storageFlexUtilOperationalProfile"
    STORAGE_FLEX_UTIL_PHYSICAL_DRIVE = "storageFlexUtilPhysicalDrive"
    STORAGE_FLEX_UTIL_VIRTUAL_DRIVE = "storageFlexUtilVirtualDrive"
    STORAGE_FLEX_UTIL_VIRTUAL_DRIVE_IMAGE_MAP = "storageFlexUtilVirtualDriveImageMap"
    STORAGE_LOCAL_DISK = "storageLocalDisk"
    STORAGE_LOCAL_DISK_PROPS = "storageLocalDiskProps"
    STORAGE_LOCAL_DISK_SLOT_EP = "storageLocalDiskSlotEp"
    STORAGE_LOCAL_DISK_USAGE = "storageLocalDiskUsage"
    STORAGE_NVME_PHYSICAL_DRIVE = "storageNVMePhysicalDrive"
    STORAGE_OPERATION = "storageOperation"
    STORAGE_RAID_BATTERY = "storageRaidBattery"
    STORAGE_SAS_EXPANDER = "storageSasExpander"
    STORAGE_UNUSED_LOCAL_DISK = "storageUnusedLocalDisk"
    STORAGE_VIRTUAL_DRIVE = "storageVirtualDrive"
    STORAGE_VIRTUAL_DRIVE_CREATOR_USING_UNUSED_PHYSICAL_DRIVE = "storageVirtualDriveCreatorUsingUnusedPhysicalDrive"
    STORAGE_VIRTUAL_DRIVE_CREATOR_USING_VIRTUAL_DRIVE_GROUP = "storageVirtualDriveCreatorUsingVirtualDriveGroup"
    STORAGE_VIRTUAL_DRIVE_WITH_DRIVE_GROUP_SPACE = "storageVirtualDriveWithDriveGroupSpace"
    SUGGESTED_STORAGE_CONTROLLER_SECURITY_KEY = "suggestedStorageControllerSecurityKey"
    SYSDEBUG_MEP_LOG = "sysdebugMEpLog"
    SYSDEBUG_TECH_SUPPORT_EXPORT = "sysdebugTechSupportExport"
    SYSTEM_BOARD_UNIT = "systemBoardUnit"
    SYSTEM_IOCONTROLLER = "systemIOController"
    TOP_ROOT = "topRoot"
    TOP_SYSTEM = "topSystem"
    UPLOAD_BIOS_PROFILE = "uploadBiosProfile"
    UPLOAD_CERTIFICATE = "uploadCertificate"
    UPLOAD_END_POINT_ROOT_CACERTIFICATE = "uploadEndPointRootCACertificate"
    UPLOAD_EXTERNAL_CERTIFICATE = "uploadExternalCertificate"
    UPLOAD_EXTERNAL_PRIVATE_KEY = "uploadExternalPrivateKey"
    UPLOAD_PIDCATALOG = "uploadPIDCatalog"
    UPLOAD_RSYSLOG_CACERTIFICATE = "uploadRsyslogCACertificate"
    UPLOAD_SECURE_BOOT_CERTIFICATE = "uploadSecureBootCertificate"
    VIC_BACKUP_ALL = "vicBackupAll"
    VIC_IMPORTER_ALL = "vicImporterAll"
    WCARD_FILTER = "wcardFilter"
    X86_LIVE_DEBUG = "x86LiveDebug"
    ADAPTER_SECURE_UPDATE = "adapterSecureUpdate"
    AUTO_POWER_PROFILE = "autoPowerProfile"
    BMC_RESET_REASON = "bmcResetReason"
    CHASSIS_PIDCATALOG = "chassisPIDCatalog"
    CHASSIS_POWER_BUDGET = "chassisPowerBudget"
    CHASSIS_POWER_MONITOR = "chassisPowerMonitor"
    CHASSIS_POWER_UTILIZATION = "chassisPowerUtilization"
    COMM_EP_IPMI_LAN = "commEpIpmiLan"
    COMM_SVC_RACK = "commSvcRack"
    COMPUTE_SERVER_NODE = "computeServerNode"
    COMPUTE_SERVER_NODE_MB_TEMP_STATS = "computeServerNodeMbTempStats"
    COMPUTE_SERVER_REF = "computeServerRef"
    COMPUTE_SHARED_IOMB_POWER_STATS = "computeSharedIOMbPowerStats"
    COMPUTE_SHARED_IOMB_TEMP_STATS = "computeSharedIOMbTempStats"
    CUSTOM_POWER_PROFILE = "customPowerProfile"
    EQUIPMENT_CHASSIS = "equipmentChassis"
    EQUIPMENT_CHASSIS_LOCATOR_LED = "equipmentChassisLocatorLed"
    EQUIPMENT_SHARED_IOMODULE = "equipmentSharedIOModule"
    EQUIPMENT_SYSTEM_IOCONTROLLER = "equipmentSystemIOController"
    GRAPHICS_CARD_TEMPERATURE = "graphicsCardTemperature"
    IO_CONTROLLER_NVME_PHYSICAL_DRIVE = "ioControllerNVMePhysicalDrive"
    IO_EXPANDER = "ioExpander"
    MGMT_BACKUP_SERVER = "mgmtBackupServer"
    MGMT_IMPORTER_SERVER = "mgmtImporterServer"
    SIOC_RESET_REASON = "siocResetReason"
    STORAGE_ENCLOSURE = "storageEnclosure"
    STORAGE_ENCLOSURE_DISK = "storageEnclosureDisk"
    STORAGE_ENCLOSURE_DISK_FW_HELPER = "storageEnclosureDiskFwHelper"
    STORAGE_ENCLOSURE_DISK_SLOT_EP = "storageEnclosureDiskSlotEp"
    STORAGE_ENCLOSURE_DISK_SLOT_ZONE_HELPER = "storageEnclosureDiskSlotZoneHelper"
    STORAGE_LOCAL_DISK_EP = "storageLocalDiskEp"
    STORAGE_SAS_UPLINK = "storageSasUplink"
    SYSTEM_IOCONTROLLER_NVME = "systemIOControllerNVMe"
    THERMAL_POWER_PROFILE = "thermalPowerProfile"


class YesOrNo:
    _NO = "No"
    _YES = "Yes"
    FALSE = "false"
    NO = "no"
    TRUE = "true"
    YES = "yes"

class BootOrderEnum:
    BOOT_ORDER_ENUM_1 = "1"
    BOOT_ORDER_ENUM_2 = "2"
    BOOT_ORDER_ENUM_3 = "3"
    BOOT_ORDER_ENUM_4 = "4"
    BOOT_ORDER_ENUM_5 = "5"

class EmptyStringIPv4address:
    pass

class EmptyStringIpv4AddressOrIPv6Address:
    pass

class EmptyStringOrHostNameOrIPv4Address:
    VALUE_0_0_0_0 = "0.0.0.0"

class EmptyStringOrHostNameOrIPv4AddressOrIPv6Address:
    pass

class EnabledDisabled:
    _DISABLED = "Disabled"
    _ENABLED = "Enabled"
    DISABLED = "disabled"
    ENABLED = "enabled"

class NamingPropertyId:
    ABSOLUTE_STATE_OF_CHARGE = "absoluteStateOfCharge"
    ACCESS = "access"
    ACCESS_POLICY = "accessPolicy"
    ACCOUNT_STATUS = "accountStatus"
    ACK = "ack"
    ACTION = "action"
    ACTIVE_SESSIONS = "activeSessions"
    ACTIVE_STATUS = "activeStatus"
    ACTUAL_BOOT_MODE = "actualBootMode"
    ACTUAL_VALUE = "actualValue"
    ADAPTER = "adapter"
    ADAPTOR_SECURE_UPDATE = "adaptorSecureUpdate"
    ADD_CHALLENGE_PASSWORD = "addChallengePassword"
    ADDITIONAL_INFO = "additionalInfo"
    ADDRESS = "address"
    ADDRESSV6 = "addressv6"
    ADMIN_ACTION = "adminAction"
    ADMIN_DUPLEX = "adminDuplex"
    ADMIN_FEC_MODE = "adminFecMode"
    ADMIN_LINK_TRAINING = "adminLinkTraining"
    ADMIN_NET_SPEED = "adminNetSpeed"
    ADMIN_PERSISTENT_BINDINGS = "adminPersistentBindings"
    ADMIN_POWER = "adminPower"
    ADMIN_SPEED = "adminSpeed"
    ADMIN_STATE = "adminState"
    ADVANCED_FILTER = "advancedFilter"
    AFFECTED_DN = "affectedDN"
    AGGRESSIVE_COOLING_ENABLE = "aggressiveCoolingEnable"
    ALLOW_BACKGROUND_INIT = "allowBackgroundInit"
    ALLOW_THROTTLE = "allowThrottle"
    ALLOWED_ATTEMPTS = "allowedAttempts"
    AMBIENT_TEMP = "ambientTemp"
    ANSWER_FILE_PASSWORD = "answerFilePassword"
    ANSWER_FILE_SHARE_FILE = "answerFileShareFile"
    ANSWER_FILE_SHARE_IP = "answerFileShareIp"
    ANSWER_FILE_SHARE_PATH = "answerFileSharePath"
    ANSWER_FILE_SHARE_TYPE = "answerFileShareType"
    ANSWER_FILE_USERNAME = "answerFileUsername"
    APP_DIRECT_CAPACITY = "appDirectCapacity"
    APPLIED_FAN_POLICY = "appliedFanPolicy"
    ARCH = "arch"
    ARFS = "arfs"
    ARRAY = "array"
    ASSET_TAG = "assetTag"
    ATTRIBUTE = "attribute"
    AUTH = "auth"
    AUTH_PRECEDENCE1 = "authPrecedence1"
    AUTH_PRECEDENCE2 = "authPrecedence2"
    AUTH_PRECEDENCE3 = "authPrecedence3"
    AUTH_PWD = "authPwd"
    AUTO_DELETE_OLDEST = "autoDeleteOldest"
    AUTO_EFF_BUDGET = "autoEffBudget"
    AUTO_ENHANCED_IMPORT = "autoEnhancedImport"
    AUTO_MIN_BUDGET = "autoMinBudget"
    AUTO_NEG = "autoNeg"
    AUTO_SNAPSHOT = "autoSnapshot"
    AUTO_SYNC = "autoSync"
    AVAILABLE_MEMORY = "availableMemory"
    AVAILABLE_STORAGE_FOR_IMCIMAGES = "availableStorageForIMCImages"
    AVAILABLE_STORAGE_FOR_USER_FILES = "availableStorageForUserFiles"
    AVERAGE = "average"
    BACKEND_PORT_COUNT = "backendPortCount"
    BACKUP_ON_ACTIVATE = "backupOnActivate"
    BANK_LOCATOR = "bankLocator"
    BASEDN = "basedn"
    BATTERY_PRESENT = "batteryPresent"
    BATTERY_STATUS = "batteryStatus"
    BATTERY_TYPE = "batteryType"
    BATTERY_WARNING = "batteryWarning"
    BBU_PRESENT = "bbuPresent"
    BIND_DN = "bindDn"
    BIND_METHOD = "bindMethod"
    BINDING_CERTIFICATE = "bindingCertificate"
    BIOS_POST_STATE = "biosPostState"
    BIOS_PROFILE_UPLOAD_STATUS = "biosProfileUploadStatus"
    BLOCK_COUNT = "blockCount"
    BLOCK_SIZE = "blockSize"
    BMC1_RESET_STATUS = "bmc1ResetStatus"
    BMC2_RESET_STATUS = "bmc2ResetStatus"
    BMC_RESET_STATUS = "bmcResetStatus"
    BOOT_LOADER_DESCR = "boot-loader-descr"
    BOOT_LOADER_NAME = "boot-loader-name"
    BOOT_LOADER_PATH = "boot-loader-path"
    BOOT_BLOCK_VERSION = "bootBlockVersion"
    BOOT_DRIVE = "bootDrive"
    BOOT_DRIVE_IS_PHYSICAL_DRIVE = "bootDriveIsPhysicalDrive"
    BOOT_LUN = "bootLun"
    BOOT_MEDIUM = "bootMedium"
    BOOT_VERSION = "bootVersion"
    BUDGET = "budget"
    BUS_ID = "busId"
    CACHE_FLUSH_INTERVAL = "cacheFlushInterval"
    CACHE_MEMORY_SIZE = "cacheMemorySize"
    CACHE_POLICY = "cachePolicy"
    CAP_BUDGET = "capBudget"
    CAPACITY = "capacity"
    CARD_MODE = "cardMode"
    CARD_SLOT = "cardSlot"
    CARD_STATUS = "cardStatus"
    CARD_TYPE = "cardType"
    CARDS_MANAGEABLE = "cardsManageable"
    CAUSE = "cause"
    CC_ENABLE = "ccEnable"
    CC_SCHEDULE_MODE = "ccScheduleMode"
    CC_STATE = "ccState"
    CDN = "cdn"
    CERTIFICATE_CONTENT = "certificateContent"
    CERTIFICATE_ID = "certificateId"
    CERTIFICATE_PRESENCE = "certificatePresence"
    CHALLENGE_PASSWORD = "challengePassword"
    CHANGE_SET = "changeSet"
    CHANNEL_NUMBER = "channelNumber"
    CHARGING_STATE = "chargingState"
    CHASSIS_UTILIZATION = "chassisUtilization"
    CIMC_MANAGEMENT_ENABLED = "cimcManagementEnabled"
    CIMC_RESET_REASON = "cimcResetReason"
    CIMC_SECURE_BOOT = "cimcSecureBoot"
    CLASS_OF_SERVICE = "classOfService"
    CLIENT_CERTIFICATE = "clientCertificate"
    CLIENT_PRIVATE_KEY = "clientPrivateKey"
    CLOCK = "clock"
    CLUSTER_ENABLE = "clusterEnable"
    CMC1_IS_ACTIVE = "cmc1IsActive"
    CMC2_IS_ACTIVE = "cmc2IsActive"
    CMC_RESET_STATUS = "cmcResetStatus"
    CMC_SECURE_BOOT = "cmcSecureBoot"
    CNTRL_ID = "cntrlId"
    COALESCING_TIME = "coalescingTime"
    COALESCING_TYPE = "coalescingType"
    CODE = "code"
    COERCED_SIZE = "coercedSize"
    COLOR = "color"
    COM2_SEC = "com2Sec"
    COMMIT = "commit"
    COMMON_NAME = "commonName"
    COMMUNITY = "community"
    COMPLETED_CHARGE_CYCLES = "completedChargeCycles"
    COMPLETION_COUNT = "completionCount"
    COMPLETION_QUEUE_COUNT = "completionQueueCount"
    COMPONENT = "component"
    COMPONENT_ID = "componentId"
    COMPONENT_NAME = "componentName"
    COMPORT = "comport"
    CONFIG_CHANGE = "configChange"
    CONFIG_ERROR = "configError"
    CONFIG_RESULT = "configResult"
    CONFIG_SHARE_FILE = "configShareFile"
    CONFIG_SHARE_IP = "configShareIp"
    CONFIG_SHARE_PASSWORD = "configSharePassword"
    CONFIG_SHARE_PATH = "configSharePath"
    CONFIG_SHARE_TYPE = "configShareType"
    CONFIG_SHARE_USERNAME = "configShareUsername"
    CONFIG_STATE = "configState"
    CONFIG_STATUS = "configStatus"
    CONFIGCHANGE = "configchange"
    CONFIGURATION_PENDING = "configurationPending"
    CONFIGURATION_STATUS = "configurationStatus"
    CONFIGURED_BOOT_MODE = "configuredBootMode"
    CONFIGURED_FAN_POLICY = "configuredFanPolicy"
    CONFIGURED_MODE = "configuredMode"
    CONFIGURED_VALUE = "configuredValue"
    CONSISTENCY_CHECK_RATE = "consistencyCheckRate"
    CONSUMED_POWER = "consumedPower"
    CONTROLLER = "controller"
    CONTROLLER_CHIP_TEMP_CELSIUS = "controllerChipTempCelsius"
    CONTROLLER_NAME = "controllerName"
    CONTROLLER_REPORTED = "controllerReported"
    CONTROLLER_STATUS = "controllerStatus"
    CONTROLLER_TEMPERATURE = "controllerTemperature"
    CONTROLLER_TYPE = "controllerType"
    COPYBACK_OPERATION_STATUS = "copybackOperationStatus"
    COPYBACK_PERCENT_COMPLETE = "copybackPercentComplete"
    CORES = "cores"
    CORES_ENABLED = "coresEnabled"
    CORR_ACTION = "corrAction"
    CORR_TIME = "corrTime"
    COUNT = "count"
    COUNTRY_CODE = "countryCode"
    CPU1_PKG_ID = "cpu1PkgId"
    CPU2_PKG_ID = "cpu2PkgId"
    CPU3_PKG_ID = "cpu3PkgId"
    CPU4_PKG_ID = "cpu4PkgId"
    CPU_MODULE1 = "cpuModule1"
    CPU_MODULE2 = "cpuModule2"
    CPU_POWER_LIMIT = "cpuPowerLimit"
    CPU_SAFE_THROT_LVL = "cpuSafeThrotLvl"
    CPU_TYPE = "cpuType"
    CPU_UTILIZATION = "cpuUtilization"
    CREATED = "created"
    CREATED_VIRTUAL_DRIVE_DN = "createdVirtualDriveDn"
    CRITICAL_PHYSICAL_DRIVE_COUNT = "criticalPhysicalDriveCount"
    CSR_STATUS = "csrStatus"
    CURR_CAPACITY = "currCapacity"
    CURRENT = "current"
    CURRENT_FW_VERSION = "currentFwVersion"
    CURRENT_LROP = "currentLrop"
    CURRENT_STATUS = "currentStatus"
    CURRENT_TIME = "currentTime"
    CURRENT_WRITE_CACHE_POLICY = "currentWriteCachePolicy"
    CURRENTSPEED = "currentspeed"
    DATAWIDTH = "datawidth"
    DATE_OF_MANUFACTURE = "dateOfManufacture"
    DDNS_DOMAIN = "ddnsDomain"
    DDNS_ENABLE = "ddnsEnable"
    DDNS_REFRESH_INTERVAL = "ddnsRefreshInterval"
    DEDICATED_HOT_SPARE_FOR_VDID = "dedicatedHotSpareForVDId"
    DEFAULT_STRIP_SIZE = "defaultStripSize"
    DEGRADED_VIRTUAL_DRIVE_COUNT = "degradedVirtualDriveCount"
    DELAY = "delay"
    DELAY_TYPE = "delayType"
    DEPLOYED_SECURE_PASSPHRASE = "deployedSecurePassphrase"
    DEPLOYED_SECURITY_KEY = "deployedSecurityKey"
    DEPLOYMENT = "deployment"
    DEPTH = "depth"
    DESCR = "descr"
    DESCRIPTION = "description"
    DESIGN_CAPACITY = "designCapacity"
    DESIGN_VOLTAGE = "designVoltage"
    DESTINATION_PDID = "destinationPDId"
    DEVICE = "device"
    DEVICE_ID = "deviceId"
    DHCP_ENABLE = "dhcpEnable"
    DHCP_ISCSI = "dhcpISCSI"
    DHCP_ID = "dhcpId"
    DHCP_NETWORK_SETTINGS = "dhcpNetworkSettings"
    DHCP_TIMEOUT = "dhcpTimeout"
    DIMM_BLACK_LIST = "dimmBlackList"
    DIMM_LOCATOR_IDS = "dimmLocatorIds"
    DIRTY_PARTITION_MAP = "dirtyPartitionMap"
    DISK = "disk"
    DISK_CACHE_POLICY = "diskCachePolicy"
    DN = "dn"
    DNS_ALTERNATE = "dnsAlternate"
    DNS_DOMAIN_SOURCE = "dnsDomainSource"
    DNS_PREFERRED = "dnsPreferred"
    DNS_SEARCH_DOMAIN = "dnsSearchDomain"
    DNS_SEARCH_FOREST = "dnsSearchForest"
    DNS_USING_DHCP = "dnsUsingDhcp"
    DNSSERVER = "dnsserver"
    DO_FORCE_DOWN = "doForceDown"
    DOMAIN = "domain"
    DOWNLOAD_PROGRESS = "downloadProgress"
    DOWNLOAD_STATUS = "downloadStatus"
    DRIVE_COUNT = "driveCount"
    DRIVE_FIRMWARE = "driveFirmware"
    DRIVE_GROUP = "driveGroup"
    DRIVE_LIFE_USED = "driveLifeUsed"
    DRIVE_POWER_POLICY = "drivePowerPolicy"
    DRIVE_SCOPE = "driveScope"
    DRIVE_SERIAL_NUMBER = "driveSerialNumber"
    DRIVE_SLOT_STATUS = "driveSlotStatus"
    DRIVE_STATE = "driveState"
    DRIVE_STATUS = "driveStatus"
    DRIVE_TYPE = "driveType"
    DRIVES_ENABLED = "drivesEnabled"
    DRIVES_PER_SPAN = "drivesPerSpan"
    DUAL_ENCLOSURE_ID_ENABLE = "dualEnclosureIdEnable"
    ECC_BUCKET_LEAK_RATE = "eccBucketLeakRate"
    EFF_CPU_POWER = "effCpuPower"
    EFF_POWER = "effPower"
    ELAPSED_SECONDS = "elapsedSeconds"
    EMAIL = "email"
    EMULATED_BLOCK_SIZE = "emulatedBlockSize"
    ENABLE = "enable"
    ENABLE_COPYBACK_ON_SMART = "enableCopybackOnSmart"
    ENABLE_COPYBACK_TO_SSD_ON_SMART_ERROR = "enableCopybackToSsdOnSmartError"
    ENABLE_JBOD = "enableJbod"
    ENABLE_SSD_PATROL_READ = "enableSsdPatrolRead"
    ENABLED = "enabled"
    ENABLED_STATUS = "enabledStatus"
    ENCLOSURE_ASSOCIATION = "enclosureAssociation"
    ENCLOSURE_DEVICE_ID = "enclosureDeviceId"
    ENCLOSURE_ID = "enclosureId"
    ENCLOSURE_LOGICAL_ID = "enclosureLogicalId"
    ENCLOSURE_SASADDRESS0 = "enclosureSASAddress0"
    ENCLOSURE_SASADDRESS1 = "enclosureSASAddress1"
    ENCRYPTION = "encryption"
    ENCRYPTION_STATE = "encryptionState"
    ENDPOINT = "endpoint"
    ENGINE_ID = "engineId"
    ENGINE_ID_KEY = "engineIdKey"
    ENTITY = "entity"
    ERROR_DESCRIPTION = "errorDescription"
    ERROR_DETECT_TIMEOUT = "errorDetectTimeout"
    ESTIMATED_SECONDS_REMAINING = "estimatedSecondsRemaining"
    EVENT = "event"
    EXEC_FREQUENCY = "execFrequency"
    EXISTING_SECURITY_KEY = "existingSecurityKey"
    EXPECTED_MARGIN_OF_ERROR = "expectedMarginOfError"
    EXPORT_PROGRESS = "exportProgress"
    EXPORT_STATUS = "exportStatus"
    EXPOSE_ENCLOSURE_DEVICES = "exposeEnclosureDevices"
    EXT_ENABLED = "extEnabled"
    EXT_GW = "extGw"
    EXT_IP = "extIp"
    EXT_MASK = "extMask"
    EXTERNAL_CERTIFICATE = "externalCertificate"
    EXTERNAL_PRIVATE_KEY = "externalPrivateKey"
    FACTORY_WWPN = "factoryWWPN"
    FAIL_COUNT = "failCount"
    FAIL_WINDOW = "failWindow"
    FAILED_MEMORY = "failedMemory"
    FAILED_PHYSICAL_DRIVE_COUNT = "failedPhysicalDriveCount"
    FALLBACK_AUTHENTICATION = "fallbackAuthentication"
    FAULT_ALERT = "faultAlert"
    FCP_ERROR_RECOVERY = "fcpErrorRecovery"
    FDE_CAPABLE = "fdeCapable"
    FDE_ENABLED = "fdeEnabled"
    FILE_ID = "fileId"
    FILE_NAME = "fileName"
    FILE_SIZE = "fileSize"
    FILE_TYPE = "fileType"
    FILTER = "filter"
    FILTER1 = "filter1"
    FILTER2 = "filter2"
    FILTER3 = "filter3"
    FILTER4 = "filter4"
    FIP_MODE = "fipMode"
    FIPS_ENABLE = "fipsEnable"
    FIRMWARE_PACKAGE_BUILD = "firmwarePackageBuild"
    FIRMWARE_VERSION = "firmwareVersion"
    FLASH_PRESENT = "flashPresent"
    FORCE_CONFIG = "forceConfig"
    FOREIGN_CONFIG_PHYSICAL_DRIVE_COUNT = "foreignConfigPhysicalDriveCount"
    FOREIGN_LOCKED = "foreignLocked"
    FORM_FACTOR = "formFactor"
    FREE_CAPACITY = "freeCapacity"
    FROM_ADDRESS = "fromAddress"
    FRONT_TEMP = "frontTemp"
    FSM_DESCR = "fsmDescr"
    FSM_PROGR = "fsmProgr"
    FSM_RMT_INV_ERR_CODE = "fsmRmtInvErrCode"
    FSM_RMT_INV_ERR_DESCR = "fsmRmtInvErrDescr"
    FSM_STAGE_DESCR = "fsmStageDescr"
    FSM_STATUS = "fsmStatus"
    FULL_CAPACITY = "fullCapacity"
    FW_UPDATE_OPER_STATE = "fwUpdateOperState"
    FW_UPDATE_PROGRESS = "fwUpdateProgress"
    FW_VERSION = "fwVersion"
    GATEWAY = "gateway"
    GENERATED_KEY_ID = "generatedKeyId"
    GENEVE_OFFLOAD = "geneveOffload"
    GRACEFUL_TIMEOUT = "gracefulTimeout"
    GROUP_ATTRIBUTE = "groupAttribute"
    GROUP_AUTH = "groupAuth"
    GROUP_NESTED_SEARCH = "groupNestedSearch"
    HARD_CAP = "hardCap"
    HDD_BACKPLANE = "hddBackplane"
    HDD_MODULE1 = "hddModule1"
    HDD_MODULE2 = "hddModule2"
    HDD_MODULE3 = "hddModule3"
    HDD_MODULE4 = "hddModule4"
    HEALTH = "health"
    HEALTH_STATE = "healthState"
    HIGHEST_SEVERITY = "highestSeverity"
    HOST = "host"
    HOST_ACCESSIBLE = "hostAccessible"
    HOST_WWPN = "hostWwpn"
    HOSTNAME = "hostname"
    HOTSPARE_ACTION = "hotspareAction"
    HUU_IMAGE_VERSION = "huuImageVersion"
    ID = "id"
    IF_TYPE = "ifType"
    IGNORE_COMP_CHECK = "ignoreCompCheck"
    IGNORED_MEMORY = "ignoredMemory"
    IMAGE = "image"
    INDEX = "index"
    INITIATOR_CHAP_NAME = "initiatorChapName"
    INITIATOR_CHAP_SECRET = "initiatorChapSecret"
    INITIATOR_GATEWAY = "initiatorGateway"
    INITIATOR_IPADDRESS = "initiatorIPAddress"
    INITIATOR_NAME = "initiatorName"
    INITIATOR_PRIMARY_DNS = "initiatorPrimaryDns"
    INITIATOR_PRIORITY = "initiatorPriority"
    INITIATOR_SECONDARY_DNS = "initiatorSecondaryDns"
    INITIATOR_SUBNET_MASK = "initiatorSubnetMask"
    INITIATOR_TCPTIMEOUT = "initiatorTCPTimeout"
    INPUT = "input"
    INPUT_CURRENT = "inputCurrent"
    INPUT_VOLTAGE = "inputVoltage"
    INTERFACE_TYPE = "interfaceType"
    INTERLEAVED_SET_ID = "interleavedSetId"
    INTERNAL_STATE = "internalState"
    INTERRUPT_COUNT = "interruptCount"
    INTRUSION_SENSOR = "intrusionSensor"
    IO_READ_ERROR_THRESHOLD = "ioReadErrorThreshold"
    IO_THROTTLE_COUNT = "ioThrottleCount"
    IO_TIMEOUT_RETRY = "ioTimeoutRetry"
    IO_UTILIZATION = "ioUtilization"
    IO_WRITE_ERROR_THRESHOLD = "ioWriteErrorThreshold"
    IOD_IMAGE_VERSION = "iodImageVersion"
    IOH1_TEMP = "ioh1Temp"
    IOH2_TEMP = "ioh2Temp"
    IP_ADDRESS = "ipAddress"
    IP_CONFIG_TYPE = "ipConfigType"
    IP_HASH = "ipHash"
    IP_VER = "ipVer"
    IPADDRESS = "ipaddress"
    IPTYPE = "iptype"
    ISCSI_BOOT = "iscsiBoot"
    ISCSI_BOOT_SUPPORTED = "iscsiBootSupported"
    ISO_SHARE = "isoShare"
    ISO_SHARE_FILE = "isoShareFile"
    ISO_SHARE_IP = "isoShareIp"
    ISO_SHARE_PATH = "isoSharePath"
    ISO_SHARE_TYPE = "isoShareType"
    ISSUER_COMMON_NAME = "issuerCommonName"
    ISSUER_COUNTRY_CODE = "issuerCountryCode"
    ISSUER_LOCALITY = "issuerLocality"
    ISSUER_ORGANIZATION = "issuerOrganization"
    ISSUER_ORGANIZATIONAL_UNIT = "issuerOrganizationalUnit"
    ISSUER_STATE = "issuerState"
    KEY = "key"
    KEY_ID = "keyId"
    KEY_MANAGEMENT = "keyManagement"
    LABEL_VERSION = "labelVersion"
    LARGE_RECEIVE = "largeReceive"
    LAST_CONFIGURED_BOOT_ORDER_SOURCE = "lastConfiguredBootOrderSource"
    LAST_OPERATION_STATUS = "lastOperationStatus"
    LAST_QUERIED_TIME_STAMP = "lastQueriedTimeStamp"
    LAST_SECURITY_OPER_STATUS = "lastSecurityOperStatus"
    LAST_TRANSITION = "lastTransition"
    LC = "lc"
    LDAP_SERVER1 = "ldapServer1"
    LDAP_SERVER2 = "ldapServer2"
    LDAP_SERVER3 = "ldapServer3"
    LDAP_SERVER4 = "ldapServer4"
    LDAP_SERVER5 = "ldapServer5"
    LDAP_SERVER6 = "ldapServer6"
    LDAP_SERVER_PORT1 = "ldapServerPort1"
    LDAP_SERVER_PORT2 = "ldapServerPort2"
    LDAP_SERVER_PORT3 = "ldapServerPort3"
    LDAP_SERVER_PORT4 = "ldapServerPort4"
    LDAP_SERVER_PORT5 = "ldapServerPort5"
    LDAP_SERVER_PORT6 = "ldapServerPort6"
    LEARN_CYCLE_REQUESTED = "learnCycleRequested"
    LEARN_CYCLE_STATUS = "learnCycleStatus"
    LEARN_MODE = "learnMode"
    LED_FAULT_STATUS = "ledFaultStatus"
    LIFELEFTIN_DAYS = "lifeleftinDays"
    LINK_BUSY_RETRY_COUNT = "linkBusyRetryCount"
    LINK_DOWN_TIMEOUT = "linkDownTimeout"
    LINK_SPEED = "linkSpeed"
    LINK_STATE = "linkState"
    LINK_STATUS = "linkStatus"
    LINK_TRAINING = "linkTraining"
    LINK_WIDTH = "linkWidth"
    LINKUP_TIMEOUT = "linkupTimeout"
    LIVE_DEBUG_STATE = "liveDebugState"
    LIVE_DEBUG_TIMEOUT = "liveDebugTimeout"
    LLDP = "lldp"
    LOCAL_SEVERITY = "localSeverity"
    LOCAL_TIME = "localTime"
    LOCAL_VIDEO_STATE = "localVideoState"
    LOCALITY = "locality"
    LOCATE_DIRECTORY_USING_DNS = "locateDirectoryUsingDNS"
    LOCATION = "location"
    LOCATOR_LEDSTATUS = "locatorLEDStatus"
    LOCKED = "locked"
    LOCKOUT_PERIOD = "lockoutPeriod"
    LOW_POWER_USB = "lowPowerUsb"
    LROP_IN_PROGRESS = "lropInProgress"
    LUN = "lun"
    LUN_ID = "lunId"
    LUN_QUEUE_DEPTH = "lunQueueDepth"
    LUNS_PER_TARGET = "lunsPerTarget"
    MAC = "mac"
    MAC_ADDR = "macAddr"
    MAC_ADDRESS = "macAddress"
    MAINTAIN_PD_FAIL_HISTORY = "maintainPdFailHistory"
    MANUFACTURER = "manufacturer"
    MANUFACTURER_DATE = "manufacturerDate"
    MANUFACTURER_ID = "manufacturerId"
    MAP = "map"
    MAP_TYPE = "mapType"
    MAPPING_STATUS = "mappingStatus"
    MAX_AVAILABLE_SPACE = "maxAvailableSpace"
    MAX_CPU_POWER = "maxCpuPower"
    MAX_DATA_FIELD_SIZE = "maxDataFieldSize"
    MAX_DEVICES = "maxDevices"
    MAX_MEMORY_POWER = "maxMemoryPower"
    MAX_OUTPUT = "maxOutput"
    MAX_POWER = "maxPower"
    MAX_SESSIONS = "maxSessions"
    MAX_VIRTUAL_DRIVE_COUNT = "maxVirtualDriveCount"
    MAXIMUM = "maximum"
    MAXIMUM_OPERATING_TEMPERATURE = "maximumOperatingTemperature"
    MAXIMUM_SESSIONS = "maximumSessions"
    MEDIA_ERROR_COUNT = "mediaErrorCount"
    MEDIA_TYPE = "mediaType"
    MEM_SAFE_THROT_LVL = "memSafeThrotLvl"
    MEMORY_CAPACITY = "memoryCapacity"
    MEMORY_CONFIGURATION = "memoryConfiguration"
    MEMORY_CORRECTABLE_ERRORS = "memoryCorrectableErrors"
    MEMORY_MODE_PERCENTAGE = "memoryModePercentage"
    MEMORY_POWER_LIMIT = "memoryPowerLimit"
    MEMORY_PRESENT = "memoryPresent"
    MEMORY_RASPOSSIBLE = "memoryRASPossible"
    MEMORY_REGIONS = "memoryRegions"
    MEMORY_SIZE = "memorySize"
    MEMORY_SPEED = "memorySpeed"
    MEMORY_TYPE_DETAIL = "memoryTypeDetail"
    MEMORY_UNCORRECTABLE_ERRORS = "memoryUncorrectableErrors"
    MEMORY_UTILIZATION = "memoryUtilization"
    MFGID = "mfgid"
    MGMT_MODE = "mgmtMode"
    MID_BACK_PLANE = "midBackPlane"
    MIN_CPU_POWER = "minCpuPower"
    MIN_MEMORY_POWER = "minMemoryPower"
    MIN_POWER = "minPower"
    MIN_REQUIRED_PHYSICAL_DRIVES = "minRequiredPhysicalDrives"
    MIN_SEVERITY_LEVEL = "minSeverityLevel"
    MINIMUM = "minimum"
    MISS_RDG_TIMEOUT = "missRdgTimeout"
    MIXED6_G12_GDRIVE_SUPPORT = "mixed6G12GDriveSupport"
    MODE = "mode"
    MODEL = "model"
    MODULE = "module"
    MOUNT_OPTIONS = "mountOptions"
    MTU = "mtu"
    MULTI_QUEUE = "multiQueue"
    MULTI_QUEUE_CLASS_OF_SERVICE = "multiQueueClassOfService"
    MULTI_QUEUE_MEMORY_REGIONS = "multiQueueMemoryRegions"
    MULTI_QUEUE_PAIRS = "multiQueuePairs"
    MULTI_QUEUE_RESOURCE_GROUPS = "multiQueueResourceGroups"
    MULTI_QUEUE_ROCE_VERSION1 = "multiQueueRoceVersion1"
    MULTI_QUEUE_ROCE_VERSION2 = "multiQueueRoceVersion2"
    NAME = "name"
    NCQ_STATUS = "ncqStatus"
    NETMASK_OR_IPV6_PREFIX = "netmaskOrIPv6Prefix"
    NEW_VERSION = "newVersion"
    NEXT_EXEC_TIME = "nextExecTime"
    NEXT_LEARN_CYCLE = "nextLearnCycle"
    NIC_MODE = "nicMode"
    NIC_REDUNDANCY = "nicRedundancy"
    NO_OF_GPUS = "noOfGPUs"
    NO_OF_SUB_VNICS = "noOfSubVNICs"
    NON_COERCED_SIZE = "nonCoercedSize"
    NON_UTIL_PARTITION_NAME = "nonUtilPartitionName"
    NOTIFICATION_TYPE = "notificationType"
    NTP_ENABLE = "ntpEnable"
    NTP_SERVER1 = "ntpServer1"
    NTP_SERVER2 = "ntpServer2"
    NTP_SERVER3 = "ntpServer3"
    NTP_SERVER4 = "ntpServer4"
    NTP_SERVER_STATUS = "ntpServerStatus"
    NUM_INTF = "numIntf"
    NUM_OF_ADAPTORS = "numOfAdaptors"
    NUM_OF_COMPONENTS = "numOfComponents"
    NUM_OF_CORES = "numOfCores"
    NUM_OF_CORES_ENABLED = "numOfCoresEnabled"
    NUM_OF_CPUS = "numOfCpus"
    NUM_OF_DIMMS = "numOfDimms"
    NUM_OF_ETH_HOST_IFS = "numOfEthHostIfs"
    NUM_OF_FAILED_DIMMS = "numOfFailedDimms"
    NUM_OF_FC_HOST_IFS = "numOfFcHostIfs"
    NUM_OF_IGNORED_DIMMS = "numOfIgnoredDimms"
    NUM_OF_REGIONS = "numOfRegions"
    NUM_OF_THREADS = "numOfThreads"
    NUMBER_OF_BLOCKS = "numberOfBlocks"
    NVDATA_VERSION = "nvdataVersion"
    NVGRE = "nvgre"
    NVRAM_PRESENT = "nvramPresent"
    OCCUR = "occur"
    OEM_ID = "oemId"
    OFFLINE_VIRTUAL_DRIVE_COUNT = "offlineVirtualDriveCount"
    ONLINE = "online"
    OPER_DUPLEX = "operDuplex"
    OPER_FEC_MODE = "operFecMode"
    OPER_LINK_TRAINING = "operLinkTraining"
    OPER_MODE = "operMode"
    OPER_NET_SPEED = "operNetSpeed"
    OPER_POWER = "operPower"
    OPER_SPEED = "operSpeed"
    OPER_STATE = "operState"
    OPER_STATUS = "operStatus"
    OPERABILITY = "operability"
    OPERATING_MODE = "operatingMode"
    OPERATING_TEMPERATURE = "operatingTemperature"
    OPERATION_IN_PROGRESS = "operationInProgress"
    OPERATION_STATUS = "operationStatus"
    OPTION_ROMSTATUS = "optionROMStatus"
    ORDER = "order"
    ORGANIZATION = "organization"
    ORGANIZATIONAL_UNIT = "organizationalUnit"
    ORIG_SEVERITY = "origSeverity"
    ORIGINAL_UUID = "originalUuid"
    OSI_CANCEL_OP = "osiCancelOp"
    OSI_IMAGE_VERSION = "osiImageVersion"
    OSI_REPORT = "osiReport"
    OTHER_ERROR_COUNT = "otherErrorCount"
    OUTPUT = "output"
    OVERALL_DIMMSTATUS = "overallDIMMStatus"
    OVERALL_SPDM_STATUS = "overallSpdmStatus"
    OVERALL_STATUS = "overallStatus"
    OVERALL_UTILIZATION = "overallUtilization"
    OWNER = "owner"
    OWNERSHIP = "ownership"
    P2P_DEVICE_ID = "p2pDeviceId"
    P2P_VENDOR_ID = "p2pVendorId"
    PART_NUMBER = "partNumber"
    PART_REVISION = "partRevision"
    PARTITION_COUNT = "partitionCount"
    PARTITION_ID = "partitionId"
    PARTITION_NAME = "partitionName"
    PASSPHRASE = "passphrase"
    PASSWORD = "password"
    PASSWORD_EXPIRY_DURATION = "passwordExpiryDuration"
    PASSWORD_GRACE_PERIOD = "passwordGracePeriod"
    PASSWORD_HISTORY = "passwordHistory"
    PASSWORD_NOTIFICATION_PERIOD = "passwordNotificationPeriod"
    PASSWORD_POLICY_RULES = "passwordPolicyRules"
    PASSWORD_PROTECTED = "passwordProtected"
    PATROL_READ_RATE = "patrolReadRate"
    PCI_ADDR = "pciAddr"
    PCI_LINK = "pciLink"
    PCI_SLOT = "pciSlot"
    PD_CHIP_TEMP_CELSIUS = "pdChipTempCelsius"
    PD_STATE = "pdState"
    PD_STATUS = "pdStatus"
    PENALTY_TIME = "penaltyTime"
    PENDING_FIRMWARE_VERSION = "pendingFirmwareVersion"
    PERCENTAGE_LIFE_LEFT = "percentageLifeLeft"
    PERCENTAGE_RESERVED_CAP_CONSUMED = "percentageReservedCapConsumed"
    PERCENTAGE_TOTAL_POWER_ON_HOUR = "percentageTotalPowerOnHour"
    PERF = "perf"
    PERFORMANCE_LEVEL = "performanceLevel"
    PERIOD = "period"
    PERSISTENT_LUN_BIND = "persistentLunBind"
    PERSISTENT_MEMORY_CAPACITY = "persistentMemoryCapacity"
    PERSISTENT_MEMORY_TYPE = "persistentMemoryType"
    PHYS_DRIVE_COERCION_MODE = "physDriveCoercionMode"
    PHYSICAL_BLOCK_SIZE = "physicalBlockSize"
    PHYSICAL_DRIVE = "physicalDrive"
    PHYSICAL_DRIVE_COUNT = "physicalDriveCount"
    PHYSICAL_DRIVE_ID = "physicalDriveId"
    PHYSICAL_DRIVE_STATUS_AUTO_CONFIG_CAPABLE = "physicalDriveStatusAutoConfigCapable"
    PHYSICAL_DRIVE_STATUS_AUTO_CONFIG_MODE = "physicalDriveStatusAutoConfigMode"
    PHYSICAL_DRIVES_LIST = "physicalDrivesList"
    PHYSICAL_NIC_MODE = "physicalNicMode"
    PHYSICAL_NIC_MODE_CAPABLE = "physicalNicModeCapable"
    PID = "pid"
    PID_ACTIVATION_STATUS = "pidActivationStatus"
    PID_UPLOAD_STATUS = "pidUploadStatus"
    PLAT_SAFE_THROT_LVL = "platSafeThrotLvl"
    PLATFORM_EVENT_FILTERS = "platformEventFilters"
    PLATFORM_THERMAL = "platformThermal"
    POPULATED = "populated"
    PORT = "port"
    PORT_CHANNEL_CAPABLE = "portChannelCapable"
    PORT_CHANNEL_ENABLE = "portChannelEnable"
    PORT_DOWN_IO_RETRY_COUNT = "portDownIoRetryCount"
    PORT_DOWN_TIMEOUT = "portDownTimeout"
    PORT_ID = "portId"
    PORT_PROFILE = "portProfile"
    PORT_PROFILES_COUNT = "portProfilesCount"
    PORT_PROFILES_NAME = "portProfilesName"
    POW_CHAR_ENABLE = "powCharEnable"
    POWER = "power"
    POWER_CHAR_STATUS = "powerCharStatus"
    POWER_CYCLE_COUNT = "powerCycleCount"
    POWER_LIMIT = "powerLimit"
    POWER_LIMIT_SERVER1 = "powerLimitServer1"
    POWER_LIMIT_SERVER2 = "powerLimitServer2"
    POWER_ON_HOURS = "powerOnHours"
    POWER_STATE = "powerState"
    PR_SCHEDULE_MODE = "prScheduleMode"
    PR_STATE = "prState"
    PREBOOT_CLI_VERSION = "prebootCliVersion"
    PREDICTIVE_FAIL_POLL_INTERVAL = "predictiveFailPollInterval"
    PREDICTIVE_FAILURE_COUNT = "predictiveFailureCount"
    PRESENCE = "presence"
    PRESENT = "present"
    PREV_SEVERITY = "prevSeverity"
    PRIMARY_TARGET_BOOT_LUN = "primaryTargetBootLun"
    PRIMARY_TARGET_CHAP_NAME = "primaryTargetChapName"
    PRIMARY_TARGET_CHAP_SECRET = "primaryTargetChapSecret"
    PRIMARY_TARGET_IPADDRESS = "primaryTargetIPAddress"
    PRIMARY_TARGET_NAME = "primaryTargetName"
    PRIMARY_TARGET_PORT = "primaryTargetPort"
    PRIOR_SERVER_ID = "priorServerId"
    PRIORITY = "priority"
    PRIV = "priv"
    PRIVACY = "privacy"
    PRIVACY_PWD = "privacyPwd"
    PRODUCT_ID = "productId"
    PRODUCT_NAME = "productName"
    PRODUCT_PID = "productPID"
    PRODUCT_REVISION = "productRevision"
    PROFILE_ENABLED = "profileEnabled"
    PROFILE_TYPE = "profileType"
    PROGRESS = "progress"
    PROGRESS_PERCENT = "progressPercent"
    PROT = "prot"
    PROTO = "proto"
    PROTOCOL = "protocol"
    PTP = "ptp"
    PURPOSE = "purpose"
    PWD = "pwd"
    PXE_BOOT = "pxeBoot"
    QUEUE_PAIRS = "queuePairs"
    RAID_CHIP_TEMP_CENTIGRADE = "raidChipTempCentigrade"
    RAID_LEVEL = "raidLevel"
    RAID_PRIMARY_MEMBER = "raidPrimaryMember"
    RAID_ROLE = "raidRole"
    RAID_SECONDARY_ROLE = "raidSecondaryRole"
    RAID_SUPPORT = "raidSupport"
    RATE_LIMIT = "rateLimit"
    RAW_SIZE = "rawSize"
    RD_ERR_COUNT_SLOT1_THRESHOLD = "rdErrCountSlot1Threshold"
    RD_ERR_COUNT_SLOT2_THRESHOLD = "rdErrCountSlot2Threshold"
    RDMA_CLASS_OF_SERVICE = "rdmaClassOfService"
    READ_AHEAD_POLICY = "readAheadPolicy"
    READ_ERROR_COUNT = "readErrorCount"
    READ_ERROR_THRESHOLD = "readErrorThreshold"
    READ_POLICY = "readPolicy"
    REAPPLY = "reapply"
    REAR_BACK_PLANE_RISER1 = "rearBackPlaneRiser1"
    REAR_BACK_PLANE_RISER3 = "rearBackPlaneRiser3"
    REAR_BP_SKU_TYPE = "rearBpSkuType"
    REAR_TEMP = "rearTemp"
    REBOOT_HOST = "rebootHost"
    REBOOT_ON_ACTIVATE = "rebootOnActivate"
    REBOOT_ON_ACTIVATE_INFO = "rebootOnActivateInfo"
    REBOOT_ON_UPDATE = "rebootOnUpdate"
    REBUILD_RATE = "rebuildRate"
    RECEIVE_COUNT = "receiveCount"
    RECEIVE_QUEUE_COUNT = "receiveQueueCount"
    RECEIVE_QUEUE_RING_SIZE = "receiveQueueRingSize"
    RECEIVE_SIDE_SCALING = "receiveSideScaling"
    RECONSTRUCTION_RATE = "reconstructionRate"
    RECOVERY_STATUS = "recoveryStatus"
    REDIRECT_STATE = "redirectState"
    REDUNDANCY_POLICY = "redundancyPolicy"
    REDUNDANCY_STATUS = "redundancyStatus"
    REDUNDANT_MEMORY = "redundantMemory"
    RELATIVE_STATE_OF_CHARGE = "relativeStateOfCharge"
    REMAINING_CAPACITY = "remainingCapacity"
    REMOTE_FILE = "remoteFile"
    REMOTE_IP = "remoteIp"
    REMOTE_PATH = "remotePath"
    REMOTE_SERVER = "remoteServer"
    REMOTE_SEVERITY = "remoteSeverity"
    REMOTE_SHARE = "remoteShare"
    REMOTE_SHARE_FILE = "remoteShareFile"
    REMOTE_SHARE_IP = "remoteShareIp"
    REMOTE_SHARE_PASSWORD = "remoteSharePassword"
    REMOTE_SHARE_PATH = "remoteSharePath"
    REMOTE_SHARE_TYPE = "remoteShareType"
    REMOTE_SHARE_USERNAME = "remoteShareUsername"
    REQUESTED_WRITE_CACHE_POLICY = "requestedWriteCachePolicy"
    RESERVED_CAPACITY = "reservedCapacity"
    RESET_COMPONENTS = "resetComponents"
    RESET_ON_ACTIVATE = "resetOnActivate"
    RESIDENT_IMAGE = "residentImage"
    RESOURCE_ALLOCATION_TIMEOUT = "resourceAllocationTimeout"
    RESOURCE_GROUPS = "resourceGroups"
    RETENTION_TIME = "retentionTime"
    RETRIES = "retries"
    REVISION = "revision"
    RING_SIZE = "ringSize"
    RISER1 = "riser1"
    RISER2 = "riser2"
    RISER3 = "riser3"
    RN = "rn"
    ROCE_VERSION1 = "roceVersion1"
    ROCE_VERSION2 = "roceVersion2"
    ROLE = "role"
    RULE = "rule"
    RUNNING_FIRMWARE_VERSION = "runningFirmwareVersion"
    RUNNING_FW_VERSION = "runningFwVersion"
    RUNNING_TIME = "runningTime"
    RUNNING_VERSION = "runningVersion"
    SAN_BOOT = "sanBoot"
    SAS_ADDRESS = "sasAddress"
    SAS_ADDRESS0 = "sasAddress0"
    SAS_ADDRESS1 = "sasAddress1"
    SAS_ADDRESS2 = "sasAddress2"
    SAS_ADDRESS3 = "sasAddress3"
    SAS_ADDRESS4 = "sasAddress4"
    SAS_ADDRESS5 = "sasAddress5"
    SAS_ADDRESS6 = "sasAddress6"
    SAS_ADDRESS7 = "sasAddress7"
    SAS_EXPANDER = "sasExpander"
    SATA_NVME = "sataNVMe"
    SD_CONTROLLER = "sdController"
    SECONDARY_TARGET_BOOT_LUN = "secondaryTargetBootLun"
    SECONDARY_TARGET_CHAP_NAME = "secondaryTargetChapName"
    SECONDARY_TARGET_CHAP_SECRET = "secondaryTargetChapSecret"
    SECONDARY_TARGET_IPADDRESS = "secondaryTargetIPAddress"
    SECONDARY_TARGET_NAME = "secondaryTargetName"
    SECONDARY_TARGET_PORT = "secondaryTargetPort"
    SECURE_BOOT = "secureBoot"
    SECURE_KEY_MANAGEMENT = "secureKeyManagement"
    SECURE_PASSPHRASE = "securePassphrase"
    SECURE_UPDATE = "secureUpdate"
    SECURED = "secured"
    SECURED_ENABLED = "securedEnabled"
    SECURITY_KEY = "securityKey"
    SECURITY_LEVEL = "securityLevel"
    SECURITY_STATE = "securityState"
    SECURITY_STATUS = "securityStatus"
    SELECT_SERVER = "selectServer"
    SELF_ENCRYPT_ENABLED = "selfEncryptEnabled"
    SELF_SIGNED = "selfSigned"
    SEQUENCE_NUMBER = "sequenceNumber"
    SERIAL = "serial"
    SERIAL_DEBUGGER_PRESENT = "serialDebuggerPresent"
    SERIAL_NUMBER = "serialNumber"
    SERIALNUMBER = "serialnumber"
    SERVER1_UPLINK1_SPEED = "server1Uplink1Speed"
    SERVER1_UPLINK2_SPEED = "server1Uplink2Speed"
    SERVER1_UPLINK3_SPEED = "server1Uplink3Speed"
    SERVER1_UPLINK4_SPEED = "server1Uplink4Speed"
    SERVER1_UPLINK5_SPEED = "server1Uplink5Speed"
    SERVER1_UPLINK6_SPEED = "server1Uplink6Speed"
    SERVER1_UTILIZATION = "server1Utilization"
    SERVER2_UPLINK1_SPEED = "server2Uplink1Speed"
    SERVER2_UPLINK2_SPEED = "server2Uplink2Speed"
    SERVER2_UPLINK3_SPEED = "server2Uplink3Speed"
    SERVER2_UPLINK4_SPEED = "server2Uplink4Speed"
    SERVER2_UPLINK5_SPEED = "server2Uplink5Speed"
    SERVER2_UPLINK6_SPEED = "server2Uplink6Speed"
    SERVER2_UTILIZATION = "server2Utilization"
    SERVER_ID = "serverId"
    SERVER_ROOT_CACERTIFICATE = "serverRootCACertificate"
    SERVER_SIOCCONNECTIVITY = "serverSIOCConnectivity"
    SESSION_TIMEOUT = "sessionTimeout"
    SEVERITY = "severity"
    SHARED_VIRTUAL_DRIVE_ID = "sharedVirtualDriveId"
    SHUTDOWN_TEMPERATURE = "shutdownTemperature"
    SIGNATURE = "signature"
    SIGNATURE_ALGORITHM = "signatureAlgorithm"
    SINGLE_IPENABLE = "singleIPEnable"
    SIOC_RESET_STATUS = "siocResetStatus"
    SIZE = "size"
    SKIP_MEMORY_TEST = "skipMemoryTest"
    SLOT = "slot"
    SLOT_ID = "slotId"
    SLOT_NAME = "slotName"
    SLOT_NUMBER = "slotNumber"
    SLOT_STATUS = "slotStatus"
    SMART_USB_ACCESS = "smartUsbAccess"
    SMART_USB_STATUS = "smartUsbStatus"
    SMBIOS_ID = "smbiosId"
    SNAPSHOT_CANCEL_OP = "snapshotCancelOp"
    SNAPSHOT_REPORT = "snapshotReport"
    SNMP_CONFIG_IN_PROGRESS = "snmpConfigInProgress"
    SNMPCONFIGINPROGRESS = "snmpconfiginprogress"
    SNMPV2_ENABLE = "snmpv2Enable"
    SNMPV3_ENABLE = "snmpv3Enable"
    SOCKET_DESIGNATION = "socketDesignation"
    SOCKET_ID = "socketId"
    SOCKET_LOCAL_DIMM_NUMBER = "socketLocalDimmNumber"
    SOCKET_LOCAL_DIMM_NUMBERS = "socketLocalDimmNumbers"
    SOCKETDESIGNATION = "socketdesignation"
    SOURCE = "source"
    SPAN = "span"
    SPAN_DEPTH = "spanDepth"
    SPDM_STATUS = "spdmStatus"
    SPEED = "speed"
    SPIN_DOWN_UNCONFIGURED = "spinDownUnconfigured"
    SPINUP_DELAY = "spinupDelay"
    SPINUP_DRIVE_COUNT = "spinupDriveCount"
    SSH_KEY = "sshKey"
    STALE_PARTITION_MAP = "stalePartitionMap"
    START_TIME = "startTime"
    STARTING_BLOCK = "startingBlock"
    STARTING_PORT = "startingPort"
    STARTUP_FW_VERSION = "startupFwVersion"
    STATE = "state"
    STATUS = "status"
    STEPPING = "stepping"
    STOP_ON_ERROR = "stopOnError"
    STORAGE_RESET_STATUS = "storageResetStatus"
    STRING_MASK = "stringMask"
    STRIP_SIZE = "stripSize"
    SUB_DEVICE_ID = "subDeviceId"
    SUB_VENDOR_ID = "subVendorId"
    SUBDEVICE = "subdevice"
    SUBJECT = "subject"
    SUBJECT_ALT_NAME_TYPE1 = "subjectAltNameType1"
    SUBJECT_ALT_NAME_TYPE10 = "subjectAltNameType10"
    SUBJECT_ALT_NAME_TYPE2 = "subjectAltNameType2"
    SUBJECT_ALT_NAME_TYPE3 = "subjectAltNameType3"
    SUBJECT_ALT_NAME_TYPE4 = "subjectAltNameType4"
    SUBJECT_ALT_NAME_TYPE5 = "subjectAltNameType5"
    SUBJECT_ALT_NAME_TYPE6 = "subjectAltNameType6"
    SUBJECT_ALT_NAME_TYPE7 = "subjectAltNameType7"
    SUBJECT_ALT_NAME_TYPE8 = "subjectAltNameType8"
    SUBJECT_ALT_NAME_TYPE9 = "subjectAltNameType9"
    SUBJECT_ALT_NAME_VALUE1 = "subjectAltNameValue1"
    SUBJECT_ALT_NAME_VALUE10 = "subjectAltNameValue10"
    SUBJECT_ALT_NAME_VALUE2 = "subjectAltNameValue2"
    SUBJECT_ALT_NAME_VALUE3 = "subjectAltNameValue3"
    SUBJECT_ALT_NAME_VALUE4 = "subjectAltNameValue4"
    SUBJECT_ALT_NAME_VALUE5 = "subjectAltNameValue5"
    SUBJECT_ALT_NAME_VALUE6 = "subjectAltNameValue6"
    SUBJECT_ALT_NAME_VALUE7 = "subjectAltNameValue7"
    SUBJECT_ALT_NAME_VALUE8 = "subjectAltNameValue8"
    SUBJECT_ALT_NAME_VALUE9 = "subjectAltNameValue9"
    SUBTYPE = "subtype"
    SUBVENDOR = "subvendor"
    SUGGESTED_SECURITY_KEY = "suggestedSecurityKey"
    SUPPORTED = "supported"
    SUPPORTED_STRIP_SIZES = "supportedStripSizes"
    SUPPORTS_RAID0 = "supportsRaid0"
    SUPPORTS_RAID00 = "supportsRaid00"
    SUPPORTS_RAID1 = "supportsRaid1"
    SUPPORTS_RAID10 = "supportsRaid10"
    SUPPORTS_RAID10_WITH_MORE_THAN2_DRIVES = "supportsRaid10WithMoreThan2Drives"
    SUPPORTS_RAID1_WITH_MORE_THAN2_DRIVES = "supportsRaid1WithMoreThan2Drives"
    SUPPORTS_RAID1E = "supportsRaid1e"
    SUPPORTS_RAID1E0RLQ0 = "supportsRaid1e0rlq0"
    SUPPORTS_RAID1ERLQ0 = "supportsRaid1erlq0"
    SUPPORTS_RAID5 = "supportsRaid5"
    SUPPORTS_RAID50 = "supportsRaid50"
    SUPPORTS_RAID6 = "supportsRaid6"
    SUPPORTS_RAID60 = "supportsRaid60"
    SUPPORTS_RAIDSRL03 = "supportsRaidsrl03"
    SUSPEND_PERIOD = "suspendPeriod"
    SWITCH_STATUS = "switchStatus"
    SYNC_MODE = "syncMode"
    SYS_CONTACT = "sysContact"
    SYS_LOCATION = "sysLocation"
    SYS_PRODUCT_ID = "sysProductID"
    SYS_PRODUCT_NAME = "sysProductName"
    SYS_SERIAL_NUM = "sysSerialNum"
    TAGS = "tags"
    TARGET_ID = "targetId"
    TARGET_WWPN = "targetWwpn"
    TCP_HASH = "tcpHash"
    TCP_RX_CHECKSUM = "tcpRxChecksum"
    TCP_SEGMENT = "tcpSegment"
    TCP_TX_CHECKSUM = "tcpTxChecksum"
    TEMPERATURE = "temperature"
    TEMPERATURE_HIGH = "temperatureHigh"
    TEST_CONNCTION_STATUS = "testConnctionStatus"
    TEST_MAIL_STATUS = "testMailStatus"
    THERMAL = "thermal"
    THERMAL_POW_LIMIT = "thermalPowLimit"
    THREADS = "threads"
    THROTTLE_START_TEMPERATURE = "throttleStartTemperature"
    TIME_COLLECTED = "timeCollected"
    TIME_OF_LAST_REFRESH = "timeOfLastRefresh"
    TIME_OUT = "timeOut"
    TIME_ZONE = "timeZone"
    TIMEOUT = "timeout"
    TLS_CONFIG_SUPPORTED = "tlsConfigSupported"
    TLSV2_CIPHER_LIST = "tlsv2CipherList"
    TLSV2_CIPHER_MODE = "tlsv2CipherMode"
    TLSV2_CIPHER_STATUS = "tlsv2CipherStatus"
    TLSV2_ENABLED = "tlsv2Enabled"
    TLSV3_CIPHER_SUITE = "tlsv3CipherSuite"
    TOTAL_CAPACITY = "totalCapacity"
    TOTAL_MEMORY = "totalMemory"
    TOTAL_SESSIONS = "totalSessions"
    TOTAL_STORAGE_FOR_IMCIMAGES = "totalStorageForIMCImages"
    TOTAL_STORAGE_FOR_USER_FILES = "totalStorageForUserFiles"
    TPM_REVISION = "tpmRevision"
    TRANSMIT_COUNT = "transmitCount"
    TRANSMIT_QUEUE_COUNT = "transmitQueueCount"
    TRANSMIT_QUEUE_RING_SIZE = "transmitQueueRingSize"
    TRANSPORT = "transport"
    TRAP_COMMUNITY = "trapCommunity"
    TRAP_COMMUNITY_STRING = "trapCommunityString"
    TRAY = "tray"
    TRUSTED_CLASS_OF_SERVICE = "trustedClassOfService"
    TTY_LOG_STATUS = "ttyLogStatus"
    TYPE = "type"
    TYPE_PLUS_SLOT_ID = "typePlusSlotId"
    UCS_PRODUCT_ID = "ucsProductId"
    UI = "ui"
    UID = "uid"
    UPDATE_COMPONENT = "updateComponent"
    UPDATE_END_TIME = "updateEndTime"
    UPDATE_START_TIME = "updateStartTime"
    UPDATE_STATUS = "updateStatus"
    UPDATE_TIME = "updateTime"
    UPDATE_TYPE = "updateType"
    UPLINK_FAILBACK_TIMEOUT = "uplinkFailbackTimeout"
    UPLINK_FAILOVER = "uplinkFailover"
    UPLINK_PORT = "uplinkPort"
    UPLOAD_PROGRESS = "uploadProgress"
    UPLOAD_STATUS = "uploadStatus"
    URI = "uri"
    USB_PATH = "usbPath"
    USED_PHYSICAL_DRIVE_IDS = "usedPhysicalDriveIds"
    USER = "user"
    USER_DISABLE_ON_LOCKOUT = "userDisableOnLockout"
    USER_MODE = "userMode"
    USER_PASSWORD_POLICY = "userPasswordPolicy"
    USER_SEARCH_PRECEDENCE = "userSearchPrecedence"
    USER_UPLOADABLE = "userUploadable"
    USERNAME = "username"
    USNIC_COUNT = "usnicCount"
    USNIC_SUPPORTED = "usnicSupported"
    USR_LBL = "usrLbl"
    UUID = "uuid"
    VALID_CERTIFICATE = "validCertificate"
    VALID_FROM = "validFrom"
    VALID_TO = "validTo"
    VALUE = "value"
    VD_STATUS = "vdStatus"
    VENDOR = "vendor"
    VENDOR_ID = "vendorId"
    VERIFY_STATUS = "verifyStatus"
    VERIFY_UPDATE = "verifyUpdate"
    VERSION = "version"
    VHBA_TYPE = "vhbaType"
    VIC_RESET_STATUS = "vicResetStatus"
    VIC_SLOT = "vicSlot"
    VIRTUAL_DRIVE = "virtualDrive"
    VIRTUAL_DRIVE_COUNT = "virtualDriveCount"
    VIRTUAL_DRIVE_NAME = "virtualDriveName"
    VIRTUAL_DRIVES_ENABLED = "virtualDrivesEnabled"
    VISIBILITY = "visibility"
    VLAN = "vlan"
    VLAN_ENABLE = "vlanEnable"
    VLAN_ID = "vlanId"
    VLAN_MODE = "vlanMode"
    VLAN_PRIORITY = "vlanPriority"
    VMQ = "vmq"
    VNTAG_MODE = "vntagMode"
    VOLTAGE = "voltage"
    VOLUME_NAME = "volumeName"
    VP_ACSCONTROL_GPU1_STATE = "vpACSControlGPU1State"
    VP_ACSCONTROL_GPU2_STATE = "vpACSControlGPU2State"
    VP_ACSCONTROL_GPU3_STATE = "vpACSControlGPU3State"
    VP_ACSCONTROL_GPU4_STATE = "vpACSControlGPU4State"
    VP_ACSCONTROL_GPU5_STATE = "vpACSControlGPU5State"
    VP_ACSCONTROL_GPU6_STATE = "vpACSControlGPU6State"
    VP_ACSCONTROL_GPU7_STATE = "vpACSControlGPU7State"
    VP_ACSCONTROL_GPU8_STATE = "vpACSControlGPU8State"
    VP_ACSCONTROL_SLOT11_STATE = "vpACSControlSlot11State"
    VP_ACSCONTROL_SLOT12_STATE = "vpACSControlSlot12State"
    VP_ACSCONTROL_SLOT13_STATE = "vpACSControlSlot13State"
    VP_ACSCONTROL_SLOT14_STATE = "vpACSControlSlot14State"
    VP_ASPMSUPPORT = "vpASPMSupport"
    VP_ADJACENT_CACHE_LINE_PREFETCH = "vpAdjacentCacheLinePrefetch"
    VP_ADVANCED_MEM_TEST = "vpAdvancedMemTest"
    VP_ALL_USB_DEVICES = "vpAllUsbDevices"
    VP_ALTITUDE = "vpAltitude"
    VP_ASSERT_NMION_PERR = "vpAssertNMIOnPERR"
    VP_ASSERT_NMION_SERR = "vpAssertNMIOnSERR"
    VP_AUTO_CCSTATE = "vpAutoCCState"
    VP_AUTONUMOUS_CSTATE_ENABLE = "vpAutonumousCstateEnable"
    VP_BAUD_RATE = "vpBaudRate"
    VP_BME_DMA_MITIGATION = "vpBmeDmaMitigation"
    VP_BOOT_OPTION_NUM_RETRY = "vpBootOptionNumRetry"
    VP_BOOT_OPTION_RE_COOL_DOWN = "vpBootOptionReCoolDown"
    VP_BOOT_OPTION_RETRY = "vpBootOptionRetry"
    VP_BOOT_PERFORMANCE_MODE = "vpBootPerformanceMode"
    VP_BURST_AND_POSTPONED_REFRESH = "vpBurstAndPostponedRefresh"
    VP_C1_AUTO_DEMOTION = "vpC1AutoDemotion"
    VP_C1_AUTO_UN_DEMOTION = "vpC1AutoUnDemotion"
    VP_CDNENABLE = "vpCDNEnable"
    VP_CDNSUPPORT = "vpCDNSupport"
    VP_CPUENERGY_PERFORMANCE = "vpCPUEnergyPerformance"
    VP_CPUFREQUENCY_FLOOR = "vpCPUFrequencyFloor"
    VP_CPUPERFORMANCE = "vpCPUPerformance"
    VP_CPUPOWER_MANAGEMENT = "vpCPUPowerManagement"
    VP_CRQOS = "vpCRQos"
    VP_CBS_CMN_APBDIS = "vpCbsCmnApbdis"
    VP_CBS_CMN_CPU_CPB = "vpCbsCmnCpuCpb"
    VP_CBS_CMN_CPU_GEN_DOWNCORE_CTRL = "vpCbsCmnCpuGenDowncoreCtrl"
    VP_CBS_CMN_CPU_GLOBAL_CSTATE_CTRL = "vpCbsCmnCpuGlobalCstateCtrl"
    VP_CBS_CMN_CPU_L1_STREAM_HW_PREFETCHER = "vpCbsCmnCpuL1StreamHwPrefetcher"
    VP_CBS_CMN_CPU_L2_STREAM_HW_PREFETCHER = "vpCbsCmnCpuL2StreamHwPrefetcher"
    VP_CBS_CMN_CPU_SMEE = "vpCbsCmnCpuSmee"
    VP_CBS_CMN_CPU_STREAMING_STORES_CTRL = "vpCbsCmnCpuStreamingStoresCtrl"
    VP_CBS_CMN_DETERMINISM_SLIDER = "vpCbsCmnDeterminismSlider"
    VP_CBS_CMN_EFFICIENCY_MODE_EN = "vpCbsCmnEfficiencyModeEn"
    VP_CBS_CMN_FIXED_SOC_PSTATE = "vpCbsCmnFixedSocPstate"
    VP_CBS_CMN_GNB_NB_IOMMU = "vpCbsCmnGnbNbIOMMU"
    VP_CBS_CMN_GNB_SMUCPPC = "vpCbsCmnGnbSMUCPPC"
    VP_CBS_CMN_GNB_SMUDF_CSTATES = "vpCbsCmnGnbSMUDfCstates"
    VP_CBS_CMN_MEM_CTRL_BANK_GROUP_SWAP_DDR4 = "vpCbsCmnMemCtrlBankGroupSwapDdr4"
    VP_CBS_CMN_MEM_MAP_BANK_INTERLEAVE_DDR4 = "vpCbsCmnMemMapBankInterleaveDdr4"
    VP_CBS_CMNC_TDPCTL = "vpCbsCmncTDPCtl"
    VP_CBS_CPU_CCD_CTRL_SSP = "vpCbsCpuCcdCtrlSsp"
    VP_CBS_CPU_CORE_CTRL = "vpCbsCpuCoreCtrl"
    VP_CBS_CPU_SMT_CTRL = "vpCbsCpuSmtCtrl"
    VP_CBS_DBG_CPU_SNP_MEM_COVER = "vpCbsDbgCpuSnpMemCover"
    VP_CBS_DBG_CPU_SNP_MEM_SIZE_COVER = "vpCbsDbgCpuSnpMemSizeCover"
    VP_CBS_DF_CMN_ACPI_SRAT_L3_NUMA = "vpCbsDfCmnAcpiSratL3Numa"
    VP_CBS_DF_CMN_DRAM_NPS = "vpCbsDfCmnDramNps"
    VP_CBS_DF_CMN_MEM_INTLV = "vpCbsDfCmnMemIntlv"
    VP_CBS_DF_CMN_MEM_INTLV_SIZE = "vpCbsDfCmnMemIntlvSize"
    VP_CBS_SEV_SNP_SUPPORT = "vpCbsSevSnpSupport"
    VP_CHANNEL_INTER_LEAVE = "vpChannelInterLeave"
    VP_CISCO_ADAPTIVE_MEM_TRAINING = "vpCiscoAdaptiveMemTraining"
    VP_CISCO_DEBUG_LEVEL = "vpCiscoDebugLevel"
    VP_CISCO_OPROM_LAUNCH_OPTIMIZATION = "vpCiscoOpromLaunchOptimization"
    VP_CISCO_XGMI_MAX_SPEED = "vpCiscoXgmiMaxSpeed"
    VP_CKE_LOW_POLICY = "vpCkeLowPolicy"
    VP_CLOSED_LOOP_THERM_THROTL = "vpClosedLoopThermThrotl"
    VP_CMCI_ENABLE = "vpCmciEnable"
    VP_CONFIG_TDP = "vpConfigTDP"
    VP_CONFIG_TDPLEVEL = "vpConfigTDPLevel"
    VP_CONSOLE_REDIRECTION = "vpConsoleRedirection"
    VP_CORE_MULTI_PROCESSING = "vpCoreMultiProcessing"
    VP_CPU_PA_LIMIT = "vpCpuPaLimit"
    VP_CPU_PERF_ENHANCEMENT = "vpCpuPerfEnhancement"
    VP_CRFASTGO_CONFIG = "vpCrfastgoConfig"
    VP_DCPMMFIRMWARE_DOWNGRADE = "vpDCPMMFirmwareDowngrade"
    VP_DRAMCLOCK_THROTTLING = "vpDRAMClockThrottling"
    VP_DEMAND_SCRUB = "vpDemandScrub"
    VP_DIRECT_CACHE_ACCESS = "vpDirectCacheAccess"
    VP_DRAM_REFRESH_RATE = "vpDramRefreshRate"
    VP_DRAM_SW_THERMAL_THROTTLING = "vpDramSwThermalThrottling"
    VP_EPPENABLE = "vpEPPEnable"
    VP_EPPPROFILE = "vpEPPProfile"
    VP_EADR_SUPPORT = "vpEadrSupport"
    VP_EDPC_EN = "vpEdpcEn"
    VP_ENABLE_CLOCK_SPREAD_SPEC = "vpEnableClockSpreadSpec"
    VP_ENABLE_MKTME = "vpEnableMktme"
    VP_ENABLE_SGX = "vpEnableSgx"
    VP_ENABLE_TME = "vpEnableTme"
    VP_ENERGY_EFFICIENT_TURBO = "vpEnergyEfficientTurbo"
    VP_ENG_PERF_TUNING = "vpEngPerfTuning"
    VP_ENHANCED_INTEL_SPEED_STEP_TECH = "vpEnhancedIntelSpeedStepTech"
    VP_EPOCH_UPDATE = "vpEpochUpdate"
    VP_EXECUTE_DISABLE_BIT = "vpExecuteDisableBit"
    VP_EXTENDED_APIC = "vpExtendedAPIC"
    VP_FRB2_ENABLE = "vpFRB2Enable"
    VP_FLOW_CONTROL = "vpFlowControl"
    VP_HWPMENABLE = "vpHWPMEnable"
    VP_HARDWARE_PREFETCH = "vpHardwarePrefetch"
    VP_IMCINTERLEAVE = "vpIMCInterleave"
    VP_IOESLOT1_STATE = "vpIOESlot1State"
    VP_IOESLOT2_STATE = "vpIOESlot2State"
    VP_IOHRESOURCE = "vpIOHResource"
    VP_IPPREFETCH = "vpIPPrefetch"
    VP_IPV4_HTTP = "vpIPV4HTTP"
    VP_IPV4_PXE = "vpIPV4PXE"
    VP_IPV6_HTTP = "vpIPV6HTTP"
    VP_IPV6_PXE = "vpIPV6PXE"
    VP_INTEL_DYNAMIC_SPEED_SELECT = "vpIntelDynamicSpeedSelect"
    VP_INTEL_HYPER_THREADING_TECH = "vpIntelHyperThreadingTech"
    VP_INTEL_SPEED_SELECT = "vpIntelSpeedSelect"
    VP_INTEL_TURBO_BOOST_TECH = "vpIntelTurboBoostTech"
    VP_INTEL_VTDATSSUPPORT = "vpIntelVTDATSSupport"
    VP_INTEL_VTDCOHERENCY_SUPPORT = "vpIntelVTDCoherencySupport"
    VP_INTEL_VTDINTERRUPT_REMAPPING = "vpIntelVTDInterruptRemapping"
    VP_INTEL_VTDPASS_THROUGH_DMASUPPORT = "vpIntelVTDPassThroughDMASupport"
    VP_INTEL_VTFOR_DIRECTED_IO = "vpIntelVTForDirectedIO"
    VP_INTEL_VIRTUALIZATION_TECHNOLOGY = "vpIntelVirtualizationTechnology"
    VP_IOH_ERROR_ENABLE = "vpIohErrorEnable"
    VP_KTIPREFETCH = "vpKTIPrefetch"
    VP_LLCALLOC = "vpLLCAlloc"
    VP_LLCPREFETCH = "vpLLCPrefetch"
    VP_LOMPORT0_STATE = "vpLOMPort0State"
    VP_LOMPORT1_STATE = "vpLOMPort1State"
    VP_LOMPORT2_STATE = "vpLOMPort2State"
    VP_LOMPORT3_STATE = "vpLOMPort3State"
    VP_LOMPORTS_ALL_STATE = "vpLOMPortsAllState"
    VP_LEGACY_OSREDIRECTION = "vpLegacyOSRedirection"
    VP_LEGACY_USBSUPPORT = "vpLegacyUSBSupport"
    VP_LV_DDRMODE = "vpLvDDRMode"
    VP_MMCFGBASE = "vpMMCFGBase"
    VP_MAKE_DEVICE_NON_BOOTABLE = "vpMakeDeviceNonBootable"
    VP_MEMORY_BANDWIDTH_BOOST = "vpMemoryBandwidthBoost"
    VP_MEMORY_INTER_LEAVE = "vpMemoryInterLeave"
    VP_MEMORY_MAPPED_IOABOVE4_GB = "vpMemoryMappedIOAbove4GB"
    VP_MEMORY_REFRESH_RATE = "vpMemoryRefreshRate"
    VP_MEMORY_SIZE_LIMIT = "vpMemorySizeLimit"
    VP_MEMORY_THERMAL_THROTTLING = "vpMemoryThermalThrottling"
    VP_MIRRORING_MODE = "vpMirroringMode"
    VP_NUMAOPTIMIZED = "vpNUMAOptimized"
    VP_NETWORK_STACK = "vpNetworkStack"
    VP_NVMDIMM_PERFORM_CONFIG = "vpNvmdimmPerformConfig"
    VP_OSBOOT_WATCHDOG_TIMER = "vpOSBootWatchdogTimer"
    VP_OSBOOT_WATCHDOG_TIMER_POLICY = "vpOSBootWatchdogTimerPolicy"
    VP_OSBOOT_WATCHDOG_TIMER_TIMEOUT = "vpOSBootWatchdogTimerTimeout"
    VP_ONBOARD10_GBIT_LOM = "vpOnboard10GbitLOM"
    VP_ONBOARD_GBIT_LOM = "vpOnboardGbitLOM"
    VP_ONBOARD_SCUSTORAGE_SWSTACK = "vpOnboardSCUStorageSWStack"
    VP_ONBOARD_SCUSTORAGE_SUPPORT = "vpOnboardSCUStorageSupport"
    VP_OPERATION_MODE = "vpOperationMode"
    VP_OUT_OF_BAND_MGMT_PORT = "vpOutOfBandMgmtPort"
    VP_PCIOPTION_ROMS = "vpPCIOptionROMs"
    VP_PCIE_RASSUPPORT = "vpPCIeRASSupport"
    VP_PCIE_SSDHOT_PLUG_SUPPORT = "vpPCIeSSDHotPlugSupport"
    VP_POPSUPPORT = "vpPOPSupport"
    VP_POSTERROR_PAUSE = "vpPOSTErrorPause"
    VP_PSATA = "vpPSata"
    VP_PSTATE_COORD_TYPE = "vpPStateCoordType"
    VP_PACKAGE_CSTATE_LIMIT = "vpPackageCStateLimit"
    VP_PANIC_HIGH_WATERMARK = "vpPanicHighWatermark"
    VP_PARTIAL_CACHE_LINE_SPARING = "vpPartialCacheLineSparing"
    VP_PARTIAL_MIRROR_MODE_CONFIG = "vpPartialMirrorModeConfig"
    VP_PARTIAL_MIRROR_PERCENT = "vpPartialMirrorPercent"
    VP_PARTIAL_MIRROR_VALUE1 = "vpPartialMirrorValue1"
    VP_PARTIAL_MIRROR_VALUE2 = "vpPartialMirrorValue2"
    VP_PARTIAL_MIRROR_VALUE3 = "vpPartialMirrorValue3"
    VP_PARTIAL_MIRROR_VALUE4 = "vpPartialMirrorValue4"
    VP_PATROL_SCRUB = "vpPatrolScrub"
    VP_PATROL_SCRUB_DURATION = "vpPatrolScrubDuration"
    VP_PCH_USB30_MODE = "vpPchUsb30Mode"
    VP_PCI_ROM_CLP = "vpPciRomClp"
    VP_PCIE_ARISUPPORT = "vpPcieARISupport"
    VP_PCIE_PLL_SSC = "vpPciePllSsc"
    VP_PCIE_SLOT_MRAID1_LINK_SPEED = "vpPcieSlotMRAID1LinkSpeed"
    VP_PCIE_SLOT_MRAID1_OPTION_ROM = "vpPcieSlotMRAID1OptionROM"
    VP_PCIE_SLOT_MRAID2_LINK_SPEED = "vpPcieSlotMRAID2LinkSpeed"
    VP_PCIE_SLOT_MRAID2_OPTION_ROM = "vpPcieSlotMRAID2OptionROM"
    VP_PCIE_SLOT_MSTORRAIDLINK_SPEED = "vpPcieSlotMSTORRAIDLinkSpeed"
    VP_PCIE_SLOT_MSTORRAIDOPTION_ROM = "vpPcieSlotMSTORRAIDOptionROM"
    VP_PCIE_SLOT_NVME1_LINK_SPEED = "vpPcieSlotNvme1LinkSpeed"
    VP_PCIE_SLOT_NVME1_OPTION_ROM = "vpPcieSlotNvme1OptionROM"
    VP_PCIE_SLOT_NVME2_LINK_SPEED = "vpPcieSlotNvme2LinkSpeed"
    VP_PCIE_SLOT_NVME2_OPTION_ROM = "vpPcieSlotNvme2OptionROM"
    VP_PCIE_SLOT_NVME3_LINK_SPEED = "vpPcieSlotNvme3LinkSpeed"
    VP_PCIE_SLOT_NVME3_OPTION_ROM = "vpPcieSlotNvme3OptionROM"
    VP_PCIE_SLOT_NVME4_LINK_SPEED = "vpPcieSlotNvme4LinkSpeed"
    VP_PCIE_SLOT_NVME4_OPTION_ROM = "vpPcieSlotNvme4OptionROM"
    VP_PCIE_SLOT_NVME5_LINK_SPEED = "vpPcieSlotNvme5LinkSpeed"
    VP_PCIE_SLOT_NVME5_OPTION_ROM = "vpPcieSlotNvme5OptionROM"
    VP_PCIE_SLOT_NVME6_LINK_SPEED = "vpPcieSlotNvme6LinkSpeed"
    VP_PCIE_SLOT_NVME6_OPTION_ROM = "vpPcieSlotNvme6OptionROM"
    VP_PCIE_SLOTS_CDN_ENABLE = "vpPcieSlotsCdnEnable"
    VP_POST_PACKAGE_REPAIR = "vpPostPackageRepair"
    VP_PROCESSOR_C1_E = "vpProcessorC1E"
    VP_PROCESSOR_C3_REPORT = "vpProcessorC3Report"
    VP_PROCESSOR_C6_REPORT = "vpProcessorC6Report"
    VP_PROCESSOR_CSTATE = "vpProcessorCState"
    VP_PUTTY_KEY_PAD = "vpPuttyKeyPad"
    VP_PWR_PERF_TUNING = "vpPwrPerfTuning"
    VP_QPILINK_FREQUENCY = "vpQPILinkFrequency"
    VP_QPI_LINK_SPEED = "vpQpiLinkSpeed"
    VP_QPI_SNOOP_MODE = "vpQpiSnoopMode"
    VP_RANK_INTER_LEAVE = "vpRankInterLeave"
    VP_REDIRECTION_AFTER_POST = "vpRedirectionAfterPOST"
    VP_RESUME_ON_ACPOWER_LOSS = "vpResumeOnACPowerLoss"
    VP_SEV = "vpSEV"
    VP_SHA1_PCRBANK = "vpSHA1PCRBank"
    VP_SHA256_PCRBANK = "vpSHA256PCRBank"
    VP_SMEE = "vpSMEE"
    VP_SNC = "vpSNC"
    VP_SATA_MODE_SELECT = "vpSataModeSelect"
    VP_SELECT_MEMORY_RASCONFIGURATION = "vpSelectMemoryRASConfiguration"
    VP_SELECT_PPR_TYPE = "vpSelectPprType"
    VP_SERIAL_PORT_AENABLE = "vpSerialPortAEnable"
    VP_SGX_AUTO_REGISTRATION_AGENT = "vpSgxAutoRegistrationAgent"
    VP_SGX_EPOCH0 = "vpSgxEpoch0"
    VP_SGX_EPOCH1 = "vpSgxEpoch1"
    VP_SGX_FACTORY_RESET = "vpSgxFactoryReset"
    VP_SGX_LE_PUB_KEY_HASH0 = "vpSgxLePubKeyHash0"
    VP_SGX_LE_PUB_KEY_HASH1 = "vpSgxLePubKeyHash1"
    VP_SGX_LE_PUB_KEY_HASH2 = "vpSgxLePubKeyHash2"
    VP_SGX_LE_PUB_KEY_HASH3 = "vpSgxLePubKeyHash3"
    VP_SGX_LE_WR = "vpSgxLeWr"
    VP_SGX_PACKAGE_INFO_IN_BAND_ACCESS = "vpSgxPackageInfoInBandAccess"
    VP_SGX_QOS = "vpSgxQos"
    VP_SINGLE_PCTLENABLE = "vpSinglePCTLEnable"
    VP_SLOT10_LINK_SPEED = "vpSlot10LinkSpeed"
    VP_SLOT10_STATE = "vpSlot10State"
    VP_SLOT11_LINK_SPEED = "vpSlot11LinkSpeed"
    VP_SLOT11_STATE = "vpSlot11State"
    VP_SLOT12_LINK_SPEED = "vpSlot12LinkSpeed"
    VP_SLOT12_STATE = "vpSlot12State"
    VP_SLOT13_STATE = "vpSlot13State"
    VP_SLOT14_STATE = "vpSlot14State"
    VP_SLOT1_LINK_SPEED = "vpSlot1LinkSpeed"
    VP_SLOT1_STATE = "vpSlot1State"
    VP_SLOT2_LINK_SPEED = "vpSlot2LinkSpeed"
    VP_SLOT2_STATE = "vpSlot2State"
    VP_SLOT3_LINK_SPEED = "vpSlot3LinkSpeed"
    VP_SLOT3_STATE = "vpSlot3State"
    VP_SLOT4_LINK_SPEED = "vpSlot4LinkSpeed"
    VP_SLOT4_STATE = "vpSlot4State"
    VP_SLOT5_LINK_SPEED = "vpSlot5LinkSpeed"
    VP_SLOT5_STATE = "vpSlot5State"
    VP_SLOT6_LINK_SPEED = "vpSlot6LinkSpeed"
    VP_SLOT6_STATE = "vpSlot6State"
    VP_SLOT7_LINK_SPEED = "vpSlot7LinkSpeed"
    VP_SLOT7_STATE = "vpSlot7State"
    VP_SLOT8_LINK_SPEED = "vpSlot8LinkSpeed"
    VP_SLOT8_STATE = "vpSlot8State"
    VP_SLOT9_LINK_SPEED = "vpSlot9LinkSpeed"
    VP_SLOT9_STATE = "vpSlot9State"
    VP_SLOT_FLOMLINK_SPEED = "vpSlotFLOMLinkSpeed"
    VP_SLOT_FRONT_NVME10_LINK_SPEED = "vpSlotFrontNvme10LinkSpeed"
    VP_SLOT_FRONT_NVME10_OPTION_ROM = "vpSlotFrontNvme10OptionROM"
    VP_SLOT_FRONT_NVME11_LINK_SPEED = "vpSlotFrontNvme11LinkSpeed"
    VP_SLOT_FRONT_NVME11_OPTION_ROM = "vpSlotFrontNvme11OptionROM"
    VP_SLOT_FRONT_NVME12_LINK_SPEED = "vpSlotFrontNvme12LinkSpeed"
    VP_SLOT_FRONT_NVME12_OPTION_ROM = "vpSlotFrontNvme12OptionROM"
    VP_SLOT_FRONT_NVME13_OPTION_ROM = "vpSlotFrontNvme13OptionROM"
    VP_SLOT_FRONT_NVME14_OPTION_ROM = "vpSlotFrontNvme14OptionROM"
    VP_SLOT_FRONT_NVME15_OPTION_ROM = "vpSlotFrontNvme15OptionROM"
    VP_SLOT_FRONT_NVME16_OPTION_ROM = "vpSlotFrontNvme16OptionROM"
    VP_SLOT_FRONT_NVME17_OPTION_ROM = "vpSlotFrontNvme17OptionROM"
    VP_SLOT_FRONT_NVME18_OPTION_ROM = "vpSlotFrontNvme18OptionROM"
    VP_SLOT_FRONT_NVME19_OPTION_ROM = "vpSlotFrontNvme19OptionROM"
    VP_SLOT_FRONT_NVME1_LINK_SPEED = "vpSlotFrontNvme1LinkSpeed"
    VP_SLOT_FRONT_NVME1_OPTION_ROM = "vpSlotFrontNvme1OptionROM"
    VP_SLOT_FRONT_NVME20_OPTION_ROM = "vpSlotFrontNvme20OptionROM"
    VP_SLOT_FRONT_NVME21_OPTION_ROM = "vpSlotFrontNvme21OptionROM"
    VP_SLOT_FRONT_NVME22_OPTION_ROM = "vpSlotFrontNvme22OptionROM"
    VP_SLOT_FRONT_NVME23_OPTION_ROM = "vpSlotFrontNvme23OptionROM"
    VP_SLOT_FRONT_NVME24_OPTION_ROM = "vpSlotFrontNvme24OptionROM"
    VP_SLOT_FRONT_NVME2_LINK_SPEED = "vpSlotFrontNvme2LinkSpeed"
    VP_SLOT_FRONT_NVME2_OPTION_ROM = "vpSlotFrontNvme2OptionROM"
    VP_SLOT_FRONT_NVME3_LINK_SPEED = "vpSlotFrontNvme3LinkSpeed"
    VP_SLOT_FRONT_NVME3_OPTION_ROM = "vpSlotFrontNvme3OptionROM"
    VP_SLOT_FRONT_NVME4_LINK_SPEED = "vpSlotFrontNvme4LinkSpeed"
    VP_SLOT_FRONT_NVME4_OPTION_ROM = "vpSlotFrontNvme4OptionROM"
    VP_SLOT_FRONT_NVME5_LINK_SPEED = "vpSlotFrontNvme5LinkSpeed"
    VP_SLOT_FRONT_NVME5_OPTION_ROM = "vpSlotFrontNvme5OptionROM"
    VP_SLOT_FRONT_NVME6_LINK_SPEED = "vpSlotFrontNvme6LinkSpeed"
    VP_SLOT_FRONT_NVME6_OPTION_ROM = "vpSlotFrontNvme6OptionROM"
    VP_SLOT_FRONT_NVME7_LINK_SPEED = "vpSlotFrontNvme7LinkSpeed"
    VP_SLOT_FRONT_NVME7_OPTION_ROM = "vpSlotFrontNvme7OptionROM"
    VP_SLOT_FRONT_NVME8_LINK_SPEED = "vpSlotFrontNvme8LinkSpeed"
    VP_SLOT_FRONT_NVME8_OPTION_ROM = "vpSlotFrontNvme8OptionROM"
    VP_SLOT_FRONT_NVME9_LINK_SPEED = "vpSlotFrontNvme9LinkSpeed"
    VP_SLOT_FRONT_NVME9_OPTION_ROM = "vpSlotFrontNvme9OptionROM"
    VP_SLOT_FRONT_SLOT5_LINK_SPEED = "vpSlotFrontSlot5LinkSpeed"
    VP_SLOT_FRONT_SLOT6_LINK_SPEED = "vpSlotFrontSlot6LinkSpeed"
    VP_SLOT_GPU1_STATE = "vpSlotGPU1State"
    VP_SLOT_GPU2_STATE = "vpSlotGPU2State"
    VP_SLOT_GPU3_STATE = "vpSlotGPU3State"
    VP_SLOT_GPU4_STATE = "vpSlotGPU4State"
    VP_SLOT_GPU5_STATE = "vpSlotGPU5State"
    VP_SLOT_GPU6_STATE = "vpSlotGPU6State"
    VP_SLOT_GPU7_STATE = "vpSlotGPU7State"
    VP_SLOT_GPU8_STATE = "vpSlotGPU8State"
    VP_SLOT_HBALINK_SPEED = "vpSlotHBALinkSpeed"
    VP_SLOT_HBASTATE = "vpSlotHBAState"
    VP_SLOT_IOEMEZZ1_LINK_SPEED = "vpSlotIOEMezz1LinkSpeed"
    VP_SLOT_IOEMEZZ1_STATE = "vpSlotIOEMezz1State"
    VP_SLOT_IOENVME1_LINK_SPEED = "vpSlotIOENVMe1LinkSpeed"
    VP_SLOT_IOENVME1_STATE = "vpSlotIOENVMe1State"
    VP_SLOT_IOENVME2_LINK_SPEED = "vpSlotIOENVMe2LinkSpeed"
    VP_SLOT_IOENVME2_STATE = "vpSlotIOENVMe2State"
    VP_SLOT_IOESLOT1_LINK_SPEED = "vpSlotIOESlot1LinkSpeed"
    VP_SLOT_IOESLOT2_LINK_SPEED = "vpSlotIOESlot2LinkSpeed"
    VP_SLOT_LOM1_LINK = "vpSlotLOM1Link"
    VP_SLOT_LOM2_LINK = "vpSlotLOM2Link"
    VP_SLOT_MLOMLINK_SPEED = "vpSlotMLOMLinkSpeed"
    VP_SLOT_MLOMSTATE = "vpSlotMLOMState"
    VP_SLOT_MLINK_SPEED = "vpSlotMLinkSpeed"
    VP_SLOT_MRAIDLINK_SPEED = "vpSlotMRAIDLinkSpeed"
    VP_SLOT_MRAIDSTATE = "vpSlotMRAIDState"
    VP_SLOT_MEZZ_STATE = "vpSlotMezzState"
    VP_SLOT_N10_STATE = "vpSlotN10State"
    VP_SLOT_N11_STATE = "vpSlotN11State"
    VP_SLOT_N12_STATE = "vpSlotN12State"
    VP_SLOT_N13_STATE = "vpSlotN13State"
    VP_SLOT_N14_STATE = "vpSlotN14State"
    VP_SLOT_N15_STATE = "vpSlotN15State"
    VP_SLOT_N16_STATE = "vpSlotN16State"
    VP_SLOT_N17_STATE = "vpSlotN17State"
    VP_SLOT_N18_STATE = "vpSlotN18State"
    VP_SLOT_N19_STATE = "vpSlotN19State"
    VP_SLOT_N1_STATE = "vpSlotN1State"
    VP_SLOT_N20_STATE = "vpSlotN20State"
    VP_SLOT_N21_STATE = "vpSlotN21State"
    VP_SLOT_N22_STATE = "vpSlotN22State"
    VP_SLOT_N23_STATE = "vpSlotN23State"
    VP_SLOT_N24_STATE = "vpSlotN24State"
    VP_SLOT_N2_STATE = "vpSlotN2State"
    VP_SLOT_N3_STATE = "vpSlotN3State"
    VP_SLOT_N4_STATE = "vpSlotN4State"
    VP_SLOT_N5_STATE = "vpSlotN5State"
    VP_SLOT_N6_STATE = "vpSlotN6State"
    VP_SLOT_N7_STATE = "vpSlotN7State"
    VP_SLOT_N8_STATE = "vpSlotN8State"
    VP_SLOT_N9_STATE = "vpSlotN9State"
    VP_SLOT_RAIDLINK_SPEED = "vpSlotRAIDLinkSpeed"
    VP_SLOT_RAIDSTATE = "vpSlotRAIDState"
    VP_SLOT_REAR_NVME1_LINK_SPEED = "vpSlotRearNvme1LinkSpeed"
    VP_SLOT_REAR_NVME1_STATE = "vpSlotRearNvme1State"
    VP_SLOT_REAR_NVME2_LINK_SPEED = "vpSlotRearNvme2LinkSpeed"
    VP_SLOT_REAR_NVME2_STATE = "vpSlotRearNvme2State"
    VP_SLOT_REAR_NVME3_LINK_SPEED = "vpSlotRearNvme3LinkSpeed"
    VP_SLOT_REAR_NVME3_STATE = "vpSlotRearNvme3State"
    VP_SLOT_REAR_NVME4_LINK_SPEED = "vpSlotRearNvme4LinkSpeed"
    VP_SLOT_REAR_NVME4_STATE = "vpSlotRearNvme4State"
    VP_SLOT_REAR_NVME5_STATE = "vpSlotRearNvme5State"
    VP_SLOT_REAR_NVME6_STATE = "vpSlotRearNvme6State"
    VP_SLOT_REAR_NVME7_STATE = "vpSlotRearNvme7State"
    VP_SLOT_REAR_NVME8_STATE = "vpSlotRearNvme8State"
    VP_SLOT_RISER1_LINK_SPEED = "vpSlotRiser1LinkSpeed"
    VP_SLOT_RISER1_SLOT1_LINK_SPEED = "vpSlotRiser1Slot1LinkSpeed"
    VP_SLOT_RISER1_SLOT2_LINK_SPEED = "vpSlotRiser1Slot2LinkSpeed"
    VP_SLOT_RISER1_SLOT3_LINK_SPEED = "vpSlotRiser1Slot3LinkSpeed"
    VP_SLOT_RISER2_LINK_SPEED = "vpSlotRiser2LinkSpeed"
    VP_SLOT_RISER2_SLOT4_LINK_SPEED = "vpSlotRiser2Slot4LinkSpeed"
    VP_SLOT_RISER2_SLOT5_LINK_SPEED = "vpSlotRiser2Slot5LinkSpeed"
    VP_SLOT_RISER2_SLOT6_LINK_SPEED = "vpSlotRiser2Slot6LinkSpeed"
    VP_SLOT_SASSTATE = "vpSlotSASState"
    VP_SLOT_SBLOM1_STATE = "vpSlotSBLom1State"
    VP_SLOT_SBMEZZ1_LINK_SPEED = "vpSlotSBMezz1LinkSpeed"
    VP_SLOT_SBMEZZ1_STATE = "vpSlotSBMezz1State"
    VP_SLOT_SBMEZZ2_LINK_SPEED = "vpSlotSBMezz2LinkSpeed"
    VP_SLOT_SBMEZZ2_STATE = "vpSlotSBMezz2State"
    VP_SLOT_SBNVME1_LINK_SPEED = "vpSlotSBNVMe1LinkSpeed"
    VP_SLOT_SBNVME1_STATE = "vpSlotSBNVMe1State"
    VP_SLOT_SBNVME2_LINK_SPEED = "vpSlotSBNVMe2LinkSpeed"
    VP_SLOT_SBNVME2_STATE = "vpSlotSBNVMe2State"
    VP_SLOT_SIOC1_LINK_SPEED = "vpSlotSIOC1LinkSpeed"
    VP_SLOT_SIOC1_STATE = "vpSlotSIOC1State"
    VP_SLOT_SIOC2_LINK_SPEED = "vpSlotSIOC2LinkSpeed"
    VP_SLOT_SIOC2_STATE = "vpSlotSIOC2State"
    VP_SLOT_SIOCNVME1_LINK_SPEED = "vpSlotSIOCNVMe1LinkSpeed"
    VP_SLOT_SIOCNVME2_LINK_SPEED = "vpSlotSIOCNVMe2LinkSpeed"
    VP_SLOT_SIOCNVME1_STATE = "vpSlotSIOCNvme1State"
    VP_SLOT_SIOCNVME2_STATE = "vpSlotSIOCNvme2State"
    VP_SLOT_SSDSLOT1_LINK_SPEED = "vpSlotSSDSlot1LinkSpeed"
    VP_SLOT_SSDSLOT2_LINK_SPEED = "vpSlotSSDSlot2LinkSpeed"
    VP_SMT_MODE = "vpSmtMode"
    VP_SNOOPY_MODE_FOR2_LM = "vpSnoopyModeFor2LM"
    VP_SNOOPY_MODE_FOR_AD = "vpSnoopyModeForAD"
    VP_SPARING_MODE = "vpSparingMode"
    VP_SR_IOV = "vpSrIov"
    VP_STREAMER_PREFETCH = "vpStreamerPrefetch"
    VP_SVM_MODE = "vpSvmMode"
    VP_TPMCONTROL = "vpTPMControl"
    VP_TPMPENDING_OPERATION = "vpTPMPendingOperation"
    VP_TPMSUPPORT = "vpTPMSupport"
    VP_TSME = "vpTSME"
    VP_TXTSUPPORT = "vpTXTSupport"
    VP_TERMINAL_TYPE = "vpTerminalType"
    VP_TPM_PPI_REQUIRED = "vpTpmPpiRequired"
    VP_UCSMBOOT_ORDER_RULE = "vpUCSMBootOrderRule"
    VP_UFSDISABLE = "vpUFSDisable"
    VP_UPILINK_ENABLEMENT = "vpUPILinkEnablement"
    VP_UPIPOWER_MANAGEMENT = "vpUPIPowerManagement"
    VP_USBEMUL6064 = "vpUSBEmul6064"
    VP_UMA_BASED_CLUSTERING = "vpUmaBasedClustering"
    VP_USB_PORT_FRONT = "vpUsbPortFront"
    VP_USB_PORT_INTERNAL = "vpUsbPortInternal"
    VP_USB_PORT_KVM = "vpUsbPortKVM"
    VP_USB_PORT_REAR = "vpUsbPortRear"
    VP_USB_PORT_SDCARD = "vpUsbPortSDCard"
    VP_USB_PORT_VMEDIA = "vpUsbPortVMedia"
    VP_USB_XHCI_SUPPORT = "vpUsbXhciSupport"
    VP_VMDENABLE = "vpVMDEnable"
    VP_VGA_PRIORITY = "vpVgaPriority"
    VP_VIRTUAL_NUMA = "vpVirtualNuma"
    VP_VOL_MEMORY_MODE = "vpVolMemoryMode"
    VP_WORK_LOAD_CONFIG = "vpWorkLoadConfig"
    VP_XPTPREFETCH = "vpXPTPrefetch"
    VP_XPTREMOTE_PREFETCH = "vpXPTRemotePrefetch"
    VXLAN = "vxlan"
    WEAR_STATUS_IN_DAYS = "wearStatusInDays"
    WEB_BIOS_VERSION = "webBiosVersion"
    WIDTH = "width"
    WR_ERR_COUNT_SLOT1_THRESHOLD = "wrErrCountSlot1Threshold"
    WR_ERR_COUNT_SLOT2_THRESHOLD = "wrErrCountSlot2Threshold"
    WRITE_CACHE_POLICY = "writeCachePolicy"
    WRITE_ENABLED = "writeEnabled"
    WRITE_ERROR_COUNT = "writeErrorCount"
    WRITE_ERROR_THRESHOLD = "writeErrorThreshold"
    WRITE_POLICY = "writePolicy"
    WWNN = "wwnn"
    WWPN = "wwpn"

class ObjectStatus:
    CREATED = "created"
    DELETED = "deleted"
    MODIFIED = "modified"
    REMOVED = "removed"

class Status:
    CREATED = "created"
    DELETED = "deleted"
    MODIFIED = "modified"
    REMOVED = "removed"

class SyslogSeverity:
    ALERT = "alert"
    CRITICAL = "critical"
    DEBUG = "debug"
    EMERGENCY = "emergency"
    ERROR = "error"
    INFORMATIONAL = "informational"
    NOTICE = "notice"
    WARNING = "warning"

