"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const lib_1 = require("../lib");
describe('User Pool Attributes', () => {
    describe('StringAttribute', () => {
        test('default', () => {
            // GIVEN
            const attr = new lib_1.StringAttribute();
            // WHEN
            const bound = attr.bind();
            // THEN
            expect(bound.dataType).toEqual('String');
            expect(bound.stringConstraints).toBeUndefined();
            expect(bound.numberConstraints).toBeUndefined();
        });
        test('specified constraints are recognized', () => {
            // GIVEN
            const attr = new lib_1.StringAttribute({ minLen: 10, maxLen: 60 });
            // WHEN
            const bound = attr.bind();
            // THEN
            expect(bound.stringConstraints).toEqual({
                minLen: 10,
                maxLen: 60,
            });
            expect(bound.numberConstraints).toBeUndefined();
        });
        test('throws error when crossing limits', () => {
            expect(() => new lib_1.StringAttribute({ minLen: -10 }))
                .toThrow(/minLen cannot be less than/);
            expect(() => new lib_1.StringAttribute({ maxLen: 5000 }))
                .toThrow(/maxLen cannot be greater than/);
        });
    });
    describe('NumberAttribute', () => {
        test('default', () => {
            // GIVEN
            const attr = new lib_1.NumberAttribute();
            // WHEN
            const bound = attr.bind();
            // THEN
            expect(bound.dataType).toEqual('Number');
            expect(bound.stringConstraints).toBeUndefined();
            expect(bound.numberConstraints).toBeUndefined();
        });
        test('specified constraints are recognized', () => {
            // GIVEN
            const attr = new lib_1.NumberAttribute({ min: 5, max: 600 });
            // WHEN
            const bound = attr.bind();
            // THEN
            expect(bound.numberConstraints).toEqual({
                min: 5,
                max: 600,
            });
            expect(bound.stringConstraints).toBeUndefined();
        });
    });
    describe('BooleanAttribute', () => {
        test('default', () => {
            // GIVEN
            const attr = new lib_1.BooleanAttribute();
            // WHEN
            const bound = attr.bind();
            // THEN
            expect(bound.dataType).toEqual('Boolean');
            expect(bound.stringConstraints).toBeUndefined();
            expect(bound.numberConstraints).toBeUndefined();
        });
    });
    describe('DateTimeAttribute', () => {
        test('default', () => {
            // GIVEN
            const attr = new lib_1.DateTimeAttribute();
            // WHEN
            const bound = attr.bind();
            // THEN
            expect(bound.dataType).toEqual('DateTime');
            expect(bound.stringConstraints).toBeUndefined();
            expect(bound.numberConstraints).toBeUndefined();
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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