"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const app = new core_1.App();
const stack = new core_1.Stack(app, 'integ-user-pool');
const userpool = new lib_1.UserPool(stack, 'myuserpool', {
    userPoolName: 'MyUserPool',
    userInvitation: {
        emailSubject: 'invitation email subject from the integ test',
        emailBody: 'invitation email body from the integ test for {username}. Temp password is {####}.',
        smsMessage: 'invitation sms message from the integ test for {username}. Temp password is {####}.',
    },
    selfSignUpEnabled: true,
    userVerification: {
        emailBody: 'verification email body from the integ test. Code is {####}.',
        emailSubject: 'verification email subject from the integ test',
        smsMessage: 'verification sms message from the integ test. Code is {####}.',
    },
    signInAliases: {
        username: true,
        email: true,
    },
    autoVerify: {
        email: true,
        phone: true,
    },
    requiredAttributes: {
        fullname: true,
        email: true,
    },
    customAttributes: {
        'some-string-attr': new lib_1.StringAttribute(),
        'another-string-attr': new lib_1.StringAttribute({ minLen: 4, maxLen: 100 }),
        'some-number-attr': new lib_1.NumberAttribute(),
        'another-number-attr': new lib_1.NumberAttribute({ min: 10, max: 50 }),
        'some-boolean-attr': new lib_1.BooleanAttribute(),
        'some-datetime-attr': new lib_1.DateTimeAttribute(),
    },
    mfa: lib_1.Mfa.REQUIRED,
    mfaSecondFactor: {
        sms: true,
        otp: true,
    },
    passwordPolicy: {
        tempPasswordValidity: core_1.Duration.days(10),
        minLength: 12,
        requireDigits: true,
        requireLowercase: true,
        requireUppercase: true,
        requireSymbols: true,
    },
    emailSettings: {
        from: 'noreply@myawesomeapp.com',
        replyTo: 'support@myawesomeapp.com',
    },
});
new core_1.CfnOutput(stack, 'userpoolId', {
    value: userpool.userPoolId
});
//# sourceMappingURL=data:application/json;base64,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