"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * The String custom attribute type.
 */
class StringAttribute {
    constructor(props = {}) {
        var _a, _b;
        if (props.minLen && props.minLen < 0) {
            throw new Error(`minLen cannot be less than 0 (value: ${props.minLen}).`);
        }
        if (props.maxLen && props.maxLen > 2048) {
            throw new Error(`maxLen cannot be greater than 2048 (value: ${props.maxLen}).`);
        }
        this.minLen = (_a = props) === null || _a === void 0 ? void 0 : _a.minLen;
        this.maxLen = (_b = props) === null || _b === void 0 ? void 0 : _b.maxLen;
    }
    bind() {
        let stringConstraints;
        if (this.minLen || this.maxLen) {
            stringConstraints = {
                minLen: this.minLen,
                maxLen: this.maxLen,
            };
        }
        return {
            dataType: 'String',
            stringConstraints,
        };
    }
}
exports.StringAttribute = StringAttribute;
/**
 * The Number custom attribute type.
 */
class NumberAttribute {
    constructor(props = {}) {
        var _a, _b;
        this.min = (_a = props) === null || _a === void 0 ? void 0 : _a.min;
        this.max = (_b = props) === null || _b === void 0 ? void 0 : _b.max;
    }
    bind() {
        let numberConstraints;
        if (this.min || this.max) {
            numberConstraints = {
                min: this.min,
                max: this.max,
            };
        }
        return {
            dataType: 'Number',
            numberConstraints,
        };
    }
}
exports.NumberAttribute = NumberAttribute;
/**
 * The Boolean custom attribute type.
 */
class BooleanAttribute {
    bind() {
        return {
            dataType: 'Boolean'
        };
    }
}
exports.BooleanAttribute = BooleanAttribute;
/**
 * The DateTime custom attribute type.
 */
class DateTimeAttribute {
    bind() {
        return {
            dataType: 'DateTime'
        };
    }
}
exports.DateTimeAttribute = DateTimeAttribute;
//# sourceMappingURL=data:application/json;base64,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