"""
配置工具函数
"""
import json
from pathlib import Path
from typing import Any, Dict

from mineru_flow.internal.common.logging import get_logger

_config_utils_logger = get_logger("utils.config")


def update_sys_info(input: Dict[str, Any]) -> None:
    """更新系统配置文件"""
    try:
        # 获取静态配置文件路径
        info_file = Path(__file__).parent.parent / "statics" / "sys-info.js"
        
        # 生成配置内容
        info_json = json.dumps(input, separators=(',', ':'))
        info_content = f"(function() {{ window.__INFO__ = {info_json}; }})();\n"
        
        # 写入配置文件
        with open(info_file, 'w', encoding='utf-8') as f:
            f.write(info_content)
            
        _config_utils_logger.debug(
            "系统配置已更新", info_file=str(info_file), payload=input
        )
        
    except Exception as e:
        _config_utils_logger.error(
            "更新系统配置失败", info_file=str(info_file), error=str(e)
        )
