from pydantic import BaseModel, Field


# ============ Worker响应 ============
class WorkerStatsData(BaseModel):
    """Worker状态数据"""

    active_jobs: int = Field(alias="activeJobs")
    total_processed: int = Field(alias="totalProcessed")
    status: str

    class Config:
        populate_by_name = True


class WorkerStatsResponse(BaseModel):
    """Worker状态响应"""

    data: WorkerStatsData
