from typing import Any, Dict, Optional

from pydantic import BaseModel, Field

from .base import BaseResponse


# ============ Task响应 ============
class JobResponseData(BaseModel):
    """作业响应数据"""

    id: int
    phase: str
    status: str
    error_message: Optional[str] = None
    config: Optional[Dict[str, Any]] = None
    created_at: int  # timestamp in milliseconds
    updated_at: Optional[int] = None


class TaskResponse(BaseModel):
    """任务响应"""

    id: int
    name: str
    created_at: int  # timestamp in milliseconds
    updated_at: Optional[int] = None
    job: Optional[JobResponseData] = None


class TaskListResponse(BaseModel):
    """任务列表响应"""

    data: Dict[str, Any] = Field(..., description="包含tasks数组和分页信息")


class TaskCreateResponse(BaseResponse):
    """任务创建响应"""

    data: Dict[str, int] = Field(..., description="包含任务ID")


class TaskDetailResponse(BaseResponse):
    """任务详情响应"""

    data: TaskResponse


class TaskSummaryData(BaseModel):
    """任务状态汇总数据"""

    total: int
    statusCounts: Dict[str, int]


class TaskSummaryResponse(BaseResponse):
    """任务汇总响应"""

    data: TaskSummaryData


class TaskDeleteResponse(BaseResponse):
    """任务删除响应"""

    data: Dict[str, int] = Field(
        default_factory=dict, description="已删除任务的标识信息"
    )
