from typing import Any, Dict

from pydantic import BaseModel, Field


# ============ System响应 ============
class SystemInfoData(BaseModel):
    """系统信息数据"""

    media_dir: str = Field(alias="mediaDir")
    cache_dir: str = Field(alias="cacheDir")
    database_path: str = Field(alias="databasePath")

    class Config:
        populate_by_name = True


class SystemInfoResponse(BaseModel):
    """系统信息响应"""

    data: SystemInfoData


class SystemStatusData(BaseModel):
    """系统状态数据"""

    version: str
    uptime: str
    memory_usage: float = Field(alias="memoryUsage")
    cpu_usage: float = Field(alias="cpuUsage")
    disk_usage: Dict[str, Any] = Field(alias="diskUsage")

    class Config:
        populate_by_name = True


class SystemStatusResponse(BaseModel):
    """系统状态响应"""

    data: SystemStatusData


class HealthCheckData(BaseModel):
    """健康检查数据"""

    database: bool
    file_system: bool = Field(alias="fileSystem")
    worker: bool

    class Config:
        populate_by_name = True


class HealthResponse(BaseModel):
    """健康检查响应"""

    status: str
    timestamp: str
    services: HealthCheckData
