from typing import Any, Dict, Optional
from datetime import datetime

from pydantic import BaseModel

from mineru_flow.internal.schema.state import JobStatus, Phase

from .base import BaseResponse


# ============ Job响应 ============
class JobResponse(BaseModel):
    """作业响应"""

    id: int
    error_message: Optional[str] = None
    phase: Phase
    status: JobStatus
    created_at: datetime
    updated_at: Optional[datetime] = None
    config: Optional[Dict[str, Any]] = None

    class Config:
        from_attributes = True


class JobCreateResponse(BaseResponse):
    """作业创建响应"""

    data: JobResponse


class JobUpdateResponse(BaseResponse):
    """作业更新响应"""

    data: JobResponse
