from typing import Any, Dict, List, Optional
from datetime import datetime

from pydantic import BaseModel

from .base import BaseResponse, ListResponse


# ============ Config响应 ============
class ConfigResponse(BaseModel):
    """配置响应"""

    id: int
    type: str
    name: str
    value: Optional[Dict[str, Any]] = None
    created_at: datetime

    class Config:
        from_attributes = True


class ConfigListResponse(ListResponse[ConfigResponse]):
    """配置列表响应"""

    pass


class ConfigCreateResponse(BaseResponse):
    """配置创建响应"""

    data: ConfigResponse


class ConfigUpdateResponse(BaseResponse):
    """配置更新响应"""

    data: ConfigResponse


class ConfigDeleteResponse(BaseResponse):
    """配置删除响应"""

    pass
