from typing import Any, Dict, Generic, List, Optional, TypeVar

from pydantic import BaseModel

T = TypeVar("T")


# ============ 基础响应模板 ============
class BaseResponse(BaseModel):
    """基础响应模板"""

    success: bool = True
    message: str = "操作成功"


class ListResponse(BaseModel, Generic[T]):
    """列表响应模板"""

    data: List[T]
    total: int
    page: Optional[int] = None
    page_size: Optional[int] = None


class ItemResponse(BaseModel, Generic[T]):
    """单项响应模板"""

    data: T


class OkResponse(BaseResponse):
    """简单成功响应"""

    data: Any = {}


class ErrorResponse(BaseModel):
    """错误响应"""

    success: bool = False
    message: str
    error_code: Optional[str] = None
    details: Optional[Dict[str, Any]] = None
