from typing import Any, Dict, Optional

from pydantic import Field

from .base import BaseRequest


# ============ Task Request Schemas ============
class TaskCreateRequest(BaseRequest):
    """任务创建请求"""

    config: Dict[str, Any] = Field(..., description="任务配置")

    class Config:
        populate_by_name = True


class TaskUpdateRequest(BaseRequest):
    """任务更新请求"""

    config: Optional[Dict[str, Any]] = Field(default=None, description="任务配置")
    file_path: Optional[str] = Field(
        default=None, alias="filePath", description="文件路径"
    )

    class Config:
        populate_by_name = True


class TaskRetryRequest(BaseRequest):
    """任务重试请求

    - phase: 指定从哪一个阶段重新开始处理；不指定时将按照任务状态推断合适的阶段。
    """

    phase: Optional[str] = Field(default=None, description="指定重试的阶段")

    class Config:
        populate_by_name = True


class TaskListRequest(BaseRequest):
    """任务列表请求"""

    page: int = Field(default=1, ge=1, description="页码")
    page_size: int = Field(
        default=20, ge=1, le=100, alias="pageSize", description="每页大小"
    )
    name: Optional[str] = Field(default=None, description="任务名称过滤")
    phase: Optional[str] = Field(default=None, description="阶段过滤")
    status: Optional[str] = Field(default=None, description="状态过滤")
    sort_by: str = Field(default="created_at", alias="sortBy", description="排序字段")
    sort_order: str = Field(default="desc", alias="sortOrder", description="排序顺序")

    class Config:
        populate_by_name = True
