from typing import Any, Dict, Optional

from pydantic import Field

from .base import BaseRequest


# ============ Job Request Schemas ============
class JobCreateRequest(BaseRequest):
    """作业创建请求"""

    phase: str = Field(default="parse", description="作业阶段")
    status: str = Field(default="waiting", description="作业状态")
    config: Optional[Dict[str, Any]] = Field(default=None, description="作业配置")


class JobUpdateRequest(BaseRequest):
    """作业更新请求"""

    error_message: Optional[str] = Field(default=None, description="错误信息")
    phase: Optional[str] = Field(default=None, description="作业阶段")
    status: Optional[str] = Field(default=None, description="作业状态")
    config: Optional[Dict[str, Any]] = Field(default=None, description="作业配置")
