from typing import Any, Dict, Optional

from pydantic import BaseModel, Field

from .base import BaseRequest


# ============ Config Request Schemas ============
class ConfigCreateRequest(BaseRequest):
    """配置创建请求"""

    type: str = Field(..., description="配置类型")
    name: str = Field(..., description="配置名称")
    value: Optional[Dict[str, Any]] = Field(default=None, description="配置值")


class ConfigUpdateRequest(BaseRequest):
    """配置更新请求"""

    type: Optional[str] = Field(default=None, description="配置类型")
    name: Optional[str] = Field(default=None, description="配置名称")
    value: Optional[Dict[str, Any]] = Field(default=None, description="配置值")


class ConfigListRequest(BaseRequest):
    """配置列表请求"""

    type: Optional[str] = Field(default=None, description="按类型过滤")
    skip: int = Field(default=0, ge=0, description="跳过的记录数")
    limit: int = Field(default=100, ge=1, le=1000, description="返回的记录数")
