from fastapi import APIRouter

from mineru_flow.internal.worker.simple_manager import get_simple_worker_stats
from mineru_flow.internal.common.logging import get_api_logger

router = APIRouter(tags=["worker"])
worker_logger = get_api_logger().bind(endpoint="worker")


@router.get("/worker/stats")
async def get_worker_status():
    """获取 Worker 状态信息"""
    stats = get_simple_worker_stats()
    worker_logger.debug(
        "查询 Worker 状态",
        active_jobs=stats.get("active_jobs", 0),
        total_processed=stats.get("total_processed", 0),
        workers=stats.get("workers"),
    )

    return {
        "data": {
            "activeJobs": stats.get("active_jobs", 0),
            "totalProcessed": stats.get("total_processed", 0),
            "status": "running" if stats.get("active_jobs", 0) > 0 else "idle",
        }
    }
