from fastapi import APIRouter

from .endpoints.task import router as task_router
from .endpoints.upload import router as upload_router
from .endpoints.system import router as system_router
from .endpoints.config import router as config_router
from .endpoints.worker import router as worker_router

v1_router = APIRouter(prefix="/v1")

# 任务相关路由
v1_router.include_router(task_router)
v1_router.include_router(upload_router)
v1_router.include_router(system_router)
v1_router.include_router(config_router)
v1_router.include_router(worker_router)
