import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Schema for Module Fragment of type FreyrAIM::ImpactApi::ApiGateway::MODULE
 *
 * @schema CfnApiGatewayModuleProps
 */
export interface CfnApiGatewayModuleProps {
    /**
     * @schema CfnApiGatewayModuleProps#Parameters
     */
    readonly parameters?: CfnApiGatewayModulePropsParameters;
    /**
     * @schema CfnApiGatewayModuleProps#Resources
     */
    readonly resources?: CfnApiGatewayModulePropsResources;
}
/**
 * Converts an object of type 'CfnApiGatewayModuleProps' to JSON representation.
 */
export declare function toJson_CfnApiGatewayModuleProps(obj: CfnApiGatewayModuleProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnApiGatewayModulePropsParameters
 */
export interface CfnApiGatewayModulePropsParameters {
    /**
     * The lambda function`s name
     *
     * @schema CfnApiGatewayModulePropsParameters#FunctionName
     */
    readonly functionName?: CfnApiGatewayModulePropsParametersFunctionName;
    /**
     * The environment name
     *
     * @schema CfnApiGatewayModulePropsParameters#EnvName
     */
    readonly envName?: CfnApiGatewayModulePropsParametersEnvName;
}
/**
 * Converts an object of type 'CfnApiGatewayModulePropsParameters' to JSON representation.
 */
export declare function toJson_CfnApiGatewayModulePropsParameters(obj: CfnApiGatewayModulePropsParameters | undefined): Record<string, any> | undefined;
/**
 * @schema CfnApiGatewayModulePropsResources
 */
export interface CfnApiGatewayModulePropsResources {
    /**
     * @schema CfnApiGatewayModulePropsResources#DocContentPostMethod
     */
    readonly docContentPostMethod?: CfnApiGatewayModulePropsResourcesDocContentPostMethod;
    /**
     * @schema CfnApiGatewayModulePropsResources#DocContentResource
     */
    readonly docContentResource?: CfnApiGatewayModulePropsResourcesDocContentResource;
    /**
     * @schema CfnApiGatewayModulePropsResources#ImpactApi
     */
    readonly impactApi?: CfnApiGatewayModulePropsResourcesImpactApi;
    /**
     * @schema CfnApiGatewayModulePropsResources#ClassifierResource
     */
    readonly classifierResource?: CfnApiGatewayModulePropsResourcesClassifierResource;
    /**
     * @schema CfnApiGatewayModulePropsResources#ApiGatewayCloudWatchLogsRole
     */
    readonly apiGatewayCloudWatchLogsRole?: CfnApiGatewayModulePropsResourcesApiGatewayCloudWatchLogsRole;
    /**
     * @schema CfnApiGatewayModulePropsResources#ApiGatewayCloudWatchLogsAccount
     */
    readonly apiGatewayCloudWatchLogsAccount?: CfnApiGatewayModulePropsResourcesApiGatewayCloudWatchLogsAccount;
    /**
     * @schema CfnApiGatewayModulePropsResources#DeploymentDocContentPost
     */
    readonly deploymentDocContentPost?: CfnApiGatewayModulePropsResourcesDeploymentDocContentPost;
    /**
     * @schema CfnApiGatewayModulePropsResources#LambdaPermission
     */
    readonly lambdaPermission?: CfnApiGatewayModulePropsResourcesLambdaPermission;
}
/**
 * Converts an object of type 'CfnApiGatewayModulePropsResources' to JSON representation.
 */
export declare function toJson_CfnApiGatewayModulePropsResources(obj: CfnApiGatewayModulePropsResources | undefined): Record<string, any> | undefined;
/**
 * The lambda function`s name
 *
 * @schema CfnApiGatewayModulePropsParametersFunctionName
 */
export interface CfnApiGatewayModulePropsParametersFunctionName {
    /**
     * @schema CfnApiGatewayModulePropsParametersFunctionName#Type
     */
    readonly type: string;
    /**
     * @schema CfnApiGatewayModulePropsParametersFunctionName#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnApiGatewayModulePropsParametersFunctionName' to JSON representation.
 */
export declare function toJson_CfnApiGatewayModulePropsParametersFunctionName(obj: CfnApiGatewayModulePropsParametersFunctionName | undefined): Record<string, any> | undefined;
/**
 * The environment name
 *
 * @schema CfnApiGatewayModulePropsParametersEnvName
 */
export interface CfnApiGatewayModulePropsParametersEnvName {
    /**
     * @schema CfnApiGatewayModulePropsParametersEnvName#Type
     */
    readonly type: string;
    /**
     * @schema CfnApiGatewayModulePropsParametersEnvName#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnApiGatewayModulePropsParametersEnvName' to JSON representation.
 */
export declare function toJson_CfnApiGatewayModulePropsParametersEnvName(obj: CfnApiGatewayModulePropsParametersEnvName | undefined): Record<string, any> | undefined;
/**
 * @schema CfnApiGatewayModulePropsResourcesDocContentPostMethod
 */
export interface CfnApiGatewayModulePropsResourcesDocContentPostMethod {
    /**
     * @schema CfnApiGatewayModulePropsResourcesDocContentPostMethod#Type
     */
    readonly type?: string;
    /**
     * @schema CfnApiGatewayModulePropsResourcesDocContentPostMethod#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnApiGatewayModulePropsResourcesDocContentPostMethod' to JSON representation.
 */
export declare function toJson_CfnApiGatewayModulePropsResourcesDocContentPostMethod(obj: CfnApiGatewayModulePropsResourcesDocContentPostMethod | undefined): Record<string, any> | undefined;
/**
 * @schema CfnApiGatewayModulePropsResourcesDocContentResource
 */
export interface CfnApiGatewayModulePropsResourcesDocContentResource {
    /**
     * @schema CfnApiGatewayModulePropsResourcesDocContentResource#Type
     */
    readonly type?: string;
    /**
     * @schema CfnApiGatewayModulePropsResourcesDocContentResource#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnApiGatewayModulePropsResourcesDocContentResource' to JSON representation.
 */
export declare function toJson_CfnApiGatewayModulePropsResourcesDocContentResource(obj: CfnApiGatewayModulePropsResourcesDocContentResource | undefined): Record<string, any> | undefined;
/**
 * @schema CfnApiGatewayModulePropsResourcesImpactApi
 */
export interface CfnApiGatewayModulePropsResourcesImpactApi {
    /**
     * @schema CfnApiGatewayModulePropsResourcesImpactApi#Type
     */
    readonly type?: string;
    /**
     * @schema CfnApiGatewayModulePropsResourcesImpactApi#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnApiGatewayModulePropsResourcesImpactApi' to JSON representation.
 */
export declare function toJson_CfnApiGatewayModulePropsResourcesImpactApi(obj: CfnApiGatewayModulePropsResourcesImpactApi | undefined): Record<string, any> | undefined;
/**
 * @schema CfnApiGatewayModulePropsResourcesClassifierResource
 */
export interface CfnApiGatewayModulePropsResourcesClassifierResource {
    /**
     * @schema CfnApiGatewayModulePropsResourcesClassifierResource#Type
     */
    readonly type?: string;
    /**
     * @schema CfnApiGatewayModulePropsResourcesClassifierResource#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnApiGatewayModulePropsResourcesClassifierResource' to JSON representation.
 */
export declare function toJson_CfnApiGatewayModulePropsResourcesClassifierResource(obj: CfnApiGatewayModulePropsResourcesClassifierResource | undefined): Record<string, any> | undefined;
/**
 * @schema CfnApiGatewayModulePropsResourcesApiGatewayCloudWatchLogsRole
 */
export interface CfnApiGatewayModulePropsResourcesApiGatewayCloudWatchLogsRole {
    /**
     * @schema CfnApiGatewayModulePropsResourcesApiGatewayCloudWatchLogsRole#Type
     */
    readonly type?: string;
    /**
     * @schema CfnApiGatewayModulePropsResourcesApiGatewayCloudWatchLogsRole#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnApiGatewayModulePropsResourcesApiGatewayCloudWatchLogsRole' to JSON representation.
 */
export declare function toJson_CfnApiGatewayModulePropsResourcesApiGatewayCloudWatchLogsRole(obj: CfnApiGatewayModulePropsResourcesApiGatewayCloudWatchLogsRole | undefined): Record<string, any> | undefined;
/**
 * @schema CfnApiGatewayModulePropsResourcesApiGatewayCloudWatchLogsAccount
 */
export interface CfnApiGatewayModulePropsResourcesApiGatewayCloudWatchLogsAccount {
    /**
     * @schema CfnApiGatewayModulePropsResourcesApiGatewayCloudWatchLogsAccount#Type
     */
    readonly type?: string;
    /**
     * @schema CfnApiGatewayModulePropsResourcesApiGatewayCloudWatchLogsAccount#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnApiGatewayModulePropsResourcesApiGatewayCloudWatchLogsAccount' to JSON representation.
 */
export declare function toJson_CfnApiGatewayModulePropsResourcesApiGatewayCloudWatchLogsAccount(obj: CfnApiGatewayModulePropsResourcesApiGatewayCloudWatchLogsAccount | undefined): Record<string, any> | undefined;
/**
 * @schema CfnApiGatewayModulePropsResourcesDeploymentDocContentPost
 */
export interface CfnApiGatewayModulePropsResourcesDeploymentDocContentPost {
    /**
     * @schema CfnApiGatewayModulePropsResourcesDeploymentDocContentPost#Type
     */
    readonly type?: string;
    /**
     * @schema CfnApiGatewayModulePropsResourcesDeploymentDocContentPost#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnApiGatewayModulePropsResourcesDeploymentDocContentPost' to JSON representation.
 */
export declare function toJson_CfnApiGatewayModulePropsResourcesDeploymentDocContentPost(obj: CfnApiGatewayModulePropsResourcesDeploymentDocContentPost | undefined): Record<string, any> | undefined;
/**
 * @schema CfnApiGatewayModulePropsResourcesLambdaPermission
 */
export interface CfnApiGatewayModulePropsResourcesLambdaPermission {
    /**
     * @schema CfnApiGatewayModulePropsResourcesLambdaPermission#Type
     */
    readonly type?: string;
    /**
     * @schema CfnApiGatewayModulePropsResourcesLambdaPermission#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnApiGatewayModulePropsResourcesLambdaPermission' to JSON representation.
 */
export declare function toJson_CfnApiGatewayModulePropsResourcesLambdaPermission(obj: CfnApiGatewayModulePropsResourcesLambdaPermission | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `FreyrAIM::ImpactApi::ApiGateway::MODULE`
 *
 * @cloudformationResource FreyrAIM::ImpactApi::ApiGateway::MODULE
 * @stability external
 * @link http://unknown-url
 */
export declare class CfnApiGatewayModule extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "FreyrAIM::ImpactApi::ApiGateway::MODULE";
    /**
     * Resource props.
     */
    readonly props: CfnApiGatewayModuleProps;
    /**
     * Create a new `FreyrAIM::ImpactApi::ApiGateway::MODULE`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnApiGatewayModuleProps);
}
