"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubscriptionFilter = void 0;
/**
 * A subscription filter for an attribute.
 */
class SubscriptionFilter {
    /**
     *
     * @param conditions conditions that specify the message attributes that should be included, excluded, matched, etc.
     */
    constructor(conditions = []) {
        this.conditions = conditions;
    }
    /**
     * Returns a subscription filter for a string attribute.
     */
    static stringFilter(stringConditions) {
        const conditions = new Array();
        if (stringConditions.whitelist) {
            conditions.push(...stringConditions.whitelist);
        }
        if (stringConditions.blacklist) {
            conditions.push({ 'anything-but': stringConditions.blacklist });
        }
        if (stringConditions.matchPrefixes) {
            conditions.push(...stringConditions.matchPrefixes.map(p => ({ prefix: p })));
        }
        return new SubscriptionFilter(conditions);
    }
    /**
     * Returns a subscription filter for a numeric attribute.
     */
    static numericFilter(numericConditions) {
        const conditions = new Array();
        if (numericConditions.whitelist) {
            conditions.push(...numericConditions.whitelist.map(v => ({ numeric: ['=', v] })));
        }
        if (numericConditions.greaterThan) {
            conditions.push({ numeric: ['>', numericConditions.greaterThan] });
        }
        if (numericConditions.greaterThanOrEqualTo) {
            conditions.push({ numeric: ['>=', numericConditions.greaterThanOrEqualTo] });
        }
        if (numericConditions.lessThan) {
            conditions.push({ numeric: ['<', numericConditions.lessThan] });
        }
        if (numericConditions.lessThanOrEqualTo) {
            conditions.push({ numeric: ['<=', numericConditions.lessThanOrEqualTo] });
        }
        if (numericConditions.between) {
            conditions.push({ numeric: ['>=', numericConditions.between.start, '<=', numericConditions.between.stop] });
        }
        if (numericConditions.betweenStrict) {
            conditions.push({ numeric: ['>', numericConditions.betweenStrict.start, '<', numericConditions.betweenStrict.stop] });
        }
        return new SubscriptionFilter(conditions);
    }
    /**
     * Returns a subscription filter for attribute key matching.
     */
    static existsFilter() {
        return new SubscriptionFilter([{ exists: true }]);
    }
}
exports.SubscriptionFilter = SubscriptionFilter;
//# sourceMappingURL=data:application/json;base64,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