import tkinter
from typing import SupportsFloat
from typing_extensions import Final

import Pmw  # type: ignore[import]
from direct.showbase.DirectObject import DirectObject
from panda3d.core import NodePath

DEFAULT_BT_WIDTH: Final[float]

class MemoryExplorer(Pmw.MegaWidget, DirectObject):
    nodePath: NodePath
    renderItem: MemoryExplorerItem | None
    render2dItem = list
    buttons: list[tkinter.Button]
    labels: list[tkinter.Label]
    rootItem: MemoryExplorerItem | None
    btWidth: float
    balloon: Pmw.Balloon
    frame: Pmw.ScrolledFrame
    scaleCtrl: tkinter.Scale
    refreshBT: tkinter.Button
    def __init__(self, parent=..., nodePath: NodePath | None = ..., **kw) -> None: ...
    def createScrolledFrame(self) -> None: ...
    def createScale(self) -> None: ...
    def createRefreshBT(self) -> None: ...
    def createDefaultCtrls(self) -> None: ...
    def setTitle(self, parent, bytes) -> None: ...
    def resetCtrls(self) -> None: ...
    def getNewButton(self, width: float, ratio: float) -> tkinter.Button: ...
    def addSelfCtrl(self, item, totalBytes: int) -> None: ...
    def addChildCtrl(self, item, totalBytes: int) -> None: ...
    def addButton(self, vertexBytes, totalBytes: int, funcLClick, funcRClick, item) -> tkinter.Button: ...
    def addLabel(self, label: str) -> None: ...
    def getBTWidth(self, vertexBytes: int, totalBytes: int) -> int: ...
    def onScaleUpdate(self, arg: SupportsFloat) -> None: ...
    def updateBTWidth(self) -> None: ...
    def updateDefaultBTWidth(self) -> None: ...
    def onSelfButtonLClick(self, item) -> None: ...
    def onSelfButtonRClick(self, item) -> None: ...
    def onChildButtonLClick(self, item) -> None: ...
    def onChildButtonRClick(self, item) -> None: ...
    def addItemCtrls(self, item) -> None: ...
    def makeList(self) -> None: ...
    def buildList(self, parentItem) -> None: ...
    def analyze(self) -> None: ...
    def refresh(self) -> None: ...

class MemoryExplorerItem:
    parent: MemoryExplorerItem | None
    nodePath: NodePath
    children: list[MemoryExplorerItem]
    selfVertexBytes: int
    childrenVertexBytes: int
    numFaces: int
    textureBytes: int
    pathName: str
    def __init__(self, parent, nodePath: NodePath) -> None: ...
    def getParent(self): ...
    def addChild(self, child) -> None: ...
    def getNumChildren(self) -> int: ...
    def getChildren(self) -> list[MemoryExplorerItem]: ...
    def getName(self) -> str: ...
    def getPathName(self) -> str: ...
    def getVertexBytes(self) -> int: ...
    def getSelfVertexBytes(self) -> int: ...
    def analyze(self) -> None: ...
    def calcVertexBytes(self, geom) -> None: ...
    def calcTextureBytes(self) -> None: ...
    def calcNumFaces(self, geom) -> None: ...
    def analyzeChildren(self) -> None: ...
    def ls(self, indent: str = ...) -> None: ...
