__all__ = ['ParticlePanel']

import tkinter
from typing import Any, SupportsInt
from typing_extensions import Literal, TypeAlias

import Pmw  # type: ignore[import]
from direct.particles.ForceGroup import ForceGroup
from direct.particles.ParticleEffect import ParticleEffect
from direct.tkwidgets.AppShell import AppShell
from direct.tkwidgets.Dial import AngleDial
from direct.tkwidgets.Floater import Floater
from direct.tkwidgets.Slider import Slider
from direct.tkwidgets.VectorWidgets import ColorEntry, Vector2Entry, Vector3Entry
from panda3d._typing import Vec3Like, Vec4Like
from panda3d.core import LVecBase2f
from panda3d.physics import BaseForce

_TkSide: TypeAlias = Literal['left', 'right', 'top', 'bottom']

class ParticlePanel(AppShell):
    particleEffect: ParticleEffect
    effectsDict: dict[str, ParticleEffect]
    forcePagesDict: dict
    particleMgrActive: tkinter.IntVar
    effectsLabel: tkinter.Menubutton
    effectsLabelMenu: tkinter.Menu
    effectsEnableMenu: tkinter.Menu
    particlesLabel: tkinter.Menubutton
    particlesLabelMenu: tkinter.Menu
    particlesEnableMenu: tkinter.Menu
    forceGroupLabel: tkinter.Menubutton
    forceGroupLabelMenu: tkinter.Menu
    forceGroupEnableMenu: tkinter.Menu
    mainNotebook: Pmw.NoteBook
    factoryNotebook: Pmw.NoteBook
    emissionType: tkinter.IntVar
    emitterNotebook: Pmw.NoteBook
    ringCustomFrame: tkinter.Frame
    rendererNotebook: Pmw.NoteBook
    rendererGeomNode: tkinter.StringVar
    rendererGeomNodeEntry: tkinter.Entry
    rendererGeomSegmentFrame: tkinter.Frame
    rendererSegmentWidgetList: list[tkinter.Frame]
    rendererSpriteAnimationFrame: tkinter.Frame
    rendererSpriteAnimationWidgetList: list[tkinter.Frame]
    rendererSpriteTexture: tkinter.StringVar
    rendererSpriteFile: tkinter.StringVar
    rendererSpriteNode: tkinter.StringVar
    rendererSpriteSegmentFrame: tkinter.Frame
    addForceButton: tkinter.Menubutton
    sf: Pmw.ScrolledFrame
    forceFrame: tkinter.Frame
    forceGroupNotebook: Pmw.NoteBook
    def __init__(self, particleEffect: ParticleEffect | None = ..., **kw) -> None: ...
    def createCheckbutton(
        self, parent: tkinter.Misc | None, category: str, text: str, balloonHelp, command, initialState, side: _TkSide = ...
    ) -> tkinter.Checkbutton: ...
    def createRadiobutton(
        self,
        parent: tkinter.Misc | None,
        side: _TkSide,
        category: str,
        text: str,
        balloonHelp,
        variable: tkinter.Variable | Literal[''],
        value,
        command,
    ) -> tkinter.Radiobutton: ...
    def createFloaters(self, parent, widgetDefinitions) -> list[Floater]: ...
    def createFloater(
        self,
        parent,
        category: str,
        text: str,
        balloonHelp,
        command=...,
        min: float = ...,
        max: float | None = ...,
        resolution: float | None = ...,
        numDigits: int | None = ...,
        **kw,
    ) -> Floater: ...
    def createAngleDial(self, parent, category: str, text: str, balloonHelp, command=..., **kw) -> AngleDial: ...
    def createSlider(
        self,
        parent,
        category: str,
        text: str,
        balloonHelp,
        command=...,
        min: float = ...,
        max: float = ...,
        resolution: float = ...,
        **kw,
    ) -> Slider: ...
    def createVector2Entry(self, parent, category: str, text: str, balloonHelp, command=..., **kw) -> Vector2Entry: ...
    def createVector3Entry(self, parent, category: str, text: str, balloonHelp, command=..., **kw) -> Vector3Entry: ...
    def createColorEntry(self, parent, category: str, text: str, balloonHelp, command=..., **kw) -> ColorEntry: ...
    def createOptionMenu(self, parent, category: str, text: str, balloonHelp, items, command) -> tkinter.StringVar: ...
    def createComboBox(
        self, parent, category: str, text: str, balloonHelp, items, command, history: int = ...
    ) -> Pmw.ComboBox: ...
    def updateMenusAndLabels(self) -> None: ...
    def updateLabels(self) -> None: ...
    def updateMenus(self) -> None: ...
    def updateEffectsMenus(self) -> None: ...
    def updateParticlesMenus(self) -> None: ...
    def updateForceGroupMenus(self) -> None: ...
    def selectEffectNamed(self, name: str) -> None: ...
    def toggleEffect(self, effect, var) -> None: ...
    def selectParticlesNamed(self, name: str) -> None: ...
    def toggleParticles(self, particles, var) -> None: ...
    def selectForceGroupNamed(self, name: str) -> None: ...
    def toggleForceGroup(self, forceGroup: ForceGroup, var) -> None: ...
    def toggleForce(self, force, pageName: str, variableName: str) -> None: ...
    def getWidget(self, category: str, text: str) -> Any: ...
    def getVariable(self, category: str, text: str) -> Any: ...
    def loadParticleEffectFromFile(self) -> None: ...
    def saveParticleEffectToFile(self) -> None: ...
    def toggleParticleMgr(self) -> None: ...
    def updateInfo(self, page: Literal['System', 'Factory', 'Emitter', 'Renderer', 'Force'] = ...) -> None: ...
    def toggleParticleEffect(self) -> None: ...
    def updateSystemWidgets(self) -> None: ...
    def setSystemPoolSize(self, value: SupportsInt) -> None: ...
    def setSystemBirthRate(self, value) -> None: ...
    def setSystemLitterSize(self, value: SupportsInt) -> None: ...
    def setSystemLitterSpread(self, value: SupportsInt) -> None: ...
    def setSystemLifespan(self, value: float) -> None: ...
    def toggleSystemLocalVelocity(self) -> None: ...
    def toggleSystemGrowsOlder(self) -> None: ...
    def setSystemPos(self, pos: Vec3Like) -> None: ...
    def setSystemHpr(self, pos: Vec3Like) -> None: ...
    def selectFactoryType(self, type) -> None: ...
    def selectFactoryPage(self) -> None: ...
    def updateFactoryWidgets(self) -> None: ...
    def setFactoryLifeSpan(self, value: float) -> None: ...
    def setFactoryLifeSpanSpread(self, value: float) -> None: ...
    def setFactoryParticleMass(self, value: float) -> None: ...
    def setFactoryParticleMassSpread(self, value: float) -> None: ...
    def setFactoryTerminalVelocity(self, value: float) -> None: ...
    def setFactoryTerminalVelocitySpread(self, value: float) -> None: ...
    def setFactoryZSpinInitialAngle(self, angle: float) -> None: ...
    def setFactoryZSpinInitialAngleSpread(self, spread: float) -> None: ...
    def setFactoryZSpinFinalAngle(self, angle: float) -> None: ...
    def setFactoryZSpinFinalAngleSpread(self, spread: float) -> None: ...
    def setFactoryZSpinAngularVelocity(self, vel: float) -> None: ...
    def setFactoryZSpinAngularVelocitySpread(self, spread: float) -> None: ...
    def selectEmitterType(self, type) -> None: ...
    def selectEmitterPage(self) -> None: ...
    def updateEmitterWidgets(self) -> None: ...
    def setEmissionType(self, newType: int | None = ...) -> None: ...
    def setEmitterAmplitude(self, value: float) -> None: ...
    def setEmitterAmplitudeSpread(self, value: float) -> None: ...
    def setEmitterOffsetForce(self, vec: Vec3Like) -> None: ...
    def setEmitterRadiateOrigin(self, origin: Vec3Like) -> None: ...
    def setEmitterExplicitLaunchVector(self, vec: Vec3Like) -> None: ...
    def setEmitterBoxPoint1(self, point: Vec3Like) -> None: ...
    def setEmitterBoxPoint2(self, point: Vec3Like) -> None: ...
    def setEmitterDiscRadius(self, radius: float) -> None: ...
    def setEmitterDiscInnerAngle(self, angle: float) -> None: ...
    def setEmitterDiscInnerVelocity(self, velocity: float) -> None: ...
    def setEmitterDiscOuterAngle(self, angle: float) -> None: ...
    def setEmitterDiscOuterVelocity(self, velocity: float) -> None: ...
    def toggleEmitterDiscCubicLerping(self) -> None: ...
    def setEmitterLinePoint1(self, point: Vec3Like) -> None: ...
    def setEmitterLinePoint2(self, point: Vec3Like) -> None: ...
    def setEmitterPointPosition(self, pos: Vec3Like) -> None: ...
    def setEmitterRectanglePoint1(self, point: LVecBase2f) -> None: ...
    def setEmitterRectanglePoint2(self, point: LVecBase2f) -> None: ...
    def setEmitterRingRadius(self, radius: float) -> None: ...
    def setEmitterRingRadiusSpread(self, radiusSpread: float) -> None: ...
    def setEmitterRingLaunchAngle(self, angle: float) -> None: ...
    def setEmitterSphereSurfaceRadius(self, radius: float) -> None: ...
    def setEmitterSphereVolumeRadius(self, radius: float) -> None: ...
    def setEmitterTangentRingRadius(self, radius: float) -> None: ...
    def setEmitterTangentRingRadiusSpread(self, radiusSpread: float) -> None: ...
    def selectRendererType(self, type) -> None: ...
    def updateRendererWidgets(self) -> None: ...
    def selectRendererPage(self) -> None: ...
    def setRendererAlphaMode(
        self, alphaMode: Literal['NO_ALPHA', 'ALPHA_OUT', 'ALPHA_IN', 'ALPHA_IN_OUT', 'ALPHA_USER']
    ) -> None: ...
    def setRendererUserAlpha(self, alpha: float) -> None: ...
    def setRendererLineHeadColor(self, color: Vec4Like) -> None: ...
    def setRendererLineTailColor(self, color: Vec4Like) -> None: ...
    def setRendererLineScaleFactor(self, sf) -> None: ...
    def setRendererGeomNode(self, event) -> None: ...
    def setRendererPointSize(self, size) -> None: ...
    def setRendererPointStartColor(self, color) -> None: ...
    def setRendererPointEndColor(self, color) -> None: ...
    def rendererPointSelectBlendType(self, blendType: Literal['PP_ONE_COLOR', 'PP_BLEND_LIFE', 'PP_BLEND_VEL']) -> None: ...
    def rendererPointSelectBlendMethod(
        self, blendMethod: Literal['PP_NO_BLEND', 'PP_BLEND_LINEAR', 'PP_BLEND_CUBIC']
    ) -> None: ...
    def setRendererSparkleCenterColor(self, color) -> None: ...
    def setRendererSparkleEdgeColor(self, color) -> None: ...
    def setRendererSparkleBirthRadius(self, radius: float) -> None: ...
    def setRendererSparkleDeathRadius(self, radius: float) -> None: ...
    def setRendererSparkleLifeScale(self, lifeScaleMethod: str) -> None: ...
    def setSpriteSourceType(self) -> None: ...
    def setRendererSpriteAnimationFrameRate(self, rate: float) -> None: ...
    def setRendererSpriteAnimationEnable(self) -> None: ...
    def addRendererSpriteAnimationTexture(self) -> None: ...
    def addRendererSpriteAnimationFromNode(self) -> None: ...
    def toggleRendererSpriteXScale(self) -> None: ...
    def toggleRendererSpriteYScale(self) -> None: ...
    def toggleRendererSpriteAnimAngle(self) -> None: ...
    def toggleAngularVelocity(self) -> None: ...
    def setRendererSpriteInitialXScale(self, xScale: float) -> None: ...
    def setRendererSpriteFinalXScale(self, xScale: float) -> None: ...
    def setRendererSpriteInitialYScale(self, yScale: float) -> None: ...
    def setRendererSpriteFinalYScale(self, yScale: float) -> None: ...
    def setRendererSpriteNonAnimatedTheta(self, theta: float) -> None: ...
    def setRendererSpriteBlendMethod(self, blendMethod: str) -> None: ...
    def toggleRendererSpriteAlphaDisable(self) -> None: ...
    def setRendererColorBlendAttrib(
        self, rendererName: str, blendMethodStr: str, incomingOperandStr: str, fbufferOperandStr: str
    ) -> None: ...
    def setRendererSpriteColorBlendMethod(self, blendMethod: str) -> None: ...
    def setRendererSpriteColorBlendIncomingOperand(self, operand: str) -> None: ...
    def setRendererSpriteColorBlendFbufferOperand(self, operand: str) -> None: ...
    def toggleRendererGeomXScale(self) -> None: ...
    def toggleRendererGeomYScale(self) -> None: ...
    def toggleRendererGeomZScale(self) -> None: ...
    def setRendererGeomInitialXScale(self, xScale: float) -> None: ...
    def setRendererGeomFinalXScale(self, xScale: float) -> None: ...
    def setRendererGeomInitialYScale(self, yScale: float) -> None: ...
    def setRendererGeomFinalYScale(self, yScale: float) -> None: ...
    def setRendererGeomInitialZScale(self, zScale: float) -> None: ...
    def setRendererGeomFinalZScale(self, zScale: float) -> None: ...
    def setRendererGeomColorBlendMethod(self, blendMethod: str) -> None: ...
    def setRendererGeomColorBlendIncomingOperand(self, operand: str) -> None: ...
    def setRendererGeomColorBlendFbufferOperand(self, operand: str) -> None: ...
    def addConstantInterpolationSegment(self, id=...) -> None: ...
    def addLinearInterpolationSegment(self, id=...) -> None: ...
    def addStepwaveInterpolationSegment(self, id=...) -> None: ...
    def addSinusoidInterpolationSegment(self, id=...) -> None: ...
    def createWidgetForExistingInterpolationSegment(self, id) -> None: ...
    def createInterpolationSegmentFrame(self, parent, segName: str, seg) -> tkinter.Frame: ...
    def createConstantInterpolationSegmentWidget(self, parent, segName: str, segment) -> tkinter.Frame: ...
    def createLinearInterpolationSegmentWidget(self, parent, segName: str, segment) -> tkinter.Frame: ...
    def createStepwaveInterpolationSegmentWidget(self, parent, segName: str, segment) -> tkinter.Frame: ...
    def createSinusoidInterpolationSegmentWidget(self, parent, segName: str, segment) -> tkinter.Frame: ...
    def createSpriteAnimationFrame(self, parent, anim, animName: str) -> tkinter.Frame: ...
    def createSpriteAnimationTextureWidget(self, parent, anim, animName: str) -> tkinter.Frame: ...
    def createSpriteAnimationNodeWidget(self, parent, anim, animName: str) -> tkinter.Frame: ...
    def readSpriteRendererAnimations(self) -> None: ...
    def writeSpriteRendererAnimations(self) -> None: ...
    def updateForceWidgets(self) -> None: ...
    def addLinearVectorForce(self) -> None: ...
    def addLinearFrictionForce(self) -> None: ...
    def addLinearJitterForce(self) -> None: ...
    def addLinearNoiseForce(self) -> None: ...
    def addLinearSinkForce(self) -> None: ...
    def addLinearSourceForce(self) -> None: ...
    def addLinearCylinderVortexForce(self) -> None: ...
    def addLinearUserDefinedForce(self) -> None: ...
    def addForce(self, f) -> None: ...
    def createNewEffect(self) -> None: ...
    def createNewParticles(self) -> None: ...
    def createNewForceGroup(self) -> None: ...
    def addForceGroupNotebookPage(self, particleEffect, forceGroup: ForceGroup) -> None: ...
    def addForceWidget(self, forceGroup: ForceGroup, force: BaseForce) -> None: ...
    def createForceFrame(self, forcePage, forceName, force: BaseForce): ...
    def createLinearForceWidgets(self, frame, pageName: str, forceName: str, force) -> None: ...
    def createForceActiveWidget(self, frame, pageName: str, forceName: str, force) -> None: ...
    def createLinearVectorForceWidget(self, forcePage, pageName: str, count: int, force) -> None: ...
    def createLinearRandomForceWidget(self, forcePage, pageName: str, count: int, force, type) -> None: ...
    def createLinearFrictionForceWidget(self, forcePage, pageName: str, count: int, force) -> None: ...
    def createLinearCylinderVortexForceWidget(self, forcePage, pageName: str, count: int, force) -> None: ...
    def createLinearDistanceForceWidget(self, forcePage, pageName: str, count: int, force, type) -> None: ...
