from typing import TypeVar, overload
from typing_extensions import Literal

from panda3d.core import AmbientLight, DirectionalLight, NodePath, PandaNode, PointLight, Spotlight

_N = TypeVar('_N', bound=PandaNode)

class DirectLight(NodePath[_N]):
    light: _N
    def __init__(self, light: _N, parent: NodePath) -> None: ...
    def getName(self) -> str: ...  # type: ignore[override]
    def getLight(self) -> _N: ...

class DirectLights(NodePath[PandaNode]):
    lightDict: dict[str, DirectLight]
    ambientCount: int
    directionalCount: int
    pointCount: int
    spotCount: int
    def __init__(self, parent: NodePath | None = ...) -> None: ...
    def __getitem__(self, name: str) -> DirectLight | None: ...
    def __len__(self) -> int: ...
    def delete(self, light: DirectLight) -> None: ...
    def deleteAll(self) -> None: ...
    def asList(self) -> list[DirectLight | None]: ...
    def getNameList(self) -> list[str]: ...
    @overload
    def create(self, type: Literal['ambient']) -> DirectLight[AmbientLight]: ...  # type: ignore[misc]
    @overload
    def create(self, type: Literal['directional']) -> DirectLight[DirectionalLight]: ...  # type: ignore[misc]
    @overload
    def create(self, type: Literal['point']) -> DirectLight[PointLight]: ...  # type: ignore[misc]
    @overload
    def create(self, type: Literal['spot']) -> DirectLight[Spotlight]: ...  # type: ignore[misc]
    @overload
    def create(self, type: str) -> None: ...
    def createDefaultLights(self) -> None: ...
    def allOn(self) -> None: ...
    def allOff(self) -> None: ...
    def toggle(self) -> None: ...
    def setOn(self, directLight: DirectLight) -> None: ...
    def setOff(self, directLight: DirectLight) -> None: ...
