from collections.abc import Iterable, Sequence
from typing import overload

from panda3d._typing import Vec3Like, Vec4Like
from panda3d.core import GeomNode, LColor, LineSegs, LPoint3f, LQuaternionf, LVecBase2f, LVecBase3f, LVector3f, NodePath

class LineNodePath(NodePath[GeomNode]):
    lineNode: GeomNode
    lineSegs: LineSegs
    def __init__(
        self, parent: NodePath | None = ..., name: str | None = ..., thickness: float = ..., colorVec: Vec4Like = ...
    ) -> None: ...
    @overload
    def moveTo(self, __v: Vec3Like) -> None: ...
    @overload
    def moveTo(self, __x: float, __y: float, __z: float) -> None: ...
    @overload
    def drawTo(self, __v: Vec3Like) -> None: ...
    @overload
    def drawTo(self, __x: float, __y: float, __z: float) -> None: ...
    def create(self, frameAccurate: bool = ...) -> None: ...
    def reset(self) -> None: ...
    def isEmpty(self) -> bool: ...  # type: ignore[override]
    def setThickness(self, thickness: float) -> None: ...
    @overload  # type: ignore[override]
    def setColor(self, __color: Vec4Like) -> None: ...
    @overload
    def setColor(self, __r: float, __g: float, __b: float, __a: float) -> None: ...
    @overload
    def setVertex(self, __n: int, __vert: Vec3Like) -> None: ...
    @overload
    def setVertex(self, __vertex: int, __x: float, __y: float, __z: float) -> None: ...
    @overload
    def setVertexColor(self, vertex: int, __c: Vec4Like) -> None: ...
    @overload
    def setVertexColor(self, vertex: int, __r: float, __g: float, __b: float, __a: float = ...) -> None: ...
    def getCurrentPosition(self) -> LPoint3f: ...
    def getNumVertices(self) -> int: ...
    def getVertex(self, index: int) -> LPoint3f: ...
    def getVertexColor(self) -> LColor: ...
    def drawArrow(self, sv: Vec3Like, ev: Vec3Like, arrowAngle: float, arrowLength: float) -> None: ...
    def drawArrow2d(self, sv: Vec3Like, ev: Vec3Like, arrowAngle: float, arrowLength: float) -> None: ...
    def drawLines(self, lineList: Iterable[Sequence[Vec3Like]]) -> None: ...

def planeIntersect(lineOrigin: Vec3Like, lineDir: LVecBase3f, planeOrigin: LVecBase3f, normal: Vec3Like) -> LVecBase3f: ...
def getNearProjectionPoint(nodePath: NodePath) -> LPoint3f: ...
def getScreenXY(nodePath: NodePath) -> LVector3f: ...
def getCrankAngle(center: LVecBase2f) -> float: ...
def relHpr(nodePath: NodePath, base: NodePath, h: float, p: float, r: float) -> None: ...
def qSlerp(startQuat: Vec4Like, endQuat: LQuaternionf, t: float) -> LQuaternionf: ...
