## Web-Extractor (python3)

Web-Extractor 支持Python 3.6+，旨在更方便更智能提取Html中所需内容。

主要用途对新闻的页面进行处理，剔除其中的html标签、超链接、脚本代码等内容，抽取出网页的标题、正文、作者、发布时间等信息

#### 建议安装方法
    pip install web-extractor

#### 升级方法
    pip install web-extractor --upgrade

#### 使用方法

```buildoutcfg
from web_extractor import NewsExtractor

extractor = NewsExtractor()
result = extractor.extract(url, title_xpath='//title/text()')
print(result)
```
```buildoutcfg
{'title': '兵马俑VS自由女神！这段视频在国外火了', 'author': '张义凌', 'publish_time': '2020-05-03T18:13:02+08:00', 'keywords': '特朗普,推特,新冠肺炎', 'description': '原标题：兵马俑VS自由女神！这段视频在国外火了', 'content': '原标题：兵马俑VS自由女神！这段视频在国外火了\n新华社在其推特上发布的一则名为《病毒往事》的视频\n“我们发现了一种新病毒，它很危险......”“这只是一种流感！”\n4月30日，新华社在其推特上发布了一则名为《病毒往事》（Once upon a Virus）的视频，获得广泛关注。\n视频中，代表中国的兵马俑乐高小人不断地向世界发布新冠病毒的有效信息，而代表美国的自由女神乐高小人，则不断地予以否认。\n最终，自由女神乐高小人红起了脸，打起了点滴.....\n截至发稿，该视频获得152余万次观看，1.5万次转推，以及2.8万次赞。\n视频一经发布，立刻获得了推特网友和西方主流媒体的注意。尽管包括澳大利亚广播公司（ABC）在内的媒体，不怀好意地将其称为中国的“政治宣传”，但大部分理性的网友还是表示：视频所言不虚，特朗普政府的应对实在太差。\n《病毒往事》：美国漠视警告，抹黑中国\n一开端，时间显示为一月，一个戴着口罩的兵马俑乐高小人出现在了画面左侧，向世界发出了警告：“（我们）出现了奇怪的肺炎病例。”随后，世卫组织（WHO）出现在了右侧回应称：“收到！”\n时间演到了一月，兵马俑小人继续发布针对新冠肺炎的警告信息：这是一种新病毒，它很危险，我们得戴口罩了，还要待在家里。我们只用十天时间就建起了一座医院......\n自由女神小人则不断地对警告信息进行否认：这只是一种流感，无需戴口罩。至于隔离令？这是“侵犯人权”！只用十天建造一座医院？这是“炫耀”。\n二月后，兵马俑小人口中的疫情形势愈发严峻：新冠肺炎患者挤满了医院，医生英勇牺牲，病毒通过空气传播。但与此同时，小人背后出现不断地有新的医生补进，象征着当时中国举全国之力支援湖北，“白衣天使”们无私奉献抗击疫情。\n兵马俑小人背后不断有医护工作人员补进\n但自由女神小人还是不当回事。除了老调重弹把中国的隔离令称为“侵犯人权”外，还宣称病毒会在四月“奇迹般消失”。\n3月，中国的确诊病例数下降，画面中出现的比萨斜塔则表明，疫情的震中已从中国转向了欧洲，此时自由女神小人开始抹黑中国“撒谎”、“数据造假”，但小人的面部开始变红，还打起了点滴。\n自由女神小人面部变红，打起点滴\n四月，看起来状况不佳的自由女神小人开始了“胡言乱语”：“病毒一点不危险，但数百万中国人死了，即便病毒不危险，我们是对的......我们三个月什么也没干，因为世卫组织认同中国，我们要停止给其提供资金。”\n兵马俑小人无奈表示：“你真的有在听自己在说什么吗？”\n最终，自由女神小人说道：“我们一直是正确的，即便我们的说法自相矛盾。”此时，自由女神小人的嘴上戴上了口罩。\n视频在最后兵马俑小人的“神吐槽”中结尾：“这就是我最爱你们美国人的地方——你们的一贯性。”\n澳媒不怀好意报道，网友：这怎么能叫“政治宣传”？\n一经发布，《病毒往事》立刻获得了大量网友的关注和评论。截至发稿，新华社的这则视频在推特上已经获得了152万次观看，1.5万余次转推，以及2.8万余个赞。除中国驻法大使馆转推以外，包括美国《新闻周刊》、法国《费加罗报》以及澳大利亚广播公司（ABC）在内的西方主流媒体，都对此进行了报道。\n虽然这些媒体都不怀好意地将此视频称为中国的“政治宣传”，但他们也承认，其中自由女神小人的话语，确实都有理可依。例如，自由女神小人曾说，病毒会在四月“奇迹般消失”，此处引用的，正是特朗普今年2月所言：“很多人都认为它们会在4月消失，因为到时候天气就热了，温度高了，一般而言，高温会杀死这样的病毒。”\n相关新闻的推特下方，大多数理性网友都认为，视频所言不虚，特朗普政府的确应对太差，而针对西方媒体“政治宣传”的指控，网友则质问：这都是事实，怎么能叫政治宣传呢？\n新华社源视频下，获赞数最高的一条评论贴出视频，展现了自中国出现疫情以来，特朗普举行竞选集会、打高尔夫、否认病毒危险性的视频。该网友还评论称：“世卫组织早在1月就发出了关于新冠肺炎的警告，与此同时特朗普却在打高尔夫（小丑）。”\n截至发稿，该评论获得了1754个赞\nABC报道的推特下方，获赞数最高的一条评论指出，（到现在）特朗普仍旧不会明白（疫情严重性）。\n获赞数第二高的评论表示：“（视频）正确展示了所有无能政府忽略真实信息的事实，澳大利亚没有问题，美国需要向总统质问真相。”\n当然，评论中不乏网友指责、抹黑中国，但恰如一位网友所说：“喜欢看你们在这否定这个视频，你们就像视频里展现的西方一样。”\n还有更多人讨论起了西方媒体评论这则视频时使用的“政治宣传”一词：“不管这是不是政治宣传，视频里对美国的描绘都挺到位的。”\n“你为什么管这个叫政治宣传？对我来说，这（视频）就像一个简单的事实宣言集合。”\n来源：观察者网\xa0赵挪亚\n责任编辑：张义凌', 'images': ['//n.sinaimg.cn/sinakd202052s/591/w599h792/20200502/a69a-isyparh1975208.jpg', '//n.sinaimg.cn/sinakd202052s/173/w639h334/20200502/362e-isyparh1975259.gif', '//n.sinaimg.cn/sinakd202052s/67/w1080h587/20200502/ca58-isyparh1975254.jpg', '//n.sinaimg.cn/sinakd202052s/510/w598h712/20200502/9e60-isyparh1975305.jpg', '//n.sinaimg.cn/sinakd202052s/82/w599h283/20200502/b230-isyparh1975350.jpg', '//n.sinaimg.cn/sinakd202052s/133/w592h341/20200502/9686-isyparh1975349.jpg', '//n.sinaimg.cn/sinakd202052s/108/w597h311/20200502/2378-isyparh1975397.jpg', '//n.sinaimg.cn/sinakd202052s/799/w602h197/20200502/e207-isyparh1975395.jpg', '//n.sinaimg.cn/sinakd202052s/769/w601h168/20200502/25ac-isyparh1975447.jpg', '//n.sinaimg.cn/sinakd202052s/751/w1080h471/20200502/43fd-isyparh1975454.png']}

```

#### 各个参数的意义如下：

url(str):  目标网页网址 与html二选一必填

html(str): 目标网站的源代码 与url二选一必填

title_xpath(str): 新闻标题的 XPath，用于定向提取标题

host(str): 图片所在的域名，例如``https://www.sina.com``, 那么，当从新闻网站提取到图片的相对连接``/images/XXX.png``时，会把 host 拼接上去，变成``https://www.sina.com/images/XXX.png``

noise_node_list(List[str]): 一个包含 XPath 的列表。这个列表中的 XPath 对应的标签，会在预处理时被直接删除掉，从而避免他们影响新闻正文的提取

author_xpath(str): 文章作者的 XPath，用于定向提取文章作者

keywords_xpath(str): 文章关键词的 XPath，用于定向提取文章关键词

description_xpath(str): 文章简介的 XPath，用于定向提取文章简介

publish_time_xpath(str): 文章发布时间的 XPath，用于定向提取文章发布时间

with_body_html(bool): 默认为 False，此时，返回的提取结果不含新闻正文所在标签的 HTML 源代码。当把它设置为 True 时，返回的结果会包含字段 body_html，内容是新闻正文所在标签的 HTML 源代码