"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DISABLE_METADATA_STACK_TRACE = exports.DISABLE_ASSET_STAGING_CONTEXT = exports.DISABLE_VERSION_REPORTING = exports.PATH_METADATA_ENABLE_CONTEXT = void 0;
// --------------------------------------------------------------------------------
// This file declares context keys that are used by the CLI to control the
// behavior of CDK apps. Contrary to feature flags (which are defined under
// `features.ts`) these options are not bound to be removed in the next major
// version.
// --------------------------------------------------------------------------------
/**
 * Enables the embedding of the "aws:cdk:path" in CloudFormation template metadata.
 */
exports.PATH_METADATA_ENABLE_CONTEXT = 'aws:cdk:enable-path-metadata';
/**
 * Disable the collection and reporting of version information.
 */
exports.DISABLE_VERSION_REPORTING = 'aws:cdk:disable-version-reporting';
/**
 * If this is set, asset staging is disabled. This means that assets will not be copied to
 * the output directory and will be referenced with absolute source paths.
 */
exports.DISABLE_ASSET_STAGING_CONTEXT = 'aws:cdk:disable-asset-staging';
/**
 * If this context key is set, the CDK will stage assets under the specified
 * directory. Otherwise, assets will not be staged.
 * Omits stack traces from construct metadata entries.
 */
exports.DISABLE_METADATA_STACK_TRACE = 'aws:cdk:disable-stack-trace';
//# sourceMappingURL=data:application/json;base64,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