"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NestedStackSynthesizer = void 0;
/**
 * Deployment environment for a nested stack
 *
 * Interoperates with the StackSynthesizer of the parent stack.
 */
class NestedStackSynthesizer {
    constructor(parentDeployment) {
        this.parentDeployment = parentDeployment;
    }
    bind(_stack) {
        // Nothing to do
    }
    addFileAsset(asset) {
        // Forward to parent deployment. By the magic of cross-stack references any parameter
        // returned and used will magically be forwarded to the nested stack.
        return this.parentDeployment.addFileAsset(asset);
    }
    addDockerImageAsset(asset) {
        // Forward to parent deployment. By the magic of cross-stack references any parameter
        // returned and used will magically be forwarded to the nested stack.
        return this.parentDeployment.addDockerImageAsset(asset);
    }
    synthesizeStackArtifacts(_session) {
        // Do not emit Nested Stack as a cloud assembly artifact.
        // It will be registered as an S3 asset of its parent instead.
    }
}
exports.NestedStackSynthesizer = NestedStackSynthesizer;
//# sourceMappingURL=data:application/json;base64,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