import { DockerImageAssetLocation, DockerImageAssetSource, FileAssetLocation, FileAssetSource } from '../assets';
import { ISynthesisSession } from '../construct-compat';
import { Stack } from '../stack';
import { IStackSynthesizer } from './types';
/**
 * Use the original deployment environment
 *
 * This deployment environment is restricted in cross-environment deployments,
 * CI/CD deployments, and will use up CloudFormation parameters in your template.
 *
 * This is the only StackSynthesizer that supports customizing asset behavior
 * by overriding `Stack.addFileAsset()` and `Stack.addDockerImageAsset()`.
 */
export declare class LegacyStackSynthesizer implements IStackSynthesizer {
    private stack?;
    private cycle;
    /**
     * Includes all parameters synthesized for assets (lazy).
     */
    private _assetParameters?;
    /**
     * The image ID of all the docker image assets that were already added to this
     * stack (to avoid duplication).
     */
    private readonly addedImageAssets;
    bind(stack: Stack): void;
    addFileAsset(asset: FileAssetSource): FileAssetLocation;
    addDockerImageAsset(asset: DockerImageAssetSource): DockerImageAssetLocation;
    synthesizeStackArtifacts(session: ISynthesisSession): void;
    private doAddDockerImageAsset;
    private doAddFileAsset;
    private get assetParameters();
}
