"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SymlinkFollowMode = void 0;
/**
 * Determines how symlinks are followed.
 */
var SymlinkFollowMode;
(function (SymlinkFollowMode) {
    /**
     * Never follow symlinks.
     */
    SymlinkFollowMode["NEVER"] = "never";
    /**
     * Materialize all symlinks, whether they are internal or external to the source directory.
     */
    SymlinkFollowMode["ALWAYS"] = "always";
    /**
     * Only follows symlinks that are external to the source directory.
     */
    SymlinkFollowMode["EXTERNAL"] = "external";
    /**
     * Forbids source from having any symlinks pointing outside of the source
     * tree.
     *
     * This is the safest mode of operation as it ensures that copy operations
     * won't materialize files from the user's file system. Internal symlinks are
     * not followed.
     *
     * If the copy operation runs into an external symlink, it will fail.
     */
    SymlinkFollowMode["BLOCK_EXTERNAL"] = "internal-only";
})(SymlinkFollowMode = exports.SymlinkFollowMode || (exports.SymlinkFollowMode = {}));
//# sourceMappingURL=data:application/json;base64,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