/**
 * A Condition for use in a Choice state branch
 */
export declare abstract class Condition {
    /**
     * Matches if a boolean field has the given value
     */
    static booleanEquals(variable: string, value: boolean): Condition;
    /**
     * Matches if a string field has the given value
     */
    static stringEquals(variable: string, value: string): Condition;
    /**
     * Matches if a string field sorts before a given value
     */
    static stringLessThan(variable: string, value: string): Condition;
    /**
     * Matches if a string field sorts equal to or before a given value
     */
    static stringLessThanEquals(variable: string, value: string): Condition;
    /**
     * Matches if a string field sorts after a given value
     */
    static stringGreaterThan(variable: string, value: string): Condition;
    /**
     * Matches if a string field sorts after or equal to a given value
     */
    static stringGreaterThanEquals(variable: string, value: string): Condition;
    /**
     * Matches if a numeric field has the given value
     */
    static numberEquals(variable: string, value: number): Condition;
    /**
     * Matches if a numeric field is less than the given value
     */
    static numberLessThan(variable: string, value: number): Condition;
    /**
     * Matches if a numeric field is less than or equal to the given value
     */
    static numberLessThanEquals(variable: string, value: number): Condition;
    /**
     * Matches if a numeric field is greater than the given value
     */
    static numberGreaterThan(variable: string, value: number): Condition;
    /**
     * Matches if a numeric field is greater than or equal to the given value
     */
    static numberGreaterThanEquals(variable: string, value: number): Condition;
    /**
     * Matches if a timestamp field is the same time as the given timestamp
     */
    static timestampEquals(variable: string, value: string): Condition;
    /**
     * Matches if a timestamp field is before the given timestamp
     */
    static timestampLessThan(variable: string, value: string): Condition;
    /**
     * Matches if a timestamp field is before or equal to the given timestamp
     */
    static timestampLessThanEquals(variable: string, value: string): Condition;
    /**
     * Matches if a timestamp field is after the given timestamp
     */
    static timestampGreaterThan(variable: string, value: string): Condition;
    /**
     * Matches if a timestamp field is after or equal to the given timestamp
     */
    static timestampGreaterThanEquals(variable: string, value: string): Condition;
    /**
     * Combine two or more conditions with a logical AND
     */
    static and(...conditions: Condition[]): Condition;
    /**
     * Combine two or more conditions with a logical OR
     */
    static or(...conditions: Condition[]): Condition;
    /**
     * Negate a condition
     */
    static not(condition: Condition): Condition;
    /**
     * Render Amazon States Language JSON for the condition
     */
    abstract renderCondition(): any;
}
