"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvokeActivity = void 0;
/**
 * A Step Functions Task to invoke an Activity worker.
 *
 * An Activity can be used directly as a Resource.
 *
 * @deprecated - use `StepFunctionsInvokeActivity`
 */
class InvokeActivity {
    constructor(activity, props = {}) {
        this.activity = activity;
        this.props = props;
    }
    bind(_task) {
        return {
            resourceArn: this.activity.activityArn,
            metricDimensions: { ActivityArn: this.activity.activityArn },
            heartbeat: this.props.heartbeat,
            // No IAM permissions necessary, execution role implicitly has Activity permissions.
            metricPrefixSingular: 'Activity',
            metricPrefixPlural: 'Activities',
        };
    }
}
exports.InvokeActivity = InvokeActivity;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW52b2tlLWFjdGl2aXR5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW52b2tlLWFjdGl2aXR5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQWVBOzs7Ozs7R0FNRztBQUNILE1BQWEsY0FBYztJQUN2QixZQUE2QixRQUF1QixFQUFtQixRQUE2QixFQUFFO1FBQXpFLGFBQVEsR0FBUixRQUFRLENBQWU7UUFBbUIsVUFBSyxHQUFMLEtBQUssQ0FBMEI7SUFDdEcsQ0FBQztJQUNNLElBQUksQ0FBQyxLQUFlO1FBQ3ZCLE9BQU87WUFDSCxXQUFXLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxXQUFXO1lBQ3RDLGdCQUFnQixFQUFFLEVBQUUsV0FBVyxFQUFFLElBQUksQ0FBQyxRQUFRLENBQUMsV0FBVyxFQUFFO1lBQzVELFNBQVMsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFNBQVM7WUFDL0Isb0ZBQW9GO1lBQ3BGLG9CQUFvQixFQUFFLFVBQVU7WUFDaEMsa0JBQWtCLEVBQUUsWUFBWTtTQUNuQyxDQUFDO0lBQ04sQ0FBQztDQUNKO0FBYkQsd0NBYUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBzZm4gZnJvbSBcIi4uLy4uL2F3cy1zdGVwZnVuY3Rpb25zXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3Mtc3RlcGZ1bmN0aW9ucydcbmltcG9ydCB7IER1cmF0aW9uIH0gZnJvbSBcIi4uLy4uL2NvcmVcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2NvcmUnXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIEZ1bmN0aW9uVGFza1xuICovXG5leHBvcnQgaW50ZXJmYWNlIEludm9rZUFjdGl2aXR5UHJvcHMge1xuICAgIC8qKlxuICAgICAqIE1heGltdW0gdGltZSBiZXR3ZWVuIGhlYXJ0IGJlYXRzXG4gICAgICpcbiAgICAgKiBJZiB0aGUgdGltZSBiZXR3ZWVuIGhlYXJ0IGJlYXRzIHRha2VzIGxvbmdlciB0aGFuIHRoaXMsIGEgJ1RpbWVvdXQnIGVycm9yIGlzIHJhaXNlZC5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IE5vIGhlYXJ0IGJlYXQgdGltZW91dFxuICAgICAqL1xuICAgIHJlYWRvbmx5IGhlYXJ0YmVhdD86IER1cmF0aW9uO1xufVxuLyoqXG4gKiBBIFN0ZXAgRnVuY3Rpb25zIFRhc2sgdG8gaW52b2tlIGFuIEFjdGl2aXR5IHdvcmtlci5cbiAqXG4gKiBBbiBBY3Rpdml0eSBjYW4gYmUgdXNlZCBkaXJlY3RseSBhcyBhIFJlc291cmNlLlxuICpcbiAqIEBkZXByZWNhdGVkIC0gdXNlIGBTdGVwRnVuY3Rpb25zSW52b2tlQWN0aXZpdHlgXG4gKi9cbmV4cG9ydCBjbGFzcyBJbnZva2VBY3Rpdml0eSBpbXBsZW1lbnRzIHNmbi5JU3RlcEZ1bmN0aW9uc1Rhc2sge1xuICAgIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgYWN0aXZpdHk6IHNmbi5JQWN0aXZpdHksIHByaXZhdGUgcmVhZG9ubHkgcHJvcHM6IEludm9rZUFjdGl2aXR5UHJvcHMgPSB7fSkge1xuICAgIH1cbiAgICBwdWJsaWMgYmluZChfdGFzazogc2ZuLlRhc2spOiBzZm4uU3RlcEZ1bmN0aW9uc1Rhc2tDb25maWcge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgcmVzb3VyY2VBcm46IHRoaXMuYWN0aXZpdHkuYWN0aXZpdHlBcm4sXG4gICAgICAgICAgICBtZXRyaWNEaW1lbnNpb25zOiB7IEFjdGl2aXR5QXJuOiB0aGlzLmFjdGl2aXR5LmFjdGl2aXR5QXJuIH0sXG4gICAgICAgICAgICBoZWFydGJlYXQ6IHRoaXMucHJvcHMuaGVhcnRiZWF0LFxuICAgICAgICAgICAgLy8gTm8gSUFNIHBlcm1pc3Npb25zIG5lY2Vzc2FyeSwgZXhlY3V0aW9uIHJvbGUgaW1wbGljaXRseSBoYXMgQWN0aXZpdHkgcGVybWlzc2lvbnMuXG4gICAgICAgICAgICBtZXRyaWNQcmVmaXhTaW5ndWxhcjogJ0FjdGl2aXR5JyxcbiAgICAgICAgICAgIG1ldHJpY1ByZWZpeFBsdXJhbDogJ0FjdGl2aXRpZXMnLFxuICAgICAgICB9O1xuICAgIH1cbn1cbiJdfQ==