"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Sns = exports.EmailEncoding = void 0;
/**
 * The type of email encoding to use for a SNS action.
 */
var EmailEncoding;
(function (EmailEncoding) {
    /**
     * Base 64
     */
    EmailEncoding["BASE64"] = "Base64";
    /**
     * UTF-8
     */
    EmailEncoding["UTF8"] = "UTF-8";
})(EmailEncoding = exports.EmailEncoding || (exports.EmailEncoding = {}));
/**
 * Publishes the email content within a notification to Amazon SNS.
 */
class Sns {
    constructor(props) {
        this.props = props;
    }
    bind(_rule) {
        return {
            snsAction: {
                encoding: this.props.encoding,
                topicArn: this.props.topic.topicArn,
            },
        };
    }
}
exports.Sns = Sns;
//# sourceMappingURL=data:application/json;base64,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