"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpNamespace = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const namespace_1 = require("./namespace");
const service_1 = require("./service");
const servicediscovery_generated_1 = require("./servicediscovery.generated");
/**
 * Define an HTTP Namespace
 */
class HttpNamespace extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        const ns = new servicediscovery_generated_1.CfnHttpNamespace(this, 'Resource', {
            name: props.name,
            description: props.description,
        });
        this.namespaceName = props.name;
        this.namespaceId = ns.attrId;
        this.namespaceArn = ns.attrArn;
        this.type = namespace_1.NamespaceType.HTTP;
    }
    static fromHttpNamespaceAttributes(scope, id, attrs) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.namespaceName = attrs.namespaceName;
                this.namespaceId = attrs.namespaceId;
                this.namespaceArn = attrs.namespaceArn;
                this.type = namespace_1.NamespaceType.HTTP;
            }
        }
        return new Import(scope, id);
    }
    /** @attribute */
    get httpNamespaceArn() { return this.namespaceArn; }
    /** @attribute */
    get httpNamespaceName() { return this.namespaceName; }
    /** @attribute */
    get httpNamespaceId() { return this.namespaceId; }
    /**
     * Creates a service within the namespace
     */
    createService(id, props) {
        return new service_1.Service(this, id, {
            namespace: this,
            ...props,
        });
    }
}
exports.HttpNamespace = HttpNamespace;
//# sourceMappingURL=data:application/json;base64,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