"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StorageClass = void 0;
/**
 * Storage class to move an object to
 */
class StorageClass {
    constructor(value) {
        this.value = value;
    }
    toString() { return this.value; }
}
exports.StorageClass = StorageClass;
/**
 * Storage class for data that is accessed less frequently, but requires rapid
 * access when needed.
 *
 * Has lower availability than Standard storage.
 */
StorageClass.INFREQUENT_ACCESS = new StorageClass('STANDARD_IA');
/**
 * Infrequent Access that's only stored in one availability zone.
 *
 * Has lower availability than standard InfrequentAccess.
 */
StorageClass.ONE_ZONE_INFREQUENT_ACCESS = new StorageClass('ONEZONE_IA');
/**
 * Storage class for long-term archival that can take between minutes and
 * hours to access.
 *
 * Use for archives where portions of the data might need to be retrieved in
 * minutes. Data stored in the GLACIER storage class has a minimum storage
 * duration period of 90 days and can be accessed in as little as 1-5 minutes
 * using expedited retrieval. If you delete an object before the 90-day
 * minimum, you are charged for 90 days.
 */
StorageClass.GLACIER = new StorageClass('GLACIER');
/**
 * Use for archiving data that rarely needs to be accessed. Data stored in the
 * DEEP_ARCHIVE storage class has a minimum storage duration period of 180
 * days and a default retrieval time of 12 hours. If you delete an object
 * before the 180-day minimum, you are charged for 180 days. For pricing
 * information, see Amazon S3 Pricing.
 */
StorageClass.DEEP_ARCHIVE = new StorageClass('DEEP_ARCHIVE');
/**
 * The INTELLIGENT_TIERING storage class is designed to optimize storage costs
 * by automatically moving data to the most cost-effective storage access
 * tier, without performance impact or operational overhead.
 * INTELLIGENT_TIERING delivers automatic cost savings by moving data on a
 * granular object level between two access tiers, a frequent access tier and
 * a lower-cost infrequent access tier, when access patterns change. The
 * INTELLIGENT_TIERING storage class is ideal if you want to optimize storage
 * costs automatically for long-lived data when access patterns are unknown or
 * unpredictable.
 */
StorageClass.INTELLIGENT_TIERING = new StorageClass('INTELLIGENT_TIERING');
//# sourceMappingURL=data:application/json;base64,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