import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::Pinpoint::ADMChannel`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-admchannel.html
 */
export interface CfnADMChannelProps {
    /**
     * `AWS::Pinpoint::ADMChannel.ApplicationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-admchannel.html#cfn-pinpoint-admchannel-applicationid
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::ADMChannel.ClientId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-admchannel.html#cfn-pinpoint-admchannel-clientid
     */
    readonly clientId: string;
    /**
     * `AWS::Pinpoint::ADMChannel.ClientSecret`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-admchannel.html#cfn-pinpoint-admchannel-clientsecret
     */
    readonly clientSecret: string;
    /**
     * `AWS::Pinpoint::ADMChannel.Enabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-admchannel.html#cfn-pinpoint-admchannel-enabled
     */
    readonly enabled?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Pinpoint::ADMChannel`
 *
 * @cloudformationResource AWS::Pinpoint::ADMChannel
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-admchannel.html
 */
export declare class CfnADMChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::ADMChannel";
    /**
     * `AWS::Pinpoint::ADMChannel.ApplicationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-admchannel.html#cfn-pinpoint-admchannel-applicationid
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::ADMChannel.ClientId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-admchannel.html#cfn-pinpoint-admchannel-clientid
     */
    clientId: string;
    /**
     * `AWS::Pinpoint::ADMChannel.ClientSecret`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-admchannel.html#cfn-pinpoint-admchannel-clientsecret
     */
    clientSecret: string;
    /**
     * `AWS::Pinpoint::ADMChannel.Enabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-admchannel.html#cfn-pinpoint-admchannel-enabled
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Pinpoint::ADMChannel`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnADMChannelProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::APNSChannel`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html
 */
export interface CfnAPNSChannelProps {
    /**
     * `AWS::Pinpoint::APNSChannel.ApplicationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-applicationid
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::APNSChannel.BundleId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-bundleid
     */
    readonly bundleId?: string;
    /**
     * `AWS::Pinpoint::APNSChannel.Certificate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-certificate
     */
    readonly certificate?: string;
    /**
     * `AWS::Pinpoint::APNSChannel.DefaultAuthenticationMethod`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-defaultauthenticationmethod
     */
    readonly defaultAuthenticationMethod?: string;
    /**
     * `AWS::Pinpoint::APNSChannel.Enabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-enabled
     */
    readonly enabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::APNSChannel.PrivateKey`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-privatekey
     */
    readonly privateKey?: string;
    /**
     * `AWS::Pinpoint::APNSChannel.TeamId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-teamid
     */
    readonly teamId?: string;
    /**
     * `AWS::Pinpoint::APNSChannel.TokenKey`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-tokenkey
     */
    readonly tokenKey?: string;
    /**
     * `AWS::Pinpoint::APNSChannel.TokenKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-tokenkeyid
     */
    readonly tokenKeyId?: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::APNSChannel`
 *
 * @cloudformationResource AWS::Pinpoint::APNSChannel
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html
 */
export declare class CfnAPNSChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::APNSChannel";
    /**
     * `AWS::Pinpoint::APNSChannel.ApplicationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-applicationid
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::APNSChannel.BundleId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-bundleid
     */
    bundleId: string | undefined;
    /**
     * `AWS::Pinpoint::APNSChannel.Certificate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-certificate
     */
    certificate: string | undefined;
    /**
     * `AWS::Pinpoint::APNSChannel.DefaultAuthenticationMethod`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-defaultauthenticationmethod
     */
    defaultAuthenticationMethod: string | undefined;
    /**
     * `AWS::Pinpoint::APNSChannel.Enabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-enabled
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::APNSChannel.PrivateKey`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-privatekey
     */
    privateKey: string | undefined;
    /**
     * `AWS::Pinpoint::APNSChannel.TeamId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-teamid
     */
    teamId: string | undefined;
    /**
     * `AWS::Pinpoint::APNSChannel.TokenKey`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-tokenkey
     */
    tokenKey: string | undefined;
    /**
     * `AWS::Pinpoint::APNSChannel.TokenKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-tokenkeyid
     */
    tokenKeyId: string | undefined;
    /**
     * Create a new `AWS::Pinpoint::APNSChannel`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAPNSChannelProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::APNSSandboxChannel`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html
 */
export interface CfnAPNSSandboxChannelProps {
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.ApplicationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-applicationid
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.BundleId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-bundleid
     */
    readonly bundleId?: string;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.Certificate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-certificate
     */
    readonly certificate?: string;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.DefaultAuthenticationMethod`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-defaultauthenticationmethod
     */
    readonly defaultAuthenticationMethod?: string;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.Enabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-enabled
     */
    readonly enabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.PrivateKey`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-privatekey
     */
    readonly privateKey?: string;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.TeamId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-teamid
     */
    readonly teamId?: string;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.TokenKey`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-tokenkey
     */
    readonly tokenKey?: string;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.TokenKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-tokenkeyid
     */
    readonly tokenKeyId?: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::APNSSandboxChannel`
 *
 * @cloudformationResource AWS::Pinpoint::APNSSandboxChannel
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html
 */
export declare class CfnAPNSSandboxChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::APNSSandboxChannel";
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.ApplicationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-applicationid
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.BundleId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-bundleid
     */
    bundleId: string | undefined;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.Certificate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-certificate
     */
    certificate: string | undefined;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.DefaultAuthenticationMethod`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-defaultauthenticationmethod
     */
    defaultAuthenticationMethod: string | undefined;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.Enabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-enabled
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.PrivateKey`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-privatekey
     */
    privateKey: string | undefined;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.TeamId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-teamid
     */
    teamId: string | undefined;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.TokenKey`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-tokenkey
     */
    tokenKey: string | undefined;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.TokenKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-tokenkeyid
     */
    tokenKeyId: string | undefined;
    /**
     * Create a new `AWS::Pinpoint::APNSSandboxChannel`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAPNSSandboxChannelProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::APNSVoipChannel`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html
 */
export interface CfnAPNSVoipChannelProps {
    /**
     * `AWS::Pinpoint::APNSVoipChannel.ApplicationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-applicationid
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.BundleId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-bundleid
     */
    readonly bundleId?: string;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.Certificate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-certificate
     */
    readonly certificate?: string;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.DefaultAuthenticationMethod`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-defaultauthenticationmethod
     */
    readonly defaultAuthenticationMethod?: string;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.Enabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-enabled
     */
    readonly enabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.PrivateKey`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-privatekey
     */
    readonly privateKey?: string;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.TeamId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-teamid
     */
    readonly teamId?: string;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.TokenKey`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-tokenkey
     */
    readonly tokenKey?: string;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.TokenKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-tokenkeyid
     */
    readonly tokenKeyId?: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::APNSVoipChannel`
 *
 * @cloudformationResource AWS::Pinpoint::APNSVoipChannel
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html
 */
export declare class CfnAPNSVoipChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::APNSVoipChannel";
    /**
     * `AWS::Pinpoint::APNSVoipChannel.ApplicationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-applicationid
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.BundleId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-bundleid
     */
    bundleId: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.Certificate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-certificate
     */
    certificate: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.DefaultAuthenticationMethod`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-defaultauthenticationmethod
     */
    defaultAuthenticationMethod: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.Enabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-enabled
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.PrivateKey`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-privatekey
     */
    privateKey: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.TeamId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-teamid
     */
    teamId: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.TokenKey`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-tokenkey
     */
    tokenKey: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.TokenKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-tokenkeyid
     */
    tokenKeyId: string | undefined;
    /**
     * Create a new `AWS::Pinpoint::APNSVoipChannel`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAPNSVoipChannelProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::APNSVoipSandboxChannel`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html
 */
export interface CfnAPNSVoipSandboxChannelProps {
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.ApplicationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-applicationid
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.BundleId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-bundleid
     */
    readonly bundleId?: string;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.Certificate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-certificate
     */
    readonly certificate?: string;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.DefaultAuthenticationMethod`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-defaultauthenticationmethod
     */
    readonly defaultAuthenticationMethod?: string;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.Enabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-enabled
     */
    readonly enabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.PrivateKey`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-privatekey
     */
    readonly privateKey?: string;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.TeamId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-teamid
     */
    readonly teamId?: string;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.TokenKey`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-tokenkey
     */
    readonly tokenKey?: string;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.TokenKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-tokenkeyid
     */
    readonly tokenKeyId?: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::APNSVoipSandboxChannel`
 *
 * @cloudformationResource AWS::Pinpoint::APNSVoipSandboxChannel
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html
 */
export declare class CfnAPNSVoipSandboxChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::APNSVoipSandboxChannel";
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.ApplicationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-applicationid
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.BundleId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-bundleid
     */
    bundleId: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.Certificate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-certificate
     */
    certificate: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.DefaultAuthenticationMethod`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-defaultauthenticationmethod
     */
    defaultAuthenticationMethod: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.Enabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-enabled
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.PrivateKey`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-privatekey
     */
    privateKey: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.TeamId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-teamid
     */
    teamId: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.TokenKey`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-tokenkey
     */
    tokenKey: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.TokenKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-tokenkeyid
     */
    tokenKeyId: string | undefined;
    /**
     * Create a new `AWS::Pinpoint::APNSVoipSandboxChannel`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAPNSVoipSandboxChannelProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::App`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-app.html
 */
export interface CfnAppProps {
    /**
     * `AWS::Pinpoint::App.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-app.html#cfn-pinpoint-app-name
     */
    readonly name: string;
    /**
     * `AWS::Pinpoint::App.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-app.html#cfn-pinpoint-app-tags
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::Pinpoint::App`
 *
 * @cloudformationResource AWS::Pinpoint::App
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-app.html
 */
export declare class CfnApp extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::App";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::Pinpoint::App.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-app.html#cfn-pinpoint-app-name
     */
    name: string;
    /**
     * `AWS::Pinpoint::App.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-app.html#cfn-pinpoint-app-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Pinpoint::App`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAppProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::ApplicationSettings`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html
 */
export interface CfnApplicationSettingsProps {
    /**
     * `AWS::Pinpoint::ApplicationSettings.ApplicationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-applicationid
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::ApplicationSettings.CampaignHook`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-campaignhook
     */
    readonly campaignHook?: CfnApplicationSettings.CampaignHookProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::ApplicationSettings.CloudWatchMetricsEnabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-cloudwatchmetricsenabled
     */
    readonly cloudWatchMetricsEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::ApplicationSettings.Limits`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-limits
     */
    readonly limits?: CfnApplicationSettings.LimitsProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::ApplicationSettings.QuietTime`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-quiettime
     */
    readonly quietTime?: CfnApplicationSettings.QuietTimeProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Pinpoint::ApplicationSettings`
 *
 * @cloudformationResource AWS::Pinpoint::ApplicationSettings
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html
 */
export declare class CfnApplicationSettings extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::ApplicationSettings";
    /**
     * `AWS::Pinpoint::ApplicationSettings.ApplicationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-applicationid
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::ApplicationSettings.CampaignHook`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-campaignhook
     */
    campaignHook: CfnApplicationSettings.CampaignHookProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::ApplicationSettings.CloudWatchMetricsEnabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-cloudwatchmetricsenabled
     */
    cloudWatchMetricsEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::ApplicationSettings.Limits`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-limits
     */
    limits: CfnApplicationSettings.LimitsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::ApplicationSettings.QuietTime`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-quiettime
     */
    quietTime: CfnApplicationSettings.QuietTimeProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Pinpoint::ApplicationSettings`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnApplicationSettingsProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnApplicationSettings {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-campaignhook.html
     */
    interface CampaignHookProperty {
        /**
         * `CfnApplicationSettings.CampaignHookProperty.LambdaFunctionName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-campaignhook.html#cfn-pinpoint-applicationsettings-campaignhook-lambdafunctionname
         */
        readonly lambdaFunctionName?: string;
        /**
         * `CfnApplicationSettings.CampaignHookProperty.Mode`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-campaignhook.html#cfn-pinpoint-applicationsettings-campaignhook-mode
         */
        readonly mode?: string;
        /**
         * `CfnApplicationSettings.CampaignHookProperty.WebUrl`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-campaignhook.html#cfn-pinpoint-applicationsettings-campaignhook-weburl
         */
        readonly webUrl?: string;
    }
}
export declare namespace CfnApplicationSettings {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-limits.html
     */
    interface LimitsProperty {
        /**
         * `CfnApplicationSettings.LimitsProperty.Daily`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-limits.html#cfn-pinpoint-applicationsettings-limits-daily
         */
        readonly daily?: number;
        /**
         * `CfnApplicationSettings.LimitsProperty.MaximumDuration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-limits.html#cfn-pinpoint-applicationsettings-limits-maximumduration
         */
        readonly maximumDuration?: number;
        /**
         * `CfnApplicationSettings.LimitsProperty.MessagesPerSecond`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-limits.html#cfn-pinpoint-applicationsettings-limits-messagespersecond
         */
        readonly messagesPerSecond?: number;
        /**
         * `CfnApplicationSettings.LimitsProperty.Total`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-limits.html#cfn-pinpoint-applicationsettings-limits-total
         */
        readonly total?: number;
    }
}
export declare namespace CfnApplicationSettings {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-quiettime.html
     */
    interface QuietTimeProperty {
        /**
         * `CfnApplicationSettings.QuietTimeProperty.End`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-quiettime.html#cfn-pinpoint-applicationsettings-quiettime-end
         */
        readonly end: string;
        /**
         * `CfnApplicationSettings.QuietTimeProperty.Start`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-quiettime.html#cfn-pinpoint-applicationsettings-quiettime-start
         */
        readonly start: string;
    }
}
/**
 * Properties for defining a `AWS::Pinpoint::BaiduChannel`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-baiduchannel.html
 */
export interface CfnBaiduChannelProps {
    /**
     * `AWS::Pinpoint::BaiduChannel.ApiKey`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-baiduchannel.html#cfn-pinpoint-baiduchannel-apikey
     */
    readonly apiKey: string;
    /**
     * `AWS::Pinpoint::BaiduChannel.ApplicationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-baiduchannel.html#cfn-pinpoint-baiduchannel-applicationid
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::BaiduChannel.SecretKey`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-baiduchannel.html#cfn-pinpoint-baiduchannel-secretkey
     */
    readonly secretKey: string;
    /**
     * `AWS::Pinpoint::BaiduChannel.Enabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-baiduchannel.html#cfn-pinpoint-baiduchannel-enabled
     */
    readonly enabled?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Pinpoint::BaiduChannel`
 *
 * @cloudformationResource AWS::Pinpoint::BaiduChannel
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-baiduchannel.html
 */
export declare class CfnBaiduChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::BaiduChannel";
    /**
     * `AWS::Pinpoint::BaiduChannel.ApiKey`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-baiduchannel.html#cfn-pinpoint-baiduchannel-apikey
     */
    apiKey: string;
    /**
     * `AWS::Pinpoint::BaiduChannel.ApplicationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-baiduchannel.html#cfn-pinpoint-baiduchannel-applicationid
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::BaiduChannel.SecretKey`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-baiduchannel.html#cfn-pinpoint-baiduchannel-secretkey
     */
    secretKey: string;
    /**
     * `AWS::Pinpoint::BaiduChannel.Enabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-baiduchannel.html#cfn-pinpoint-baiduchannel-enabled
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Pinpoint::BaiduChannel`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnBaiduChannelProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::Campaign`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 */
export interface CfnCampaignProps {
    /**
     * `AWS::Pinpoint::Campaign.ApplicationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-applicationid
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::Campaign.MessageConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-messageconfiguration
     */
    readonly messageConfiguration: CfnCampaign.MessageConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::Campaign.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-name
     */
    readonly name: string;
    /**
     * `AWS::Pinpoint::Campaign.Schedule`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-schedule
     */
    readonly schedule: CfnCampaign.ScheduleProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::Campaign.SegmentId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-segmentid
     */
    readonly segmentId: string;
    /**
     * `AWS::Pinpoint::Campaign.AdditionalTreatments`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-additionaltreatments
     */
    readonly additionalTreatments?: Array<CfnCampaign.WriteTreatmentResourceProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::Campaign.CampaignHook`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-campaignhook
     */
    readonly campaignHook?: CfnCampaign.CampaignHookProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::Campaign.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-description
     */
    readonly description?: string;
    /**
     * `AWS::Pinpoint::Campaign.HoldoutPercent`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-holdoutpercent
     */
    readonly holdoutPercent?: number;
    /**
     * `AWS::Pinpoint::Campaign.IsPaused`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-ispaused
     */
    readonly isPaused?: boolean | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::Campaign.Limits`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-limits
     */
    readonly limits?: CfnCampaign.LimitsProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::Campaign.SegmentVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-segmentversion
     */
    readonly segmentVersion?: number;
    /**
     * `AWS::Pinpoint::Campaign.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-tags
     */
    readonly tags?: any;
    /**
     * `AWS::Pinpoint::Campaign.TreatmentDescription`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-treatmentdescription
     */
    readonly treatmentDescription?: string;
    /**
     * `AWS::Pinpoint::Campaign.TreatmentName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-treatmentname
     */
    readonly treatmentName?: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`
 *
 * @cloudformationResource AWS::Pinpoint::Campaign
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 */
export declare class CfnCampaign extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::Campaign";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute CampaignId
     */
    readonly attrCampaignId: string;
    /**
     * `AWS::Pinpoint::Campaign.ApplicationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-applicationid
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::Campaign.MessageConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-messageconfiguration
     */
    messageConfiguration: CfnCampaign.MessageConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::Campaign.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-name
     */
    name: string;
    /**
     * `AWS::Pinpoint::Campaign.Schedule`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-schedule
     */
    schedule: CfnCampaign.ScheduleProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::Campaign.SegmentId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-segmentid
     */
    segmentId: string;
    /**
     * `AWS::Pinpoint::Campaign.AdditionalTreatments`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-additionaltreatments
     */
    additionalTreatments: Array<CfnCampaign.WriteTreatmentResourceProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::Campaign.CampaignHook`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-campaignhook
     */
    campaignHook: CfnCampaign.CampaignHookProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::Campaign.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-description
     */
    description: string | undefined;
    /**
     * `AWS::Pinpoint::Campaign.HoldoutPercent`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-holdoutpercent
     */
    holdoutPercent: number | undefined;
    /**
     * `AWS::Pinpoint::Campaign.IsPaused`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-ispaused
     */
    isPaused: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::Campaign.Limits`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-limits
     */
    limits: CfnCampaign.LimitsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::Campaign.SegmentVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-segmentversion
     */
    segmentVersion: number | undefined;
    /**
     * `AWS::Pinpoint::Campaign.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Pinpoint::Campaign.TreatmentDescription`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-treatmentdescription
     */
    treatmentDescription: string | undefined;
    /**
     * `AWS::Pinpoint::Campaign.TreatmentName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-treatmentname
     */
    treatmentName: string | undefined;
    /**
     * Create a new `AWS::Pinpoint::Campaign`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCampaignProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnCampaign {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-attributedimension.html
     */
    interface AttributeDimensionProperty {
        /**
         * `CfnCampaign.AttributeDimensionProperty.AttributeType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-attributedimension.html#cfn-pinpoint-campaign-attributedimension-attributetype
         */
        readonly attributeType?: string;
        /**
         * `CfnCampaign.AttributeDimensionProperty.Values`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-attributedimension.html#cfn-pinpoint-campaign-attributedimension-values
         */
        readonly values?: string[];
    }
}
export declare namespace CfnCampaign {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignemailmessage.html
     */
    interface CampaignEmailMessageProperty {
        /**
         * `CfnCampaign.CampaignEmailMessageProperty.Body`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignemailmessage.html#cfn-pinpoint-campaign-campaignemailmessage-body
         */
        readonly body?: string;
        /**
         * `CfnCampaign.CampaignEmailMessageProperty.FromAddress`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignemailmessage.html#cfn-pinpoint-campaign-campaignemailmessage-fromaddress
         */
        readonly fromAddress?: string;
        /**
         * `CfnCampaign.CampaignEmailMessageProperty.HtmlBody`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignemailmessage.html#cfn-pinpoint-campaign-campaignemailmessage-htmlbody
         */
        readonly htmlBody?: string;
        /**
         * `CfnCampaign.CampaignEmailMessageProperty.Title`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignemailmessage.html#cfn-pinpoint-campaign-campaignemailmessage-title
         */
        readonly title?: string;
    }
}
export declare namespace CfnCampaign {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaigneventfilter.html
     */
    interface CampaignEventFilterProperty {
        /**
         * `CfnCampaign.CampaignEventFilterProperty.Dimensions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaigneventfilter.html#cfn-pinpoint-campaign-campaigneventfilter-dimensions
         */
        readonly dimensions?: CfnCampaign.EventDimensionsProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.CampaignEventFilterProperty.FilterType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaigneventfilter.html#cfn-pinpoint-campaign-campaigneventfilter-filtertype
         */
        readonly filterType?: string;
    }
}
export declare namespace CfnCampaign {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignhook.html
     */
    interface CampaignHookProperty {
        /**
         * `CfnCampaign.CampaignHookProperty.LambdaFunctionName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignhook.html#cfn-pinpoint-campaign-campaignhook-lambdafunctionname
         */
        readonly lambdaFunctionName?: string;
        /**
         * `CfnCampaign.CampaignHookProperty.Mode`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignhook.html#cfn-pinpoint-campaign-campaignhook-mode
         */
        readonly mode?: string;
        /**
         * `CfnCampaign.CampaignHookProperty.WebUrl`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignhook.html#cfn-pinpoint-campaign-campaignhook-weburl
         */
        readonly webUrl?: string;
    }
}
export declare namespace CfnCampaign {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignsmsmessage.html
     */
    interface CampaignSmsMessageProperty {
        /**
         * `CfnCampaign.CampaignSmsMessageProperty.Body`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignsmsmessage.html#cfn-pinpoint-campaign-campaignsmsmessage-body
         */
        readonly body?: string;
        /**
         * `CfnCampaign.CampaignSmsMessageProperty.MessageType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignsmsmessage.html#cfn-pinpoint-campaign-campaignsmsmessage-messagetype
         */
        readonly messageType?: string;
        /**
         * `CfnCampaign.CampaignSmsMessageProperty.SenderId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignsmsmessage.html#cfn-pinpoint-campaign-campaignsmsmessage-senderid
         */
        readonly senderId?: string;
    }
}
export declare namespace CfnCampaign {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-eventdimensions.html
     */
    interface EventDimensionsProperty {
        /**
         * `CfnCampaign.EventDimensionsProperty.Attributes`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-eventdimensions.html#cfn-pinpoint-campaign-eventdimensions-attributes
         */
        readonly attributes?: any | cdk.IResolvable;
        /**
         * `CfnCampaign.EventDimensionsProperty.EventType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-eventdimensions.html#cfn-pinpoint-campaign-eventdimensions-eventtype
         */
        readonly eventType?: CfnCampaign.SetDimensionProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.EventDimensionsProperty.Metrics`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-eventdimensions.html#cfn-pinpoint-campaign-eventdimensions-metrics
         */
        readonly metrics?: any | cdk.IResolvable;
    }
}
export declare namespace CfnCampaign {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-limits.html
     */
    interface LimitsProperty {
        /**
         * `CfnCampaign.LimitsProperty.Daily`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-limits.html#cfn-pinpoint-campaign-limits-daily
         */
        readonly daily?: number;
        /**
         * `CfnCampaign.LimitsProperty.MaximumDuration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-limits.html#cfn-pinpoint-campaign-limits-maximumduration
         */
        readonly maximumDuration?: number;
        /**
         * `CfnCampaign.LimitsProperty.MessagesPerSecond`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-limits.html#cfn-pinpoint-campaign-limits-messagespersecond
         */
        readonly messagesPerSecond?: number;
        /**
         * `CfnCampaign.LimitsProperty.Total`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-limits.html#cfn-pinpoint-campaign-limits-total
         */
        readonly total?: number;
    }
}
export declare namespace CfnCampaign {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html
     */
    interface MessageProperty {
        /**
         * `CfnCampaign.MessageProperty.Action`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-action
         */
        readonly action?: string;
        /**
         * `CfnCampaign.MessageProperty.Body`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-body
         */
        readonly body?: string;
        /**
         * `CfnCampaign.MessageProperty.ImageIconUrl`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-imageiconurl
         */
        readonly imageIconUrl?: string;
        /**
         * `CfnCampaign.MessageProperty.ImageSmallIconUrl`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-imagesmalliconurl
         */
        readonly imageSmallIconUrl?: string;
        /**
         * `CfnCampaign.MessageProperty.ImageUrl`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-imageurl
         */
        readonly imageUrl?: string;
        /**
         * `CfnCampaign.MessageProperty.JsonBody`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-jsonbody
         */
        readonly jsonBody?: string;
        /**
         * `CfnCampaign.MessageProperty.MediaUrl`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-mediaurl
         */
        readonly mediaUrl?: string;
        /**
         * `CfnCampaign.MessageProperty.RawContent`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-rawcontent
         */
        readonly rawContent?: string;
        /**
         * `CfnCampaign.MessageProperty.SilentPush`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-silentpush
         */
        readonly silentPush?: boolean | cdk.IResolvable;
        /**
         * `CfnCampaign.MessageProperty.TimeToLive`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-timetolive
         */
        readonly timeToLive?: number;
        /**
         * `CfnCampaign.MessageProperty.Title`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-title
         */
        readonly title?: string;
        /**
         * `CfnCampaign.MessageProperty.Url`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-url
         */
        readonly url?: string;
    }
}
export declare namespace CfnCampaign {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-messageconfiguration.html
     */
    interface MessageConfigurationProperty {
        /**
         * `CfnCampaign.MessageConfigurationProperty.ADMMessage`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-messageconfiguration.html#cfn-pinpoint-campaign-messageconfiguration-admmessage
         */
        readonly admMessage?: CfnCampaign.MessageProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.MessageConfigurationProperty.APNSMessage`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-messageconfiguration.html#cfn-pinpoint-campaign-messageconfiguration-apnsmessage
         */
        readonly apnsMessage?: CfnCampaign.MessageProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.MessageConfigurationProperty.BaiduMessage`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-messageconfiguration.html#cfn-pinpoint-campaign-messageconfiguration-baidumessage
         */
        readonly baiduMessage?: CfnCampaign.MessageProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.MessageConfigurationProperty.DefaultMessage`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-messageconfiguration.html#cfn-pinpoint-campaign-messageconfiguration-defaultmessage
         */
        readonly defaultMessage?: CfnCampaign.MessageProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.MessageConfigurationProperty.EmailMessage`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-messageconfiguration.html#cfn-pinpoint-campaign-messageconfiguration-emailmessage
         */
        readonly emailMessage?: CfnCampaign.CampaignEmailMessageProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.MessageConfigurationProperty.GCMMessage`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-messageconfiguration.html#cfn-pinpoint-campaign-messageconfiguration-gcmmessage
         */
        readonly gcmMessage?: CfnCampaign.MessageProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.MessageConfigurationProperty.SMSMessage`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-messageconfiguration.html#cfn-pinpoint-campaign-messageconfiguration-smsmessage
         */
        readonly smsMessage?: CfnCampaign.CampaignSmsMessageProperty | cdk.IResolvable;
    }
}
export declare namespace CfnCampaign {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-metricdimension.html
     */
    interface MetricDimensionProperty {
        /**
         * `CfnCampaign.MetricDimensionProperty.ComparisonOperator`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-metricdimension.html#cfn-pinpoint-campaign-metricdimension-comparisonoperator
         */
        readonly comparisonOperator?: string;
        /**
         * `CfnCampaign.MetricDimensionProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-metricdimension.html#cfn-pinpoint-campaign-metricdimension-value
         */
        readonly value?: number;
    }
}
export declare namespace CfnCampaign {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule-quiettime.html
     */
    interface QuietTimeProperty {
        /**
         * `CfnCampaign.QuietTimeProperty.End`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule-quiettime.html#cfn-pinpoint-campaign-schedule-quiettime-end
         */
        readonly end: string;
        /**
         * `CfnCampaign.QuietTimeProperty.Start`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule-quiettime.html#cfn-pinpoint-campaign-schedule-quiettime-start
         */
        readonly start: string;
    }
}
export declare namespace CfnCampaign {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule.html
     */
    interface ScheduleProperty {
        /**
         * `CfnCampaign.ScheduleProperty.EndTime`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule.html#cfn-pinpoint-campaign-schedule-endtime
         */
        readonly endTime?: string;
        /**
         * `CfnCampaign.ScheduleProperty.EventFilter`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule.html#cfn-pinpoint-campaign-schedule-eventfilter
         */
        readonly eventFilter?: CfnCampaign.CampaignEventFilterProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.ScheduleProperty.Frequency`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule.html#cfn-pinpoint-campaign-schedule-frequency
         */
        readonly frequency?: string;
        /**
         * `CfnCampaign.ScheduleProperty.IsLocalTime`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule.html#cfn-pinpoint-campaign-schedule-islocaltime
         */
        readonly isLocalTime?: boolean | cdk.IResolvable;
        /**
         * `CfnCampaign.ScheduleProperty.QuietTime`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule.html#cfn-pinpoint-campaign-schedule-quiettime
         */
        readonly quietTime?: CfnCampaign.QuietTimeProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.ScheduleProperty.StartTime`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule.html#cfn-pinpoint-campaign-schedule-starttime
         */
        readonly startTime?: string;
        /**
         * `CfnCampaign.ScheduleProperty.TimeZone`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule.html#cfn-pinpoint-campaign-schedule-timezone
         */
        readonly timeZone?: string;
    }
}
export declare namespace CfnCampaign {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-setdimension.html
     */
    interface SetDimensionProperty {
        /**
         * `CfnCampaign.SetDimensionProperty.DimensionType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-setdimension.html#cfn-pinpoint-campaign-setdimension-dimensiontype
         */
        readonly dimensionType?: string;
        /**
         * `CfnCampaign.SetDimensionProperty.Values`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-setdimension.html#cfn-pinpoint-campaign-setdimension-values
         */
        readonly values?: string[];
    }
}
export declare namespace CfnCampaign {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-writetreatmentresource.html
     */
    interface WriteTreatmentResourceProperty {
        /**
         * `CfnCampaign.WriteTreatmentResourceProperty.MessageConfiguration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-writetreatmentresource.html#cfn-pinpoint-campaign-writetreatmentresource-messageconfiguration
         */
        readonly messageConfiguration?: CfnCampaign.MessageConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.WriteTreatmentResourceProperty.Schedule`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-writetreatmentresource.html#cfn-pinpoint-campaign-writetreatmentresource-schedule
         */
        readonly schedule?: CfnCampaign.ScheduleProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.WriteTreatmentResourceProperty.SizePercent`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-writetreatmentresource.html#cfn-pinpoint-campaign-writetreatmentresource-sizepercent
         */
        readonly sizePercent?: number;
        /**
         * `CfnCampaign.WriteTreatmentResourceProperty.TreatmentDescription`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-writetreatmentresource.html#cfn-pinpoint-campaign-writetreatmentresource-treatmentdescription
         */
        readonly treatmentDescription?: string;
        /**
         * `CfnCampaign.WriteTreatmentResourceProperty.TreatmentName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-writetreatmentresource.html#cfn-pinpoint-campaign-writetreatmentresource-treatmentname
         */
        readonly treatmentName?: string;
    }
}
/**
 * Properties for defining a `AWS::Pinpoint::EmailChannel`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html
 */
export interface CfnEmailChannelProps {
    /**
     * `AWS::Pinpoint::EmailChannel.ApplicationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-applicationid
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::EmailChannel.FromAddress`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-fromaddress
     */
    readonly fromAddress: string;
    /**
     * `AWS::Pinpoint::EmailChannel.Identity`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-identity
     */
    readonly identity: string;
    /**
     * `AWS::Pinpoint::EmailChannel.ConfigurationSet`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-configurationset
     */
    readonly configurationSet?: string;
    /**
     * `AWS::Pinpoint::EmailChannel.Enabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-enabled
     */
    readonly enabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::EmailChannel.RoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-rolearn
     */
    readonly roleArn?: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::EmailChannel`
 *
 * @cloudformationResource AWS::Pinpoint::EmailChannel
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html
 */
export declare class CfnEmailChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::EmailChannel";
    /**
     * `AWS::Pinpoint::EmailChannel.ApplicationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-applicationid
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::EmailChannel.FromAddress`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-fromaddress
     */
    fromAddress: string;
    /**
     * `AWS::Pinpoint::EmailChannel.Identity`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-identity
     */
    identity: string;
    /**
     * `AWS::Pinpoint::EmailChannel.ConfigurationSet`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-configurationset
     */
    configurationSet: string | undefined;
    /**
     * `AWS::Pinpoint::EmailChannel.Enabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-enabled
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::EmailChannel.RoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-rolearn
     */
    roleArn: string | undefined;
    /**
     * Create a new `AWS::Pinpoint::EmailChannel`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEmailChannelProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::EmailTemplate`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html
 */
export interface CfnEmailTemplateProps {
    /**
     * `AWS::Pinpoint::EmailTemplate.Subject`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-subject
     */
    readonly subject: string;
    /**
     * `AWS::Pinpoint::EmailTemplate.TemplateName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-templatename
     */
    readonly templateName: string;
    /**
     * `AWS::Pinpoint::EmailTemplate.DefaultSubstitutions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-defaultsubstitutions
     */
    readonly defaultSubstitutions?: string;
    /**
     * `AWS::Pinpoint::EmailTemplate.HtmlPart`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-htmlpart
     */
    readonly htmlPart?: string;
    /**
     * `AWS::Pinpoint::EmailTemplate.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-tags
     */
    readonly tags?: any;
    /**
     * `AWS::Pinpoint::EmailTemplate.TemplateDescription`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-templatedescription
     */
    readonly templateDescription?: string;
    /**
     * `AWS::Pinpoint::EmailTemplate.TextPart`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-textpart
     */
    readonly textPart?: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::EmailTemplate`
 *
 * @cloudformationResource AWS::Pinpoint::EmailTemplate
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html
 */
export declare class CfnEmailTemplate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::EmailTemplate";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::Pinpoint::EmailTemplate.Subject`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-subject
     */
    subject: string;
    /**
     * `AWS::Pinpoint::EmailTemplate.TemplateName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-templatename
     */
    templateName: string;
    /**
     * `AWS::Pinpoint::EmailTemplate.DefaultSubstitutions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-defaultsubstitutions
     */
    defaultSubstitutions: string | undefined;
    /**
     * `AWS::Pinpoint::EmailTemplate.HtmlPart`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-htmlpart
     */
    htmlPart: string | undefined;
    /**
     * `AWS::Pinpoint::EmailTemplate.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Pinpoint::EmailTemplate.TemplateDescription`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-templatedescription
     */
    templateDescription: string | undefined;
    /**
     * `AWS::Pinpoint::EmailTemplate.TextPart`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-textpart
     */
    textPart: string | undefined;
    /**
     * Create a new `AWS::Pinpoint::EmailTemplate`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEmailTemplateProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::EventStream`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-eventstream.html
 */
export interface CfnEventStreamProps {
    /**
     * `AWS::Pinpoint::EventStream.ApplicationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-eventstream.html#cfn-pinpoint-eventstream-applicationid
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::EventStream.DestinationStreamArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-eventstream.html#cfn-pinpoint-eventstream-destinationstreamarn
     */
    readonly destinationStreamArn: string;
    /**
     * `AWS::Pinpoint::EventStream.RoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-eventstream.html#cfn-pinpoint-eventstream-rolearn
     */
    readonly roleArn: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::EventStream`
 *
 * @cloudformationResource AWS::Pinpoint::EventStream
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-eventstream.html
 */
export declare class CfnEventStream extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::EventStream";
    /**
     * `AWS::Pinpoint::EventStream.ApplicationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-eventstream.html#cfn-pinpoint-eventstream-applicationid
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::EventStream.DestinationStreamArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-eventstream.html#cfn-pinpoint-eventstream-destinationstreamarn
     */
    destinationStreamArn: string;
    /**
     * `AWS::Pinpoint::EventStream.RoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-eventstream.html#cfn-pinpoint-eventstream-rolearn
     */
    roleArn: string;
    /**
     * Create a new `AWS::Pinpoint::EventStream`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEventStreamProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::GCMChannel`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-gcmchannel.html
 */
export interface CfnGCMChannelProps {
    /**
     * `AWS::Pinpoint::GCMChannel.ApiKey`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-gcmchannel.html#cfn-pinpoint-gcmchannel-apikey
     */
    readonly apiKey: string;
    /**
     * `AWS::Pinpoint::GCMChannel.ApplicationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-gcmchannel.html#cfn-pinpoint-gcmchannel-applicationid
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::GCMChannel.Enabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-gcmchannel.html#cfn-pinpoint-gcmchannel-enabled
     */
    readonly enabled?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Pinpoint::GCMChannel`
 *
 * @cloudformationResource AWS::Pinpoint::GCMChannel
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-gcmchannel.html
 */
export declare class CfnGCMChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::GCMChannel";
    /**
     * `AWS::Pinpoint::GCMChannel.ApiKey`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-gcmchannel.html#cfn-pinpoint-gcmchannel-apikey
     */
    apiKey: string;
    /**
     * `AWS::Pinpoint::GCMChannel.ApplicationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-gcmchannel.html#cfn-pinpoint-gcmchannel-applicationid
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::GCMChannel.Enabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-gcmchannel.html#cfn-pinpoint-gcmchannel-enabled
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Pinpoint::GCMChannel`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnGCMChannelProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::PushTemplate`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html
 */
export interface CfnPushTemplateProps {
    /**
     * `AWS::Pinpoint::PushTemplate.TemplateName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-templatename
     */
    readonly templateName: string;
    /**
     * `AWS::Pinpoint::PushTemplate.ADM`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-adm
     */
    readonly adm?: CfnPushTemplate.AndroidPushNotificationTemplateProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::PushTemplate.APNS`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-apns
     */
    readonly apns?: CfnPushTemplate.APNSPushNotificationTemplateProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::PushTemplate.Baidu`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-baidu
     */
    readonly baidu?: CfnPushTemplate.AndroidPushNotificationTemplateProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::PushTemplate.Default`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-default
     */
    readonly default?: CfnPushTemplate.DefaultPushNotificationTemplateProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::PushTemplate.DefaultSubstitutions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-defaultsubstitutions
     */
    readonly defaultSubstitutions?: string;
    /**
     * `AWS::Pinpoint::PushTemplate.GCM`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-gcm
     */
    readonly gcm?: CfnPushTemplate.AndroidPushNotificationTemplateProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::PushTemplate.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-tags
     */
    readonly tags?: any;
    /**
     * `AWS::Pinpoint::PushTemplate.TemplateDescription`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-templatedescription
     */
    readonly templateDescription?: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::PushTemplate`
 *
 * @cloudformationResource AWS::Pinpoint::PushTemplate
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html
 */
export declare class CfnPushTemplate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::PushTemplate";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::Pinpoint::PushTemplate.TemplateName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-templatename
     */
    templateName: string;
    /**
     * `AWS::Pinpoint::PushTemplate.ADM`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-adm
     */
    adm: CfnPushTemplate.AndroidPushNotificationTemplateProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::PushTemplate.APNS`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-apns
     */
    apns: CfnPushTemplate.APNSPushNotificationTemplateProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::PushTemplate.Baidu`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-baidu
     */
    baidu: CfnPushTemplate.AndroidPushNotificationTemplateProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::PushTemplate.Default`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-default
     */
    default: CfnPushTemplate.DefaultPushNotificationTemplateProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::PushTemplate.DefaultSubstitutions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-defaultsubstitutions
     */
    defaultSubstitutions: string | undefined;
    /**
     * `AWS::Pinpoint::PushTemplate.GCM`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-gcm
     */
    gcm: CfnPushTemplate.AndroidPushNotificationTemplateProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::PushTemplate.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Pinpoint::PushTemplate.TemplateDescription`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-templatedescription
     */
    templateDescription: string | undefined;
    /**
     * Create a new `AWS::Pinpoint::PushTemplate`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPushTemplateProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnPushTemplate {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html
     */
    interface APNSPushNotificationTemplateProperty {
        /**
         * `CfnPushTemplate.APNSPushNotificationTemplateProperty.Action`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html#cfn-pinpoint-pushtemplate-apnspushnotificationtemplate-action
         */
        readonly action?: string;
        /**
         * `CfnPushTemplate.APNSPushNotificationTemplateProperty.Body`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html#cfn-pinpoint-pushtemplate-apnspushnotificationtemplate-body
         */
        readonly body?: string;
        /**
         * `CfnPushTemplate.APNSPushNotificationTemplateProperty.MediaUrl`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html#cfn-pinpoint-pushtemplate-apnspushnotificationtemplate-mediaurl
         */
        readonly mediaUrl?: string;
        /**
         * `CfnPushTemplate.APNSPushNotificationTemplateProperty.Sound`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html#cfn-pinpoint-pushtemplate-apnspushnotificationtemplate-sound
         */
        readonly sound?: string;
        /**
         * `CfnPushTemplate.APNSPushNotificationTemplateProperty.Title`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html#cfn-pinpoint-pushtemplate-apnspushnotificationtemplate-title
         */
        readonly title?: string;
        /**
         * `CfnPushTemplate.APNSPushNotificationTemplateProperty.Url`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html#cfn-pinpoint-pushtemplate-apnspushnotificationtemplate-url
         */
        readonly url?: string;
    }
}
export declare namespace CfnPushTemplate {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html
     */
    interface AndroidPushNotificationTemplateProperty {
        /**
         * `CfnPushTemplate.AndroidPushNotificationTemplateProperty.Action`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-action
         */
        readonly action?: string;
        /**
         * `CfnPushTemplate.AndroidPushNotificationTemplateProperty.Body`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-body
         */
        readonly body?: string;
        /**
         * `CfnPushTemplate.AndroidPushNotificationTemplateProperty.ImageIconUrl`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-imageiconurl
         */
        readonly imageIconUrl?: string;
        /**
         * `CfnPushTemplate.AndroidPushNotificationTemplateProperty.ImageUrl`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-imageurl
         */
        readonly imageUrl?: string;
        /**
         * `CfnPushTemplate.AndroidPushNotificationTemplateProperty.SmallImageIconUrl`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-smallimageiconurl
         */
        readonly smallImageIconUrl?: string;
        /**
         * `CfnPushTemplate.AndroidPushNotificationTemplateProperty.Sound`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-sound
         */
        readonly sound?: string;
        /**
         * `CfnPushTemplate.AndroidPushNotificationTemplateProperty.Title`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-title
         */
        readonly title?: string;
        /**
         * `CfnPushTemplate.AndroidPushNotificationTemplateProperty.Url`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-url
         */
        readonly url?: string;
    }
}
export declare namespace CfnPushTemplate {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-defaultpushnotificationtemplate.html
     */
    interface DefaultPushNotificationTemplateProperty {
        /**
         * `CfnPushTemplate.DefaultPushNotificationTemplateProperty.Action`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-defaultpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-defaultpushnotificationtemplate-action
         */
        readonly action?: string;
        /**
         * `CfnPushTemplate.DefaultPushNotificationTemplateProperty.Body`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-defaultpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-defaultpushnotificationtemplate-body
         */
        readonly body?: string;
        /**
         * `CfnPushTemplate.DefaultPushNotificationTemplateProperty.Sound`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-defaultpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-defaultpushnotificationtemplate-sound
         */
        readonly sound?: string;
        /**
         * `CfnPushTemplate.DefaultPushNotificationTemplateProperty.Title`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-defaultpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-defaultpushnotificationtemplate-title
         */
        readonly title?: string;
        /**
         * `CfnPushTemplate.DefaultPushNotificationTemplateProperty.Url`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-defaultpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-defaultpushnotificationtemplate-url
         */
        readonly url?: string;
    }
}
/**
 * Properties for defining a `AWS::Pinpoint::SMSChannel`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html
 */
export interface CfnSMSChannelProps {
    /**
     * `AWS::Pinpoint::SMSChannel.ApplicationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html#cfn-pinpoint-smschannel-applicationid
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::SMSChannel.Enabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html#cfn-pinpoint-smschannel-enabled
     */
    readonly enabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::SMSChannel.SenderId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html#cfn-pinpoint-smschannel-senderid
     */
    readonly senderId?: string;
    /**
     * `AWS::Pinpoint::SMSChannel.ShortCode`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html#cfn-pinpoint-smschannel-shortcode
     */
    readonly shortCode?: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::SMSChannel`
 *
 * @cloudformationResource AWS::Pinpoint::SMSChannel
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html
 */
export declare class CfnSMSChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::SMSChannel";
    /**
     * `AWS::Pinpoint::SMSChannel.ApplicationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html#cfn-pinpoint-smschannel-applicationid
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::SMSChannel.Enabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html#cfn-pinpoint-smschannel-enabled
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::SMSChannel.SenderId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html#cfn-pinpoint-smschannel-senderid
     */
    senderId: string | undefined;
    /**
     * `AWS::Pinpoint::SMSChannel.ShortCode`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html#cfn-pinpoint-smschannel-shortcode
     */
    shortCode: string | undefined;
    /**
     * Create a new `AWS::Pinpoint::SMSChannel`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSMSChannelProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::Segment`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html
 */
export interface CfnSegmentProps {
    /**
     * `AWS::Pinpoint::Segment.ApplicationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html#cfn-pinpoint-segment-applicationid
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::Segment.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html#cfn-pinpoint-segment-name
     */
    readonly name: string;
    /**
     * `AWS::Pinpoint::Segment.Dimensions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html#cfn-pinpoint-segment-dimensions
     */
    readonly dimensions?: CfnSegment.SegmentDimensionsProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::Segment.SegmentGroups`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html#cfn-pinpoint-segment-segmentgroups
     */
    readonly segmentGroups?: CfnSegment.SegmentGroupsProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::Segment.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html#cfn-pinpoint-segment-tags
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::Pinpoint::Segment`
 *
 * @cloudformationResource AWS::Pinpoint::Segment
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html
 */
export declare class CfnSegment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::Segment";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute SegmentId
     */
    readonly attrSegmentId: string;
    /**
     * `AWS::Pinpoint::Segment.ApplicationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html#cfn-pinpoint-segment-applicationid
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::Segment.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html#cfn-pinpoint-segment-name
     */
    name: string;
    /**
     * `AWS::Pinpoint::Segment.Dimensions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html#cfn-pinpoint-segment-dimensions
     */
    dimensions: CfnSegment.SegmentDimensionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::Segment.SegmentGroups`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html#cfn-pinpoint-segment-segmentgroups
     */
    segmentGroups: CfnSegment.SegmentGroupsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::Segment.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html#cfn-pinpoint-segment-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Pinpoint::Segment`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSegmentProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnSegment {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-attributedimension.html
     */
    interface AttributeDimensionProperty {
        /**
         * `CfnSegment.AttributeDimensionProperty.AttributeType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-attributedimension.html#cfn-pinpoint-segment-attributedimension-attributetype
         */
        readonly attributeType?: string;
        /**
         * `CfnSegment.AttributeDimensionProperty.Values`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-attributedimension.html#cfn-pinpoint-segment-attributedimension-values
         */
        readonly values?: string[];
    }
}
export declare namespace CfnSegment {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-behavior.html
     */
    interface BehaviorProperty {
        /**
         * `CfnSegment.BehaviorProperty.Recency`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-behavior.html#cfn-pinpoint-segment-segmentdimensions-behavior-recency
         */
        readonly recency?: CfnSegment.RecencyProperty | cdk.IResolvable;
    }
}
export declare namespace CfnSegment {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-location-gpspoint-coordinates.html
     */
    interface CoordinatesProperty {
        /**
         * `CfnSegment.CoordinatesProperty.Latitude`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-location-gpspoint-coordinates.html#cfn-pinpoint-segment-segmentdimensions-location-gpspoint-coordinates-latitude
         */
        readonly latitude: number;
        /**
         * `CfnSegment.CoordinatesProperty.Longitude`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-location-gpspoint-coordinates.html#cfn-pinpoint-segment-segmentdimensions-location-gpspoint-coordinates-longitude
         */
        readonly longitude: number;
    }
}
export declare namespace CfnSegment {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-demographic.html
     */
    interface DemographicProperty {
        /**
         * `CfnSegment.DemographicProperty.AppVersion`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-demographic.html#cfn-pinpoint-segment-segmentdimensions-demographic-appversion
         */
        readonly appVersion?: CfnSegment.SetDimensionProperty | cdk.IResolvable;
        /**
         * `CfnSegment.DemographicProperty.Channel`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-demographic.html#cfn-pinpoint-segment-segmentdimensions-demographic-channel
         */
        readonly channel?: CfnSegment.SetDimensionProperty | cdk.IResolvable;
        /**
         * `CfnSegment.DemographicProperty.DeviceType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-demographic.html#cfn-pinpoint-segment-segmentdimensions-demographic-devicetype
         */
        readonly deviceType?: CfnSegment.SetDimensionProperty | cdk.IResolvable;
        /**
         * `CfnSegment.DemographicProperty.Make`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-demographic.html#cfn-pinpoint-segment-segmentdimensions-demographic-make
         */
        readonly make?: CfnSegment.SetDimensionProperty | cdk.IResolvable;
        /**
         * `CfnSegment.DemographicProperty.Model`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-demographic.html#cfn-pinpoint-segment-segmentdimensions-demographic-model
         */
        readonly model?: CfnSegment.SetDimensionProperty | cdk.IResolvable;
        /**
         * `CfnSegment.DemographicProperty.Platform`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-demographic.html#cfn-pinpoint-segment-segmentdimensions-demographic-platform
         */
        readonly platform?: CfnSegment.SetDimensionProperty | cdk.IResolvable;
    }
}
export declare namespace CfnSegment {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-location-gpspoint.html
     */
    interface GPSPointProperty {
        /**
         * `CfnSegment.GPSPointProperty.Coordinates`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-location-gpspoint.html#cfn-pinpoint-segment-segmentdimensions-location-gpspoint-coordinates
         */
        readonly coordinates: CfnSegment.CoordinatesProperty | cdk.IResolvable;
        /**
         * `CfnSegment.GPSPointProperty.RangeInKilometers`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-location-gpspoint.html#cfn-pinpoint-segment-segmentdimensions-location-gpspoint-rangeinkilometers
         */
        readonly rangeInKilometers: number;
    }
}
export declare namespace CfnSegment {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups-groups.html
     */
    interface GroupsProperty {
        /**
         * `CfnSegment.GroupsProperty.Dimensions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups-groups.html#cfn-pinpoint-segment-segmentgroups-groups-dimensions
         */
        readonly dimensions?: Array<CfnSegment.SegmentDimensionsProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSegment.GroupsProperty.SourceSegments`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups-groups.html#cfn-pinpoint-segment-segmentgroups-groups-sourcesegments
         */
        readonly sourceSegments?: Array<CfnSegment.SourceSegmentsProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSegment.GroupsProperty.SourceType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups-groups.html#cfn-pinpoint-segment-segmentgroups-groups-sourcetype
         */
        readonly sourceType?: string;
        /**
         * `CfnSegment.GroupsProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups-groups.html#cfn-pinpoint-segment-segmentgroups-groups-type
         */
        readonly type?: string;
    }
}
export declare namespace CfnSegment {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-location.html
     */
    interface LocationProperty {
        /**
         * `CfnSegment.LocationProperty.Country`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-location.html#cfn-pinpoint-segment-segmentdimensions-location-country
         */
        readonly country?: CfnSegment.SetDimensionProperty | cdk.IResolvable;
        /**
         * `CfnSegment.LocationProperty.GPSPoint`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-location.html#cfn-pinpoint-segment-segmentdimensions-location-gpspoint
         */
        readonly gpsPoint?: CfnSegment.GPSPointProperty | cdk.IResolvable;
    }
}
export declare namespace CfnSegment {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-behavior-recency.html
     */
    interface RecencyProperty {
        /**
         * `CfnSegment.RecencyProperty.Duration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-behavior-recency.html#cfn-pinpoint-segment-segmentdimensions-behavior-recency-duration
         */
        readonly duration: string;
        /**
         * `CfnSegment.RecencyProperty.RecencyType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-behavior-recency.html#cfn-pinpoint-segment-segmentdimensions-behavior-recency-recencytype
         */
        readonly recencyType: string;
    }
}
export declare namespace CfnSegment {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions.html
     */
    interface SegmentDimensionsProperty {
        /**
         * `CfnSegment.SegmentDimensionsProperty.Attributes`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions.html#cfn-pinpoint-segment-segmentdimensions-attributes
         */
        readonly attributes?: any | cdk.IResolvable;
        /**
         * `CfnSegment.SegmentDimensionsProperty.Behavior`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions.html#cfn-pinpoint-segment-segmentdimensions-behavior
         */
        readonly behavior?: CfnSegment.BehaviorProperty | cdk.IResolvable;
        /**
         * `CfnSegment.SegmentDimensionsProperty.Demographic`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions.html#cfn-pinpoint-segment-segmentdimensions-demographic
         */
        readonly demographic?: CfnSegment.DemographicProperty | cdk.IResolvable;
        /**
         * `CfnSegment.SegmentDimensionsProperty.Location`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions.html#cfn-pinpoint-segment-segmentdimensions-location
         */
        readonly location?: CfnSegment.LocationProperty | cdk.IResolvable;
        /**
         * `CfnSegment.SegmentDimensionsProperty.Metrics`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions.html#cfn-pinpoint-segment-segmentdimensions-metrics
         */
        readonly metrics?: any | cdk.IResolvable;
        /**
         * `CfnSegment.SegmentDimensionsProperty.UserAttributes`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions.html#cfn-pinpoint-segment-segmentdimensions-userattributes
         */
        readonly userAttributes?: any | cdk.IResolvable;
    }
}
export declare namespace CfnSegment {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups.html
     */
    interface SegmentGroupsProperty {
        /**
         * `CfnSegment.SegmentGroupsProperty.Groups`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups.html#cfn-pinpoint-segment-segmentgroups-groups
         */
        readonly groups?: Array<CfnSegment.GroupsProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSegment.SegmentGroupsProperty.Include`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups.html#cfn-pinpoint-segment-segmentgroups-include
         */
        readonly include?: string;
    }
}
export declare namespace CfnSegment {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-setdimension.html
     */
    interface SetDimensionProperty {
        /**
         * `CfnSegment.SetDimensionProperty.DimensionType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-setdimension.html#cfn-pinpoint-segment-setdimension-dimensiontype
         */
        readonly dimensionType?: string;
        /**
         * `CfnSegment.SetDimensionProperty.Values`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-setdimension.html#cfn-pinpoint-segment-setdimension-values
         */
        readonly values?: string[];
    }
}
export declare namespace CfnSegment {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups-groups-sourcesegments.html
     */
    interface SourceSegmentsProperty {
        /**
         * `CfnSegment.SourceSegmentsProperty.Id`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups-groups-sourcesegments.html#cfn-pinpoint-segment-segmentgroups-groups-sourcesegments-id
         */
        readonly id: string;
        /**
         * `CfnSegment.SourceSegmentsProperty.Version`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups-groups-sourcesegments.html#cfn-pinpoint-segment-segmentgroups-groups-sourcesegments-version
         */
        readonly version?: number;
    }
}
/**
 * Properties for defining a `AWS::Pinpoint::SmsTemplate`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html
 */
export interface CfnSmsTemplateProps {
    /**
     * `AWS::Pinpoint::SmsTemplate.Body`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html#cfn-pinpoint-smstemplate-body
     */
    readonly body: string;
    /**
     * `AWS::Pinpoint::SmsTemplate.TemplateName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html#cfn-pinpoint-smstemplate-templatename
     */
    readonly templateName: string;
    /**
     * `AWS::Pinpoint::SmsTemplate.DefaultSubstitutions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html#cfn-pinpoint-smstemplate-defaultsubstitutions
     */
    readonly defaultSubstitutions?: string;
    /**
     * `AWS::Pinpoint::SmsTemplate.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html#cfn-pinpoint-smstemplate-tags
     */
    readonly tags?: any;
    /**
     * `AWS::Pinpoint::SmsTemplate.TemplateDescription`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html#cfn-pinpoint-smstemplate-templatedescription
     */
    readonly templateDescription?: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::SmsTemplate`
 *
 * @cloudformationResource AWS::Pinpoint::SmsTemplate
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html
 */
export declare class CfnSmsTemplate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::SmsTemplate";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::Pinpoint::SmsTemplate.Body`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html#cfn-pinpoint-smstemplate-body
     */
    body: string;
    /**
     * `AWS::Pinpoint::SmsTemplate.TemplateName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html#cfn-pinpoint-smstemplate-templatename
     */
    templateName: string;
    /**
     * `AWS::Pinpoint::SmsTemplate.DefaultSubstitutions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html#cfn-pinpoint-smstemplate-defaultsubstitutions
     */
    defaultSubstitutions: string | undefined;
    /**
     * `AWS::Pinpoint::SmsTemplate.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html#cfn-pinpoint-smstemplate-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Pinpoint::SmsTemplate.TemplateDescription`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html#cfn-pinpoint-smstemplate-templatedescription
     */
    templateDescription: string | undefined;
    /**
     * Create a new `AWS::Pinpoint::SmsTemplate`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSmsTemplateProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::VoiceChannel`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-voicechannel.html
 */
export interface CfnVoiceChannelProps {
    /**
     * `AWS::Pinpoint::VoiceChannel.ApplicationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-voicechannel.html#cfn-pinpoint-voicechannel-applicationid
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::VoiceChannel.Enabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-voicechannel.html#cfn-pinpoint-voicechannel-enabled
     */
    readonly enabled?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Pinpoint::VoiceChannel`
 *
 * @cloudformationResource AWS::Pinpoint::VoiceChannel
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-voicechannel.html
 */
export declare class CfnVoiceChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::VoiceChannel";
    /**
     * `AWS::Pinpoint::VoiceChannel.ApplicationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-voicechannel.html#cfn-pinpoint-voicechannel-applicationid
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::VoiceChannel.Enabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-voicechannel.html#cfn-pinpoint-voicechannel-enabled
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Pinpoint::VoiceChannel`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVoiceChannelProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
