import { ISecurityGroup, IVpc } from "../../aws-ec2";
import { Construct } from "../../core";
import { EndpointGroup } from '../lib';
/**
 * The security group used by a Global Accelerator to send traffic to resources in a VPC.
 */
export declare class AcceleratorSecurityGroup {
    /**
     * Lookup the Global Accelerator security group at CloudFormation deployment time.
     *
     * As of this writing, Global Accelerators (AGA) create a single security group per VPC. AGA security groups are shared
     * by all AGAs in an account. Additionally, there is no CloudFormation mechanism to reference the AGA security groups.
     *
     * This makes creating security group rules which allow traffic from an AGA complicated in CDK. This lookup will identify
     * the AGA security group for a given VPC at CloudFormation deployment time, and lets you create rules for traffic from AGA
     * to other resources created by CDK.
     */
    static fromVpc(scope: Construct, id: string, vpc: IVpc, endpointGroup: EndpointGroup): ISecurityGroup;
    private constructor();
}
