"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthenticateCognitoAction = void 0;
const elbv2 = require("../../aws-elasticloadbalancingv2"); // Automatically re-written from '@aws-cdk/aws-elasticloadbalancingv2'
/**
 * A Listener Action to authenticate with Cognito
 */
class AuthenticateCognitoAction extends elbv2.ListenerAction {
    /**
     * Authenticate using an identity provide (IdP) that is compliant with OpenID Connect (OIDC)
     */
    constructor(options) {
        var _a;
        super({
            type: 'authenticate-cognito',
            authenticateCognitoConfig: {
                userPoolArn: options.userPool.userPoolArn,
                userPoolClientId: options.userPoolClient.userPoolClientId,
                userPoolDomain: options.userPoolDomain.domainName,
                authenticationRequestExtraParams: options.authenticationRequestExtraParams,
                onUnauthenticatedRequest: options.onUnauthenticatedRequest,
                scope: options.scope,
                sessionCookieName: options.sessionCookieName,
                sessionTimeout: (_a = options.sessionTimeout) === null || _a === void 0 ? void 0 : _a.toSeconds(),
            },
        }, options.next);
    }
}
exports.AuthenticateCognitoAction = AuthenticateCognitoAction;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29nbml0by1hY3Rpb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJjb2duaXRvLWFjdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFDQSwwREFBMEQsQ0FBQyxzRUFBc0U7QUEwRGpJOztHQUVHO0FBQ0gsTUFBYSx5QkFBMEIsU0FBUSxLQUFLLENBQUMsY0FBYztJQUMvRDs7T0FFRztJQUNILFlBQVksT0FBdUM7O1FBQy9DLEtBQUssQ0FBQztZQUNGLElBQUksRUFBRSxzQkFBc0I7WUFDNUIseUJBQXlCLEVBQUU7Z0JBQ3ZCLFdBQVcsRUFBRSxPQUFPLENBQUMsUUFBUSxDQUFDLFdBQVc7Z0JBQ3pDLGdCQUFnQixFQUFFLE9BQU8sQ0FBQyxjQUFjLENBQUMsZ0JBQWdCO2dCQUN6RCxjQUFjLEVBQUUsT0FBTyxDQUFDLGNBQWMsQ0FBQyxVQUFVO2dCQUNqRCxnQ0FBZ0MsRUFBRSxPQUFPLENBQUMsZ0NBQWdDO2dCQUMxRSx3QkFBd0IsRUFBRSxPQUFPLENBQUMsd0JBQXdCO2dCQUMxRCxLQUFLLEVBQUUsT0FBTyxDQUFDLEtBQUs7Z0JBQ3BCLGlCQUFpQixFQUFFLE9BQU8sQ0FBQyxpQkFBaUI7Z0JBQzVDLGNBQWMsUUFBRSxPQUFPLENBQUMsY0FBYywwQ0FBRSxTQUFTLEVBQUU7YUFDdEQ7U0FDSixFQUFFLE9BQU8sQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUNyQixDQUFDO0NBQ0o7QUFuQkQsOERBbUJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY29nbml0byBmcm9tIFwiLi4vLi4vYXdzLWNvZ25pdG9cIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2F3cy1jb2duaXRvJ1xuaW1wb3J0ICogYXMgZWxidjIgZnJvbSBcIi4uLy4uL2F3cy1lbGFzdGljbG9hZGJhbGFuY2luZ3YyXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3MtZWxhc3RpY2xvYWRiYWxhbmNpbmd2MidcbmltcG9ydCB7IER1cmF0aW9uIH0gZnJvbSBcIi4uLy4uL2NvcmVcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2NvcmUnXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIEF1dGhlbnRpY2F0ZUNvZ25pdG9BY3Rpb25cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBBdXRoZW50aWNhdGVDb2duaXRvQWN0aW9uUHJvcHMge1xuICAgIC8qKlxuICAgICAqIFdoYXQgYWN0aW9uIHRvIGV4ZWN1dGUgbmV4dFxuICAgICAqXG4gICAgICogTXVsdGlwbGUgYWN0aW9ucyBmb3JtIGEgbGlua2VkIGNoYWluOyB0aGUgY2hhaW4gbXVzdCBhbHdheXMgdGVybWluYXRlIGluIGFcbiAgICAgKiAod2VpZ2h0ZWQpZm9yd2FyZCwgZml4ZWRSZXNwb25zZSBvciByZWRpcmVjdCBhY3Rpb24uXG4gICAgICovXG4gICAgcmVhZG9ubHkgbmV4dDogZWxidjIuTGlzdGVuZXJBY3Rpb247XG4gICAgLyoqXG4gICAgICogVGhlIEFtYXpvbiBDb2duaXRvIHVzZXIgcG9vbC5cbiAgICAgKi9cbiAgICByZWFkb25seSB1c2VyUG9vbDogY29nbml0by5JVXNlclBvb2w7XG4gICAgLyoqXG4gICAgICogVGhlIEFtYXpvbiBDb2duaXRvIHVzZXIgcG9vbCBjbGllbnQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgdXNlclBvb2xDbGllbnQ6IGNvZ25pdG8uSVVzZXJQb29sQ2xpZW50O1xuICAgIC8qKlxuICAgICAqIFRoZSBkb21haW4gcHJlZml4IG9yIGZ1bGx5LXF1YWxpZmllZCBkb21haW4gbmFtZSBvZiB0aGUgQW1hem9uIENvZ25pdG8gdXNlciBwb29sLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHVzZXJQb29sRG9tYWluOiBjb2duaXRvLklVc2VyUG9vbERvbWFpbjtcbiAgICAvKipcbiAgICAgKiBUaGUgcXVlcnkgcGFyYW1ldGVycyAodXAgdG8gMTApIHRvIGluY2x1ZGUgaW4gdGhlIHJlZGlyZWN0IHJlcXVlc3QgdG8gdGhlIGF1dGhvcml6YXRpb24gZW5kcG9pbnQuXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCAtIE5vIGV4dHJhIHBhcmFtZXRlcnNcbiAgICAgKi9cbiAgICByZWFkb25seSBhdXRoZW50aWNhdGlvblJlcXVlc3RFeHRyYVBhcmFtcz86IFJlY29yZDxzdHJpbmcsIHN0cmluZz47XG4gICAgLyoqXG4gICAgICogVGhlIGJlaGF2aW9yIGlmIHRoZSB1c2VyIGlzIG5vdCBhdXRoZW50aWNhdGVkLlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgVW5hdXRoZW50aWNhdGVkQWN0aW9uLkFVVEhFTlRJQ0FURVxuICAgICAqL1xuICAgIHJlYWRvbmx5IG9uVW5hdXRoZW50aWNhdGVkUmVxdWVzdD86IGVsYnYyLlVuYXV0aGVudGljYXRlZEFjdGlvbjtcbiAgICAvKipcbiAgICAgKiBUaGUgc2V0IG9mIHVzZXIgY2xhaW1zIHRvIGJlIHJlcXVlc3RlZCBmcm9tIHRoZSBJZFAuXG4gICAgICpcbiAgICAgKiBUbyB2ZXJpZnkgd2hpY2ggc2NvcGUgdmFsdWVzIHlvdXIgSWRQIHN1cHBvcnRzIGFuZCBob3cgdG8gc2VwYXJhdGUgbXVsdGlwbGUgdmFsdWVzLCBzZWUgdGhlIGRvY3VtZW50YXRpb24gZm9yIHlvdXIgSWRQLlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgXCJvcGVuaWRcIlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHNjb3BlPzogc3RyaW5nO1xuICAgIC8qKlxuICAgICAqIFRoZSBuYW1lIG9mIHRoZSBjb29raWUgdXNlZCB0byBtYWludGFpbiBzZXNzaW9uIGluZm9ybWF0aW9uLlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgXCJBV1NFTEJBdXRoU2Vzc2lvbkNvb2tpZVwiXG4gICAgICovXG4gICAgcmVhZG9ubHkgc2Vzc2lvbkNvb2tpZU5hbWU/OiBzdHJpbmc7XG4gICAgLyoqXG4gICAgICogVGhlIG1heGltdW0gZHVyYXRpb24gb2YgdGhlIGF1dGhlbnRpY2F0aW9uIHNlc3Npb24uXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCBEdXJhdGlvbi5kYXlzKDcpXG4gICAgICovXG4gICAgcmVhZG9ubHkgc2Vzc2lvblRpbWVvdXQ/OiBEdXJhdGlvbjtcbn1cbi8qKlxuICogQSBMaXN0ZW5lciBBY3Rpb24gdG8gYXV0aGVudGljYXRlIHdpdGggQ29nbml0b1xuICovXG5leHBvcnQgY2xhc3MgQXV0aGVudGljYXRlQ29nbml0b0FjdGlvbiBleHRlbmRzIGVsYnYyLkxpc3RlbmVyQWN0aW9uIHtcbiAgICAvKipcbiAgICAgKiBBdXRoZW50aWNhdGUgdXNpbmcgYW4gaWRlbnRpdHkgcHJvdmlkZSAoSWRQKSB0aGF0IGlzIGNvbXBsaWFudCB3aXRoIE9wZW5JRCBDb25uZWN0IChPSURDKVxuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKG9wdGlvbnM6IEF1dGhlbnRpY2F0ZUNvZ25pdG9BY3Rpb25Qcm9wcykge1xuICAgICAgICBzdXBlcih7XG4gICAgICAgICAgICB0eXBlOiAnYXV0aGVudGljYXRlLWNvZ25pdG8nLFxuICAgICAgICAgICAgYXV0aGVudGljYXRlQ29nbml0b0NvbmZpZzoge1xuICAgICAgICAgICAgICAgIHVzZXJQb29sQXJuOiBvcHRpb25zLnVzZXJQb29sLnVzZXJQb29sQXJuLFxuICAgICAgICAgICAgICAgIHVzZXJQb29sQ2xpZW50SWQ6IG9wdGlvbnMudXNlclBvb2xDbGllbnQudXNlclBvb2xDbGllbnRJZCxcbiAgICAgICAgICAgICAgICB1c2VyUG9vbERvbWFpbjogb3B0aW9ucy51c2VyUG9vbERvbWFpbi5kb21haW5OYW1lLFxuICAgICAgICAgICAgICAgIGF1dGhlbnRpY2F0aW9uUmVxdWVzdEV4dHJhUGFyYW1zOiBvcHRpb25zLmF1dGhlbnRpY2F0aW9uUmVxdWVzdEV4dHJhUGFyYW1zLFxuICAgICAgICAgICAgICAgIG9uVW5hdXRoZW50aWNhdGVkUmVxdWVzdDogb3B0aW9ucy5vblVuYXV0aGVudGljYXRlZFJlcXVlc3QsXG4gICAgICAgICAgICAgICAgc2NvcGU6IG9wdGlvbnMuc2NvcGUsXG4gICAgICAgICAgICAgICAgc2Vzc2lvbkNvb2tpZU5hbWU6IG9wdGlvbnMuc2Vzc2lvbkNvb2tpZU5hbWUsXG4gICAgICAgICAgICAgICAgc2Vzc2lvblRpbWVvdXQ6IG9wdGlvbnMuc2Vzc2lvblRpbWVvdXQ/LnRvU2Vjb25kcygpLFxuICAgICAgICAgICAgfSxcbiAgICAgICAgfSwgb3B0aW9ucy5uZXh0KTtcbiAgICB9XG59XG4iXX0=